/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUICustomizationSupport;
import com.ibm.team.apt.internal.ide.ui.editor.AbstractPlanModeTab;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlanModeColumnsTab
extends AbstractPlanModeTab {
    public static final String ID = "com.ibm.team.apt.planmodes.ui.fields";
    private Section fSection;
    private LocalResourceManager fResources;
    private List<IAttributeDefinitionDescriptor> fAvailableAttributes = new ArrayList<IAttributeDefinitionDescriptor>();
    private TableViewer fTblAvialableColumns;
    private TableViewer fTblSelectedColumns;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.PlanModeFieldsTab_LABEL;
    }

    @Override
    public Control createControl(Composite parent, FormToolkit toolkit) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        parent.setLayout((Layout)new FillLayout());
        this.fSection = toolkit.createSection(parent, 320);
        this.fSection.setText(this.getName());
        Composite composite = toolkit.createComposite((Composite)this.fSection);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(composite);
        int tblHeight = -1;
        GC gc = new GC((Drawable)parent);
        try {
            gc.setFont(parent.getFont());
            tblHeight = gc.getFontMetrics().getHeight() * 8;
        }
        finally {
            gc.dispose();
        }
        this.fTblAvialableColumns = new TableViewer(composite, 2820);
        GridDataFactory.fillDefaults().hint(-1, tblHeight).grab(true, true).applyTo(this.fTblAvialableColumns.getControl());
        this.fTblAvialableColumns.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTblAvialableColumns.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.fTblAvialableColumns.setComparator((ViewerComparator)new AttributeComparator());
        this.fTblAvialableColumns.setFilters(new ViewerFilter[]{new SelectedColumnsFilter()});
        this.fTblAvialableColumns.setInput(this.fAvailableAttributes);
        this.fTblAvialableColumns.addOpenListener((IOpenListener)new AttributeToggleAction(true));
        this.fTblSelectedColumns = new TableViewer(composite, 2820);
        GridDataFactory.fillDefaults().hint(-1, tblHeight).grab(true, true).applyTo(this.fTblSelectedColumns.getControl());
        this.fTblSelectedColumns.setContentProvider((IContentProvider)new SelectedColumnsLabelProvider());
        this.fTblSelectedColumns.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.fTblSelectedColumns.addOpenListener((IOpenListener)new AttributeToggleAction(false));
        Composite toolbar = toolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().applyTo(toolbar);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)toolbar);
        toolbar.moveAbove(this.fTblSelectedColumns.getControl());
        Button btn = this.createActionBtn(toolbar, toolkit, new DefaultColumnsAction());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createActionBtn(toolbar, toolkit, new ManageColumnAction(true, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createActionBtn(toolbar, toolkit, new ManageColumnAction(true, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createActionBtn(toolbar, toolkit, new ManageColumnAction(false, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createActionBtn(toolbar, toolkit, new ManageColumnAction(false, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        toolbar = toolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().applyTo(toolbar);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)toolbar);
        btn = this.createActionBtn(toolbar, toolkit, new MoveColumnAction(true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createActionBtn(toolbar, toolkit, new MoveColumnAction(false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        this.fSection.setClient((Control)composite);
        return this.fSection;
    }

    @Override
    public Control getControl() {
        return this.fSection;
    }

    protected Button createActionBtn(Composite parent, FormToolkit toolkit, final Action action) {
        final Button btn = toolkit.createButton(parent, action.getText(), 8);
        btn.setEnabled(action.isEnabled());
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                btn.setEnabled(action.isEnabled());
            }
        });
        return btn;
    }

    public void setAvailableAttributes(List<IAttributeDefinitionDescriptor> availableAttributes) {
        this.fAvailableAttributes.clear();
        this.fAvailableAttributes.addAll(availableAttributes);
    }

    @Override
    protected void setInput(PlanModeState input) {
        super.setInput(input);
        this.fTblAvialableColumns.refresh();
        this.fTblSelectedColumns.setInput((Object)this.getInput());
    }

    private static <T> int indexOf(T[] array, T element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class AttributeComparator
    extends ViewerComparator {
        private AttributeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IAttributeDefinitionDescriptor a1 = (IAttributeDefinitionDescriptor)e1;
            IAttributeDefinitionDescriptor a2 = (IAttributeDefinitionDescriptor)e2;
            if (PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)a1) ^ PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)a2)) {
                return PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)a1) ? -1 : 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class AttributeLabelProvider
    extends LabelProvider {
        private AttributeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IAttributeDefinitionDescriptor) {
                IAttributeDefinitionDescriptor attr = (IAttributeDefinitionDescriptor)element;
                return attr.getDisplayName() != null ? attr.getDisplayName() : attr.getId();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IAttributeDefinitionDescriptor) {
                ImageDescriptor img = PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)((IAttributeDefinitionDescriptor)element)) ? ImagePool.ATTR_CUSTOM : ImagePool.ATTR_BUILT_IN;
                return PlanModeColumnsTab.this.fResources.createImage(img);
            }
            return super.getImage(element);
        }
    }

    private class AttributeToggleAction
    implements IOpenListener {
        private final boolean fAdd;

        public AttributeToggleAction(boolean add) {
            this.fAdd = add;
        }

        public void open(OpenEvent event) {
            ManageColumnAction action = new ManageColumnAction(this.fAdd, false);
            if (action.isEnabled()) {
                action.run();
            }
        }
    }

    private abstract class ColumnAction
    extends Action
    implements ISelectionChangedListener {
        private final ISelectionProvider fSource;

        public ColumnAction(String text, ImageDescriptor image, ISelectionProvider source) {
            this.fSource = source;
            this.setText(text);
            this.setImageDescriptor(image);
            if (source != null) {
                source.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            this.setEnabled(selection != null && !selection.isEmpty() && this.updateEnabled());
        }

        protected boolean updateEnabled() {
            return true;
        }

        protected List<IAttributeDefinitionDescriptor> getSelection() {
            return this.getSelection(this.fSource);
        }

        protected List<IAttributeDefinitionDescriptor> getSelection(ISelectionProvider provider) {
            IStructuredSelection selection;
            if (provider != null && (selection = (IStructuredSelection)provider.getSelection()) != null && !selection.isEmpty()) {
                return selection.toList();
            }
            return Collections.emptyList();
        }
    }

    private class DefaultColumnsAction
    extends ColumnAction {
        private final List<String> fgDefaultColumns;

        public DefaultColumnsAction() {
            super(Messages.PlanModeColumnsTab_SET_DFL_LABEL, null, null);
            this.fgDefaultColumns = Arrays.asList(PlanItem.PRIORITY.getId());
        }

        public void run() {
            ArrayList result = new ArrayList(PlanModeColumnsTab.this.fAvailableAttributes);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                IAttributeDefinitionDescriptor attr = (IAttributeDefinitionDescriptor)iter.next();
                if (this.fgDefaultColumns.contains(attr.getId())) continue;
                iter.remove();
            }
            PlanModeColumnsTab.this.getInput().setLegacyColumns(result.toArray(new IAttributeDefinitionDescriptor[0]));
            PlanModeColumnsTab.this.fTblSelectedColumns.refresh();
            PlanModeColumnsTab.this.fTblAvialableColumns.refresh();
        }
    }

    private class ManageColumnAction
    extends ColumnAction {
        private final boolean fAll;
        private final boolean fAdd;

        public ManageColumnAction(boolean add, boolean all) {
            super(add ? (all ? Messages.PlanModeColumnsTab_LBL_ADD_ALL : Messages.PlanModeColumnsTab_LBL_ADD) : (all ? Messages.PlanModeColumnsTab_LBL_REMOVE_ALL : Messages.PlanModeColumnsTab_LBL_REMOVE), null, (ISelectionProvider)(add ? PlanModeColumnsTab.this.fTblAvialableColumns : PlanModeColumnsTab.this.fTblSelectedColumns));
            this.fAdd = add;
            this.fAll = all;
        }

        public void run() {
            if (this.fAll) {
                if (this.fAdd) {
                    ViewerFilter[] filters;
                    ArrayList<IAttributeDefinitionDescriptor> availableAttributes = new ArrayList<IAttributeDefinitionDescriptor>();
                    availableAttributes.addAll(PlanModeColumnsTab.this.fAvailableAttributes);
                    ViewerFilter[] viewerFilterArray = filters = PlanModeColumnsTab.this.fTblAvialableColumns.getFilters();
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter filter = viewerFilterArray[n2];
                        Iterator iter = availableAttributes.iterator();
                        while (iter.hasNext()) {
                            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)iter.next();
                            if (filter.select((Viewer)PlanModeColumnsTab.this.fTblAvialableColumns, null, (Object)attribute)) continue;
                            iter.remove();
                        }
                        ++n2;
                    }
                    availableAttributes.addAll(Arrays.asList(PlanModeColumnsTab.this.getInput().getLegacyColumns()));
                    PlanModeColumnsTab.this.getInput().setLegacyColumns(availableAttributes.toArray(new IAttributeDefinitionDescriptor[0]));
                } else {
                    PlanModeColumnsTab.this.getInput().setColumns(new IColumnDescriptor[0]);
                }
            } else {
                ArrayList<IAttributeDefinitionDescriptor> columns = new ArrayList<IAttributeDefinitionDescriptor>(Arrays.asList(PlanModeColumnsTab.this.getInput().getLegacyColumns()));
                IAttributeDefinitionDescriptor attr = this.getSelection().get(0);
                if (this.fAdd) {
                    int index = -1;
                    List<IAttributeDefinitionDescriptor> insertion = this.getSelection((ISelectionProvider)PlanModeColumnsTab.this.fTblSelectedColumns);
                    if (!insertion.isEmpty()) {
                        index = PlanModeColumnsTab.indexOf(PlanModeColumnsTab.this.getInput().getLegacyColumns(), insertion.get(0));
                    }
                    if (index != -1) {
                        columns.add(index + 1, attr);
                    } else {
                        columns.add(attr);
                    }
                } else {
                    columns.remove(attr);
                }
                PlanModeColumnsTab.this.getInput().setLegacyColumns(columns.toArray(new IAttributeDefinitionDescriptor[0]));
            }
            PlanModeColumnsTab.this.fTblAvialableColumns.refresh();
            PlanModeColumnsTab.this.fTblSelectedColumns.refresh();
        }
    }

    private class MoveColumnAction
    extends ColumnAction {
        private final boolean fUp;

        public MoveColumnAction(boolean up) {
            super(up ? Messages.PlanModeColumnsTab_LBL_UP : Messages.PlanModeColumnsTab_LBL_DOWN, null, (ISelectionProvider)PlanModeColumnsTab.this.fTblSelectedColumns);
            this.fUp = up;
        }

        @Override
        protected boolean updateEnabled() {
            IAttributeDefinitionDescriptor attr = this.getSelection().get(0);
            Object[] columns = PlanModeColumnsTab.this.getInput().getLegacyColumns();
            int len = columns.length;
            int index = PlanModeColumnsTab.indexOf(columns, attr);
            return index != -1 && this.fUp ? index > 0 : index < len - 1;
        }

        public void run() {
            IAttributeDefinitionDescriptor attr = this.getSelection().get(0);
            IAttributeDefinitionDescriptor[] columns = PlanModeColumnsTab.this.getInput().getLegacyColumns();
            Object[] newColumns = new IAttributeDefinitionDescriptor[columns.length];
            System.arraycopy(columns, 0, newColumns, 0, columns.length);
            int index = PlanModeColumnsTab.indexOf(newColumns, attr);
            int newIndex = this.fUp ? index - 1 : index + 1;
            Object tmp = newColumns[newIndex];
            newColumns[newIndex] = attr;
            newColumns[index] = tmp;
            PlanModeColumnsTab.this.getInput().setLegacyColumns((IAttributeDefinitionDescriptor[])newColumns);
            PlanModeColumnsTab.this.fTblSelectedColumns.refresh();
            PlanModeColumnsTab.this.fTblSelectedColumns.setSelection(PlanModeColumnsTab.this.fTblSelectedColumns.getSelection());
        }
    }

    private class SelectedColumnsFilter
    extends ViewerFilter {
        private final List<String> fgIgnoreList = Arrays.asList(PlanItem.ID.getId(), PlanItem.SUMMARY.getId(), PlanItem.DESCRIPTION.getId(), PlanItem.SEQUENCE_VALUE.getId());

        private SelectedColumnsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
            if (PlanningUICustomizationSupport.V3_ATTRIBUTES.contains(attribute.getId())) {
                return false;
            }
            if (this.fgIgnoreList.contains(attribute.getId())) {
                return false;
            }
            if (PlanModeColumnsTab.indexOf(PlanModeColumnsTab.this.getInput().getLegacyColumns(), attribute) != -1) {
                return false;
            }
            return PlanItemAttributes.isWorkItemBuiltIn((IAttributeDefinitionDescriptor)attribute) || PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attribute) || attribute.getDisplayName() != null;
        }
    }

    private class SelectedColumnsLabelProvider
    implements IStructuredContentProvider {
        private SelectedColumnsLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PlanModeColumnsTab.this.getInput().getLegacyColumns();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

