/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfigurationControl;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorUtil;
import com.ibm.team.apt.internal.ide.ui.editor.AbstractPlanModeTab;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PlanModeColorizeTab
extends AbstractPlanModeTab {
    public static final String ID = "com.ibm.team.apt.planmode.ui.colorize";
    private Composite fControl;
    private ColorizeConfigurationControl fConfigControl;

    public PlanModeColorizeTab(QuickQueryParser quickQueryParser) {
        this.fConfigControl = new DialogColorizeConfigurationControl(quickQueryParser);
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.PlanModeColorizeTab_TAB_NAME;
    }

    @Override
    public Control createControl(Composite parent, FormToolkit toolkit) {
        this.fControl = toolkit.createComposite(parent);
        this.fControl.setLayout((Layout)new GridLayout());
        this.fConfigControl.createControls(this.fControl);
        return this.fControl;
    }

    @Override
    public Control getControl() {
        return this.fControl;
    }

    @Override
    public Action getAction(String id) {
        return this.fConfigControl.getAction(id);
    }

    @Override
    protected IStatus update() {
        return this.fConfigControl.getStatus();
    }

    @Override
    public void setInput(PlanModeState input) {
        this.fInput = input;
        PlanModeState planMode = input;
        ArrayList<IColorizeDescription> configurations = new ArrayList<IColorizeDescription>(Arrays.asList(planMode.getColors()));
        Collections.sort(configurations, new Comparator<IColorizeDescription>(){

            @Override
            public int compare(IColorizeDescription o1, IColorizeDescription o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        this.fConfigControl.setConfigurations(configurations);
    }

    private class DialogColorizeConfigurationControl
    extends ColorizeConfigurationControl {
        public DialogColorizeConfigurationControl(QuickQueryParser quickQueryParser) {
            super(quickQueryParser, Collections.EMPTY_LIST);
        }

        @Override
        protected IColorizeDescription createConfig() {
            return IColorizeDescription.FACTORY.create(Messages.PlanModeColorizeTab_NEWCONFIG_LABEL, QuickQueryColorUtil.serializeColor(new RGB(141, 198, 63)), 1);
        }

        @Override
        protected void added(IColorizeDescription configuration) {
            super.added(configuration);
            PlanModeColorizeTab.this.fInput.addColorizeConfiguration(configuration);
            PlanModeColorizeTab.this.getConfigurationPart().updateStatus();
        }

        @Override
        protected void enablementChanged(IColorizeDescription configuration) {
            super.enablementChanged(configuration);
            PlanModeColorizeTab.this.fInput.updateColorizeConfigEnablement(configuration);
            PlanModeColorizeTab.this.getConfigurationPart().updateStatus();
        }

        @Override
        protected void contentChanged(IColorizeDescription configuration) {
            super.contentChanged(configuration);
            PlanModeColorizeTab.this.fInput.updateColorizeConfigurations(configuration);
            PlanModeColorizeTab.this.getConfigurationPart().updateStatus();
        }

        @Override
        protected void removed(IColorizeDescription configuration) {
            super.removed(configuration);
            PlanModeColorizeTab.this.fInput.removeColorizeConfiguration(configuration);
            PlanModeColorizeTab.this.getConfigurationPart().updateStatus();
        }
    }
}

