/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.ide.ui.editor.IterationPlanEditorPage;
import com.ibm.team.apt.ide.ui.editor.IterationPlanEditorPageFactory;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.PlanningUIStatus;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.ui.forms.editor.FormEditor;

public class PageDescriptor {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String POSITION = "position";
    private static final String FACTORY = "factory";
    private static final String CREATE = "create";
    private final IConfigurationElement fElement;

    public PageDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    public String getId() {
        return this.fElement.getAttribute(ID);
    }

    public String getName() {
        return this.fElement.getAttribute(NAME);
    }

    public String getPosition() {
        return this.fElement.getAttribute(POSITION);
    }

    public boolean isEnabled(IResolvedIterationPlanRecord record) {
        IConfigurationElement[] elements;
        block4: {
            elements = this.fElement.getChildren("enablement");
            if (elements.length != 0) break block4;
            return false;
        }
        try {
            Assert.isTrue((elements.length == 1 ? 1 : 0) != 0);
            Expression exp = ExpressionConverter.getDefault().perform(elements[0]);
            EvaluationContext context = new EvaluationContext(null, (Object)record);
            context.addVariable("plan", (Object)record);
            return this.convert(exp.evaluate((IEvaluationContext)context));
        }
        catch (CoreException e) {
            PlanningUIPlugin.log(e);
        }
        catch (InvalidRegistryObjectException e) {
            PlanningUIPlugin.log(e);
        }
        return false;
    }

    private boolean convert(EvaluationResult eval) {
        return eval != EvaluationResult.FALSE;
    }

    public IterationPlanEditorPage createPage(FormEditor editor) throws CoreException {
        IterationPlanEditorPageFactory factory = (IterationPlanEditorPageFactory)this.fElement.createExecutableExtension(FACTORY);
        try {
            Method createMethod = factory.getClass().getDeclaredMethod(CREATE, FormEditor.class, String.class, String.class);
            return (IterationPlanEditorPage)((Object)createMethod.invoke((Object)factory, editor, this.fElement.getAttribute(ID), this.fElement.getAttribute(NAME)));
        }
        catch (SecurityException e) {
            this.handleException(e);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e);
        }
        catch (IllegalArgumentException e) {
            this.handleException(e);
        }
        catch (IllegalAccessException e) {
            this.handleException(e);
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
        }
        return null;
    }

    private void handleException(Throwable e) throws CoreException {
        throw new CoreException((IStatus)new PlanningUIStatus(PlanningUIStatus.Codes.PageDescriptor_CREATE_FAILED, NLS.bind((String)Messages.PageDescriptor_CREATE_FAILED, (Object)this.fElement.getAttribute(ID), (Object[])new Object[0]), e));
    }
}

