/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.IPlanningAttributeDependency;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.common.LegacyHelper;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.util.Collections2;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUICustomizationSupport;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.JavaScriptItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.JavaScriptPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.MyFolderItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.ScriptableFilter;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.ScriptableSorter;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.foundation.api.ui.model.IUnlockedViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntrySorter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.mozilla.javascript.Function;

class OutlinePageSettingsListener
extends PlanOutlineSettingsListener {
    private final Collection<IPlanningAttributeIdentifier> fDependantAttributes = new HashSet<IPlanningAttributeIdentifier>();
    private OutlinePage fOutlinePage;

    OutlinePageSettingsListener(OutlinePage outlinePage) {
        super(outlinePage.getPlanOutlineSettings());
        this.fOutlinePage = outlinePage;
    }

    protected void runPrepared(final Runnable code) {
        IDeferredResolveListener<Void> resolveListener = new IDeferredResolveListener<Void>(){

            public void canceled() {
            }

            public void failed(IStatus state) {
                OutlinePageSettingsListener.this.fOutlinePage.displayErrorStatus(state);
            }

            public void resolved(Void result) {
                UI.asyncExec(OutlinePageSettingsListener.this.fOutlinePage.getPartControl(), code);
            }
        };
        IDeferredResolver<Void> resolver = new IDeferredResolver<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                if (OutlinePageSettingsListener.this.fOutlinePage.getPlanModel() != null) {
                    HashSet attr = new HashSet();
                    Collection collection = OutlinePageSettingsListener.this.fDependantAttributes;
                    synchronized (collection) {
                        attr.addAll(OutlinePageSettingsListener.this.fDependantAttributes);
                        OutlinePageSettingsListener.this.fDependantAttributes.clear();
                    }
                    OutlinePageSettingsListener.this.fOutlinePage.getPlanModel().prepare((PlanElement)OutlinePageSettingsListener.this.fOutlinePage.getPlanModel(), attr, monitor);
                }
                return null;
            }
        };
        if (!this.fOutlinePage.getPlanModel().isPrepared(this.fDependantAttributes)) {
            this.fOutlinePage.getIterationPlanEditor().deferredResolve(resolver, resolveListener, true);
        } else {
            resolveListener.resolved(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependency(Object ... elements) {
        Collection<IPlanningAttributeIdentifier> collection = this.fDependantAttributes;
        synchronized (collection) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof Collection) {
                    this.addDependency(((Collection)element).toArray());
                } else if (element instanceof IPlanningAttributeDependency) {
                    this.fDependantAttributes.addAll(((IPlanningAttributeDependency)element).getDependantAttributes());
                } else if (element instanceof IAttributeDefinitionDescriptor) {
                    this.fDependantAttributes.add(PlanningAttributeIdentifier.create((String)((IAttributeDefinitionDescriptor)element).getId()));
                } else if (element instanceof IColorizeDescription) {
                    QuickQueryParser parser = this.fOutlinePage.getQuickQueryParser();
                    parser.getParseTree(((IColorizeDescription)element).getExpression());
                    this.fDependantAttributes.addAll(parser.getDependantAttributes());
                } else if (element != null) {
                    throw new IllegalArgumentException(element.getClass().getName());
                }
                ++n2;
            }
        }
    }

    @Override
    public void refresh(IPlanModeDescription newValue, final IPlanModeDescription oldValue) {
        final IScriptEnvironment scriptEnvironment = this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment();
        ResolvedIterationPlan plan = this.fOutlinePage.getViewModel().getInput();
        Object[] columns = PlanningUICustomizationSupport.handleV3Columns(newValue.getColumns(), (ResolvedPlan)plan);
        final JavaScriptPlanModelTransformer transformer = new JavaScriptPlanModelTransformer(scriptEnvironment, (IAttributeDefinitionDescriptor[])columns, newValue.getViewMode(), newValue.getGroupMode(), this.fOutlinePage.getScriptStore());
        this.addDependency(transformer.getGroupProvider());
        Collections2.IMapping<IFilterDescription, ScriptableFilter> filterCtor = new Collections2.IMapping<IFilterDescription, ScriptableFilter>(){

            public ScriptableFilter map(IFilterDescription element) {
                return new ScriptableFilter(element, scriptEnvironment);
            }
        };
        List filtersAdd = Collections2.map(Arrays.asList(newValue.getFilters()), (Collections2.IMapping)filterCtor);
        this.addDependency(filtersAdd);
        final ScriptableSorter sorter = new ScriptableSorter(this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment(), newValue.getSortMode(), this.fOutlinePage.getScriptStore());
        this.addDependency(sorter);
        this.addDependency(newValue.getColors());
        this.addDependency(columns);
        this.runPrepared(new Runnable((Collections2.IMapping)filterCtor, filtersAdd, newValue){
            private final /* synthetic */ Collections2.IMapping val$filterCtor;
            private final /* synthetic */ List val$filtersAdd;
            private final /* synthetic */ IPlanModeDescription val$newValue;
            {
                this.val$filterCtor = iMapping;
                this.val$filtersAdd = list;
                this.val$newValue = iPlanModeDescription2;
            }

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.getViewModel().executeUnlocked(new IUnlockedViewModelFunction<Void, RuntimeException>(){

                    public Void run() throws RuntimeException {
                        IColorizeDescription color;
                        IColorizeDescription[] iColorizeDescriptionArray;
                        OutlinePageSettingsListener.this.doUpdatePlanModel(transformer);
                        OutlinePageSettingsListener.this.doHandleSortModeChanged(sorter);
                        if (oldValue != null) {
                            List filtersRemove = Collections2.map(Arrays.asList(oldValue.getFilters()), (Collections2.IMapping)val$filterCtor);
                            for (ScriptableFilter filter : filtersRemove) {
                                OutlinePageSettingsListener.this.doHandleFilterChanged(false, filter);
                            }
                        }
                        for (ScriptableFilter filter : val$filtersAdd) {
                            OutlinePageSettingsListener.this.doHandleFilterChanged(true, filter);
                        }
                        if (oldValue != null) {
                            iColorizeDescriptionArray = oldValue.getColors();
                            int n = iColorizeDescriptionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                color = iColorizeDescriptionArray[n2];
                                OutlinePageSettingsListener.this.fOutlinePage.removeColorizer(color);
                                ++n2;
                            }
                        }
                        iColorizeDescriptionArray = val$newValue.getColors();
                        int n = iColorizeDescriptionArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            color = iColorizeDescriptionArray[n3];
                            OutlinePageSettingsListener.this.fOutlinePage.addColorizer(color);
                            ++n3;
                        }
                        OutlinePageSettingsListener.this.handleProgressModeChanged(val$newValue.getProgressMode());
                        return null;
                    }
                });
            }
        });
    }

    @Override
    public void handleColumnsChanged(IAttributeDefinitionDescriptor[] columns) {
        this.updateViewModel(this.fOutlinePage.getPlanMode());
    }

    @Override
    public void handleViewModeChanged(IViewModeDescription mode) {
        this.updateViewModel(this.fOutlinePage.getPlanMode());
    }

    @Override
    public void handleGroupModeChanged(IGroupModeDescription mode) {
        this.updateViewModel(this.fOutlinePage.getPlanMode());
    }

    private void updateViewModel(IPlanModeDescription planMode) {
        IScriptEnvironment scriptEnvironment = this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment();
        ResolvedIterationPlan plan = this.fOutlinePage.getViewModel().getInput();
        Object[] columns = PlanningUICustomizationSupport.handleV3Columns(planMode.getColumns(), (ResolvedPlan)plan);
        final JavaScriptPlanModelTransformer modelTransformer = new JavaScriptPlanModelTransformer(scriptEnvironment, (IAttributeDefinitionDescriptor[])columns, planMode.getViewMode(), planMode.getGroupMode(), this.fOutlinePage.getScriptStore());
        this.addDependency(columns);
        this.addDependency(planMode.getColors());
        this.addDependency(modelTransformer.getGroupProvider());
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.getViewModel().executeUnlocked(new IUnlockedViewModelFunction<Void, RuntimeException>(){

                    public Void run() throws RuntimeException {
                        OutlinePageSettingsListener.this.doUpdatePlanModel(modelTransformer);
                        return null;
                    }
                });
            }
        });
    }

    private void doUpdatePlanModel(JavaScriptPlanModelTransformer modelTransformer) {
        if (LegacyHelper.isFolderGroupMode((IGroupModeDescription)this.fOutlinePage.getPlanMode().getGroupMode())) {
            this.fOutlinePage.setItemMovePolicy(new MyFolderItemMovePolicy(this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment()));
        } else {
            this.fOutlinePage.setItemMovePolicy(new JavaScriptItemMovePolicy(this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment()));
        }
        this.fOutlinePage.getItemMovePolicy().setViewMode(modelTransformer.getViewMode());
        this.fOutlinePage.getItemMovePolicy().setGroupProvider(modelTransformer.getGroupProvider());
        this.fOutlinePage.getViewModel().setModelTransformer(modelTransformer);
        this.updateSorterComparators();
    }

    @Override
    public void handleSortModeChanged(ISortModeDescription mode) {
        final ScriptableSorter sorter = new ScriptableSorter(this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment(), mode, this.fOutlinePage.getScriptStore());
        this.addDependency(sorter);
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.getViewModel().executeUnlocked(new IUnlockedViewModelFunction<Void, RuntimeException>(){

                    public Void run() throws RuntimeException {
                        OutlinePageSettingsListener.this.doHandleSortModeChanged(sorter);
                        return null;
                    }
                });
            }
        });
    }

    private void doHandleSortModeChanged(ScriptableSorter sorter) {
        this.fOutlinePage.getViewModel().setSorter(sorter);
        this.fOutlinePage.getItemMovePolicy().setEntrySorter(sorter);
        this.updateSorterComparators();
    }

    private void updateSorterComparators() {
        IViewEntrySorter sorter = this.fOutlinePage.getViewModel().getSorter();
        if (sorter instanceof ScriptableSorter) {
            Function comparator = null;
            PlanModelTransformer modelTransformer = (PlanModelTransformer)this.fOutlinePage.getViewModel().getModelTransformer();
            if (modelTransformer instanceof JavaScriptPlanModelTransformer) {
                comparator = ((JavaScriptPlanModelTransformer)modelTransformer).getComparator();
            }
            ((ScriptableSorter)sorter).setComparator(comparator);
        }
    }

    @Override
    public void handleFilterChanged(IFilterDescription filter, final boolean added) {
        final ScriptableFilter scriptableFilter = new ScriptableFilter(filter, this.fOutlinePage.getIterationPlanEditor().getScriptEnvironment());
        this.addDependency(scriptableFilter);
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.doHandleFilterChanged(added, scriptableFilter);
            }
        });
    }

    private void doHandleFilterChanged(boolean added, ScriptableFilter scriptableFilter) {
        if (added) {
            this.fOutlinePage.getViewModel().addFilter(scriptableFilter);
        } else {
            this.fOutlinePage.getViewModel().removeFilter(scriptableFilter);
        }
    }

    @Override
    public void handlePlanCheckChanged(IPlanCheckDescription planCheck, boolean added) {
    }

    @Override
    public void colorizeConfigAdded(final IColorizeDescription config) {
        this.addDependency(config);
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.addColorizer(config);
            }
        });
    }

    @Override
    public void colorizeConfigUpdated(final IColorizeDescription config) {
        this.addDependency(config);
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.updateColorizer(config);
            }
        });
    }

    @Override
    public void colorizeConfigRemoved(IColorizeDescription config) {
        this.fOutlinePage.removeColorizer(config);
    }

    @Override
    public void colorizeEnablementChanged(final IColorizeDescription config, boolean enabled) {
        this.addDependency(config);
        this.runPrepared(new Runnable(){

            @Override
            public void run() {
                OutlinePageSettingsListener.this.fOutlinePage.updateColorizer(config);
            }
        });
    }

    @Override
    public void handleProgressModeChanged(ProgressMode newValue) {
        this.fOutlinePage.getViewModel().updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(final IViewModelUpdater updateAccessor) throws RuntimeException {
                updateAccessor.accept(new IViewEntryVisitor(){

                    public boolean visit(IViewEntry<?> entry) {
                        if (EntryUtils.isType(entry, OwnerElement.class)) {
                            updateAccessor.update(entry, new String[]{"progress"});
                            return false;
                        }
                        return true;
                    }
                }, null);
                return null;
            }
        });
    }

    @Override
    public void settingChanged(final OutlineSettingChangeEvent event) {
        BusyIndicator.showWhile((Display)this.fOutlinePage.getPartControl().getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                OutlinePage outlinePage = OutlinePageSettingsListener.this.fOutlinePage;
                outlinePage.getClass();
                SafeRunner.run((ISafeRunnable)new OutlinePage.ViewModelSafeRunnable(outlinePage){

                    @Override
                    public void doRun() throws Exception {
                        OutlinePageSettingsListener.this.fOutlinePage.getViewModel().updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

                            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                                OutlinePageSettingsListener.this.fireSettingChanged(event);
                                return null;
                            }
                        });
                    }
                });
            }
        });
    }

    private void fireSettingChanged(OutlineSettingChangeEvent event) {
        super.settingChanged(event);
    }
}

