/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.ui.essentials.IMarker;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckEngine;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.common.IterationPlanNoCategoriesException;
import com.ibm.team.apt.internal.common.JSUtils;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.DefaultPlanType;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanMode;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.plantype.ResolvedPlanMode;
import com.ibm.team.apt.internal.common.plantype.SharedPlanModeComparator;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.StateResolveEvent;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.ISidebarAction;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.common.PlanCheckTriggerAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanOpenListener;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUICustomizationSupport;
import com.ibm.team.apt.internal.ide.ui.common.ResortItemsAction;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelContentProvider;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryBar;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorUtil;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorizer;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFilter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.JavaScriptItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.JavaScriptPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.editor.ConfigurationDescriptorLabelProvider;
import com.ibm.team.apt.internal.ide.ui.editor.DeprecatedConfigurationElementCheckboxViewerFilter;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditorInput;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePageSettingsListener;
import com.ibm.team.apt.internal.ide.ui.editor.PlanEditorPage;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeColorizeTab;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeColumnsTab;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeConfigurationPart;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeConfigurationTab;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import com.ibm.team.apt.internal.ide.ui.editor.PreviewPane;
import com.ibm.team.apt.internal.ide.ui.editor.StatusComposite;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageChangeListener;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanViewModel;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.jface.CheckboxListViewer;
import com.ibm.team.apt.internal.ide.ui.jface.CommandLinkEvent;
import com.ibm.team.apt.internal.ide.ui.jface.CommandListViewer;
import com.ibm.team.apt.internal.ide.ui.jface.ConfigurationUIProvider;
import com.ibm.team.apt.internal.ide.ui.jface.ICommandLinkListener;
import com.ibm.team.apt.internal.ide.ui.jface.StructuredContentProvider;
import com.ibm.team.apt.internal.ide.ui.progress.IProgressComputer;
import com.ibm.team.apt.internal.ide.ui.progress.OutlineEntryItemAccessorScriptType;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.internal.ide.ui.quickquery.IQuickQueryExpression;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.apt.internal.ide.ui.scripting.facades.StoreScriptType;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.ScriptableSorter;
import com.ibm.team.apt.internal.ide.ui.util.AntispamLabelProvider;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.Line;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GDeferredImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditorActivationListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.GradientUtilities;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.rtc.common.scriptengine.environment.WrappedScriptEnvironment;
import com.ibm.team.rtc.foundation.api.ui.model.IExpansionHull;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntrySorter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressService;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class OutlinePage
extends PlanEditorPage
implements IActionProvider {
    public static final String ID = "com.ibm.team.apt.ui.IterationPlanEditor.PlannedItemsPage";
    private static final String ACTIVE_PLAN_MODE = "active-plan-mode";
    private static final String USAGE_PLAN_MODE = "usage-plan-mode";
    private static final String PAGE_TITLE = Messages.OutlinePage_OUTLINE_PAGE_NAME;
    private IterationPlanData fIterationPlanData;
    private volatile TeamFuture<ResolvedIterationPlan> fFuture;
    private ResolvedIterationPlan fIterationPlan;
    private IterationPlanListener fIterationPlanListener;
    private PlanModeStructure fPlanModeStructure;
    private PlanModeState fPlanModeState;
    private String fDefaultModeId;
    private boolean fDefaultOverrideable;
    private JavaScriptItemMovePolicy fItemMovePolicy;
    private PlanItemOutlineViewer fOutlineViewer;
    private Map<IColorizeDescription, QuickQueryColorizer> fColorizers = new HashMap<IColorizeDescription, QuickQueryColorizer>();
    private IterationPlanViewModel fViewModel;
    private ResourceManager fResourceManager;
    private ILabelProvider fLabelProvider;
    private List<IOutlineSettingsListener> fAttachedSettingListeners = new ArrayList<IOutlineSettingsListener>();
    private Control fActivePart;
    private PlanModeConfigurationPart fPlanModeConfiguration;
    private PlanModeConfigurationTab fPlanModeBasicTab;
    private PlanModeColumnsTab fPlanModeColumnsTab;
    private PlanModeColorizeTab fPlanModeColorizeTab;
    private CheckboxListViewer fPlanModeViewer;
    private CommandListViewer fActionsViewer;
    private CheckboxListViewer fQuickFilterViewer;
    private PlanItemOutline fOutline;
    private Composite fSideBar;
    private HyperlinkGroup fHyperlinkGroup;
    private QuickQueryBar fQuickSearch;
    private CheckboxListViewer fQuickFilterList;
    private boolean fIsDisposed;
    private Font fActionFont;
    private Font fActionInProgressFont;
    private StackLayout fStack;
    private Composite fOutlineComposite;
    private AnimatedLoadingLabel fLoadingLabel;
    private FailureInfo fFailureInfo;
    private QuickQueryParser fQuickQueryParser;
    private Composite fInnerOutlineContainer;
    private StackLayout fOutlineExceptionStack;
    private Composite fOutlineContainer;
    private StatusComposite fErrorContainer;
    private boolean fIsReadModeEnabled;
    private PreviewPane fPreviewPane;
    private IUsageChangeListener fFilterRankingListener = new IUsageChangeListener(){

        @Override
        public void filterRankingChanged() {
            Control control = OutlinePage.this.fQuickFilterList.getControl();
            if (control != null && !control.isDisposed()) {
                OutlinePage.this.fQuickFilterList.refresh();
            }
        }
    };
    private IPropertyChangeListener fInProgressActionListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("inprogress".equals(event.getProperty())) {
                OutlinePage.this.fActionsViewer.update(event.getSource());
            }
        }
    };
    private StoreScriptType fScriptStore;
    private final SettingsDelegate fSettingsDelegate = new SettingsDelegate();
    private String fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.outline.bars";
    private boolean fDirty = false;

    public OutlinePage(FormEditor editor, List<ResolvedPlanMode> planModes, String rankingMode, IParameter[] explicitRankParams, IMemento uiState) {
        super(editor, ID, PAGE_TITLE);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        ElementRemovedNotifierImpl notifier = new ElementRemovedNotifierImpl();
        this.fLabelProvider = new AntispamLabelProvider((IViewerLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)notifier), (IElementRemovedNotifier)notifier);
        IScriptEnvironment scriptEnvironment = this.getIterationPlanEditor().getScriptEnvironment();
        IQuickQueryDefinition quickQueryDefinition = (IQuickQueryDefinition)ScriptUtilities.newInstance((IScriptEnvironment)scriptEnvironment, IQuickQueryDefinition.class, (String)"com.ibm.team.apt.shared.ui.internal.quickquery.QuickQueryDefinition", (Object[])new Object[]{new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return ((IScriptTypeConverterFactory)IScriptEnvironment.CURRENT.adapt(IScriptTypeConverterFactory.class)).getConverter(ResolvedPlan.class).toScript(cx, scope, (Object)OutlinePage.this.fIterationPlan);
            }
        }});
        this.fQuickQueryParser = new QuickQueryParser(quickQueryDefinition, scriptEnvironment);
        this.fPlanModeStructure = new PlanModeStructure(planModes, rankingMode, explicitRankParams);
        this.loadState(uiState);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = managedForm.getForm().getBody();
        this.fStack = new StackLayout();
        this.fStack.marginWidth = 0;
        this.fStack.marginHeight = 0;
        parent.setLayout((Layout)this.fStack);
        this.fLoadingLabel = new AnimatedLoadingLabel(parent, 0);
        this.fLoadingLabel.setFont(JFaceResources.getHeaderFont());
        this.fOutlineComposite = new Composite(parent, 0);
        if (this.fFailureInfo == null) {
            if (this.fIterationPlan != null) {
                this.fStack.topControl = this.fOutlineComposite;
                parent.layout();
                this.setResolvedIterationPlan(this.fIterationPlan);
            } else {
                this.fLoadingLabel.start(0);
                this.fStack.topControl = this.fLoadingLabel;
                parent.layout();
            }
        } else {
            this.createFailurePage(parent);
        }
        UI.hookHelpListener((Control)parent, "com.ibm.team.apt.ide.ui.page_plannedItems");
    }

    public void dispose() {
        if (this.fQuickSearch != null) {
            this.fQuickSearch.dispose();
        }
        for (IColorizeDescription configuration : new ArrayList<IColorizeDescription>(this.fColorizers.keySet())) {
            this.removeColorizer(configuration);
        }
        if (this.fPreviewPane != null) {
            this.fPreviewPane.dispose();
        }
        if (this.fViewModel != null) {
            this.fViewModel.dispose();
        }
        if (this.fIterationPlanListener != null) {
            this.fIterationPlan.removeListener((IPlanElementListener)this.fIterationPlanListener);
        }
        this.fResourceManager.dispose();
        for (IOutlineSettingsListener listener : this.fAttachedSettingListeners) {
            this.getPlanOutlineSettings().removeSettingsChangeListener(listener);
        }
        this.fLabelProvider.dispose();
        PlanningUIPlugin.getDefault().getFilterUsageStatistics().removeUsageChangeListener(this.fFilterRankingListener);
        this.fIsDisposed = true;
        super.dispose();
    }

    @Override
    public void aboutToSave() {
        if (this.fScriptStore != null) {
            this.storeScriptStore();
        }
    }

    public void setFocus() {
        if (this.fOutline != null) {
            this.fOutline.setFocus();
            return;
        }
        super.setFocus();
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result == null && this.fPreviewPane != null) {
            result = this.fPreviewPane.getAdapter(adapter);
        }
        return result;
    }

    @Override
    public Action getAction(String id) {
        Action result = null;
        if (this.fPlanModeColorizeTab != null && this.fActivePart == this.fPlanModeColorizeTab.getControl() && (result = this.fPlanModeColorizeTab.getAction(id)) != null) {
            return result;
        }
        if (!(this.fQuickSearch == null || this.fActivePart != this.fQuickSearch.getControl() && (this.fActivePart != this.fOutline && this.fActivePart != this.fSideBar || "org.eclipse.ui.edit.text.contentAssist.proposals".equals(id)) || (result = this.fQuickSearch.getAction(id)) == null)) {
            return result;
        }
        if (this.fViewModel != null && (this.fActivePart == this.fOutline || this.fActivePart == this.fSideBar)) {
            result = this.fViewModel.getAction(id);
        } else if (this.fPreviewPane != null && this.fActivePart == this.fPreviewPane.getControl()) {
            result = this.fPreviewPane.getAction(id);
        }
        return result;
    }

    public void setInput(IterationPlanData data) {
        String defaultPlanMode;
        Assert.isTrue((boolean)Thread.currentThread().equals(this.getIterationPlanEditor().getSite().getShell().getDisplay().getThread()));
        this.fIterationPlanData = data;
        if (this.fDefaultOverrideable && (defaultPlanMode = data.getPlanType().getDefaultPlanMode()) != null && this.fPlanModeStructure.containsIdentifier(defaultPlanMode)) {
            this.fDefaultModeId = defaultPlanMode;
            this.doSetMode(this.fPlanModeStructure.get(defaultPlanMode));
        }
        if (this.fStack != null && this.fLoadingLabel != null) {
            this.fLoadingLabel.start(0);
            this.fStack.topControl = this.fLoadingLabel;
            this.getManagedForm().getForm().getBody().layout();
        }
        this.setBusy(true);
        if (this.fFuture != null) {
            this.fFuture.cancel();
        }
        this.fFailureInfo = null;
        ITeamFutureListener<ResolvedIterationPlan> teamFutureListener = new ITeamFutureListener<ResolvedIterationPlan>(){

            public void stateResolved(StateResolveEvent<ResolvedIterationPlan> event) {
            }

            public void resolvingDone(final TeamFutureEvent<ResolvedIterationPlan> event) {
                event.getTeamFuture().removeListener((ITeamFutureListener)this);
                OutlinePage.this.getIterationPlanEditor().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OutlinePage.this.setResolvedIterationPlan((ResolvedIterationPlan)event.getTeamFuture().getResult());
                        OutlinePage.this.fFuture = null;
                    }
                });
            }

            public void resolvingFailed(final TeamFutureEvent<ResolvedIterationPlan> event) {
                event.getTeamFuture().removeListener((ITeamFutureListener)this);
                OutlinePage.this.getIterationPlanEditor().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OutlinePage.this.doResolvingFailed((TeamFutureEvent<ResolvedIterationPlan>)event);
                        OutlinePage.this.fFuture = null;
                    }
                });
            }

            public void resolvingCanceled(TeamFutureEvent<ResolvedIterationPlan> event) {
                OutlinePage.this.fFuture = null;
            }
        };
        this.fFuture = new TeamFuture<ResolvedIterationPlan>(true, (ITeamFutureListener)teamFutureListener){

            protected ResolvedIterationPlan resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", 6);
                IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((ITeamRepository)OutlinePage.this.fIterationPlanData.getTeamRepository());
                IterationPlanClient planningClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)OutlinePage.this.fIterationPlanData.getTeamRepository());
                IAuditableCommonProcess processCommon = auditableClient.getProcess((IProcessAreaHandle)OutlinePage.this.fIterationPlanData.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ILicenseClient licenseClient = (ILicenseClient)OutlinePage.this.fIterationPlanData.getTeamRepository().getClientLibrary(ILicenseClient.class);
                IScriptEnvironment scriptEnvironment = OutlinePage.this.getIterationPlanEditor().getScriptEnvironment();
                List attributeDescriptors = planningClient.findConfigurationElements(IAttributeDefinitionDescriptor.class, processCommon, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                List<IPlanningAttribute<?, ?>> customAttributes = PlanningUICustomizationSupport.createCustomAttributes(attributeDescriptors, scriptEnvironment);
                List<PlanCheck> planChecks = PlanningUICustomizationSupport.createPlanChecks(OutlinePage.this.fIterationPlanData.getPlanType().getPlanChecks(), scriptEnvironment, licenseClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ResolvedIterationPlan result = planningClient.fetchIterationPlan(OutlinePage.this.fIterationPlanData, (Collection)attributeDescriptors, customAttributes, planChecks, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                result.connect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (OutlinePage.this.getPlanModel() != null) {
                    ArrayList<IPlanningAttribute> attributes = new ArrayList<IPlanningAttribute>();
                    for (IPlanningAttribute next : result.getAllAttributes()) {
                        if (!OutlinePage.this.getPlanModel().isPrepared(Collections.singleton(next))) continue;
                        attributes.add(next);
                    }
                    result.prepare((PlanElement)result, attributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                return result;
            }
        };
        this.fFuture.addListener((ITeamFutureListener)teamFutureListener);
    }

    public Composite getSideBar() {
        return this.fSideBar;
    }

    public IterationPlanViewModel getViewModel() {
        return this.fViewModel;
    }

    public void setPlanMode(String planModeId) {
        PlanModeState newState = this.fPlanModeStructure.get(planModeId);
        if (newState == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Unknown plan mode: {0}", (Object)planModeId, (Object[])new Object[0]));
        }
        if (this.fIterationPlan != null) {
            this.doSetMode(newState);
        } else {
            this.fDefaultModeId = planModeId;
        }
    }

    public TeamFuture<ResolvedIterationPlan> getFuture() {
        return this.fFuture;
    }

    public boolean toggleReadMode() {
        boolean bl = this.fIsReadModeEnabled = !this.fIsReadModeEnabled;
        if (this.fPreviewPane != null) {
            this.fPreviewPane.setVisible(this.fIsReadModeEnabled);
            if (this.fIsReadModeEnabled) {
                this.fPlanModeState.setShowDetails(false);
            } else {
                this.fPlanModeState.setShowDetails(true);
            }
        }
        return this.fIsReadModeEnabled;
    }

    protected String getRankingMode() {
        return this.fIterationPlanData.getRankingMode();
    }

    protected IParameter[] getExplicitRankParams() {
        return this.fIterationPlanData.getExplicitRankParams();
    }

    public void setPlanOutlineSettingsDEBUG(boolean showDetails, IPlanModeDescription planMode) {
        ISharedPlanMode sharedPlanMode = (ISharedPlanMode)ISharedPlanMode.ITEM_TYPE.createItem();
        sharedPlanMode.setOwner((IItemHandle)this.fIterationPlanData.getProjectArea());
        this.doSetMode(PlanModeState.newState(new ResolvedPlanMode(sharedPlanMode, planMode), this.getRankingMode(), this.getExplicitRankParams()));
    }

    private void setResolvedIterationPlan(ResolvedIterationPlan plan) {
        if (this.fIsDisposed) {
            return;
        }
        boolean inputExists = this.fIterationPlan != null;
        ISelection selection = null;
        IExpansionHull expansionHull = null;
        int scrollX = 0;
        int scrollY = 0;
        if (inputExists) {
            this.storeScriptStore();
            this.fIterationPlan.removeListener((IPlanElementListener)this.fIterationPlanListener);
            this.fIterationPlanData.setIterationPlan(null);
            if (this.fOutlineViewer != null) {
                selection = this.fOutlineViewer.getSelection();
                expansionHull = this.fViewModel.getExpansionHull(null);
                scrollX = this.fOutline.getTransformation().getX();
                scrollY = this.fOutline.getTransformation().getY();
            }
        }
        this.fIterationPlan = plan;
        this.fIterationPlanData.setIterationPlan(this.fIterationPlan);
        if (this.fOutlineViewer == null && this.getManagedForm() != null) {
            this.createOutliner();
            this.initializeOutliner();
        } else {
            this.doSetMode((PlanModeState)this.getPlanMode());
            if (this.fViewModel != null) {
                SafeRunner.run((ISafeRunnable)new ViewModelSafeRunnable(this){

                    @Override
                    public void doRun() throws Exception {
                        fViewModel.setInput(fIterationPlan);
                    }
                });
            }
        }
        if (!inputExists) {
            this.fIterationPlanListener = new IterationPlanListener();
        } else if (this.fOutlineViewer != null) {
            if (expansionHull != null) {
                this.fOutlineViewer.collapseAll();
                this.fViewModel.setExpansionHull(null, expansionHull);
            }
            if (selection != null) {
                this.fOutlineViewer.setSelection(selection);
                this.fOutline.scroll(scrollX, scrollY);
            }
        }
        if (this.fQuickFilterViewer != null) {
            this.fQuickFilterViewer.setInput(this.fIterationPlanData.getAllFilters());
        }
        this.fIterationPlan.addListener((IPlanElementListener)this.fIterationPlanListener);
        this.hookProgressComputerExtension();
        this.updateActions();
        this.setBusy(false);
        if (this.fLoadingLabel != null) {
            this.fLoadingLabel.stop();
        }
        if (this.fOutline != null) {
            this.fStack.topControl = this.fOutlineComposite;
            this.getManagedForm().getForm().getBody().layout();
        }
        this.fIterationPlan.triggerCheckerCalculation();
        if (plan.isDirty()) {
            this.setDirtyPartName();
        } else {
            this.setSavedPartName();
        }
        if (plan.isDirty()) {
            this.setDirtyPartName();
        } else {
            this.setSavedPartName();
        }
        for (IColorizeDescription colorizeDescription : this.fColorizers.keySet()) {
            this.updateColorizer(colorizeDescription);
        }
        this.setFocus();
    }

    private void updateActions() {
        if (this.fActionsViewer != null) {
            Collection oldActions = (Collection)this.fActionsViewer.getInput();
            if (oldActions != null) {
                for (ISidebarAction sidebarAction : oldActions) {
                    sidebarAction.removePropertyChangeListener(this.fInProgressActionListener);
                    sidebarAction.dispose();
                }
            }
            ArrayList<Action> sidebarActions = new ArrayList<Action>();
            sidebarActions.add(new ResortItemsAction(this.fViewModel));
            PlanCheckEngine checkEngine = this.fIterationPlan.getPlanChecker();
            Collection checks = checkEngine.getChecks();
            for (PlanCheck planCheck : checks) {
                if (planCheck.getCheckDescription().getTrigger() != IPlanCheckDescription.Trigger.manual) continue;
                PlanCheckTriggerAction checkTriggerAction = new PlanCheckTriggerAction(checkEngine, planCheck, (Control)this.fOutline);
                sidebarActions.add(checkTriggerAction);
                checkTriggerAction.addPropertyChangeListener(this.fInProgressActionListener);
            }
            this.fActionsViewer.setInput(sidebarActions);
            this.fSideBar.layout(true, true);
        }
    }

    private void hookProgressComputerExtension() {
        if (this.fViewModel == null) {
            return;
        }
        Class<IProgressComputer> key = IProgressComputer.class;
        if (this.fViewModel.getOption(key) != null) {
            return;
        }
        this.fViewModel.setOption(key, new IProgressComputer(){

            @Override
            public IProgressInformation getProgress(final IViewEntry<?> entry) {
                final IScriptEnvironment environment = OutlinePage.this.getIterationPlanEditor().getScriptEnvironment();
                return (IProgressInformation)entry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<IProgressInformation, RuntimeException>(){

                    public IProgressInformation run(final IViewModelReader readAccessor) throws RuntimeException {
                        return (IProgressInformation)environment.execute((IScriptRunnable)new IScriptRunnable<IProgressInformation, RuntimeException>(){

                            public IProgressInformation run(Context cx, Scriptable scope) throws RuntimeException {
                                IViewEntry[] children;
                                IViewEntry[] iViewEntryArray;
                                IComplexityAttribute attribute = ((ResolvedIterationPlan)entry.getModel().getInput()).getComplexityAttribute();
                                OutlineEntryItemAccessorScriptType accessor = new OutlineEntryItemAccessorScriptType(cx, scope, readAccessor, attribute);
                                IProgressInformation progressInformation = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)environment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
                                Scriptable computer = ProgressIDE.newProgressComputer(environment, entry, attribute != null, new Object[]{accessor, progressInformation});
                                if (ProgressIDE.useComplexity(entry) && attribute != null) {
                                    iViewEntryArray = accessor.getChildren(entry);
                                } else {
                                    IViewEntry[] iViewEntryArray2 = new IViewEntry[1];
                                    iViewEntryArray = iViewEntryArray2;
                                    iViewEntryArray2[0] = entry;
                                }
                                IViewEntry[] iViewEntryArray3 = children = iViewEntryArray;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IViewEntry child = iViewEntryArray3[n2];
                                    JSUtils.callMethod((IScriptEnvironment)environment, (Context)cx, (Scriptable)computer, (String)"compute", (Object[])new Object[]{child});
                                    ++n2;
                                }
                                return progressInformation;
                            }
                        });
                    }
                });
            }
        });
    }

    private void doResolvingFailed(TeamFutureEvent<ResolvedIterationPlan> event) {
        if (this.fIsDisposed) {
            return;
        }
        this.setBusy(false);
        if (this.fLoadingLabel != null) {
            this.fLoadingLabel.stop();
        }
        TeamFuture teamFuture = event.getTeamFuture();
        this.fFailureInfo = new FailureInfo(teamFuture.getException(), teamFuture.getStatus());
        if (this.getManagedForm() != null) {
            this.createFailurePage(this.getManagedForm().getForm().getBody());
        }
    }

    private void createFailurePage(Composite parent) {
        StatusComposite statusPresenter = new StatusComposite(parent, 0);
        TeamRepositoryException exception = this.fFailureInfo.exception;
        if (exception != null) {
            if (exception instanceof IterationPlanNoCategoriesException) {
                statusPresenter.setStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), this.fIterationPlanData.getOwner() instanceof ITeamAreaHandle ? NLS.bind((String)Messages.OutlinePage_ERROR_NO_CATEGORIES_TEAM_AREA, (Object)this.fIterationPlanData.getOwner().getName(), (Object[])new Object[0]) : NLS.bind((String)Messages.OutlinePage_ERROR_NO_CATEGORIES_PROJECT_AREA, (Object)this.fIterationPlanData.getOwner().getName(), (Object[])new Object[0])), Messages.OutlinePage_NO_CATEGORIES_HELP_MESSAGE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IProcessArea teamMemberArea = OutlinePage.this.fIterationPlanData.getOwner();
                        IProjectAreaHandle handle = teamMemberArea.getProjectArea();
                        Location location = Location.itemLocation((IItemHandle)handle, (String)OutlinePage.this.fIterationPlanData.getTeamRepository().getRepositoryURI());
                        Hyperlinks.open((URI)location.toAbsoluteUri(), null);
                    }
                });
            } else if (exception instanceof NotLoggedInException) {
                statusPresenter.setStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), Messages.OutlinePage_ERROR_NOT_LOGGED_IN));
            } else {
                PlanningUIPlugin.log(exception);
                statusPresenter.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getMessage(), (Throwable)exception));
            }
        } else {
            IStatus status = this.fFailureInfo.status;
            if (status != null && !status.isOK()) {
                PlanningUIPlugin.log(status);
                statusPresenter.setStatus(status);
            } else {
                statusPresenter.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), Messages.OutlinePage_ERROR_LOADING_FAILED));
            }
        }
        this.fStack.topControl = statusPresenter;
        parent.layout();
    }

    public IPlanOutlineSettings getPlanOutlineSettings() {
        return this.fSettingsDelegate;
    }

    protected void addColorizer(IColorizeDescription config) {
        QuickQueryColorizer colorizer = new QuickQueryColorizer(this.fViewModel);
        this.fColorizers.put(config, colorizer);
        this.updateColorizer(config);
    }

    protected void updateColorizer(IColorizeDescription config) {
        QuickQueryColorizer colorizer = this.fColorizers.get(config);
        if (colorizer != null) {
            colorizer.allowUpdates(false);
            try {
                colorizer.setExpression(this.fQuickQueryParser.getExpression(config.getExpression()));
                colorizer.setColor(QuickQueryColorUtil.parseColor(config.getValue()));
                colorizer.setEnabled(config.isEnabled());
                colorizer.setPriority(config.getPriority());
            }
            finally {
                colorizer.allowUpdates(true);
            }
        }
    }

    protected void removeColorizer(IColorizeDescription config) {
        QuickQueryColorizer colorizer = this.fColorizers.remove(config);
        if (colorizer != null) {
            colorizer.setEnabled(false);
        }
    }

    private void doSetMode(PlanModeState mode) {
        if (this.fViewModel == null) {
            return;
        }
        if (this.fIterationPlan != null && this.fPlanModeState != null) {
            this.storeScriptStore();
        }
        PlanModeState oldValue = null;
        if (this.fPlanModeState != null) {
            this.fPlanModeState.removeSettingsChangeListener(this.fSettingsDelegate);
            oldValue = this.fPlanModeState;
        }
        this.fPlanModeState = mode;
        this.fPlanModeState.addSettingsChangeListener(this.fSettingsDelegate);
        if (this.fIterationPlan != null) {
            this.loadScriptStore();
        }
        IUsageStatistics stats = PlanningUIPlugin.getDefault().getUsageStatistics(USAGE_PLAN_MODE);
        if (this.fPlanModeViewer.isExpanded()) {
            stats.promote(mode.getId());
        } else {
            stats.touch(mode.getId());
        }
        if (this.fQuickFilterViewer != null) {
            this.fQuickFilterViewer.getControl().setEnabled(mode.getDescription() != DefaultPlanType.DefaultPlanMode.INSTANCE);
            this.fQuickFilterViewer.setSelection((ISelection)new StructuredSelection((Object[])mode.getFilters()));
            this.fQuickFilterViewer.setFilter(new DeprecatedConfigurationElementCheckboxViewerFilter(), false);
        }
        this.fPlanModeViewer.setChecked(mode, true);
        this.fSettingsDelegate.settingChanged(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.REFRESH, (Object)mode, oldValue));
    }

    private void initializeOutliner() {
        this.hookActions();
        this.doSetMode(this.fPlanModeStructure.get(this.fDefaultModeId));
        this.hookProgressComputerExtension();
        SafeRunner.run((ISafeRunnable)new ViewModelSafeRunnable(this){

            @Override
            public void doRun() throws Exception {
                fViewModel.setInput(fIterationPlan);
            }
        });
    }

    private void storeScriptStore() {
        if (this.fScriptStore != null && this.fPlanModeState != null && this.fViewModel != null) {
            this.fViewModel.readModel(new IViewModelReadFunction<Void, RuntimeException>(){

                public Void run(IViewModelReader readAccessor) throws RuntimeException {
                    IViewEntrySorter sorter;
                    PlanModelTransformer modelTransformer = (PlanModelTransformer)OutlinePage.this.fViewModel.getModelTransformer();
                    if (modelTransformer instanceof JavaScriptPlanModelTransformer) {
                        ((JavaScriptPlanModelTransformer)modelTransformer).storeOptions(readAccessor);
                    }
                    if ((sorter = OutlinePage.this.fViewModel.getSorter()) instanceof ScriptableSorter) {
                        ((ScriptableSorter)sorter).storeOptions(readAccessor);
                    }
                    return null;
                }
            });
            this.fScriptStore.serialize(this.fIterationPlan.getStore().getStore(this.fPlanModeState.getId(), true));
        }
    }

    private void loadScriptStore() {
        if (this.fPlanModeState != null) {
            IViewEntrySorter sorter;
            WrappedScriptEnvironment storeCreationScriptEnvironment = new WrappedScriptEnvironment(this.getIterationPlanEditor().getScriptEnvironment());
            this.fScriptStore = (StoreScriptType)((Object)storeCreationScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<StoreScriptType, RuntimeException>(){

                public StoreScriptType run(Context cx, Scriptable scope) throws RuntimeException {
                    return new StoreScriptType(cx, scope, OutlinePage.this.fIterationPlan.getStore().getStore(OutlinePage.this.fPlanModeState.getId()), OutlinePage.this.fIterationPlan);
                }
            }));
            PlanModelTransformer modelTransformer = (PlanModelTransformer)this.fViewModel.getModelTransformer();
            if (modelTransformer instanceof JavaScriptPlanModelTransformer) {
                ((JavaScriptPlanModelTransformer)modelTransformer).loadOptions(this.fScriptStore);
            }
            if ((sorter = this.fViewModel.getSorter()) instanceof ScriptableSorter) {
                ((ScriptableSorter)sorter).loadOptions(this.fScriptStore);
            }
        }
    }

    ResolvedPlan getPlanModel() {
        return this.fIterationPlan;
    }

    IPlanModeDescription getPlanMode() {
        return this.fPlanModeState;
    }

    JavaScriptItemMovePolicy getItemMovePolicy() {
        return this.fItemMovePolicy;
    }

    void setItemMovePolicy(JavaScriptItemMovePolicy itemMovePolicy) {
        this.fItemMovePolicy = itemMovePolicy;
    }

    QuickQueryParser getQuickQueryParser() {
        return this.fQuickQueryParser;
    }

    StoreScriptType getScriptStore() {
        return this.fScriptStore;
    }

    private void activePartChanged(Control control) {
        this.fActivePart = control;
        this.fContextId = this.computeContextId();
        this.getIterationPlanEditor().refreshActionBarContributor();
        if (this.fActivePart == this.fOutline && this.fOutline != null) {
            this.getSite().setSelectionProvider((ISelectionProvider)this.fOutlineViewer);
        } else {
            this.getSite().setSelectionProvider(null);
        }
    }

    private void createOutliner() {
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(this.fOutlineComposite);
        this.fHyperlinkGroup = new HyperlinkGroup(this.getSite().getShell().getDisplay());
        this.fHyperlinkGroup.setHyperlinkUnderlineMode(2);
        Composite outerOutlineContainer = new Composite(this.fOutlineComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerOutlineContainer);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(outerOutlineContainer);
        this.fPlanModeConfiguration = this.createPlanModeConfigurationPart(outerOutlineContainer);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.fPlanModeConfiguration);
        this.fInnerOutlineContainer = new Composite(outerOutlineContainer, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fInnerOutlineContainer);
        this.fOutlineExceptionStack = new StackLayout();
        this.fOutlineExceptionStack.marginWidth = 0;
        this.fOutlineExceptionStack.marginHeight = 0;
        this.fInnerOutlineContainer.setLayout((Layout)this.fOutlineExceptionStack);
        this.fErrorContainer = new StatusComposite(this.fInnerOutlineContainer, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.fErrorContainer);
        this.fErrorContainer.setBackground(this.fErrorContainer.getDisplay().getSystemColor(25));
        this.fOutlineContainer = new Composite(this.fInnerOutlineContainer, 0);
        this.fOutlineContainer.setLayout((Layout)new FormLayout());
        this.fOutlineExceptionStack.topControl = this.fOutlineContainer;
        this.fOutline = new PlanItemOutline(this.fOutlineContainer, 0, this.getPlanOutlineSettings());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100, 0);
        this.fOutline.setLayoutData(data);
        ActivationListener listener = new ActivationListener((Control)this.fOutline);
        this.fOutline.addListener(26, listener);
        this.fOutline.addListener(27, listener);
        this.fOutlineViewer = new PlanItemOutlineViewer(this.fOutline, (IWorkbenchPartSite)this.getEditorSite());
        this.fOutlineViewer.setComparator(new OutlineModelViewerSorter());
        this.fOutlineViewer.setContentProvider((IContentProvider)new OutlineModelContentProvider());
        this.fOutlineViewer.addOpenListener(new PlanOpenListener(this.getEditorSite().getPage()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fOutlineViewer);
        this.fViewModel = new IterationPlanViewModel(this.getPlanOutlineSettings());
        this.fViewModel.setViewer(this.fOutlineViewer);
        this.fViewModel.hookContextMenu(this.getSite());
        this.attachSettingListener(new OutlinePageSettingsListener(this));
        this.attachSettingListener(new PlanOutlineSettingsListener(this.getPlanOutlineSettings()){
            private final EnumSet<PlanOutlineSettingChangeEvent.Property> fProperties;
            {
                this.fProperties = EnumSet.of(PlanOutlineSettingChangeEvent.Property.REFRESH, PlanOutlineSettingChangeEvent.Property.VIEW_MODE, PlanOutlineSettingChangeEvent.Property.GROUP_MODE, PlanOutlineSettingChangeEvent.Property.COLUMNS);
            }

            @Override
            public void handleFilterChanged(IFilterDescription filter, boolean added) {
                OutlinePage.this.fQuickFilterViewer.setSelection((ISelection)new StructuredSelection((Object[])OutlinePage.this.getPlanMode().getFilters()));
            }

            @Override
            public void settingChanged(OutlineSettingChangeEvent event) {
                if (this.fProperties.contains(event.getChangedProperty())) {
                    OutlinePage.this.fOutline.stopEditSession();
                }
            }
        });
        this.fOutlineViewer.setInput(this.fViewModel);
        this.createPreviewPane(this.fOutlineContainer);
        this.createSearchBar(outerOutlineContainer);
        this.fOutlineComposite.layout(new Control[]{this.fOutlineContainer, this.createSideBar(this.fOutlineComposite)});
        new TooltipSupport((Control)this.fOutline, true, false){

            public Object getElement(Control control, int x, int y) {
                IGObject graphicalObject = OutlinePage.this.fOutline.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return null;
                }
                Object element = graphicalObject.getElement();
                if (element instanceof IterationPlanItem && graphicalObject instanceof GLink) {
                    return ((IterationPlanItem)element).getWorkItemHandle();
                }
                if (element instanceof IContributor && (graphicalObject instanceof GLabel || graphicalObject instanceof GDeferredImage)) {
                    return element;
                }
                if (element instanceof IMarker) {
                    return element;
                }
                if (element instanceof LoadItem) {
                    return element;
                }
                if (element instanceof IProgressInformation) {
                    return element;
                }
                if (element instanceof IItemReference) {
                    return ((IItemReference)element).getReferencedItem();
                }
                return null;
            }

            public Rectangle getElementBounds(Control control, int x, int y) {
                IGObject graphicalObject = OutlinePage.this.fOutline.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return Rectangles.create(OutlinePage.this.fOutline.getTransformation().toViewPort(graphicalObject.getBounds()));
            }
        };
        ((IterationPlanEditor)this.getEditor()).refreshActionBarContributor();
    }

    private PlanModeConfigurationPart createPlanModeConfigurationPart(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fPlanModeConfiguration = new PlanModeConfigurationPart(parent, toolkit, 0);
        this.fPlanModeConfiguration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.data == PlanModeConfigurationPart.OK) {
                    PlanModeState originalPlanModeState;
                    PlanModeState newPlanModeState = OutlinePage.this.fPlanModeConfiguration.getInput();
                    String parentId = newPlanModeState.getParentId();
                    PlanModeState planModeState = originalPlanModeState = parentId != null ? OutlinePage.this.fPlanModeStructure.get(parentId) : null;
                    if (parentId == null || !ConfigurationElements.deepEquals((Object)newPlanModeState.getDescription(), (Object)originalPlanModeState.getDescription())) {
                        OutlinePage.this.savePlanMode(newPlanModeState);
                    } else {
                        OutlinePage.this.doSetMode(originalPlanModeState);
                    }
                } else if (e.data == PlanModeConfigurationPart.CANCEL) {
                    PlanModeState changedPlanModeState = OutlinePage.this.fPlanModeConfiguration.getInput();
                    PlanModeState originalPlanMode = OutlinePage.this.fPlanModeStructure.get(changedPlanModeState.getId());
                    OutlinePage.this.doSetMode(originalPlanMode != null ? originalPlanMode : (changedPlanModeState.getParentId() != null ? OutlinePage.this.fPlanModeStructure.get(changedPlanModeState.getParentId()) : OutlinePage.this.fPlanModeStructure.get(OutlinePage.this.fPlanModeStructure.someIdentifier())));
                }
                GridData gridData = (GridData)OutlinePage.this.fPlanModeConfiguration.getLayoutData();
                gridData.exclude = true;
                OutlinePage.this.fPlanModeViewer.setEnableConfigurationUI(false);
                OutlinePage.this.fPlanModeConfiguration.setVisible(false);
                OutlinePage.this.fPlanModeConfiguration.getParent().layout(true, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fPlanModeBasicTab = new PlanModeConfigurationTab(this.fIterationPlan.getProjectArea());
        Control control = this.fPlanModeConfiguration.addTab(this.fPlanModeBasicTab);
        ActivationListener listener = new ActivationListener(control);
        control.addListener(26, (Listener)listener);
        control.addListener(27, (Listener)listener);
        this.fPlanModeColumnsTab = new PlanModeColumnsTab();
        control = this.fPlanModeConfiguration.addTab(this.fPlanModeColumnsTab);
        listener = new ActivationListener(control);
        control.addListener(26, (Listener)listener);
        control.addListener(27, (Listener)listener);
        this.fPlanModeColorizeTab = new PlanModeColorizeTab(this.fQuickQueryParser);
        control = this.fPlanModeConfiguration.addTab(this.fPlanModeColorizeTab);
        listener = new ActivationListener(control);
        control.addListener(26, (Listener)listener);
        control.addListener(27, (Listener)listener);
        return this.fPlanModeConfiguration;
    }

    private void createSearchBar(Composite parent) {
        this.fQuickSearch = new QuickQueryBar(parent);
        this.fQuickSearch.setQuickQueryParser(this.fQuickQueryParser);
        Control control = this.fQuickSearch.getControl();
        ActivationListener listener = new ActivationListener(control);
        control.addListener(26, (Listener)listener);
        control.addListener(27, (Listener)listener);
        QuickQueryEntryFilter filter = new QuickQueryEntryFilter(this.fViewModel);
        this.fQuickSearch.registerParticipant(filter);
        QuickQueryColorizer colorizer = new QuickQueryColorizer(this.fViewModel);
        colorizer.setPriority(-1);
        colorizer.setLabel(Messages.OutlinePage_QUICK_COLORIZE);
        colorizer.setEnabled(true);
        colorizer.setColor(new RGB(255, 255, 0));
        this.fQuickSearch.registerParticipant(colorizer);
        QuickQueryEntryFinder finder = new QuickQueryEntryFinder((PlanViewModel)this.fViewModel){

            @Override
            public void setExpression(IQuickQueryExpression expression) {
                super.setExpression(expression);
                if (!this.find(true)) {
                    this.fViewModel.setSelectedEntries(Collections.EMPTY_LIST);
                }
            }
        };
        this.fQuickSearch.registerParticipant(finder);
    }

    private Control createPreviewPane(Composite parent) {
        this.fPreviewPane = new PreviewPane(parent, this.fOutline, this);
        Control previewControl = this.fPreviewPane.getControl();
        ActivationListener listener = new ActivationListener(previewControl);
        previewControl.addListener(26, (Listener)listener);
        previewControl.addListener(27, (Listener)listener);
        this.fPreviewPane.setVisible(this.fIsReadModeEnabled);
        this.fOutlineViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlanItem planItem = null;
                IViewEntry firstElement = (IViewEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (EntryUtils.isType(firstElement, PlanItem.class)) {
                    planItem = (PlanItem)firstElement.getElement();
                }
                OutlinePage.this.fPreviewPane.setInput(planItem);
            }
        });
        return previewControl;
    }

    private Composite createSideBar(Composite parent) {
        this.fSideBar = new Composite(parent, 0);
        ActivationListener listener = new ActivationListener((Control)this.fSideBar);
        this.fSideBar.addListener(26, (Listener)listener);
        this.fSideBar.addListener(27, (Listener)listener);
        int wHint = -1;
        GC gc = new GC((Drawable)this.fSideBar);
        try {
            gc.setFont(JazzResources.getFont((String)"com.ibm.team.jface.itemview.TitleFont"));
            wHint = gc.getFontMetrics().getAverageCharWidth() * 23;
        }
        finally {
            gc.dispose();
        }
        GridDataFactory.swtDefaults().align(1, 4).applyTo((Control)this.fSideBar);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).extendedMargins(0, 0, 0, 10).applyTo(this.fSideBar);
        Line separator = new Line(this.fSideBar, 512);
        separator.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.OutlineColor"));
        GridDataFactory.swtDefaults().align(1, 4).grab(false, true).span(0, 2).applyTo((Control)separator);
        Composite container = new Composite(this.fSideBar, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(0, 5).extendedMargins(0, 0, 5, 0).applyTo(container);
        container.setBackgroundMode(1);
        wHint = Math.max(wHint, this.createPlanModeContainer(container));
        this.createSeparator(container);
        wHint = Math.max(wHint, this.createActionsContainer(container));
        this.createSeparator(container);
        wHint = Math.max(wHint, this.createFilterContainer(container));
        this.createSeparator(container);
        wHint = Math.max(wHint, this.createRelatedPlansContainer(container));
        RGB listBackgroundRGB = this.fSideBar.getDisplay().getSystemColor(25).getRGB();
        Color widgetBackgroundColor = this.fSideBar.getDisplay().getSystemColor(22);
        Color sideBarTopColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)FormColors.blend((RGB)widgetBackgroundColor.getRGB(), (RGB)listBackgroundRGB, (int)10));
        GradientUtilities.setVerticalGradient((Composite)this.fSideBar, (Color)sideBarTopColor, (Color)widgetBackgroundColor);
        GridData data = (GridData)this.fSideBar.getLayoutData();
        data.widthHint = wHint + 10;
        return this.fSideBar;
    }

    private int createPlanModeContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        Text label = this.createTitle(composite, Messages.OutlinePage_VIEW_MODES_LABEL, 0);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        this.fPlanModeViewer = new CheckboxListViewer(composite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fPlanModeViewer.getControl());
        this.fPlanModeViewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof PlanModeStructure) {
                    return ((PlanModeStructure)inputElement).getActive().toArray();
                }
                return super.getElements(inputElement);
            }
        });
        this.fPlanModeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PlanModeState) {
                    return ((PlanModeState)element).getDisplayName();
                }
                return super.getText(element);
            }
        });
        this.fPlanModeViewer.setComparator(new ViewerComparator());
        this.fPlanModeViewer.setFilter(new ViewerFilter(){
            private final int fTop = 5;
            private List<String> fPlanModeIds = new ArrayList<String>(5);

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                this.fPlanModeIds.clear();
                for (PlanModeState planModeState : OutlinePage.this.fPlanModeStructure.getActive()) {
                    this.fPlanModeIds.add(planModeState.getId());
                }
                IUsageStatistics stats = PlanningUIPlugin.getDefault().getUsageStatistics(OutlinePage.USAGE_PLAN_MODE);
                stats.sort(this.fPlanModeIds);
                this.fPlanModeIds = this.fPlanModeIds.size() < 5 ? this.fPlanModeIds : this.fPlanModeIds.subList(0, 5);
                return super.filter(viewer, parent, elements);
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return this.fPlanModeIds.contains(((IPlanModeDescription)element).getId());
            }
        });
        this.fPlanModeViewer.setConfigurationUIProvider(new ConfigurationUIProvider(){

            @Override
            public ConfigurationUIProvider.IConfigurationUI getConfigureUI(Object element) {
                return new DeletePlanModeUI();
            }

            @Override
            public boolean canConfigure(Object element) {
                if (!(element instanceof PlanModeState)) {
                    return false;
                }
                return !(((PlanModeState)element).getOrigin().getOwner() instanceof IProcessDefinitionHandle);
            }
        });
        this.fPlanModeViewer.setInput(this.fPlanModeStructure);
        this.fPlanModeViewer.setChecked(this.fPlanModeStructure.get(this.fDefaultModeId), true);
        this.fPlanModeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked()) {
                    return;
                }
                PlanModeState planModeState = (PlanModeState)event.getElement();
                OutlinePage.this.doSetPlanModeConfigurationPartInput(planModeState);
            }
        });
        this.fPlanModeViewer.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OutlinePage.this.fSideBar.layout(true, true);
            }
        });
        Composite commands = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(LayoutConstants.getSpacing().x / 2, 0).applyTo(commands);
        GridDataFactory.swtDefaults().indent(5, 0).align(1, 0x1000000).applyTo((Control)commands);
        Hyperlink link = this.createLink(commands, Messages.OutlinePage_VIEW_MODES_SHOW_CONFIGURATION);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)link);
        this.fHyperlinkGroup.add(link);
        link.addHyperlinkListener((IHyperlinkListener)new PlanModeHyperlinkListener(false));
        int hint = 8;
        GC gc = new GC((Drawable)link);
        try {
            gc.setFont(link.getFont());
            hint = gc.getFontMetrics().getHeight() - gc.getFontMetrics().getLeading();
        }
        finally {
            gc.dispose();
        }
        Label line = new Label(commands, 514);
        GridDataFactory.swtDefaults().align(1, 0x1000000).hint(-1, hint).applyTo((Control)line);
        link = this.createLink(commands, Messages.OutlinePage_VIEW_MODES_NEW);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)link);
        this.fHyperlinkGroup.add(link);
        link.addHyperlinkListener((IHyperlinkListener)new PlanModeHyperlinkListener(true));
        return label.computeSize((int)-1, (int)-1).x;
    }

    private void doSetPlanModeConfigurationPartInput(PlanModeState planModeState) {
        if (!((GridData)this.fPlanModeConfiguration.getLayoutData()).exclude) {
            planModeState = PlanModeState.editState(planModeState);
            this.fPlanModeConfiguration.setInput(planModeState);
        }
        this.doSetMode(planModeState);
    }

    private int createActionsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        Text label = this.createTitle(container, Messages.OutlinePage_ACTIONS_LABEL, 0);
        this.fActionFont = container.getFont();
        FontData[] normalFontData = this.fActionFont.getFontData();
        FontData[] italicFontData = new FontData[normalFontData.length];
        int i = 0;
        while (i < normalFontData.length) {
            italicFontData[i] = new FontData(normalFontData[i].getName(), normalFontData[i].getHeight(), normalFontData[i].getStyle() | 2);
            ++i;
        }
        this.fActionInProgressFont = JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])italicFontData), (Font)this.fActionFont);
        this.fActionsViewer = new CommandListViewer(container, this.fHyperlinkGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fActionsViewer.getControl());
        this.fActionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fActionsViewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.fActionsViewer.setComparator(new ViewerComparator());
        this.fActionsViewer.addCommandLinkListener(new ICommandLinkListener(){

            @Override
            public void selected(CommandLinkEvent e) {
                ((ISidebarAction)e.getElement()).run();
            }
        });
        return label.computeSize((int)-1, (int)-1).x;
    }

    private int createFilterContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        Text label = this.createTitle(container, Messages.OutlinePage_GROUP_FILTERS, 0);
        this.fQuickFilterViewer = new CheckboxListViewer(container, 32);
        GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).applyTo(this.fQuickFilterViewer.getControl());
        this.fQuickFilterViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
        this.fQuickFilterViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fQuickFilterViewer.setComparator(new ViewerComparator());
        this.fQuickFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IFilterDescription filter = (IFilterDescription)event.getElement();
                if (event.getChecked()) {
                    OutlinePage.this.fPlanModeState.addFilter(filter);
                } else {
                    OutlinePage.this.fPlanModeState.removeFilter(filter);
                }
            }
        });
        if (this.getIterationPlanData() != null) {
            this.fQuickFilterViewer.setInput(this.getIterationPlanData().getAllFilters());
        }
        return label.computeSize((int)-1, (int)-1).x;
    }

    private int createRelatedPlansContainer(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        Text title = this.createTitle(container, Messages.OutlinePage_SIDEBAR_PLANS_RELATED, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)title);
        int width = title.computeSize((int)-1, (int)-1).x;
        final CommandListViewer viewer = new CommandListViewer(container, this.fHyperlinkGroup, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, true).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        viewer.addCommandLinkListener(new ICommandLinkListener(){

            @Override
            public void selected(CommandLinkEvent e) {
                Object element = e.getElement();
                if (element instanceof IIterationPlanRecordHandle) {
                    PlanningUI.openIterationPlanEditor((IIterationPlanRecordHandle)element, OutlinePage.this.getIterationPlanEditor().getSite().getPage());
                }
            }
        });
        this.fLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                viewer.refresh();
            }
        });
        IDeferredResolver<List<IIterationPlanRecord>> resolver = new IDeferredResolver<List<IIterationPlanRecord>>(){

            public List<IIterationPlanRecord> resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IIterationPlanRecordHandle handle = ((IterationPlanEditorInput)OutlinePage.this.getIterationPlanEditor().getEditorInput()).getHandle();
                IIterationPlanClient planClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
                IItemQueryPage queryPage = planClient.fetchRelatedPlans(handle, (IProgressMonitor)progress.newChild(1));
                if (queryPage != null) {
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                    return itemManager.fetchCompleteItems(queryPage.getItemHandles(), 0, (IProgressMonitor)progress.newChild(1));
                }
                return Collections.emptyList();
            }
        };
        IDeferredResolveListener<List<IIterationPlanRecord>> resolveListener = new IDeferredResolveListener<List<IIterationPlanRecord>>(){

            public void resolved(final List<IIterationPlanRecord> result) {
                UI.asyncExec((Control)container, new Runnable(){

                    @Override
                    public void run() {
                        viewer.setInput(result);
                        OutlinePage.this.fSideBar.layout(true, true);
                    }
                });
            }

            public void canceled() {
                this.resolved(Collections.emptyList());
            }

            public void failed(IStatus state) {
                this.resolved(Collections.emptyList());
                PlanningClientPlugin.log((IStatus)state);
            }
        };
        this.getIterationPlanEditor().deferredResolve(resolver, resolveListener, false);
        return width;
    }

    private Hyperlink createLink(Composite composite, String string) {
        Hyperlink l = new Hyperlink(composite, 64);
        l.setText(string);
        return l;
    }

    private Text createTitle(Composite parent, String text, int style) {
        Text l = new Text(parent, style | 8 | 0x40000000);
        l.setText(text);
        l.setFont(JazzResources.getFont((String)"com.ibm.team.jface.itemview.TitleFont"));
        l.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.TitleColor"));
        return l;
    }

    private void createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
    }

    public String getContextId() {
        return this.fContextId;
    }

    private String computeContextId() {
        if (this.fOutline != null && this.fActivePart == this.fOutline) {
            return "com.ibm.team.apt.actions.iterationPlanEditor.outline.plannedItems";
        }
        return "com.ibm.team.apt.actions.iterationPlanEditor.outline.bars";
    }

    private void hookActions() {
        Action action;
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Action[] actionArray = this.fQuickSearch.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
            ++n2;
        }
        actionArray = this.fViewModel.getActions();
        n = actionArray.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
            ++n2;
        }
        this.fOutline.addGadgetEditorActivationListener(new IGadgetEditorActivationListener(){

            @Override
            public void activated(IGadgetEditor editor) {
                if (editor == null) {
                    return;
                }
                Gadget gadget = editor.getGadget();
                if (!(gadget instanceof GText)) {
                    return;
                }
                String id = ((GText)gadget).getId();
                if ("summary".equals(id)) {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing.summary";
                } else if ("description".equals(id)) {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing.description";
                } else {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing";
                }
                OutlinePage.this.getIterationPlanEditor().refreshActionBarContributor();
            }

            @Override
            public void deactivated(IGadgetEditor editor) {
                if (editor == null) {
                    return;
                }
                OutlinePage.this.fContextId = OutlinePage.this.computeContextId();
                OutlinePage.this.getIterationPlanEditor().refreshActionBarContributor();
            }
        });
    }

    public void saveState(IMemento memento) {
        if (this.fPlanModeState != null) {
            memento.putString(ACTIVE_PLAN_MODE, this.fPlanModeState.getId());
        }
    }

    public void loadState(IMemento memento) {
        this.fDefaultOverrideable = true;
        this.fDefaultModeId = this.fPlanModeStructure.someIdentifier();
        if (memento == null) {
            return;
        }
        String value = memento.getString(ACTIVE_PLAN_MODE);
        if (value != null && this.fPlanModeStructure.containsIdentifier(value)) {
            this.fDefaultModeId = value;
            this.fDefaultOverrideable = false;
        }
    }

    public void savePlanMode(final PlanModeState modeState) {
        IDeferredResolver<PlanModeState> resolver = new IDeferredResolver<PlanModeState>(){

            public PlanModeState resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                if (!modeState.isDirty()) {
                    return null;
                }
                ISharedPlanMode sharedPlanMode = (ISharedPlanMode)modeState.getOrigin().getWorkingCopy();
                if (sharedPlanMode.getOwner() instanceof IProcessDefinitionHandle) {
                    sharedPlanMode.setOwner((IItemHandle)OutlinePage.this.fIterationPlanData.getOwner());
                }
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot((String)"auxiliaryData");
                    ConfigurationElementFactory.serializeIntoConfigData((Object)modeState.getDescription(), (IMemento)memento);
                    sharedPlanMode.setDescription(memento.asXMLString());
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)OutlinePage.this.fIterationPlanData.getTeamRepository());
                sharedPlanMode = (ISharedPlanMode)client.saveSharedPlanModeDescription(Arrays.asList(sharedPlanMode), monitor).get(0);
                return PlanModeState.newState(new ResolvedPlanMode(sharedPlanMode, modeState.getDescription()), OutlinePage.this.getRankingMode(), OutlinePage.this.getExplicitRankParams());
            }
        };
        IDeferredResolveListener<PlanModeState> listener = new IDeferredResolveListener<PlanModeState>(){

            public void canceled() {
                this.failed((IStatus)new Status(8, PlanningClientPlugin.getPluginId(), null));
            }

            public void failed(final IStatus status) {
                UI.asyncExec((Control)OutlinePage.this.fOutline, new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)OutlinePage.this.fOutline.getShell(), (String)Messages.OutlinePage_PLAN_MODE_SAVE_TITLE, (String)NLS.bind((String)Messages.OutlinePage_PLAN_MODE_SAVE_FAILURE, (Object)modeState.getDisplayName(), (Object[])new Object[0]), (IStatus)status);
                        String identifier = OutlinePage.this.fPlanModeStructure.someIdentifier();
                        OutlinePage.this.doSetMode(OutlinePage.this.fPlanModeStructure.get(identifier));
                    }
                });
            }

            public void resolved(final PlanModeState result) {
                UI.asyncExec((Control)OutlinePage.this.fOutline, new Runnable(){

                    @Override
                    public void run() {
                        OutlinePage.this.fPlanModeStructure.insert(result);
                        PlanningUIPlugin.getDefault().getUsageStatistics(OutlinePage.USAGE_PLAN_MODE).promote(result.getId());
                        OutlinePage.this.fPlanModeViewer.refresh();
                        OutlinePage.this.fSideBar.layout(true, true);
                        OutlinePage.this.doSetMode(result);
                    }
                });
            }
        };
        this.getIterationPlanEditor().deferredResolve(resolver, listener, true);
    }

    private void attachSettingListener(IOutlineSettingsListener listener) {
        this.getPlanOutlineSettings().addSettingsChangeListener(listener);
        this.fAttachedSettingListeners.add(listener);
    }

    private void setDirtyPartName() {
        if (this.fDirty) {
            return;
        }
        this.fDirty = true;
        this.getIterationPlanEditor().asyncExec(new Runnable(){

            @Override
            public void run() {
                OutlinePage.this.setPartName("*" + PAGE_TITLE);
            }
        });
    }

    private void setSavedPartName() {
        if (!this.fDirty) {
            return;
        }
        this.fDirty = false;
        this.getIterationPlanEditor().asyncExec(new Runnable(){

            @Override
            public void run() {
                OutlinePage.this.setPartName(PAGE_TITLE);
            }
        });
    }

    void displayErrorStatus(IStatus s) {
        Composite topControl;
        if (s != null && !s.isOK()) {
            this.fErrorContainer.setStatus(s);
            topControl = this.fErrorContainer;
        } else {
            topControl = this.fOutlineContainer;
        }
        if (this.fOutlineExceptionStack.topControl != topControl) {
            this.fOutlineExceptionStack.topControl = topControl;
            this.fInnerOutlineContainer.layout(true, true);
        }
    }

    private class ActionLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private ActionLabelProvider() {
        }

        public String getText(Object element) {
            return ((ISidebarAction)element).getText();
        }

        public Image getImage(Object element) {
            boolean enabled = ((ISidebarAction)element).isEnabled();
            return OutlinePage.this.fResourceManager.createImage(enabled ? ImagePool.VERIFY_RUN_ENABLED : ImagePool.VERIFY_RUN_DISABLED);
        }

        public Font getFont(Object element) {
            return ((ISidebarAction)element).isInProgress() ? OutlinePage.this.fActionInProgressFont : OutlinePage.this.fActionFont;
        }
    }

    private class ActivationListener
    implements Listener {
        private Control fControl;

        public ActivationListener(Control control) {
            this.fControl = control;
        }

        public void handleEvent(Event event) {
            if (event.type == 26) {
                OutlinePage.this.activePartChanged(this.fControl);
            } else if (event.type == 27 && OutlinePage.this.fActivePart == this.fControl) {
                OutlinePage.this.activePartChanged(null);
            }
        }
    }

    private final class DeletePlanModeUI
    implements ConfigurationUIProvider.IConfigurationUI {
        private CheckboxListViewer.DeletationMarkDrawingStrategy fDrawingStrategy;

        private DeletePlanModeUI() {
        }

        @Override
        public void configure(Object element, Shell shell) {
            String message;
            final PlanModeState planState = (PlanModeState)element;
            final SortedSet<PlanModeState> modeStates = OutlinePage.this.fPlanModeStructure.all(planState.getId());
            String string = message = modeStates.size() <= 1 ? NLS.bind((String)Messages.OutlinePage_DELETE_PLAN_MODE_CONFIRM_1, (Object)planState.getDisplayName(), (Object[])new Object[0]) : NLS.bind((String)Messages.OutlinePage_DELETE_PLAN_MODE_CONFORM_2, (Object)planState.getDisplayName(), (Object[])new Object[0]);
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.OutlinePage_DELETE_PLAN_MODE_TITLE, (String)message)) {
                IProgressService service = UI.getProgressService((IWorkbenchPart)OutlinePage.this.getIterationPlanEditor());
                try {
                    service.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                        @Override
                        protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                            try {
                                IIterationPlanRecord handle = OutlinePage.this.getIterationPlanData().getPlanRecord();
                                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
                                client.deleteSharedPlanModeDescription((IProjectAreaHandle)OutlinePage.this.getIterationPlanData().getProjectArea(), Arrays.asList(planState.getOrigin()), monitor);
                                OutlinePage.this.fPlanModeStructure.remove(planState);
                                PlanningUIPlugin.getDefault().getUsageStatistics(OutlinePage.USAGE_PLAN_MODE).remove(planState.getId());
                            }
                            catch (Throwable throwable) {
                                UI.syncExec(OutlinePage.this.fPlanModeViewer.getControl(), new Runnable(planState, modeStates){
                                    private final /* synthetic */ PlanModeState val$planState;
                                    private final /* synthetic */ SortedSet val$modeStates;
                                    {
                                        this.val$planState = planModeState;
                                        this.val$modeStates = sortedSet;
                                    }

                                    @Override
                                    public void run() {
                                        boolean updateSelection = OutlinePage.this.fPlanModeViewer.getChecked(this.val$planState);
                                        OutlinePage.this.fPlanModeViewer.refresh();
                                        OutlinePage.this.fSideBar.layout(true, true);
                                        if (updateSelection) {
                                            PlanModeState selection = this.val$modeStates.isEmpty() ? OutlinePage.this.fPlanModeStructure.get(OutlinePage.this.fPlanModeStructure.someIdentifier()) : (PlanModeState)this.val$modeStates.first();
                                            OutlinePage.this.fPlanModeViewer.setChecked(selection, true);
                                            OutlinePage.this.doSetPlanModeConfigurationPartInput(selection);
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            UI.syncExec(OutlinePage.this.fPlanModeViewer.getControl(), new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    PlanningClientPlugin.log((Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)Messages.OutlinePage_DELETE_PLAN_MODE_TITLE, (String)Messages.OutlinePage_DELETE_PLAN_MODE_FAILURE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public CheckboxListViewer.IDrawingStrategy getDrawingStrategy(Object element) {
            if (this.fDrawingStrategy == null) {
                this.fDrawingStrategy = new CheckboxListViewer.DeletationMarkDrawingStrategy();
            }
            return this.fDrawingStrategy;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof IPlanModeDescription) {
                return NLS.bind((String)Messages.OutlinePage_DELETE_PLAN_MODE_DESC, (Object)((IPlanModeDescription)element).getDisplayName(), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private static class FailureInfo {
        public TeamRepositoryException exception;
        public IStatus status;

        public FailureInfo(TeamRepositoryException e, IStatus s) {
            this.exception = e;
            this.status = s;
        }
    }

    private final class InProgressUI
    implements ConfigurationUIProvider.IConfigurationUI {
        private CheckboxListViewer.IDrawingStrategy fDrawingStrategy;

        private InProgressUI() {
        }

        @Override
        public void configure(Object element, Shell shell) {
        }

        @Override
        public CheckboxListViewer.IDrawingStrategy getDrawingStrategy(Object element) {
            if (this.fDrawingStrategy == null) {
                this.fDrawingStrategy = new CheckboxListViewer.AnimatedImageDrawingStrategy(ImagePool.PROGRESS);
            }
            return this.fDrawingStrategy;
        }

        @Override
        public String getText(Object element) {
            return null;
        }
    }

    private final class IterationPlanListener
    implements IPlanElementListener {
        private IterationPlanListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            final Boolean[] dirty = new Boolean[1];
            if (OutlinePage.this.fOutlineViewer == null) {
                event.getDelta().accept(new IPlanElementDeltaVisitor(){

                    public boolean visit(IPlanElementDelta delta) {
                        PlanElement element = delta.getPlanElement();
                        if (element instanceof ResolvedIterationPlan) {
                            IPlanAttributeDelta attribute = delta.getAttributeDelta(ResolvedPlan.DIRTY);
                            if (attribute == null) {
                                return true;
                            }
                            dirty[0] = (Boolean)attribute.getNewValue();
                            return false;
                        }
                        return true;
                    }
                });
            } else {
                String[] newLabel = new String[1];
                event.getDelta().accept(new IPlanElementDeltaVisitor(){

                    public boolean visit(IPlanElementDelta delta) {
                        PlanElement element = delta.getPlanElement();
                        if (element instanceof ResolvedIterationPlan) {
                            IPlanAttributeDelta attribute = delta.getAttributeDelta(ResolvedPlan.DIRTY);
                            if (attribute == null) {
                                return true;
                            }
                            dirty[0] = (Boolean)attribute.getNewValue();
                            return true;
                        }
                        return true;
                    }
                });
            }
            if (dirty[0] != null) {
                if (dirty[0].booleanValue()) {
                    OutlinePage.this.setDirtyPartName();
                } else {
                    OutlinePage.this.setSavedPartName();
                }
            }
        }
    }

    private final class PlanModeHyperlinkListener
    extends HyperlinkAdapter {
        private final boolean fNew;

        private PlanModeHyperlinkListener(boolean newPlanMode) {
            this.fNew = newPlanMode;
        }

        public void linkActivated(HyperlinkEvent e) {
            final GridData gridData = (GridData)OutlinePage.this.fPlanModeConfiguration.getLayoutData();
            if (!gridData.exclude && !this.fNew) {
                return;
            }
            class Result {
                public List<IViewModeDescription> viewmodes;
                public List<IGroupModeDescription> groupings;
                public List<IFilterDescription> filterings;
                public List<ISortModeDescription> sortings;
                public List<IAttributeDefinitionDescriptor> attributes;

                Result() {
                }
            }
            IDeferredResolver<Result> resolver = new IDeferredResolver<Result>(){

                public Result resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                    IProcessArea teamMemberArea = OutlinePage.this.getIterationPlanData().getOwner();
                    IIterationPlanClient common = PlanningClientPlugin.getIterationPlanClient((IItemHandle)teamMemberArea);
                    IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)teamMemberArea).getProcess((IProcessAreaHandle)teamMemberArea, (IProgressMonitor)progress.newChild(1));
                    Result result = new Result();
                    result.viewmodes = PlanningUICustomizationSupport.filterViewModes(common.findConfigurationElements(IViewModeDescription.class, process, (IProgressMonitor)progress.newChild(1)));
                    result.groupings = PlanningUICustomizationSupport.filterGroupModes(common.findConfigurationElements(IGroupModeDescription.class, process, (IProgressMonitor)progress.newChild(1)));
                    result.sortings = PlanningUICustomizationSupport.filterSortModes(common.findConfigurationElements(ISortModeDescription.class, process, (IProgressMonitor)progress.newChild(1)));
                    result.filterings = PlanningUICustomizationSupport.excludeWebOnlyFilters(common.findConfigurationElements(IFilterDescription.class, process, (IProgressMonitor)progress.newChild(1)));
                    result.attributes = common.findConfigurationElements(IAttributeDefinitionDescriptor.class, process, (IProgressMonitor)progress.newChild(1));
                    return result;
                }
            };
            IDeferredResolveListener<Result> listener = new IDeferredResolveListener<Result>(){

                public void canceled() {
                    UI.asyncExec((Control)OutlinePage.this.fPlanModeConfiguration, new Runnable(){

                        @Override
                        public void run() {
                            gridData.exclude = true;
                            OutlinePage.this.fPlanModeViewer.setEnableConfigurationUI(false);
                            OutlinePage.this.fPlanModeConfiguration.setVisible(false);
                            OutlinePage.this.fPlanModeConfiguration.getParent().layout(true, true);
                        }
                    });
                }

                public void failed(IStatus state) {
                    PlanningClientPlugin.log((IStatus)state);
                }

                public void resolved(final Result result) {
                    UI.asyncExec((Control)OutlinePage.this.fPlanModeConfiguration, new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            PlanModeState input;
                            OutlinePage.this.fPlanModeBasicTab.setViewModes(result.viewmodes);
                            OutlinePage.this.fPlanModeBasicTab.setGroupings(result.groupings);
                            OutlinePage.this.fPlanModeBasicTab.setFilterings(result.filterings);
                            OutlinePage.this.fPlanModeBasicTab.setSortings(result.sortings);
                            OutlinePage.this.fPlanModeColumnsTab.setAvailableAttributes(result.attributes);
                            PlanModeState planModeState = (PlanModeState)((IStructuredSelection)OutlinePage.this.fPlanModeViewer.getSelection()).getFirstElement();
                            if (PlanModeHyperlinkListener.this.fNew) {
                                input = PlanModeState.copyState(planModeState);
                                input.setDisplayName(NLS.bind((String)Messages.OutlinePage_VIEW_MODES_LABEL_NEW, (Object)input.getDisplayName(), (Object[])new Object[0]));
                                input.setId(UUID.generate().getUuidValue());
                            } else {
                                input = PlanModeState.editState(planModeState);
                                input.setDirty(true);
                            }
                            OutlinePage.this.fPlanModeConfiguration.setInput(input);
                            OutlinePage.this.fPlanModeConfiguration.setVisible(true);
                            gridData.exclude = false;
                            OutlinePage.this.doSetMode(input);
                            OutlinePage.this.fPlanModeConfiguration.getParent().layout(true, true);
                            OutlinePage.this.fPlanModeViewer.setEnableConfigurationUI(true);
                        }
                    });
                }
            };
            OutlinePage.this.getIterationPlanEditor().deferredResolve(resolver, listener, true);
        }
    }

    private static class PlanModeStructure
    implements Iterable<PlanModeState> {
        private final Comparator<PlanModeState> fgComparator = new Comparator<PlanModeState>(){
            private SharedPlanModeComparator fDelegate;

            @Override
            public int compare(PlanModeState o1, PlanModeState o2) {
                if (this.fDelegate == null) {
                    this.fDelegate = new SharedPlanModeComparator(SortMode.DESC);
                }
                return this.fDelegate.compare(o1.getOrigin(), o2.getOrigin());
            }
        };
        private Map<String, SortedSet<PlanModeState>> fAllPlanModeStates = new HashMap<String, SortedSet<PlanModeState>>();

        private PlanModeStructure(List<ResolvedPlanMode> planModes, String rankingMode, IParameter[] explicitRankParams) {
            for (ResolvedPlanMode planMode : planModes) {
                this.insert(PlanModeState.newState(planMode, rankingMode, explicitRankParams));
            }
        }

        public void insert(PlanModeState planMode) {
            boolean add;
            SortedSet<PlanModeState> set = this.all(planMode.getId());
            if (set == null) {
                set = new TreeSet<PlanModeState>(this.fgComparator);
                this.fAllPlanModeStates.put(planMode.getId(), set);
            }
            if (!(add = set.add(planMode))) {
                set.remove(planMode);
                set.add(planMode);
            }
        }

        public boolean remove(PlanModeState planMode) {
            String identifier = planMode.getId();
            SortedSet<PlanModeState> set = this.fAllPlanModeStates.get(identifier);
            if (set == null) {
                return false;
            }
            boolean remove = set.remove(planMode);
            if (set.isEmpty()) {
                this.fAllPlanModeStates.remove(identifier);
            }
            return remove;
        }

        public boolean replace(PlanModeState remove, PlanModeState insert) {
            boolean b = this.remove(remove);
            this.insert(insert);
            return b;
        }

        public PlanModeState get(String identifier) {
            SortedSet<PlanModeState> planModes = this.all(identifier);
            return planModes == null || planModes.isEmpty() ? null : planModes.first();
        }

        public SortedSet<PlanModeState> all(String identifier) {
            return this.fAllPlanModeStates.get(identifier);
        }

        @Override
        public Iterator<PlanModeState> iterator() {
            final Iterator<SortedSet<PlanModeState>> outerDelegate = this.fAllPlanModeStates.values().iterator();
            return new Iterator<PlanModeState>(){
                private Iterator<PlanModeState> fCurrentDelegate;

                private void ensureDelegate() {
                    if ((this.fCurrentDelegate == null || !this.fCurrentDelegate.hasNext()) && outerDelegate.hasNext()) {
                        this.fCurrentDelegate = ((SortedSet)outerDelegate.next()).iterator();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.ensureDelegate();
                    return this.fCurrentDelegate != null && this.fCurrentDelegate.hasNext();
                }

                @Override
                public PlanModeState next() {
                    this.ensureDelegate();
                    return this.fCurrentDelegate.next();
                }

                @Override
                public void remove() {
                    this.fCurrentDelegate.remove();
                }
            };
        }

        public List<PlanModeState> getActive() {
            ArrayList<PlanModeState> result = new ArrayList<PlanModeState>();
            Collection<SortedSet<PlanModeState>> values = this.fAllPlanModeStates.values();
            for (SortedSet<PlanModeState> list : values) {
                PlanModeState first = list.first();
                if (PlanningUICustomizationSupport.filterV3PlanMode(first.getDescription())) continue;
                result.add(first);
            }
            return result;
        }

        public boolean containsIdentifier(Object key) {
            return this.fAllPlanModeStates.containsKey(key);
        }

        public String someIdentifier() {
            return this.fAllPlanModeStates.keySet().iterator().next();
        }
    }

    private class SettingsDelegate
    implements IPlanOutlineSettings,
    IOutlineSettingsListener {
        private final ListenerList fSettingListeners = new ListenerList(1);

        private SettingsDelegate() {
        }

        @Override
        public boolean isUsable() {
            return OutlinePage.this.fPlanModeState == null ? false : OutlinePage.this.fPlanModeState.isUsable();
        }

        @Override
        public ItemMovePolicy getItemMovePolicy() {
            return OutlinePage.this.fItemMovePolicy;
        }

        public IColumnDescriptor[] getColumns() {
            return OutlinePage.this.fPlanModeState.getColumns();
        }

        public IColumnDescriptor[] setColumns(IColumnDescriptor[] value) {
            return OutlinePage.this.fPlanModeState.setColumns(value);
        }

        @Override
        public boolean getShowDetails() {
            return OutlinePage.this.fPlanModeState.getShowDetails();
        }

        @Override
        public String getDefaultWorkItemType() {
            return OutlinePage.this.fPlanModeState.getDefaultWorkItemType();
        }

        @Override
        public void setDefaultWorkItemType(String value) {
            OutlinePage.this.fPlanModeState.setDefaultWorkItemType(value);
        }

        public ProgressMode getProgressMode() {
            return OutlinePage.this.fPlanModeState.getProgressMode();
        }

        public String getDisplayName() {
            return OutlinePage.this.fPlanModeState.getDisplayName();
        }

        public IFilterDescription[] getFilters() {
            return OutlinePage.this.fPlanModeState.getFilters();
        }

        public IGroupModeDescription getGroupMode() {
            return OutlinePage.this.fPlanModeState.getGroupMode();
        }

        public String getId() {
            return OutlinePage.this.fPlanModeState.getId();
        }

        public ISortModeDescription getSortMode() {
            return OutlinePage.this.fPlanModeState.getSortMode();
        }

        public IViewModeDescription getViewMode() {
            return OutlinePage.this.fPlanModeState.getViewMode();
        }

        public String setDisplayName(String value) {
            return OutlinePage.this.fPlanModeState.setDisplayName(value);
        }

        public IFilterDescription[] setFilters(IFilterDescription[] value) {
            return OutlinePage.this.fPlanModeState.setFilters(value);
        }

        public IGroupModeDescription setGroupMode(IGroupModeDescription value) {
            return OutlinePage.this.fPlanModeState.setGroupMode(value);
        }

        public IAttributeDefinitionDescriptor[] getPlanChecks() {
            return OutlinePage.this.fPlanModeState.getPlanChecks();
        }

        public IAttributeDefinitionDescriptor[] setPlanChecks(IAttributeDefinitionDescriptor[] value) {
            return OutlinePage.this.fPlanModeState.setPlanChecks(value);
        }

        public String setId(String value) {
            return OutlinePage.this.fPlanModeState.setId(value);
        }

        public ProgressMode setProgressMode(ProgressMode value) {
            return OutlinePage.this.fPlanModeState.setProgressMode(value);
        }

        public ISortModeDescription setSortMode(ISortModeDescription value) {
            return OutlinePage.this.fPlanModeState.setSortMode(value);
        }

        public IViewModeDescription setViewMode(IViewModeDescription value) {
            return OutlinePage.this.fPlanModeState.setViewMode(value);
        }

        public IColorizeDescription[] getColors() {
            return OutlinePage.this.fPlanModeState.getColors();
        }

        public IColorizeDescription[] setColors(IColorizeDescription[] value) {
            return OutlinePage.this.fPlanModeState.setColors(value);
        }

        public String isDeprecated() {
            return null;
        }

        @Override
        public void addSettingsChangeListener(IOutlineSettingsListener listener) {
            this.fSettingListeners.add((Object)listener);
        }

        @Override
        public void removeSettingsChangeListener(IOutlineSettingsListener listener) {
            this.fSettingListeners.remove((Object)listener);
        }

        @Override
        public void settingChanged(OutlineSettingChangeEvent event) {
            Object[] listeners = this.fSettingListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IOutlineSettingsListener listener = (IOutlineSettingsListener)listeners[i];
                listener.settingChanged(event);
                ++i;
            }
        }

        @Override
        public boolean isTaskboardViewmode() {
            return OutlinePage.this.fPlanModeState.isTaskboardViewmode();
        }
    }

    abstract class ViewModelSafeRunnable
    implements ISafeRunnable {
        private String fMessage;

        public ViewModelSafeRunnable() {
        }

        public ViewModelSafeRunnable(String message) {
            this.fMessage = message;
        }

        public final void run() throws Exception {
            OutlinePage.this.displayErrorStatus(null);
            this.doRun();
        }

        protected abstract void doRun() throws Exception;

        public void handleException(Throwable e) {
            OutlinePage.this.displayErrorStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), this.fMessage, e));
        }
    }
}

