/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUIScriptEnvironment;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUIScriptingSupport;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.RecentlyViewedPlansFolder;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class IterationPlanEditorInput
extends PlatformObject
implements IEditorInput {
    private String fName;
    private IIterationPlanRecordHandle fHandle;
    private TeamFuture<IterationPlanData> fFuture;
    private IterationPlanData fIterationPlanData;
    private IScriptEnvironment fScriptEnvironment;
    private PlanningUIScriptEnvironment.IPlanAccessor fPlanAccessor = new PlanningUIScriptEnvironment.IPlanAccessor(){

        @Override
        public ResolvedPlan getPlan() {
            return IterationPlanEditorInput.this.getIterationPlanData() != null ? IterationPlanEditorInput.this.getIterationPlanData().getIterationPlan() : null;
        }
    };

    public IterationPlanEditorInput(IIterationPlanRecordHandle handle) {
        this.fHandle = handle;
        this.fFuture = this.createFuture();
    }

    public TeamFuture<IterationPlanData> getFuture() {
        if (this.fFuture == null) {
            this.fFuture = this.createFuture();
        }
        return this.fFuture;
    }

    public IIterationPlanRecordHandle getHandle() {
        return this.fHandle;
    }

    public void clear() {
        this.fFuture = null;
        this.fIterationPlanData = null;
        this.fScriptEnvironment = null;
    }

    public synchronized IterationPlanData getIterationPlanData() {
        return this.fIterationPlanData;
    }

    public synchronized IScriptEnvironment getScriptEnvironment() {
        return this.fScriptEnvironment;
    }

    synchronized void setIterationPlan(IterationPlanData data, IScriptEnvironment scriptEnvironment) {
        this.fIterationPlanData = data;
        this.fScriptEnvironment = scriptEnvironment;
        this.fName = NLS.bind((String)Messages.IterationPlanEditorInput_NAME, (Object)this.fIterationPlanData.getPlanRecord().getName(), (Object[])new Object[]{this.fIterationPlanData.getIteration().getLabel()});
        RecentlyViewedPlansFolder.getStats((IProjectAreaHandle)this.fIterationPlanData.getProjectArea()).touch(this.fHandle.getItemId().getUuidValue());
    }

    synchronized void handlePlanDeleted() {
        this.clear();
        this.fHandle = null;
    }

    public boolean exists() {
        return this.fHandle != null;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fIterationPlanData == null) {
            return null;
        }
        return PlanningUI.getImageDescriptor(this.fIterationPlanData.getPlanType());
    }

    public String getName() {
        if (this.fName != null) {
            return this.fName;
        }
        return "";
    }

    public String getToolTipText() {
        if (this.fName != null) {
            return NLS.bind((String)Messages.IterationPlanEditorInput_TOOLTIP, (Object)this.fName, (Object[])new Object[0]);
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IterationPlanEditorInput)) {
            return false;
        }
        IterationPlanEditorInput other = (IterationPlanEditorInput)((Object)obj);
        if (this.fHandle == null || other.fHandle == null) {
            return false;
        }
        return this.fHandle.sameItemId((IItemHandle)other.fHandle);
    }

    private TeamFuture<IterationPlanData> createFuture() {
        return new TeamFuture<IterationPlanData>(true){

            public IterationPlanData resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)IterationPlanEditorInput.this.fHandle);
                    IIterationPlanRecord plan = (IIterationPlanRecord)PlanningClientPlugin.getTeamRepository((IItemHandle)IterationPlanEditorInput.this.fHandle).itemManager().fetchCompleteItem((IItemHandle)IterationPlanEditorInput.this.fHandle, 0, monitor);
                    TeamFuture<IScriptEnvironment> future = PlanningUIScriptingSupport.getScriptEnvironmentFuture(plan.getOwner(), IterationPlanEditorInput.this.fPlanAccessor);
                    IterationPlanData iterationPlanData = client.fetchIterationPlanData(IterationPlanEditorInput.this.fHandle, monitor);
                    future.join(0);
                    IterationPlanEditorInput.this.setIterationPlan(iterationPlanData, (IScriptEnvironment)future.getResult());
                    return iterationPlanData;
                }
                catch (ItemNotFoundException e) {
                    IterationPlanEditorInput.this.handlePlanDeleted();
                    throw e;
                }
            }
        };
    }
}

