/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.ide.ui.editor.IIterationPlanEditor;
import com.ibm.team.apt.ide.ui.editor.IterationPlanEditorPage;
import com.ibm.team.apt.internal.client.ICorePlanItemFilter;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.client.progress.ProgressClient;
import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.TeamLoadItem;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.client.util.Items;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.InvalidConfigurationException;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_PlanSaveExceptionData;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.common.wiki.WikMarkupCleaner;
import com.ibm.team.apt.internal.common.wiki.WikiCommon;
import com.ibm.team.apt.internal.ide.core.ResolvedIterationPlanRecord;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.StateResolveEvent;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUIScriptEnvironment;
import com.ibm.team.apt.internal.ide.ui.common.PlanningUIScriptingSupport;
import com.ibm.team.apt.internal.ide.ui.common.SaveConflictDialog;
import com.ibm.team.apt.internal.ide.ui.common.SaveConflictItem;
import com.ibm.team.apt.internal.ide.ui.editor.AttachedPageNameDialog;
import com.ibm.team.apt.internal.ide.ui.editor.IInformationMessageProvider;
import com.ibm.team.apt.internal.ide.ui.editor.InformationMessageProvider;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditorActionBarContributor;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditorInput;
import com.ibm.team.apt.internal.ide.ui.editor.LoadingPage;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.editor.PageDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.PageManager;
import com.ibm.team.apt.internal.ide.ui.editor.PlanEditorPage;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeDescription;
import com.ibm.team.apt.internal.ide.ui.editor.ProblemDialog;
import com.ibm.team.apt.internal.ide.ui.editor.ProgressInformationUpdater;
import com.ibm.team.apt.internal.ide.ui.editor.QueryDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.TeamPlanMode;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanLoadBar;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanProgressBar;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanViewModel;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.compare.WikiCompareEditorInput;
import com.ibm.team.apt.internal.ide.ui.jface.StructuredContentProvider;
import com.ibm.team.apt.internal.ide.ui.navigator.AddPlanToSubscriptionsAction;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.util.DisplayCallable;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.Result;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import com.ibm.team.calm.foundation.rcp.ui.linking.CALMBackLinkProblemDialog;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.rcp.ui.ContextMenuHelper2;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class IterationPlanEditor
extends TeamFormEditor
implements IItemResolveService,
IIterationPlanEditor,
PlanningUIScriptEnvironment.IPlanAccessor {
    public static final String ID = "com.ibm.team.apt.internal.ide.ui.IterationPlanEditor";
    public static final String GROUP_PLAN = "plan";
    public static final String GROUP_PAGES = "pages";
    public static final String GROUP_ITEMS = "items";
    private IterationPlanData fIterationPlanData;
    private IterationPlanDataDirtyListener fIterationPlanDataListener;
    private IProgressInformation fProgressInformation;
    private ProgressInformationUpdater fProgressInformationUpdater;
    private IPlanElementListener fIterationPlanListener;
    private List<IterationPlanEditorPage> fContributedPages;
    private List<WikiFormPage2> fWikiPages;
    private final LocalResourceManager fResourceManager;
    private IMemento fUIState;
    private final PlanActionGroup fActionGroup;
    private OutlinePage fOutlinePage;
    private IFormPage fActivePage;
    private Form fFormHead;
    private Link fStatusLink;
    private Composite fBarContainer;
    private IterationPlanProgressBar fIterationPlanProgressBar;
    private IterationPlanLoadBar fIterationPlanLoadBar;
    private InformationViewer fInformationViewer;
    private InformationMessageProvider fInformationProvider;
    private final OverlayIcon fTitleImageWithError;
    private final OverlayIcon fTitleImageWithWarning;
    private final Font fBusyFont;
    private boolean fIsDisposed;
    private ProblemDialog fProblemDialog;
    private final List<TeamFuture<?>> fOutstandingFutures = Collections.synchronizedList(new ArrayList());
    private IScriptEnvironment fScriptEnvironment;
    private final IPropertyListener fPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (260 == propId && source instanceof FormPage) {
                FormPage page = (FormPage)source;
                IterationPlanEditor.this.setPageText(IterationPlanEditor.this.pages.indexOf(page), page.getPartName());
            }
        }
    };
    private Menu fCTabFolderMenu;
    private static final String FILENAME_PREFIX = "editor_state_";
    private static final String ITERATION_PLAN_EDITOR = "iterationPlanEditor";
    private static final String ACTIVE_PAGE = "activePage";
    private static final String ACTIVE_PLANMODE = "activePlanMode";

    public IterationPlanEditor() {
        this.fActionGroup = new PlanActionGroup(this);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.ERROR_OVR;
        this.fTitleImageWithError = new OverlayIcon(ImagePool.ITERATION_PLAN_OBJ, imageDescriptorArray, 17408);
        ImageDescriptor[] imageDescriptorArray2 = new ImageDescriptor[2];
        imageDescriptorArray2[1] = ImagePool.WARNING_OVR;
        this.fTitleImageWithWarning = new OverlayIcon(ImagePool.ITERATION_PLAN_OBJ, imageDescriptorArray2, 17408);
        FontData[] datas = JFaceResources.getDefaultFont().getFontData();
        FontData[] newDatas = UI.modifyFont(datas, 0, 2);
        this.fBusyFont = JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)JFaceResources.getDefaultFont());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                IterationPlanEditor.this.refreshActionBarContributor();
                IterationPlanEditor.this.fActivePage = IterationPlanEditor.this.getActivePageInstance();
                IterationPlanEditor.this.updateHeaderToolBar();
                IterationPlanEditor.this.fInformationViewer.refresh();
                if (IterationPlanEditor.this.getTabFolderMenu() != null) {
                    PlanEditorPage.removeCTabFolderMenu(IterationPlanEditor.this.getTabFolderMenu(), IterationPlanEditor.this.fActivePage.getPartControl());
                }
            }
        });
        this.fUIState = this.loadUIState();
    }

    public void refreshActionBarContributor() {
        ((IterationPlanEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).refresh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        TeamFuture<IterationPlanData> future;
        this.fIsDisposed = true;
        IterationPlanEditorInput input = (IterationPlanEditorInput)this.getEditorInput();
        TeamFuture<IterationPlanData> teamFuture = future = input.getFuture();
        synchronized (teamFuture) {
            if (!future.isResolved()) {
                future.cancel();
            } else {
                if (this.fIterationPlanData != null) {
                    this.fIterationPlanData.disconnect();
                    this.fIterationPlanData.removePlanListener(this.fIterationPlanListener);
                }
                this.saveUIState();
            }
        }
        input.clear();
        this.fResourceManager.dispose();
        if (this.fProblemDialog != null) {
            this.fProblemDialog.close();
        }
        super.dispose();
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        super.configurePage(index, page);
        page.addPropertyListener(this.fPropertyListener);
    }

    public void removePage(int pageIndex) {
        Object page;
        if (pageIndex >= 0 && pageIndex < this.pages.size() && (page = this.pages.get(pageIndex)) instanceof IFormPage) {
            ((IFormPage)page).removePropertyListener(this.fPropertyListener);
        }
        super.removePage(pageIndex);
    }

    @Override
    public void setBusy(IFormPage page, boolean value) {
        Composite container = this.getContainer();
        if (!(container instanceof CTabFolder)) {
            return;
        }
        CTabFolder folder = (CTabFolder)container;
        int index = this.pages.indexOf(page);
        if (index >= 0 && index < folder.getItemCount()) {
            folder.getItem(index).setFont(value ? this.fBusyFont : null);
        }
    }

    void syncExec(Runnable runnable) {
        UI.syncExec((Control)this.getContainer(), runnable);
    }

    void asyncExec(Runnable runnable) {
        UI.asyncExec((Control)this.getContainer(), runnable);
    }

    IProgressInformation getProgressInformation() {
        return this.fProgressInformation;
    }

    public IterationPlanData getIterationPlanData() {
        return this.fIterationPlanData;
    }

    public IScriptEnvironment getScriptEnvironment() {
        return this.fScriptEnvironment;
    }

    public OutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }

    public InformationViewer getInformationViewer() {
        return this.fInformationViewer;
    }

    public Font getBusyFont() {
        return this.fBusyFont;
    }

    void showSideBar(boolean show) {
        Composite composite = this.getOutlinePage().getSideBar();
        if (composite != null) {
            ((GridData)composite.getLayoutData()).exclude = !show;
            composite.getParent().layout(new Control[]{composite});
        }
        this.fFormHead.updateToolBar();
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (this.fActivePage != null) {
            result = this.fActivePage.getAdapter(adapter);
        }
        if (result == null) {
            result = super.getAdapter(adapter);
        }
        if (result == null && this.fOutlinePage != null) {
            result = this.fOutlinePage.getAdapter(adapter);
        }
        return result;
    }

    public Action getAction(String id) {
        Action action = this.fActionGroup.getAction(id);
        if (action != null) {
            return action;
        }
        IFormPage activePage = this.getActivePageInstance();
        if (activePage instanceof IActionProvider) {
            return ((IActionProvider)activePage).getAction(id);
        }
        return null;
    }

    public String getContextId() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof WikiFormPage2) {
            return "com.ibm.team.apt.actions.iterationPlanEditor.editing.pages";
        }
        if (page instanceof OutlinePage) {
            return ((OutlinePage)page).getContextId();
        }
        return null;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        super.createHeaderContents(headerForm);
        this.fFormHead = headerForm.getForm().getForm();
        this.fFormHead.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IterationPlanEditor.this.openProblemDialog();
            }
        });
        this.fActionGroup.fillTitleToolbar(this.fFormHead.getToolBarManager());
        this.fFormHead.addTitleDragSupport(20, new Transfer[]{URIReferenceTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection((Object)IterationPlanEditor.this.fIterationPlanData.getPlanRecord()));
            }

            public void dragSetData(DragSourceEvent event) {
                if (URIReferenceTransfer.getInstance().isSupportedType(event.dataType)) {
                    IIterationPlanRecord record = IterationPlanEditor.this.fIterationPlanData.getPlanRecord();
                    URIReference reference = Hyperlinks.createHyperlink((Object)record);
                    if (reference != null) {
                        event.data = new URIReference[]{reference};
                    } else {
                        event.doit = false;
                    }
                } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }
        });
        Composite body = this.fFormHead.getHead();
        this.fFormHead.setHeadClient((Control)this.createHeaderClient(body));
        this.createContextMenu(this.fFormHead);
    }

    protected void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        if (menuMgr instanceof MenuManager) {
            this.getSite().registerContextMenu(this.getSite().getId(), (MenuManager)menuMgr, this.fActionGroup.getSelectionProvider());
        }
    }

    protected Composite createHeaderClient(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(client);
        this.fStatusLink = new Link(client, 0);
        this.fStatusLink.addSelectionListener((SelectionListener)new LinkQueryAdapter());
        GridDataFactory.swtDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.fStatusLink);
        this.fBarContainer = new Composite(client, 0);
        StackLayout layout = new StackLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fBarContainer.setLayout((Layout)layout);
        this.fIterationPlanProgressBar = new IterationPlanProgressBar(this.fBarContainer, 0, 131072);
        Point size = this.fIterationPlanProgressBar.computeSize(1, -1);
        GridDataFactory.swtDefaults().grab(true, false).hint(1, size.y).align(4, 0x1000000).applyTo((Control)this.fBarContainer);
        layout.topControl = this.fIterationPlanProgressBar;
        this.fIterationPlanLoadBar = new IterationPlanLoadBar(this.fBarContainer, 0, 131072);
        return client;
    }

    private void showLoadBar(boolean value) {
        StackLayout layout = (StackLayout)this.fBarContainer.getLayout();
        layout.topControl = value ? this.fIterationPlanLoadBar : this.fIterationPlanProgressBar;
        this.fBarContainer.layout();
    }

    private boolean isSprintPlan(IterationPlanData data) {
        String id = data.getPlanType().getId();
        return "com.ibm.team.apt.plantype.default".equals(id);
    }

    protected Composite createPageContainer(Composite parent) {
        Composite composite = super.createPageContainer(parent);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(composite);
        this.fInformationViewer = new InformationViewer(composite, 2048);
        this.fInformationProvider = new InformationMessageProvider(InformationMessageProvider.ANY_PAGE, this.fInformationViewer);
        this.fInformationViewer.setComparator(new InformationViewer.MessageComparator());
        this.fInformationViewer.setLabelProvider(new InformationViewer.MessageLabelProvider());
        this.fInformationViewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.addAll(IterationPlanEditor.this.fInformationProvider.getMessages());
                for (Object page : IterationPlanEditor.this.pages) {
                    Object adapter;
                    if (!(page instanceof IAdaptable) || !((adapter = ((IAdaptable)page).getAdapter(IInformationMessageProvider.class)) instanceof IInformationMessageProvider)) continue;
                    messages.addAll(((IInformationMessageProvider)adapter).getMessages());
                }
                return messages.toArray();
            }
        });
        this.fInformationViewer.addInformationMessageListener(new InformationViewer.IInformationMessageListener(){

            @Override
            public void clicked(Object element, String text) {
                if ("webClient".equals(text)) {
                    if (IterationPlanEditor.this.fIterationPlanData == null) {
                        return;
                    }
                    new FoundationJob(""){

                        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                            IIterationPlanRecord planRecord = IterationPlanEditor.this.fIterationPlanData.getPlanRecord();
                            URIReference reference = Hyperlinks.create((Object)planRecord, (IProgressMonitor)monitor);
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(reference.getURI().toURL());
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }

            @Override
            public void closed(Object element) {
            }
        });
        this.fInformationViewer.setInput(new Object());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fInformationViewer.getControl());
        Composite result = this.getToolkit().createComposite(composite, 0);
        result.setFont(composite.getFont());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)result);
        return result;
    }

    protected FormToolkit createToolkit(Display display) {
        return WorkItemIDEUIPlugin.getDefault().getWorkItemEditorToolkit();
    }

    protected void updateHeader() {
        IterationPlanData data = this.getIterationPlanData();
        if (data == null) {
            return;
        }
        if (this.fFormHead == null || this.fFormHead.isDisposed()) {
            return;
        }
        ImageDescriptor image = PlanningUI.getImageDescriptor(data.getPlanType());
        this.fFormHead.setImage(this.fResourceManager.createImage(image));
        this.fFormHead.setText(TextProcessor.process((String)UI.safeString(data.getName())));
        this.setPartName(NLS.bind((String)Messages.IterationPlanEditor_PLAN_TITLE, (Object)data.getName(), (Object[])new Object[]{UI.safeString(data.getIteration().getLabel())}));
        this.setTitleImage(this.fResourceManager.createImage(image));
        this.updateHeaderStatus();
        this.updateHeaderToolBar();
        this.fInformationViewer.refresh();
    }

    protected void updateHeaderToolBar() {
        this.fActionGroup.update();
        this.fFormHead.getToolBarManager().markDirty();
        this.fFormHead.updateToolBar();
    }

    protected void updateHeaderStatus() {
        LoadInformation loadInformation;
        IterationPlanData data = this.getIterationPlanData();
        if (data == null) {
            return;
        }
        if (this.fProgressInformation instanceof IScriptableProxy && ((IScriptableProxy)this.fProgressInformation).getScriptEnvironment().adapt(ResolvedPlan.class) == null) {
            IScriptEnvironment scriptEnvironment = this.getScriptEnvironment();
            IProgressInformation progressInformation = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)scriptEnvironment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
            ProgressClient.delta((IProgressInformation)progressInformation, (IProgressInformation)this.fProgressInformation);
            this.fProgressInformation = progressInformation;
        }
        this.fIterationPlanProgressBar.setLabelProvider(ProgressIDE.newLabelProvider(((IScriptableProxy)this.fProgressInformation).getScriptEnvironment(), data.getComplexityAttribute()));
        this.fIterationPlanProgressBar.setProgressInformation(this.fProgressInformation);
        this.fIterationPlanProgressBar.redraw();
        this.fIterationPlanProgressBar.update();
        ResolvedIterationPlan iterationPlan = data.getIterationPlan();
        TeamLoadItem input = null;
        if (iterationPlan != null && this.isSprintPlan(data) && (loadInformation = iterationPlan.getLoadInformation((IIterationHandle)iterationPlan.getInterval())) != null) {
            input = new TeamLoadItem(loadInformation);
        }
        this.fIterationPlanLoadBar.setInput((AbstractLoadItem)input);
        this.fFormHead.layout(new Control[]{this.fBarContainer});
        Date startDate = data.getIteration().getStartDate();
        Date endDate = data.getIteration().getEndDate();
        String iterationDuration = "";
        if (startDate != null && endDate != null) {
            iterationDuration = MessageFormat.format(Messages.IterationPlanEditor_HEADER_SUMMARY_ITERATION_DURATION, startDate, endDate);
        }
        String name = data.getOwner().getName();
        name = name.replace("<", "");
        name = name.replace(">", "");
        String iteration = data.getIteration().getLabel();
        iteration = iteration.replace("<", "");
        iteration = iteration.replace(">", "");
        this.fStatusLink.setText(UI.safeString(NLS.bind((String)Messages.IterationPlanEditor_HEADER_SUMMARY, (Object)name, (Object[])new Object[]{iteration, iterationDuration, "closed", this.fProgressInformation.getCloseCount(), "open", this.fProgressInformation.getOpenCount()})));
        this.fStatusLink.getParent().layout(true, true);
    }

    protected void updateHeaderMessage(PlanCheckReport report) {
        if (this.fFormHead.isDisposed()) {
            return;
        }
        if (report == null) {
            this.fFormHead.setMessage(null);
        } else if (report.isSeverity(Severity.ERROR)) {
            this.fFormHead.setMessage(Messages.IterationPlanEditor_PROBLEMS_ERRORS, 3);
        } else if (report.isSeverity(Severity.WARNING)) {
            this.fFormHead.setMessage(Messages.IterationPlanEditor_PROBLEMS_WARNINGS, 2);
        } else if (report.isSeverity(Severity.INFO)) {
            this.fFormHead.setMessage(Messages.IterationPlanEditor_PROBLEMS_INFO, 1);
        } else {
            this.fFormHead.setMessage(null);
        }
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPages() {
        TeamFuture<IterationPlanData> future;
        this.doAddPages();
        IterationPlanEditorInput input = (IterationPlanEditorInput)this.getEditorInput();
        TeamFuture<IterationPlanData> teamFuture = future = input.getFuture();
        synchronized (teamFuture) {
            IStatus status = future.getStatus();
            if (status == null) {
                if (this.getPartName().length() == 0) {
                    this.setPartName(Messages.IterationPlanEditor_LOADING_PLAN_MESSAGE);
                }
                this.showAnimation();
                future.addListener((ITeamFutureListener)new TeamFutureAdapter(){

                    public void resolvingCanceled(TeamFutureEvent event) {
                        future.removeListener((ITeamFutureListener)this);
                    }

                    public void resolvingFailed(TeamFutureEvent event) {
                        future.removeListener((ITeamFutureListener)this);
                        IterationPlanEditor.this.doResolvingFailed(event.getTeamFuture().getStatus(), event.getTeamFuture().getException());
                    }

                    public void resolvingDone(TeamFutureEvent event) {
                        future.removeListener((ITeamFutureListener)this);
                        IterationPlanEditor.this.doResolvingDone(event);
                    }

                    public void stateResolved(StateResolveEvent event) {
                        IterationPlanEditor.this.doStateResolved(event);
                    }
                });
            } else if (status.getSeverity() == 0) {
                this.setInput(input.getIterationPlanData(), input.getScriptEnvironment());
            } else if (status.getSeverity() == 4) {
                this.doResolvingFailed(status, status.getException());
            }
        }
    }

    private void doResolvingFailed(final IStatus status, final Throwable exception) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IterationPlanEditor.this.stopAnimation();
                IterationPlanEditor.this.setPartName(Messages.IterationPlanEditor_LOADING_PLAN_FAILED);
                IterationPlanEditor.this.fFormHead.setText(Messages.IterationPlanEditor_LOADING_PLAN_FAILED_HEADERTEXT);
                LoadingPage page = (LoadingPage)IterationPlanEditor.this.getActivePageInstance();
                if (exception instanceof ItemNotFoundException) {
                    page.setStatus((IStatus)new Status(1, PlanningUI.getPluginId(), Messages.IterationPlanEditor_LOADING_PLAN_FAILED_DELETED));
                } else if (exception instanceof NotLoggedInException) {
                    page.setStatus((IStatus)new Status(1, PlanningUI.getPluginId(), Messages.IterationPlanEditor_LOADING_PLAN_FAILED_NOT_LOGGED_IN));
                } else if (exception instanceof PermissionDeniedException) {
                    page.setStatus((IStatus)new Status(1, PlanningUI.getPluginId(), exception.getMessage()));
                } else if (exception instanceof LicenseNotGrantedException) {
                    page.setStatus((IStatus)new Status(4, PlanningUI.getPluginId(), MessageFormat.format(Messages.IterationPlanEditor_NO_READ_ACCESS_LICENSE, exception.getMessage())));
                } else if (exception instanceof InvalidConfigurationException) {
                    Status status2 = new Status(1, PlanningUIPlugin.getPluginId(), Messages.IterationPlanEditor_LOADING_PLAN_FAILED_INVALID_CONFIG);
                    String message = NLS.bind((String)Messages.IterationPlanEditor_LOADING_PLAN_FAILED_INVALID_CONFIG_HINT, (Object)exception.getMessage(), (Object[])new Object[0]);
                    page.setStatus((IStatus)status2, message, (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            IIterationPlanRecordHandle handle = ((IterationPlanEditorInput)IterationPlanEditor.this.getEditorInput()).getHandle();
                            if (handle instanceof IIterationPlanRecord) {
                                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                                IProcessAreaHandle ownerHandle = ((IIterationPlanRecord)handle).getOwner();
                                IProcessArea owner = (IProcessArea)repository.itemManager().getSharedItemIfKnown((IItemHandle)ownerHandle);
                                if (owner != null) {
                                    Location location = Location.itemLocation((IItemHandle)owner.getProjectArea(), (String)repository.getRepositoryURI());
                                    Hyperlinks.open((URI)location.toAbsoluteUri(), null);
                                }
                            }
                        }
                    });
                } else {
                    page.setStatus(status);
                }
            }
        });
    }

    protected void doAddPages() {
        try {
            this.addPage((IFormPage)new LoadingPage((FormEditor)this, Messages.IterationPlanEditor_OVERVIEW_PAGE));
            this.setActivePage(0);
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getSite().getShell(), Messages.IterationPlanEditor_CREATE_OVERVIEW_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_CREATE_OVERVIEW_PAGE_FAILED_MESSAGE);
        }
    }

    protected void addPagesMenu() {
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            final AttachedPagesMenuBuilder menuBuilder = new AttachedPagesMenuBuilder();
            final MenuManager menu = new MenuManager();
            menu.setRemoveAllWhenShown(true);
            menu.addMenuListener((IMenuListener)menuBuilder);
            this.fCTabFolderMenu = menu.createContextMenu((Control)container);
            container.setMenu(this.fCTabFolderMenu);
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    menu.removeMenuListener((IMenuListener)menuBuilder);
                }
            });
        }
    }

    public Menu getTabFolderMenu() {
        return this.fCTabFolderMenu;
    }

    public boolean isDirty() {
        if (this.fIterationPlanData == null) {
            return false;
        }
        return this.fIterationPlanData.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        this.internalSave(false);
    }

    /*
     * Unable to fully structure code
     */
    private void internalSave(boolean ignoreBackLinksProblem) {
        block23: {
            if (!PlanningClientPlugin.exists((ITeamRepository)this.getIterationPlanData().getTeamRepository())) {
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.IterationPlanEditor_SAVE_CONFIRMATION_DIALOG_TITLE, (String)Messages.IterationPlanEditor_SAVE_CONFIRMATION_CONNECTION_GONE_MESSAGE)) {
                    this.close(false);
                }
                return;
            }
            try {
                outlineViewer = this.getViewer();
                selection = null;
                if (outlineViewer != null) {
                    outlineViewer.getOutline().stopEditSession();
                    selection = outlineViewer.getSelection();
                }
                try {
                    saveResult = new IterationPlanSaveResult[1];
                    this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress((PlanSaveResult[])saveResult, ignoreBackLinksProblem){
                        private final /* synthetic */ PlanSaveResult[] val$saveResult;
                        private final /* synthetic */ boolean val$ignoreBackLinksProblem;
                        {
                            this.val$saveResult = planSaveResultArray;
                            this.val$ignoreBackLinksProblem = bl;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                final Runnable notifyPagesAboutToSave = new Runnable(){

                                    @Override
                                    public void run() {
                                        for (Object page : IterationPlanEditor.this.pages) {
                                            if (page instanceof PlanEditorPage) {
                                                ((PlanEditorPage)((Object)page)).aboutToSave();
                                                continue;
                                            }
                                            if (!(page instanceof WikiFormPage2)) continue;
                                            ((WikiFormPage2)page).aboutToSave();
                                        }
                                    }
                                };
                                final ResolvedIterationPlan iterationPlan = IterationPlanEditor.this.getIterationPlanData().getIterationPlan();
                                if (iterationPlan != null) {
                                    monitor.beginTask(Messages.IterationPlanEditor_MONITOR_SAVE_AWAIT_REFRESHES, -1);
                                    iterationPlan.joinPlanChecker(monitor);
                                    Result result = new DisplayCallable<Boolean>(IterationPlanEditor.this.getSite().getShell().getDisplay()){

                                        @Override
                                        protected Boolean execute() {
                                            PlanCheckReport problemReport = iterationPlan.getPlanCheckReport();
                                            if (problemReport != null && problemReport.isSeverity(Severity.FATAL_ERROR) && !MessageDialog.openQuestion((Shell)IterationPlanEditor.this.getSite().getShell(), (String)Messages.IterationPlanEditor_SAVE_CONFIRMATION_DIALOG_TITLE, (String)Messages.IterationPlanEditor_SAVE_CONFIRMATION_ERRORS_MESSAGE)) {
                                                return false;
                                            }
                                            notifyPagesAboutToSave.run();
                                            return true;
                                        }
                                    }.syncExec();
                                    if (result.isCanceled() || !((Boolean)result.value).booleanValue()) {
                                        throw new OperationCanceledException();
                                    }
                                } else {
                                    UI.syncExec((Control)IterationPlanEditor.this.getSite().getShell(), notifyPagesAboutToSave);
                                }
                                List list = IterationPlanEditor.this.fOutstandingFutures;
                                synchronized (list) {
                                    if (!IterationPlanEditor.this.fOutstandingFutures.isEmpty()) {
                                        if (iterationPlan == null) {
                                            monitor.beginTask(Messages.IterationPlanEditor_MONITOR_SAVE_AWAIT_REFRESHES, -1);
                                        }
                                        while (!IterationPlanEditor.this.fOutstandingFutures.isEmpty()) {
                                            IterationPlanEditor.this.fOutstandingFutures.wait(500L);
                                            if (!monitor.isCanceled()) continue;
                                            throw new OperationCanceledException();
                                        }
                                    }
                                }
                                this.val$saveResult[0] = IterationPlanEditor.this.fIterationPlanData.save(this.val$ignoreBackLinksProblem, monitor);
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    if (saveResult[0].getStatus().matches(4)) {
                        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.IterationPlanEditor_SAVE_PLAN_FAILED_TITLE, (String)Messages.IterationPlanEditor_SAVE_PLAN_FAILED_PROBLEM_MESSAGE, (IStatus)saveResult[0].getStatus());
                    } else if (selection != null) {
                        outlineViewer.setSelection(selection, true);
                    }
                    break block23;
                }
                catch (InvocationTargetException e) {
                    t = e.getTargetException();
                    if (t instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)t;
                    }
                    ExceptionHandler.handle(e, this.getSite().getShell(), Messages.IterationPlanEditor_SAVE_PLAN_FAILED_TITLE, Messages.IterationPlanEditor_SAVE_PLAN_FAILED_UNKNOWN_MESSAGE);
                    break block23;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (MultiStaleDataException e) {
                reports = e.getReconcileReports();
                saveConflicts = new SaveConflictItem[reports.length];
                i = 0;
                ** while (i < reports.length)
            }
lbl-1000:
            // 1 sources

            {
                report = reports[i];
                origin = (ITeamRepository)e.getOrigin();
                Items.setOrigin((IItem)report.getBase(), (ITeamRepository)origin);
                Items.setOrigin((IItem)report.getOutgoing(), (ITeamRepository)origin);
                Items.setOrigin((IItem)report.getIncoming(), (ITeamRepository)origin);
                Items.setOrigin((IItem)report.getMergeResult(), (ITeamRepository)origin);
                saveConflicts[i] = new SaveConflictItem(report);
                ++i;
                continue;
            }
lbl43:
            // 1 sources

            dialog = new SaveConflictDialog(this.getSite().getShell(), saveConflicts);
            switch (dialog.open()) {
                case 1: {
                    return;
                }
                case 1025: {
                    this.fIterationPlanData.autoMerge(reports);
                    break;
                }
                case 1027: {
                    this.fIterationPlanData.revert(reports);
                    break;
                }
                case 1026: {
                    this.fIterationPlanData.refresh(reports);
                }
            }
            break block23;
            catch (StaleDataException e) {
                this.handleStaleData(e);
            }
            catch (TeamOperationCanceledException e) {
            }
            catch (TeamRepositoryException e) {
                exceptionHandled = false;
                exceptionData = e.getData();
                if (exceptionData instanceof DTO_PlanSaveExceptionData) {
                    exceptionHandled = this.handlePlanSaveExceptionData((DTO_PlanSaveExceptionData)exceptionData);
                }
                if (exceptionHandled) break block23;
                ExceptionHandler.handle(e, this.getSite().getShell(), Messages.IterationPlanEditor_SAVE_PLAN_FAILED_TITLE, Messages.IterationPlanEditor_SAVE_PLAN_FAILED_UNKNOWN_MESSAGE);
            }
        }
        this.firePropertyChange(257);
    }

    private boolean handlePlanSaveExceptionData(DTO_PlanSaveExceptionData exceptionData) {
        CALMBackLinkProblemDialog backLinkDialog;
        int result;
        if (exceptionData.isSetErrorCode() && exceptionData.getErrorCode() == 327680 && (result = (backLinkDialog = new CALMBackLinkProblemDialog(this.getEditorSite().getShell(), Messages.PlanReferences_BACK_LINKS_PROBLEM_DIALOG_NAME, exceptionData.getErrorReasons())).open()) == 0) {
            CALMBackLinkProblemDialog.SaveStrategy saveStrategy = backLinkDialog.getSaveStrategy();
            boolean save = true;
            boolean ignorebackLinksProblem = false;
            if (CALMBackLinkProblemDialog.SaveStrategy.IGNORE_BACKLINKS.equals((Object)saveStrategy)) {
                ignorebackLinksProblem = true;
            } else if (CALMBackLinkProblemDialog.SaveStrategy.REVERT_LINKS.equals((Object)saveStrategy)) {
                save = false;
            }
            if (save) {
                this.internalSave(ignorebackLinksProblem);
            } else {
                this.fIterationPlanData.getReferences().revert();
            }
            return true;
        }
        return false;
    }

    private static WikiFormPage2 findPage(List<WikiFormPage2> pages, IWikiPageHandle page) {
        for (WikiFormPage2 wpage : pages) {
            if (wpage.getInput() == null || !wpage.getInput().getWikiPage().sameItemId((IItemHandle)page)) continue;
            return wpage;
        }
        return null;
    }

    private void handleStaleData(StaleDataException e) {
        final boolean[] contentChange = new boolean[1];
        Object data = e.getData();
        final WikiCompareEditorInput[] input = new WikiCompareEditorInput[1];
        boolean stalePage = data instanceof IWikiPage;
        if (stalePage) {
            WikiFormPage2 handler = IterationPlanEditor.findPage(this.fWikiPages, (IWikiPageHandle)((IWikiPage)data));
            input[0] = new WikiCompareEditorInput(handler.getInput2());
            try {
                UI.getProgressService((IWorkbenchPart)this).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Object object = input[0].prepareInput(monitor);
                        contentChange[0] = object != null;
                    }
                });
            }
            catch (InvocationTargetException e1) {
                ExceptionHandler.handle((TeamRepositoryException)((Object)e), this.getSite().getShell(), Messages.IterationPlanEditor_COMPARE_PAGES_FAILED_TITLE, Messages.IterationPlanEditor_COMPARE_PAGES_FAILED_MESSAGE);
                return;
            }
            catch (InterruptedException e1) {
                return;
            }
        }
        if (contentChange[0]) {
            this.handleStaleWikiPage((IWikiPage)data, input[0]);
        } else {
            this.handleStaleWorkItem(e);
        }
    }

    private void handleStaleWorkItem(StaleDataException e) {
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.IterationPlanEditor_SAVE_PLAN_CONFLICT_DIALOG_TITLE, null, Messages.IterationPlanEditor_SAVE_PLAN_CONFLICT_DIALOG_MESSAGE, 4, new String[]{Messages.IterationPlanEditor_SAVE_PLAN_CONFLICT_DIALOG_REFRESH, Messages.IterationPlanEditor_SAVE_PLAN_CONFLICT_DIALOG_OVERWRITE, Messages.IterationPlanEditor_SAVE_PLAN_CONFLICT_DIALOG_CANCEL}, 0);
        switch (dialog.open()) {
            case 0: {
                this.doRefresh();
                break;
            }
            case 1: {
                try {
                    UI.getProgressService((IWorkbenchPart)this).run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                        @Override
                        protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                            IterationPlanEditor.this.fIterationPlanData.overwriteRecord(monitor);
                        }
                    });
                    break;
                }
                catch (InvocationTargetException e1) {
                    ExceptionHandler.handle(e1, this.getSite().getShell(), Messages.IterationPlanEditor_SAVE_PLAN_FAILED_TITLE, Messages.IterationPlanEditor_SAVE_PLAN_FAILED_UNKNOWN_MESSAGE);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void handleStaleWikiPage(IWikiPage data, WikiCompareEditorInput input) {
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.IterationPlanEditor_SAVE_PAGE_CONFLICT_DIALOG_TITLE, null, NLS.bind((String)Messages.IterationPlanEditor_SAVE_PAGE_CONFLICT_DIALOG_MESSAGE, (Object)WikiClient.getLabel((IWikiPage)data), (Object[])new Object[0]), 4, new String[]{Messages.IterationPlanEditor_SAVE_PAGE_CONFLICT_DIALOG_REFRESH, Messages.IterationPlanEditor_SAVE_PAGE_CONFLICT_DIALOG_MERGE, Messages.IterationPlanEditor_SAVE_PAGE_CONFLICT_DIALOG_CANCEL}, 1);
        switch (dialog.open()) {
            case 0: {
                this.doRefresh();
                break;
            }
            case 1: {
                CompareUI.openCompareDialog((CompareEditorInput)input);
            }
        }
    }

    private void refresh() {
        if (this.isDirty() && !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.IterationPlanEditor_REFRESH_PLAN_CONFIRMATION_TITLE, (String)Messages.IterationPlanEditor_REFRESH_PLAN_CONFIRMATION_MESSAGE)) {
            return;
        }
        this.doRefresh();
    }

    private void doRefresh() {
        PlanItemOutlineViewer outlineViewer = this.getViewer();
        if (outlineViewer != null) {
            outlineViewer.stopEditSession();
        }
        final IterationPlanData[] newData = new IterationPlanData[1];
        final IScriptEnvironment[] scriptEnvironment = new IScriptEnvironment[1];
        final IterationPlanData oldData = this.fIterationPlanData;
        try {
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            workbenchWindow.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 2);
                    try {
                        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)oldData.getTeamRepository());
                        TeamFuture<IScriptEnvironment> future = PlanningUIScriptingSupport.getScriptEnvironmentFuture((IProcessAreaHandle)oldData.getOwner(), IterationPlanEditor.this);
                        newData[0] = client.fetchIterationPlanData((IIterationPlanRecordHandle)oldData.getPlanRecord().getItemHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        scriptEnvironment[0] = (IScriptEnvironment)future.join(0);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            oldData.disconnect();
            if (newData[0] != null && scriptEnvironment[0] != null) {
                this.setInput(newData[0], scriptEnvironment[0]);
            }
            this.firePropertyChange(257);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getSite().getShell(), Messages.IterationPlanEditor_REFRESH_PLAN_FAILED_TITLE, Messages.IterationPlanEditor_REFRESH_PLAN_FAILED_MESSAGE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public ResolvedPlan getPlan() {
        return this.fIterationPlanData != null ? this.fIterationPlanData.getIterationPlan() : null;
    }

    private void doResolvingDone(TeamFutureEvent event) {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                IterationPlanEditor.this.stopAnimation();
                IterationPlanEditorInput input = (IterationPlanEditorInput)IterationPlanEditor.this.getEditorInput();
                IterationPlanEditor.this.setInput(input.getIterationPlanData(), input.getScriptEnvironment());
            }
        });
    }

    private synchronized void setInput(IterationPlanData iterationPlanData, IScriptEnvironment scriptEnvironment) {
        IProgressInformation progressInformation;
        boolean inputExists = this.fIterationPlanData != null;
        String currentActivePageId = this.fActivePage != null ? this.fActivePage.getId() : null;
        this.fScriptEnvironment = scriptEnvironment;
        if (!inputExists) {
            this.fIterationPlanListener = new IterationPlanListener();
            this.fIterationPlanDataListener = new IterationPlanDataDirtyListener();
            this.removePage(0);
            this.fOutlinePage = new OutlinePage((FormEditor)this, iterationPlanData.getPlanModes(), iterationPlanData.getRankingMode(), iterationPlanData.getExplicitRankParams(), this.fUIState);
            try {
                this.addPage((IFormPage)this.fOutlinePage);
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getSite().getShell(), Messages.IterationPlanEditor_CREATE_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_CREATE_PAGE_FAILED_MESSAGE);
            }
        } else {
            this.fIterationPlanData.removePlanListener(this.fIterationPlanListener);
            this.fIterationPlanData.setItemResolveService(null);
            this.fIterationPlanData.removeListener((IterationPlanDataListener)this.fIterationPlanDataListener);
            ((IterationPlanEditorInput)this.getEditorInput()).setIterationPlan(iterationPlanData, scriptEnvironment);
        }
        this.fIterationPlanData = iterationPlanData;
        this.fProgressInformation = iterationPlanData.getProgressInformation();
        if (this.fProgressInformationUpdater != null) {
            this.fProgressInformationUpdater.dispose();
        }
        this.fProgressInformationUpdater = new ProgressInformationUpdater(this);
        this.fIterationPlanData.setCoreElementCriteria(new ICorePlanItemFilter[0]);
        this.fOutlinePage.setInput(iterationPlanData);
        this.fIterationPlanData.addListener((IterationPlanDataListener)this.fIterationPlanDataListener);
        this.fIterationPlanData.addPlanListener(this.fIterationPlanListener);
        ((IterationPlanEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).refresh(this);
        this.fIterationPlanData.setItemResolveService((IItemResolveService)this);
        this.addPagesMenu();
        this.addContributedPages();
        this.addWikiPages();
        if (!inputExists) {
            String activePageId = this.getInitialActivePage();
            if (activePageId == null) {
                activePageId = "overview";
            }
            this.setActivePage(activePageId);
            IFormPage activePageInstance = this.getActivePageInstance();
            if (activePageInstance == null) {
                this.setActivePage("overview");
            }
            this.fActivePage = this.getActivePageInstance();
        } else {
            this.setActivePage(currentActivePageId);
            this.fActivePage = this.getActivePageInstance();
            this.fActionGroup.uncheckEditPageAction();
        }
        this.fInformationProvider.clear();
        boolean noPlan = iterationPlanData.canSavePlan();
        boolean noPages = iterationPlanData.canSavePages();
        if (noPlan ^ noPages) {
            if (!noPlan) {
                this.fInformationProvider.addMessage(new Message(Messages.IterationPlanEditor_NO_PERMISSION_SAVE_PLAN, Severity.INFO));
            } else {
                this.fInformationProvider.addMessage(new Message(Messages.IterationPlanEditor_NO_PERMISSION_SAVE_PAGE, Severity.INFO));
            }
        } else if (!noPages && !noPlan) {
            this.fInformationProvider.addMessage(new Message(Messages.IterationPlanEditor_NO_PERMISSION_SAVE_PLAN_PAGE, Severity.INFO));
        }
        Message message = null;
        if (iterationPlanData.getProjectArea().isArchived()) {
            message = new Message(Messages.IterationPlanEditor_MSG_ARCHIVED_PROJECT_AREA, Severity.WARNING);
        } else if (iterationPlanData.getOwner().isArchived()) {
            message = new Message(Messages.IterationPlanEditor_MSG_ARCHIVED_TEAM_AREA, Severity.WARNING);
        } else if (iterationPlanData.getIteration().isArchived()) {
            message = new Message(Messages.IterationPlanEditor_MSG_ARCHIVED_ITERATION, Severity.WARNING);
        }
        if (message != null) {
            this.fInformationProvider.addMessage(message);
        }
        if ((progressInformation = this.fIterationPlanData.getProgressInformation()).getCloseCount() + progressInformation.getOpenCount() > 2048) {
            this.fInformationProvider.addMessage(new Message(Messages.IterationPlanEditor_MSG_MORE_THAN_2048_ITEMS, Severity.WARNING));
        }
        this.updateHeader();
        this.firePropertyChange(257);
    }

    private void addWikiPages() {
        if (this.fWikiPages != null) {
            for (WikiFormPage2 page : this.fWikiPages) {
                this.removePage(this.pages.indexOf(page));
            }
            this.fWikiPages.clear();
        } else {
            this.fWikiPages = new ArrayList<WikiFormPage2>();
        }
        ItemArrayList wikiPages = new ItemArrayList((ItemCollection)this.fIterationPlanData.getWikiPages());
        if (wikiPages.isEmpty()) {
            return;
        }
        ItemCollections.sort((ItemList)wikiPages, (Comparator)new Comparator<IWikiPage>(){
            Collator collator = CollatorCache.getInstance();

            @Override
            public int compare(IWikiPage w1, IWikiPage w2) {
                boolean o1 = w1.getWikiID().equals("overview");
                boolean o2 = w2.getWikiID().equals("overview");
                if (o1 && o2) {
                    return 0;
                }
                if (o1) {
                    return -1;
                }
                if (o2) {
                    return 1;
                }
                String s1 = w1.getLabel();
                String s2 = w2.getLabel();
                return this.collator.compare(s1, s2);
            }
        });
        for (IWikiPage page : wikiPages) {
            String name = "overview".equals(page.getWikiID()) ? IterationPlanData.OVERVIEW_PAGE_NAME : page.getLabel();
            try {
                WikiFormPage2 wikiPage = new WikiFormPage2((FormEditor)this, page.getWikiID(), name, false);
                this.fWikiPages.add(wikiPage);
                if ("overview".equals(page.getWikiID())) {
                    this.addPage(0, (IFormPage)wikiPage);
                    continue;
                }
                this.addPage((IFormPage)wikiPage);
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getSite().getShell(), Messages.IterationPlanEditor_CREATE_ATTACHED_PAGE_EDITOR_FAILED_MESSAGE, NLS.bind((String)Messages.IterationPlanEditor_CREATE_ATTACHED_PAGE_EDITOR_FAILED_TITLE, (Object)name, (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addContributedPages() {
        Comparator<PageDescriptor> descriptorComparator = new Comparator<PageDescriptor>(){
            Collator collator = CollatorCache.getInstance();

            @Override
            public int compare(PageDescriptor o1, PageDescriptor o2) {
                return this.collator.compare(o1.getName(), o2.getName());
            }
        };
        try {
            ResolvedIterationPlanRecord input = new ResolvedIterationPlanRecord(this.fIterationPlanData);
            List<PageDescriptor> pageDescriptors = PageManager.getInstance().getPages((IResolvedIterationPlanRecord)input, this.fIterationPlanData.showChartPage());
            if (this.fContributedPages != null) {
                for (IFormPage iFormPage : this.fContributedPages) {
                    this.removePage(this.pages.indexOf(iFormPage));
                }
                this.fContributedPages.clear();
            } else {
                this.fContributedPages = new ArrayList<IterationPlanEditorPage>(pageDescriptors.size());
            }
            boolean bl = false;
            class PageDescriptorOrder {
                public List<PageDescriptor> first = new ArrayList<PageDescriptor>();
                public Map<String, List<PageDescriptor>> positioned = new HashMap<String, List<PageDescriptor>>();
                public List<PageDescriptor> last = new ArrayList<PageDescriptor>();

                public PageDescriptorOrder(List<PageDescriptor> input) {
                    for (PageDescriptor pageDescriptor : input) {
                        String position = pageDescriptor.getPosition();
                        if (String.valueOf(null).equals(position)) {
                            this.first.add(pageDescriptor);
                            continue;
                        }
                        if (position == null) {
                            this.last.add(pageDescriptor);
                            continue;
                        }
                        List<PageDescriptor> list = this.positioned.get(position);
                        if (list == null) {
                            list = new ArrayList<PageDescriptor>(2);
                            this.positioned.put(position, list);
                        }
                        list.add(pageDescriptor);
                    }
                    Collections.sort(this.first, var3_3);
                    Collections.sort(this.last, var3_3);
                    for (List list : this.positioned.values()) {
                        Collections.sort(list, var3_3);
                    }
                }
            }
            PageDescriptorOrder order = new PageDescriptorOrder(pageDescriptors, (Comparator)descriptorComparator);
            for (PageDescriptor descriptor : order.first) {
                void var4_9;
                this.addContributedPage(descriptor, (IResolvedIterationPlanRecord)input, (int)(++var4_9));
            }
            int i = 0;
            while (i < this.pages.size() && !order.positioned.isEmpty()) {
                String id;
                List<PageDescriptor> toInsert;
                Object page = this.pages.get(i);
                if (page instanceof IFormPage && (toInsert = order.positioned.remove(id = ((IFormPage)page).getId())) != null) {
                    int n = i + 1;
                    for (PageDescriptor descriptor : toInsert) {
                        this.addContributedPage(descriptor, (IResolvedIterationPlanRecord)input, n++);
                    }
                }
                ++i;
            }
            if (!order.positioned.isEmpty()) {
                ArrayList<PageDescriptor> rest = new ArrayList<PageDescriptor>();
                for (List<PageDescriptor> list : order.positioned.values()) {
                    rest.addAll(list);
                }
                Collections.sort(rest, descriptorComparator);
                for (PageDescriptor descriptor : rest) {
                    this.addContributedPage(descriptor, (IResolvedIterationPlanRecord)input, -1);
                }
            }
            for (PageDescriptor descriptor : order.last) {
                this.addContributedPage(descriptor, (IResolvedIterationPlanRecord)input, -1);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getSite().getShell(), Messages.IterationPlanEditor_CREATE_CONTRIBUTED_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_CREATE_CONTRIBUTED_PAGE_FAILED_MESSAGE);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getSite().getShell(), Messages.IterationPlanEditor_CREATE_CONTRIBUTED_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_CREATE_CONTRIBUTED_PAGE_FAILED_MESSAGE);
        }
    }

    private void addContributedPage(PageDescriptor descriptor, IResolvedIterationPlanRecord input, int insertionIndex) throws CoreException {
        IterationPlanEditorPage newPage = descriptor.createPage((FormEditor)this);
        this.fContributedPages.add(newPage);
        if (insertionIndex != -1) {
            this.addPage(insertionIndex, (IFormPage)newPage);
        } else {
            this.addPage((IFormPage)newPage);
        }
        newPage.setInput(input);
    }

    private void addNewContentPage() {
        final AttachedPageNameDialog dialog = new AttachedPageNameDialog(this.getSite().getShell(), this.getPageNames());
        if (dialog.open() == 0) {
            try {
                this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IIterationPlanRecord planRecord = IterationPlanEditor.this.getIterationPlanData().getPlanRecord();
                        WikiManager manager = WikiClient.getWikiManager((IItem)planRecord);
                        final String name = dialog.getResult();
                        String id = WikiCommon.createWikiId((String)name);
                        try {
                            try {
                                monitor.beginTask(Messages.IterationPlanEditor_MONITOR_ADDING_NEW_PAGE, 3);
                                int appendix = 0;
                                while (manager.findPageUsingOwner((IItemHandle)planRecord, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) != null) {
                                    id = String.valueOf(id) + ++appendix;
                                }
                                monitor.worked(1);
                                manager.createPageUsingOwner((IItemHandle)planRecord, id, name, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                final String pageId = id;
                                monitor.worked(2);
                                IterationPlanEditor.this.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            WikiFormPage2 newPage = new WikiFormPage2((FormEditor)IterationPlanEditor.this, pageId, name, true);
                                            IterationPlanEditor.this.fWikiPages.add(newPage);
                                            int i = IterationPlanEditor.this.addPage((IFormPage)newPage);
                                            IterationPlanEditor.this.setActivePage(i);
                                        }
                                        catch (PartInitException e) {
                                            PlanningUIPlugin.log(e);
                                        }
                                    }
                                });
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                PlanningUIPlugin.log(e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<String> getPageNames() {
        ArrayList<String> pageNames = new ArrayList<String>(this.pages.size());
        Iterator iter = this.pages.iterator();
        while (iter.hasNext()) {
            pageNames.add(((IFormPage)iter.next()).getTitle());
        }
        return pageNames;
    }

    private void doStateResolved(StateResolveEvent event) {
        final Object element = event.getResolvedElement();
        if (element instanceof IIterationPlanRecord) {
            this.syncExec(new Runnable(){

                @Override
                public void run() {
                    String name = ((IIterationPlanRecord)element).getName();
                    IterationPlanEditor.this.setPartName(name);
                    IterationPlanEditor.this.fFormHead.setText(UI.safeString(name));
                }
            });
        }
    }

    public void showAnimation() {
        this.fFormHead.setBusy(true);
    }

    public void stopAnimation() {
        this.fFormHead.setBusy(false);
    }

    private synchronized void openProblemDialog() {
        if (this.fProblemDialog != null) {
            this.fProblemDialog.setInput(this.fIterationPlanData.getIterationPlan().getPlanCheckReport());
        } else {
            this.fProblemDialog = new ProblemDialog(this);
            this.fProblemDialog.open();
            this.fProblemDialog.setInput(this.fIterationPlanData.getIterationPlan().getPlanCheckReport());
        }
    }

    public void revealAttachedPage(IWikiPage wikiPage) {
        String name;
        List<String> names = this.getPageNames();
        int index = names.indexOf(name = "overview".equals(wikiPage.getWikiID()) ? IterationPlanData.OVERVIEW_PAGE_NAME : wikiPage.getName());
        if (index != -1) {
            this.setActivePage(index);
        }
    }

    synchronized void problemDialogClosed() {
        this.fProblemDialog = null;
    }

    boolean select(PlanItem item) {
        IterationPlanViewModel viewModel;
        this.setActivePage("com.ibm.team.apt.ui.IterationPlanEditor.PlannedItemsPage");
        if (this.fOutlinePage != null && (viewModel = this.fOutlinePage.getViewModel()) != null) {
            List<IViewEntry<PlanItem>> primaryEntries = viewModel.getPrimaryEntries(Collections.singleton(item));
            for (IViewEntry iViewEntry : primaryEntries) {
                if (iViewEntry != null) continue;
                return false;
            }
            viewModel.setSelectedElements(new PlanElement[]{item});
            viewModel.revealElement((PlanElement)item);
            return true;
        }
        return false;
    }

    private void saveUIState() {
        IPath stateLocation = PlanningUIPlugin.getDefault().getStateLocation();
        File stateFile = stateLocation.append(this.getUIStateFilename()).toFile();
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            XMLMemento memento = XMLMemento.createWriteRoot((String)ITERATION_PLAN_EDITOR);
            if (this.fActivePage != null) {
                memento.putString(ACTIVE_PAGE, this.fActivePage.getId());
            }
            if (this.fOutlinePage != null) {
                this.fOutlinePage.saveState((IMemento)memento);
            }
            memento.save((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            stateFile.delete();
        }
    }

    private XMLMemento loadUIState() {
        IPath stateLocation = PlanningUIPlugin.getDefault().getStateLocation();
        File stateFile = stateLocation.append(this.getUIStateFilename()).toFile();
        if (!stateFile.exists()) {
            return null;
        }
        try {
            FileInputStream input = new FileInputStream(stateFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
            return XMLMemento.createReadRoot((Reader)reader);
        }
        catch (IOException e) {
            PlanningUIPlugin.log(e);
        }
        catch (CoreException e) {
            PlanningUIPlugin.log(e);
        }
        return null;
    }

    private String getInitialActivePage() {
        if (this.fUIState == null) {
            return "overview";
        }
        String result = this.fUIState.getString(ACTIVE_PAGE);
        if (result == null) {
            return "overview";
        }
        return result;
    }

    private String getInitialPlanModeId() {
        if (this.fUIState != null) {
            return this.fUIState.getString(ACTIVE_PLANMODE);
        }
        return null;
    }

    private String getUIStateFilename() {
        return FILENAME_PREFIX + ((IterationPlanEditorInput)this.getEditorInput()).getHandle().getItemId().getUuidValue();
    }

    public <T> void deferredResolve(final IDeferredResolver<T> resolver, final IDeferredResolveListener<T> resolveListener, final boolean isBlocking) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IterationPlanEditor.this.showAnimation();
                ((IWorkbenchSiteProgressService)IterationPlanEditor.this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class)).incrementBusy();
                if (isBlocking) {
                    IterationPlanEditor.this.getContainer().setEnabled(false);
                }
            }
        });
        TeamFuture future = new TeamFuture<T>(false){

            protected T resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                return resolver.resolve(monitor);
            }
        };
        this.fOutstandingFutures.add(future);
        future.addListener(new ITeamFutureListener<T>(){

            public void resolvingDone(final TeamFutureEvent<T> event) {
                IterationPlanEditor.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resolveListener.resolved(event.getTeamFuture().getResult());
                        }
                        finally {
                            this.done(event);
                        }
                    }
                });
            }

            public void resolvingCanceled(final TeamFutureEvent<T> event) {
                IterationPlanEditor.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resolveListener.canceled();
                        }
                        finally {
                            this.done(event);
                        }
                    }
                });
            }

            public void resolvingFailed(final TeamFutureEvent<T> event) {
                IterationPlanEditor.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resolveListener.failed(event.getTeamFuture().getStatus());
                        }
                        finally {
                            this.done(event);
                        }
                    }
                });
            }

            public void stateResolved(StateResolveEvent<T> event) {
                Assert.isTrue((boolean)false, (String)"No state resolving support");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void done(TeamFutureEvent<T> event) {
                List list = IterationPlanEditor.this.fOutstandingFutures;
                synchronized (list) {
                    IterationPlanEditor.this.fOutstandingFutures.remove(event.getTeamFuture());
                    IterationPlanEditor.this.fOutstandingFutures.notifyAll();
                }
                ((IWorkbenchSiteProgressService)IterationPlanEditor.this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class)).decrementBusy();
                IterationPlanEditor.this.stopAnimation();
                if (isBlocking) {
                    IterationPlanEditor.this.getContainer().setEnabled(true);
                }
            }
        });
    }

    public <T> T blockingResolve(final IDeferredResolver<T> resolver) throws TeamRepositoryException {
        final Object[] result = new Object[1];
        final TeamRepositoryException[] resolveException = new TeamRepositoryException[1];
        final IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        Display display = this.getSite().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        IterationPlanEditor.this.getContainer().setEnabled(false);
                        progressService.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.IterationPlanEditor_MONITOR_LOADING_ADDITIONAL_PLAN_DATA, 1);
                                try {
                                    try {
                                        result[0] = resolver.resolve((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                    catch (TeamRepositoryException e) {
                                        resolveException[0] = e;
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        resolveException[0] = new TeamRepositoryException((Throwable)e);
                        IterationPlanEditor.this.getContainer().setEnabled(true);
                    }
                    catch (InterruptedException e) {
                        resolveException[0] = new TeamRepositoryException((Throwable)e);
                        IterationPlanEditor.this.getContainer().setEnabled(true);
                    }
                }
                finally {
                    IterationPlanEditor.this.getContainer().setEnabled(true);
                }
            }
        });
        if (resolveException[0] != null) {
            throw resolveException[0];
        }
        return (T)result[0];
    }

    private PlanItemOutlineViewer getViewer() {
        IterationPlanViewModel viewModel;
        PlanItemOutlineViewer result = null;
        if (this.fOutlinePage != null && (viewModel = this.fOutlinePage.getViewModel()) != null) {
            result = (PlanItemOutlineViewer)viewModel.getViewer();
        }
        return result;
    }

    public final class AddAttachedPageAction
    extends PlanAction {
        public AddAttachedPageAction(IterationPlanEditor editor) {
            super(editor, new Class[0]);
            this.setText(Messages.IterationPlanEditor_ACTION_ADD_PAGE_LABEL);
            this.setImageDescriptor(ImagePool.CREATE_PAGE_ENABLED);
            this.setDisabledImageDescriptor(ImagePool.CREATE_PAGE_DISABLED);
        }

        @Override
        protected boolean updateEnabled() {
            return this.fEditor.getIterationPlanData().canSavePlan() && this.fEditor.getIterationPlanData().canSavePages();
        }

        public void run() {
            this.fEditor.addNewContentPage();
            Action action = this.fEditor.getAction("com.ibm.team.apt.action.pages.editPage");
            if (action instanceof PlanAction) {
                ((PlanAction)action).update();
            }
        }
    }

    private final class AttachedPagesMenuBuilder
    implements IMenuListener {
        private AttachedPagesMenuBuilder() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)IterationPlanEditor.this.getAction("com.ibm.team.apt.action.pages.addPage"));
            manager.add((IAction)IterationPlanEditor.this.getAction("com.ibm.team.apt.action.pages.renamePage"));
            manager.add((IAction)IterationPlanEditor.this.getAction("com.ibm.team.apt.action.pages.deltePage"));
        }
    }

    public static class ButtonControlContribution
    extends ControlContribution {
        private final IPropertyChangeListener fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (fButton == null) {
                    return;
                }
                if (!"enabled".equals(event.getProperty())) {
                    return;
                }
                fButton.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        };
        private final IAction fDelegate;
        private Button fButton;

        public ButtonControlContribution(IAction delegate) {
            super(delegate.getId());
            this.fDelegate = delegate;
            this.fDelegate.addPropertyChangeListener(this.fListener);
        }

        public void dispose() {
            super.dispose();
            this.fDelegate.removePropertyChangeListener(this.fListener);
        }

        protected Control createControl(Composite parent) {
            this.fButton = new Button(parent, 0x800000 | ButtonControlContribution.map(this.fDelegate.getStyle()));
            this.fButton.setText(this.fDelegate.getText());
            this.fButton.setToolTipText(this.fDelegate.getToolTipText());
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    fDelegate.run();
                }

                public void widgetSelected(SelectionEvent e) {
                    fDelegate.run();
                }
            });
            this.fButton.setEnabled(this.fDelegate.isEnabled());
            return this.fButton;
        }

        public boolean isEnabled() {
            return this.fDelegate.isEnabled();
        }

        private static int map(int actionStyle) {
            switch (actionStyle) {
                case 2: {
                    return 2;
                }
                case 1: {
                    return 8;
                }
                case 4: {
                    return 4;
                }
                case 8: {
                    return 16;
                }
            }
            return 0;
        }
    }

    public static class CollapseAllAction
    extends PlanAction {
        public CollapseAllAction(IterationPlanEditor editor) {
            super(editor, OutlinePage.class);
            this.setImageDescriptor(ImagePool.COLLAPSE_ALL);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_COLLAPSE_ALL_TOOLTIP);
        }

        public void run() {
            PlanItemOutlineViewer viewer;
            IPlanModeDescription planMode = this.fEditor.getOutlinePage().getPlanMode();
            IViewModeDescription viewModeDescription = planMode.getViewMode();
            String implementationName = viewModeDescription.getImplementationName();
            if (!"com.ibm.team.apt.shared.ui.internal.structure.TaskboardViewMode".equals(implementationName) && (viewer = this.fEditor.getViewer()) != null) {
                viewer.collapseAll();
            }
        }
    }

    public final class DeleteAttachedPageAction
    extends PlanAction {
        public DeleteAttachedPageAction(IterationPlanEditor editor) {
            super(editor, WikiFormPage2.class);
            this.setText(Messages.IterationPlanEditor_ACTION_DELETE_PAGE_LABEL);
        }

        @Override
        protected boolean updateEnabled() {
            return this.fEditor.getIterationPlanData().canSavePlan() && !"overview".equals(IterationPlanEditor.this.fActivePage.getId());
        }

        public void run() {
            WikiFormPage2 page = (WikiFormPage2)IterationPlanEditor.this.getActivePageInstance();
            final IWikiPage wikiPage = page.getWikiPage().getWikiPage();
            if (MessageDialog.openConfirm((Shell)IterationPlanEditor.this.getSite().getShell(), (String)Messages.IterationPlanEditor_CONFIRM_DELETE_PAGE_TITLE, (String)NLS.bind((String)Messages.IterationPlanEditor_CONFIRM_DELETE_PAGE_MESSAGE, (Object)wikiPage.getName(), (Object[])new Object[0]))) {
                try {
                    IterationPlanEditor.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                        @Override
                        public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                            IterationPlanEditor.this.getIterationPlanData().deleteAttachedPage(wikiPage, monitor);
                            UI.syncExec((Control)IterationPlanEditor.this.getSite().getShell(), new Runnable(){

                                @Override
                                public void run() {
                                    int index = IterationPlanEditor.this.getActivePage();
                                    IterationPlanEditor.this.removePage(index);
                                }
                            });
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, IterationPlanEditor.this.getSite().getShell(), Messages.IterationPlanEditor_DELETE_ATTACHED_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_DELETE_ATTACHED_PAGE_FAILED_MESSAGE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final class EditPageAction
    extends PlanAction {
        public EditPageAction(IterationPlanEditor editor) {
            super(editor, 2, WikiFormPage2.class);
            this.setImageDescriptor(ImagePool.EDIT_OVERVIEW_ENABLED);
            this.setDisabledImageDescriptor(ImagePool.EDIT_OVERVIEW_DISABLED);
            editor.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    IFormPage page = IterationPlanEditor.this.getActivePageInstance();
                    if (page instanceof WikiFormPage2) {
                        EditPageAction.this.setToolTipText(NLS.bind((String)Messages.IterationPlanEditor_ACTION_EDIT_PAGE_TOOLTIP, (Object)page.getTitle(), (Object[])new Object[0]));
                    }
                }
            });
        }

        @Override
        protected boolean updateEnabled() {
            return this.fEditor.getIterationPlanData().canSavePages();
        }

        @Override
        protected boolean updateChecked() {
            return ((WikiFormPage2)this.fEditor.getActivePageInstance()).getEditMode();
        }

        public void run() {
            if (IterationPlanEditor.this.fActivePage instanceof WikiFormPage2) {
                boolean edit = this.isChecked();
                final WikiFormPage2 page = (WikiFormPage2)IterationPlanEditor.this.fActivePage;
                ResolvedWikiPage input = page.getInput();
                if (input == null) {
                    this.setChecked(!edit);
                    return;
                }
                if (edit) {
                    String version = input.getWikiPage().getVersion();
                    if ("1.0".equals(version)) {
                        final ResolvedWikiPage resolvedPage = page.getWikiPage();
                        IWikiPage wikiPage = resolvedPage.getWikiPage();
                        String name = "overview".equals(wikiPage.getWikiID()) ? IterationPlanData.OVERVIEW_PAGE_NAME : wikiPage.getLabel();
                        boolean proceed = MessageDialog.openQuestion((Shell)this.fEditor.getSite().getShell(), (String)NLS.bind((String)Messages.IterationPlanEditor_CONFIRM_EDIT_OLDPAGE_TITLE, (Object)name, (Object[])new Object[0]), (String)Messages.IterationPlanEditor_CONFIRM_EDIT_OLDPAGE_MESSAGE);
                        if (!proceed) {
                            this.setChecked(!edit);
                            return;
                        }
                        FoundationJob job = new FoundationJob(Messages.IterationPlanEditor_JOB_MIGRATE_WIKI_PAGE){
                            private final Pattern fgPattern;
                            {
                                super($anonymous0);
                                this.fgPattern = Pattern.compile(".*<body>(.*)</body>.*", 40);
                            }

                            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                                XMLString clean = new WikMarkupCleaner(true).clean(page.getWikiPage().getContent());
                                clean = this.stripOutBodyEncloseInAngles(clean);
                                resolvedPage.setContent(clean);
                                IterationPlanEditor.this.getIterationPlanData().upgradeAttachedPage(resolvedPage, monitor);
                                IterationPlanEditor.this.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        page.update(resolvedPage);
                                    }
                                });
                                return Status.OK_STATUS;
                            }

                            private XMLString stripOutBodyEncloseInAngles(XMLString clean) {
                                String text = clean.getXMLText();
                                Matcher matcher = this.fgPattern.matcher(text);
                                StringBuilder body = new StringBuilder();
                                body.append(Token.XHTML_START.wiki);
                                if (!matcher.matches()) {
                                    body.append(clean.getXMLText());
                                } else {
                                    body.append(matcher.group(1));
                                }
                                body.append(Token.XHTML_END.wiki);
                                return XMLString.createFromXMLText((String)body.toString());
                            }
                        };
                        IterationPlanEditor.this.setBusy((IFormPage)page, true);
                        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                IterationPlanEditor.this.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        IterationPlanEditor.this.setBusy((IFormPage)page, false);
                                        page.startEdit();
                                    }
                                });
                            }
                        });
                        job.schedule();
                    } else {
                        page.startEdit();
                    }
                } else {
                    page.stopEdit();
                }
            }
            IterationPlanEditor.this.fActionGroup.update();
        }
    }

    public static class ExpandAllAction
    extends PlanAction {
        public ExpandAllAction(IterationPlanEditor editor) {
            super(editor, OutlinePage.class);
            this.setImageDescriptor(ImagePool.EXPAND_ALL);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_EXPAND_ALL_TOOLTIP);
        }

        public void run() {
            PlanItemOutlineViewer viewer = this.fEditor.getViewer();
            if (viewer != null) {
                viewer.expandAll();
            }
        }
    }

    private class IterationPlanDataDirtyListener
    extends IterationPlanDataListener {
        private IterationPlanDataDirtyListener() {
        }

        public void iterationPlanResolved(ResolvedIterationPlan plan) {
            if (plan.isDirty() && !IterationPlanEditor.this.fIterationPlanData.isWikiPageDirty(null)) {
                IterationPlanEditor.this.firePropertyChange(257);
            }
            ((ToggleBarAction)IterationPlanEditor.this.getAction("com.ibm.team.apt.action.iterationPlan.header.toogleBars")).update();
            if (IterationPlanEditor.this.getIterationPlanData() != null && IterationPlanEditor.this.isSprintPlan(IterationPlanEditor.this.getIterationPlanData())) {
                TeamLoadItem input = null;
                LoadInformation loadInformation = plan.getLoadInformation((IIterationHandle)plan.getInterval());
                if (loadInformation != null) {
                    input = new TeamLoadItem(loadInformation);
                }
                IterationPlanEditor.this.fIterationPlanLoadBar.setInput((AbstractLoadItem)input);
            }
        }

        public void dirtyStateChanged(boolean oldValue, boolean newValue) {
            UIJob job = new UIJob(IterationPlanEditor.this.getSite().getShell().getDisplay(), Messages.IterationPlanEditor_JOB_UPDATE_DIRTY_STATE){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IterationPlanEditor.this.firePropertyChange(257);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private class IterationPlanListener
    implements IPlanElementListener {
        private IterationPlanListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            ResolvedIterationPlan plan = IterationPlanEditor.this.getIterationPlanData().getIterationPlan();
            IPlanElementDelta delta = event.getDelta();
            delta.accept(new IPlanElementDeltaVisitor((ResolvedPlan)plan){
                private final /* synthetic */ ResolvedPlan val$plan;
                {
                    this.val$plan = resolvedPlan;
                }

                public boolean visit(IPlanElementDelta delta) {
                    PlanElement element = delta.getPlanElement();
                    if (this.val$plan == element && delta.affectsAttribute(PlanElement.PLANCHECK_REPORT)) {
                        UIJob job = new UIJob(IterationPlanEditor.this.getSite().getShell().getDisplay(), Messages.IterationPlanEditor_JOB_UPDATE_EDITOR_ICON){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (IterationPlanEditor.this.fIsDisposed) {
                                    return Status.OK_STATUS;
                                }
                                PlanCheckReport report = val$plan.getPlanCheckReport();
                                Image image = JazzResources.getImageWithDefault((ResourceManager)IterationPlanEditor.this.fResourceManager, (ImageDescriptor)PlanningUI.getImageDescriptor(IterationPlanEditor.this.getIterationPlanData().getPlanType()));
                                if (report.isSeverity(Severity.FATAL_ERROR)) {
                                    image = JazzResources.getImageWithDefault((ResourceManager)IterationPlanEditor.this.fResourceManager, (ImageDescriptor)IterationPlanEditor.this.fTitleImageWithError);
                                } else if (report.isSeverity(Severity.ERROR)) {
                                    image = JazzResources.getImageWithDefault((ResourceManager)IterationPlanEditor.this.fResourceManager, (ImageDescriptor)IterationPlanEditor.this.fTitleImageWithError);
                                } else if (report.isSeverity(Severity.WARNING)) {
                                    image = JazzResources.getImageWithDefault((ResourceManager)IterationPlanEditor.this.fResourceManager, (ImageDescriptor)IterationPlanEditor.this.fTitleImageWithWarning);
                                }
                                IterationPlanEditor.this.setTitleImage(image);
                                IterationPlanEditor.this.updateHeaderMessage(report);
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.schedule();
                    }
                    return true;
                }
            });
        }
    }

    private class LinkQueryAdapter
    extends SelectionAdapter {
        public static final String OPEN = "open";
        public static final String CLOSED = "closed";

        private LinkQueryAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            int state;
            int n = OPEN.equals(e.text) ? 1 : (state = CLOSED.equals(e.text) ? 0 : -1);
            if (state == -1) {
                return;
            }
            IProgressService service = IterationPlanEditor.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
            final ITeamRepository repository = IterationPlanEditor.this.getIterationPlanData().getTeamRepository();
            IProjectArea projectArea = IterationPlanEditor.this.getIterationPlanData().getProjectArea();
            final PlanModeDescription.SidebarQuery query = state == 0 ? PlanModeDescription.SidebarQuery.CLOSED_ITEMS : PlanModeDescription.SidebarQuery.OPEN_ITEMS;
            try {
                service.run(true, true, (IRunnableWithProgress)new TeamRunnable((IProjectAreaHandle)projectArea){
                    private final /* synthetic */ IProjectAreaHandle val$projectArea;
                    {
                        this.val$projectArea = iProjectAreaHandle;
                    }

                    @Override
                    public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, TeamRepositoryException {
                        QueryDescriptor descriptor = new TeamPlanMode().getSidebarQuery(query, IterationPlanEditor.this.getIterationPlanData(), monitor, new Object[0]);
                        QueriesUI.showQueryResults((IWorkbenchWindow)IterationPlanEditor.this.getSite().getWorkbenchWindow(), (ITeamRepository)repository, (IProjectAreaHandle)this.val$projectArea, (String)descriptor.getLabel(), (Expression)descriptor.getQuery());
                    }
                });
            }
            catch (InvocationTargetException e1) {
                ExceptionHandler.handle(e1, IterationPlanEditor.this.getSite().getShell(), Messages.IterationPlanEditor_RUN_QUERY_FAILED_TITLE, Messages.IterationPlanEditor_RUN_QUERY_FAILED_MESSAGE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final class PagesMenuAction
    extends PlanAction {
        private final IAction fDelegate;
        private IMenuCreator fMenuCreator;

        public PagesMenuAction(IterationPlanEditor editor, IAction delegate) {
            super(editor, 4, new Class[0]);
            Assert.isNotNull((Object)delegate);
            this.fDelegate = delegate;
            this.setText(this.fDelegate.getText());
            this.setImageDescriptor(this.fDelegate.getImageDescriptor());
            this.setDisabledImageDescriptor(this.fDelegate.getDisabledImageDescriptor());
        }

        public void runWithEvent(Event event) {
            if (this.fDelegate.isEnabled()) {
                this.fDelegate.run();
            } else if (event.widget instanceof ToolItem) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle bounds = item.getBounds();
                Point point = item.getDisplay().map((Control)item.getParent(), null, new Point(bounds.x, bounds.y + bounds.height));
                Menu menu = this.getMenuCreator().getMenu((Control)item.getParent());
                menu.setLocation(point);
                menu.setVisible(true);
            }
        }

        public IMenuCreator getMenuCreator() {
            if (this.fMenuCreator == null) {
                this.fMenuCreator = new IMenuCreator(){
                    private final AttachedPagesMenuBuilder fBuilder;
                    private final MenuManager fManager;
                    {
                        this.fBuilder = new AttachedPagesMenuBuilder();
                        this.fManager = new MenuManager();
                    }

                    public Menu getMenu(Menu parent) {
                        return null;
                    }

                    public Menu getMenu(Control parent) {
                        this.fManager.removeAll();
                        this.fBuilder.menuAboutToShow((IMenuManager)this.fManager);
                        return this.fManager.createContextMenu(parent);
                    }

                    public void dispose() {
                        this.fManager.removeAll();
                        this.fManager.dispose();
                    }
                };
            }
            return this.fMenuCreator;
        }
    }

    public static abstract class PlanAction
    extends Action {
        protected IterationPlanEditor fEditor;
        private final Collection<Class<? extends IFormPage>> fWorkForPages;

        public PlanAction(IterationPlanEditor editor, Class<? extends IFormPage> ... pages) {
            this(editor, 1, pages);
        }

        public PlanAction(IterationPlanEditor editor, int style, Class<? extends IFormPage> ... pages) {
            super(null, style);
            this.fEditor = editor;
            this.fWorkForPages = Arrays.asList(pages);
        }

        public final void update() {
            this.setEnabled(this.validPage() && this.fEditor.getIterationPlanData() != null && this.updateEnabled());
            this.setChecked(this.validPage() && this.fEditor.getIterationPlanData() != null && this.updateChecked());
        }

        protected boolean updateChecked() {
            return this.isChecked();
        }

        protected boolean updateEnabled() {
            return true;
        }

        private boolean validPage() {
            IFormPage page = this.fEditor.getActivePageInstance();
            if (page == null) {
                return false;
            }
            return this.fWorkForPages.isEmpty() || this.fWorkForPages.contains(page.getClass());
        }
    }

    public class PlanActionGroup
    extends ActionGroup
    implements IActionProvider {
        private final Map<String, PlanAction> fActions = new HashMap<String, PlanAction>();
        private IterationPlanEditor fEditor;
        private ISelectionProvider fSelectionProvider;

        public PlanActionGroup(IterationPlanEditor editor) {
            Assert.isNotNull((Object)editor);
            this.fEditor = editor;
            this.fEditor.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    PlanActionGroup.this.update();
                }
            });
            this.fSelectionProvider = new ISelectionProvider(){
                private final StructuredSelection emptySelection = new StructuredSelection();

                public ISelection getSelection() {
                    IIterationPlanRecord record;
                    IterationPlanData data = PlanActionGroup.this.fEditor.getIterationPlanData();
                    if (data != null && (record = data.getPlanRecord()) != null) {
                        return new StructuredSelection((Object)record);
                    }
                    return this.emptySelection;
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                    throw new UnsupportedOperationException();
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                    throw new UnsupportedOperationException();
                }

                public void setSelection(ISelection selection) {
                    throw new UnsupportedOperationException();
                }
            };
            this.initActions();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fSelectionProvider;
        }

        protected void initActions() {
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.subscribeToPlan", new SubscribeToPlanAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.toggleReadMode", new ToggleReadModeAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.toogleSideBar", new ShowSideBarAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.toogleBars", new ToggleBarAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.expandAll", new ExpandAllAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.iterationPlan.header.collapseAll", new CollapseAllAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.pages.editPage", new EditPageAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.pages.addPage", new AddAttachedPageAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.pages.pagesMenu", new PagesMenuAction(this.fEditor, (IAction)this.getAction("com.ibm.team.apt.action.pages.addPage")));
            this.initAction("com.ibm.team.apt.action.pages.renamePage", new RenameAttachedPageAction(this.fEditor));
            this.initAction("com.ibm.team.apt.action.pages.deltePage", new DeleteAttachedPageAction(this.fEditor));
            this.initAction(ActionFactory.REFRESH.getId(), new RefreshPlanAction(this.fEditor));
            this.initAction(ActionFactory.SAVE.getId(), new SavePlanAction(this.fEditor));
            this.initAction(ActionFactory.PRINT.getId(), new WikiPrintAction(this.fEditor));
        }

        protected void initAction(String id, PlanAction action) {
            this.fActions.put(id, action);
        }

        public void update() {
            for (PlanAction action : this.fActions.values()) {
                action.update();
            }
        }

        @Override
        public Action getAction(String id) {
            return this.fActions.get(id);
        }

        public void uncheckEditPageAction() {
            this.getAction("com.ibm.team.apt.action.pages.editPage").setChecked(false);
        }

        public void fillTitleToolbar(IToolBarManager manager) {
            manager.add((IContributionItem)new GroupMarker(IterationPlanEditor.GROUP_ITEMS));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.subscribeToPlan"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.collapseAll"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.expandAll"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.toggleReadMode"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.toogleSideBar"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.iterationPlan.header.toogleBars"));
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker(IterationPlanEditor.GROUP_PAGES));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.pages.editPage"));
            manager.add((IAction)this.getAction("com.ibm.team.apt.action.pages.pagesMenu"));
            manager.add((IContributionItem)new GroupMarker(IterationPlanEditor.GROUP_PLAN));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction(ActionFactory.REFRESH.getId()));
            manager.add((IContributionItem)new ButtonControlContribution((IAction)this.getAction(ActionFactory.SAVE.getId())));
        }

        public void fillContextMenu(IMenuManager menu) {
            ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)menu);
            ContextMenuHelper2.addStandardActions((IMenuManager)menu, (ISelectionProvider)this.fSelectionProvider, (IWorkbenchSite)this.fEditor.getSite(), (String[])IMenuOperationTarget.ALL_TYPES);
        }
    }

    public static class RefreshPlanAction
    extends PlanAction {
        public RefreshPlanAction(IterationPlanEditor editor) {
            super(editor, new Class[0]);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_REFRESH_TOOLTIP);
            this.setImageDescriptor(ImagePool.REFRESH);
        }

        public void run() {
            this.fEditor.refresh();
        }
    }

    public final class RenameAttachedPageAction
    extends PlanAction {
        public RenameAttachedPageAction(IterationPlanEditor editor) {
            super(editor, WikiFormPage2.class);
            this.setText(Messages.IterationPlanEditor_ACTION_RENAME_PAGE_LABEL);
        }

        @Override
        protected boolean updateEnabled() {
            return this.fEditor.getIterationPlanData().canSavePlan() && !"overview".equals(IterationPlanEditor.this.fActivePage.getId());
        }

        public void run() {
            WikiFormPage2 wikiFormPage = (WikiFormPage2)IterationPlanEditor.this.getActivePageInstance();
            final ResolvedWikiPage resolvedWikiPage = wikiFormPage.getWikiPage();
            AttachedPageNameDialog dialog = new AttachedPageNameDialog(IterationPlanEditor.this.getSite().getShell(), Messages.IterationPlanEditor_ACTION_RENAME_PAGE_DIALOG_LABEL, resolvedWikiPage.getWikiPage().getName(), IterationPlanEditor.this.getPageNames());
            dialog.setTitle(Messages.IterationPlanEditor_RENAME_PAGE_DIALOG_TITLE);
            if (dialog.open() == 0) {
                final String name = dialog.getResult();
                try {
                    IterationPlanEditor.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                IterationPlanEditor.this.getIterationPlanData().renameAttachedPage(resolvedWikiPage, name, monitor);
                                UI.syncExec((Control)IterationPlanEditor.this.getSite().getShell(), new Runnable(){

                                    @Override
                                    public void run() {
                                        if (IterationPlanEditor.this.getActivePageInstance() instanceof WikiFormPage2) {
                                            String dirtyPrefix;
                                            WikiFormPage2 page;
                                            String oldName = (page = (WikiFormPage2)IterationPlanEditor.this.getActivePageInstance()).getPartName();
                                            page.setPartName(oldName.startsWith(dirtyPrefix = "*") ? String.valueOf(dirtyPrefix) + name : name);
                                        }
                                    }
                                });
                            }
                            catch (StaleDataException e) {
                                UI.syncExec((Control)IterationPlanEditor.this.getSite().getShell(), new Runnable(){

                                    @Override
                                    public void run() {
                                        IterationPlanEditor.this.handleStaleData(e);
                                    }
                                });
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, IterationPlanEditor.this.getSite().getShell(), Messages.IterationPlanEditor_RENAME_ATTACHED_PAGE_FAILED_TITLE, Messages.IterationPlanEditor_RENAME_ATTACHED_PAGE_FAILED_MESSAGE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class SavePlanAction
    extends PlanAction {
        public SavePlanAction(final IterationPlanEditor editor) {
            super(editor, 1, new Class[0]);
            this.setText(Messages.IterationPlanEditor_ACTION_SAVE_LABEL);
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (257 == propId) {
                        this.setEnabled(editor.isDirty());
                    }
                }
            });
            this.setEnabled(false);
        }

        @Override
        protected boolean updateEnabled() {
            return this.fEditor.getIterationPlanData().canSavePlan() && this.fEditor.isDirty();
        }

        public void run() {
            this.fEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static class ShowSideBarAction
    extends PlanAction {
        public ShowSideBarAction(IterationPlanEditor editor) {
            super(editor, 2, OutlinePage.class);
            this.setImageDescriptor(ImagePool.TOGGLE_SIDE_BAR);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_SHOW_SIDEBAR_TOOLTIP);
        }

        public void run() {
            this.fEditor.showSideBar(this.isChecked());
        }

        @Override
        protected boolean updateChecked() {
            Composite composite;
            OutlinePage page = this.fEditor.getOutlinePage();
            if (page != null && (composite = page.getSideBar()) != null) {
                return !((GridData)composite.getLayoutData()).exclude;
            }
            return true;
        }
    }

    public static class SubscribeToPlanAction
    extends PlanAction {
        private final AddPlanToSubscriptionsAction fDelegate;

        public SubscribeToPlanAction(IterationPlanEditor editor) {
            super(editor, new Class[0]);
            this.fDelegate = new AddPlanToSubscriptionsAction(editor.getSite());
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_SUBSCRIBE_TO_PLAN_TOOLTIP);
            this.setImageDescriptor(ImagePool.RSS_FEED);
        }

        public void run() {
            this.fDelegate.setActivePart((IAction)this, (IWorkbenchPart)this.fEditor);
            this.fDelegate.run((IIterationPlanRecordHandle)this.fEditor.getIterationPlanData().getPlanRecord());
        }
    }

    public static class ToggleBarAction
    extends PlanAction {
        public ToggleBarAction(IterationPlanEditor editor) {
            super(editor, 2, OutlinePage.class);
            this.setImageDescriptor(ImagePool.TOGGLE_LOAD_BAR);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_SHOW_LOAD_BAR_TOOLTIP);
        }

        public void run() {
            this.fEditor.showLoadBar(this.isChecked());
        }

        @Override
        protected boolean updateEnabled() {
            if (this.fEditor.fIterationPlanData == null) {
                return false;
            }
            if (this.fEditor.fIterationPlanData.getIterationPlan() != null) {
                String id = this.fEditor.fIterationPlanData.getPlanType().getId();
                return "com.ibm.team.apt.plantype.default".equals(id);
            }
            return false;
        }

        @Override
        protected boolean updateChecked() {
            StackLayout layout = (StackLayout)this.fEditor.fBarContainer.getLayout();
            return layout.topControl != this.fEditor.fIterationPlanProgressBar;
        }
    }

    public static class ToggleReadModeAction
    extends PlanAction {
        public ToggleReadModeAction(IterationPlanEditor editor) {
            super(editor, 2, OutlinePage.class);
            this.setToolTipText(Messages.IterationPlanEditor_ACTION_READ_MODE_TOOLTIP);
            this.setImageDescriptor(ImagePool.TOGGLE_READMODE);
            this.setChecked(false);
        }

        public void run() {
            boolean readMode = this.fEditor.getOutlinePage().toggleReadMode();
            if (readMode) {
                this.fEditor.showSideBar(false);
                this.fEditor.updateHeaderToolBar();
            }
        }
    }

    public class WikiPrintAction
    extends PlanAction {
        private static final String JS_PRINT = "window.print();";
        private final IterationPlanEditor fEditor;

        public WikiPrintAction(IterationPlanEditor editor) {
            super(editor, WikiFormPage2.class);
            Assert.isNotNull((Object)editor);
            this.fEditor = editor;
        }

        @Override
        protected boolean updateEnabled() {
            return !((WikiFormPage2)this.fEditor.getActivePageInstance()).getEditMode();
        }

        public void run() {
            Browser browser = ((WikiFormPage2)this.fEditor.getActivePageInstance()).getBrowser();
            browser.execute(JS_PRINT);
        }
    }
}

