/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyIterationPlanURLAction
implements IObjectActionDelegate {
    private IIterationPlanRecord fCurrentIterationPlan;
    private IWorkbenchPart fWorkbenchPart;

    public void run(IAction action) {
        if (this.fCurrentIterationPlan == null) {
            return;
        }
        ITeamRepository teamRepository = PlanningClientPlugin.getTeamRepository((IItemHandle)this.fCurrentIterationPlan);
        String repositoryURI = teamRepository.publicUriRoot();
        if (repositoryURI == null) {
            repositoryURI = teamRepository.getRepositoryURI();
        }
        Location location = Location.itemLocation((IItemHandle)this.fCurrentIterationPlan, (String)repositoryURI);
        Display display = this.fWorkbenchPart.getSite().getShell().getDisplay();
        Clipboard cb = new Clipboard(display);
        String name = this.fCurrentIterationPlan.getName();
        String url = location.toAbsoluteUri().toString();
        StringBuffer html = new StringBuffer();
        Html.ANCHOR.open((CharSequence)html, new Html.Attribute[]{new Html.Attribute("href", url)});
        Html.append((CharSequence)html, (CharSequence)name);
        Html.ANCHOR.close((CharSequence)html);
        cb.setContents(new Object[]{url, Utils.escapeForHTMLTransfer((String)html.toString())}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IIterationPlanRecord) {
            this.fCurrentIterationPlan = (IIterationPlanRecord)object;
            action.setEnabled(true);
        }
    }
}

