/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.IResolvedWikiPageListener;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAdapter;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.transformer.WikiPageAttachmentReferenceDetector;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.WikiPageAttachmentStore;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;

public class ClientReferenceDetector
extends WikiPageAttachmentReferenceDetector {
    private static final URI IMG_PENDING;
    private IResolvedWikiPageListener fListener = new ResolvedWikiPageAdapter(){

        public void attachmentAdded(ResolvedWikiPageAttachment attachment) {
            ClientReferenceDetector.this.setAttachments(Attachments.getAttachments((List)ClientReferenceDetector.this.fPage.getAttachments()));
        }

        public void attachmentRemoved(ResolvedWikiPageAttachment attachment) {
            ClientReferenceDetector.this.setAttachments(Attachments.getAttachments((List)ClientReferenceDetector.this.fPage.getAttachments()));
        }
    };
    private final ResolvedWikiPage fPage;

    static {
        URL url = JazzResources.createURL((ImageDescriptor)ImagePool.IN_PROGRESS);
        String file = url.getFile();
        IMG_PENDING = new File(file).toURI();
    }

    public ClientReferenceDetector(ResolvedWikiPage page) {
        super(ClientReferenceDetector.repositoryUri(page), page.getProjectArea(), false);
        this.fPage = page;
        this.setAttachments(Attachments.getAttachments((List)page.getAttachments()));
        page.addListener(this.fListener);
    }

    private static URI repositoryUri(ResolvedWikiPage page) {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)page.getWikiPage());
        try {
            return new URI(repository.getRepositoryURI());
        }
        catch (URISyntaxException e) {
            Assert.isTrue((boolean)false, (String)e.getMessage());
            return null;
        }
    }

    public IItemReferenceDetector.Reference detect(String text) {
        IItemReferenceDetector.Reference uri = super.detect(text);
        IWikiPageAttachment attachment = (IWikiPageAttachment)this.fAttachmentsMap.get(text);
        if (attachment != null && WikiPageAttachmentStore.shouldDownload(attachment)) {
            if (WikiPageAttachmentStore.isDownloaded(attachment)) {
                return new IItemReferenceDetector.Reference(WikiPageAttachmentStore.getFileUri(attachment));
            }
            WikiPageAttachmentStore.getInstance().registerWikiPageAttachment(attachment);
            IItemReferenceDetector.Reference link = new IItemReferenceDetector.Reference(IMG_PENDING, attachment.getItemId().getUuidValue());
            return link;
        }
        return uri;
    }
}

