/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.common.wiki.WikiPath;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttachedPageNameDialog
extends StatusDialog {
    private Text fPageName;
    private String fResult;
    private final String fLabel;
    private final String fPresetName;
    private final List<String> fExistingPages;

    public AttachedPageNameDialog(Shell parent, List<String> pageNames) {
        this(parent, Messages.AttachedPageNameDialog_NAME_LABEL, null, pageNames);
    }

    public AttachedPageNameDialog(Shell parent, String label, String presetName, List<String> pageNames) {
        super(parent);
        this.fExistingPages = pageNames;
        this.fLabel = label;
        this.fPresetName = presetName;
        this.setTitle(Messages.AttachedPageNameDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(this.fLabel);
        this.fPageName = new Text(result, 2048);
        if (this.fPresetName != null) {
            this.fPageName.setText(this.fPresetName);
            this.fPageName.selectAll();
        }
        this.fPageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttachedPageNameDialog.this.updateStatus();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fPageName.setLayoutData((Object)gridData);
        UI.hookHelpListener((Control)result, "com.ibm.team.apt.ide.ui.dialog_pages");
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public String getResult() {
        return this.fResult;
    }

    public boolean close() {
        this.fResult = this.fPageName.getText();
        return super.close();
    }

    private void updateStatus() {
        String message = null;
        String name = this.fPageName.getText().trim();
        if (name.length() == 0) {
            message = Messages.AttachedPageNameDialog_MESSAGE_MISSING_PAGENAME;
            this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, message, null));
        } else {
            if (this.fPresetName != null && CollatorCache.getInstance().equals(this.fPresetName, name)) {
                this.getButton(0).setEnabled(false);
                return;
            }
            message = WikiPath.isValidPageName((String)name);
            if (message != null) {
                this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, message, null));
            } else {
                for (String pageName : this.fExistingPages) {
                    if (!CollatorCache.getInstance().equals(pageName, name)) continue;
                    message = Messages.AttachedPageNameDialog_MESSAGE_DUPLICATE_PAGENAME;
                    this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, message, null));
                    break;
                }
            }
        }
        if (message == null) {
            this.updateStatus(Status.OK_STATUS);
        }
    }
}

