/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.Messages;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TimeElement
extends GroupElement {
    private final TimeSpanDefinition fTimeSpan;
    private final IContributor fOwner;

    public TimeElement(IContributor owner, TimeSpanDefinition timeSpan) {
        Assert.isLegal((owner != null && timeSpan != null ? 1 : 0) != 0);
        this.fOwner = owner;
        this.fTimeSpan = timeSpan;
    }

    public TimeSpanDefinition getTimeSpan() {
        return this.fTimeSpan;
    }

    @Override
    public String getId() {
        return this.fOwner.getItemId().getUuidValue();
    }

    @Override
    public String getLabel() {
        return this.fTimeSpan.getLabel();
    }

    @Override
    public boolean canAdopt(PlanElement toAdopt, IViewEntry<GroupElement> groupEntry) {
        if (!(toAdopt instanceof PlanItem)) {
            return false;
        }
        if (this.fTimeSpan == TimeSpanDefinition.UNSCHEDULED) {
            return false;
        }
        return this.fTimeSpan.isPast() == ((PlanItem)toAdopt).isResolved();
    }

    @Override
    public boolean adopt(PlanElement toAdopt, IViewEntry<? extends GroupElement> groupEntry, IProgressMonitor monitor) {
        if (!(toAdopt instanceof PlanItem)) {
            return false;
        }
        PlanItem planItem = (PlanItem)toAdopt;
        if (this.fOwner != null) {
            planItem.setOwner(this.fOwner);
        }
        if (this.fTimeSpan != TimeSpanDefinition.UNSCHEDULED) {
            monitor.beginTask(Messages.TimeElement_MONITOR_ADOPT_WORKITEMS, 2);
            try {
                try {
                    ResolvedPlan plan = toAdopt.getPlan();
                    IIteration iteration = plan.suggestCurrentIteration(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (iteration != null) {
                        planItem.setTarget(iteration);
                    }
                    this.doSchedule(planItem, groupEntry);
                }
                catch (TeamRepositoryException e) {
                    PlanningUIPlugin.log(e);
                }
            }
            finally {
                monitor.done();
            }
        }
        return true;
    }

    @Override
    public int compareTo(GroupElement o) {
        if (o instanceof TimeElement) {
            TimeSpanDefinition t1 = this.getTimeSpan();
            TimeSpanDefinition t2 = ((TimeElement)o).getTimeSpan();
            if (t1 == TimeSpanDefinition.UNSCHEDULED || t2 == TimeSpanDefinition.UNSCHEDULED) {
                return (t1 == TimeSpanDefinition.UNSCHEDULED ? 1 : 0) - (t2 == TimeSpanDefinition.UNSCHEDULED ? 1 : 0);
            }
            return t1.compareTo(t2);
        }
        return super.compareTo(o);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        TimeElement other = (TimeElement)obj;
        return this.fOwner.sameItemId((IItemHandle)other.fOwner) && this.fTimeSpan.equals(other.fTimeSpan);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fOwner.getItemId().hashCode();
        result = 31 * result + this.fTimeSpan.hashCode();
        return result;
    }

    private void doSchedule(PlanItem planItem, final IViewEntry<? extends GroupElement> groupEntry) {
        Date referenceTime;
        long[] startEnd = (long[])groupEntry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<long[], RuntimeException>(){

            public long[] run(IViewModelReader readAccessor) throws RuntimeException {
                Date startTime = null;
                Date endTime = null;
                for (Object child : readAccessor.getEntryNavigator(false).children(groupEntry)) {
                    Timespan scheduledTime;
                    if (!(child instanceof IScheduleItem) || (scheduledTime = ((IScheduleItem)child).getScheduledTime()) == null) continue;
                    if (startTime == null || scheduledTime.getStart().before(startTime)) {
                        startTime = scheduledTime.getStart();
                    }
                    if (endTime != null && !scheduledTime.getEnd().after(endTime)) continue;
                    endTime = scheduledTime.getEnd();
                }
                long start = (startTime != null ? startTime : TimeElement.this.fTimeSpan.getStartTime()).getTime();
                long end = (endTime != null ? endTime : TimeElement.this.fTimeSpan.getEndTime()).getTime();
                return new long[]{start, end};
            }
        });
        Date scheduleTime = new Date(startEnd[0] + (startEnd[1] - startEnd[0]) / 2L);
        if (scheduleTime.before(referenceTime = planItem.getPlan().getReferenceTime())) {
            scheduleTime = referenceTime;
        }
        planItem.schedule(scheduleTime);
    }
}

