/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import java.util.Date;

public class StaticTimeSpanFactory
extends TimeSpanFactory {
    private Date fReferenceTime;
    private Date fExpiryTime;
    private final TimeSpanDefinition[] fTimeSpans;
    private final TimeSpanDefinition fTimeSpanDefaultOpen;
    private final TimeSpanDefinition fTimeSpanDefaultResolved;

    public StaticTimeSpanFactory(TimeSpanDefinition[] timeSpans, TimeSpanDefinition defaultResolved, TimeSpanDefinition defaultOpen) {
        this.fTimeSpans = timeSpans;
        this.fTimeSpanDefaultOpen = defaultOpen;
        this.fTimeSpanDefaultResolved = defaultResolved;
    }

    @Override
    public TimeSpanDefinition findTimeSpan(Timespan scheduledTime, boolean isResolved) {
        if (scheduledTime == null) {
            return TimeSpanDefinition.UNSCHEDULED;
        }
        Date time = isResolved ? scheduledTime.getEnd() : scheduledTime.getStart();
        TimeSpanDefinition[] timeSpanDefinitionArray = this.fTimeSpans;
        int n = this.fTimeSpans.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSpanDefinition timeSpan = timeSpanDefinitionArray[n2];
            if (timeSpan.isInGroup(time, isResolved)) {
                return timeSpan;
            }
            ++n2;
        }
        return isResolved ? this.fTimeSpanDefaultResolved : this.fTimeSpanDefaultOpen;
    }

    @Override
    public void updateTimespans(Date referenceTime) {
        this.fReferenceTime = referenceTime;
        this.fExpiryTime = null;
        TimeSpanDefinition[] timeSpanDefinitionArray = this.fTimeSpans;
        int n = this.fTimeSpans.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSpanDefinition timeSpan = timeSpanDefinitionArray[n2];
            timeSpan.refreshTimestamps(this.fReferenceTime);
            Date expiryTime = timeSpan.getExpiryTime();
            if (this.fExpiryTime == null || this.fExpiryTime.after(expiryTime)) {
                this.fExpiryTime = expiryTime;
            }
            ++n2;
        }
    }

    @Override
    public Date getExpiryTime() {
        return this.fExpiryTime;
    }
}

