/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.ide.ui.common.structure.Messages;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.workitem.common.model.ILiteral;
import java.util.Date;

public enum SortMode {
    PRIORITY("priority", Messages.SortMode_PRIORITY, (PartialViewerSorter.ElementComparer)new PrioritySortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return PlanItem.PRIORITY.getId().equals(attribute);
        }
    }
    ,
    SEVERITY("severity", Messages.SortMode_SEVERITY, (PartialViewerSorter.ElementComparer)new SeveritySortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return PlanItem.SEVERITY.getId().equals(attribute);
        }
    }
    ,
    CREATION_DATE("creation_date", Messages.SortMode_CREATION_DATE, (PartialViewerSorter.ElementComparer)new CreationDateSortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return false;
        }
    }
    ,
    MODIFIED_DATE("modified_date", Messages.SortMode_MODIFICATION_DATE, (PartialViewerSorter.ElementComparer)new ModifiedDateSortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return false;
        }
    }
    ,
    DURATION("duration", Messages.SortMode_ESTIMATE, (PartialViewerSorter.ElementComparer)new DurationSortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return PlanItem.DURATION.getId().equals(attribute);
        }
    }
    ,
    SCHEDULED("scheduled", Messages.SortMode_SCHEDULED_TIME, (PartialViewerSorter.ElementComparer)new SequenceSortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return PlanItem.SCHEDULED_TIME.getId().equals(attribute);
        }
    }
    ,
    MY_SORT_ORDER("myOrder", Messages.SortMode_MY_SORT_ORDER, (PartialViewerSorter.ElementComparer)new UserDefinedOrderSortMode()){

        @Override
        public boolean isAffectedBy(String attribute) {
            return false;
        }
    };

    private final String fKey;
    private final String fLabel;
    private final PartialViewerSorter.ElementComparer<?> fComparator;

    private SortMode(String mode, String label, PartialViewerSorter.ElementComparer<?> comparator) {
        this.fKey = mode;
        this.fLabel = label;
        this.fComparator = comparator;
    }

    public static SortMode getSortMode(String key) {
        SortMode[] sortModeArray = SortMode.values();
        int n = sortModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortMode sortMode = sortModeArray[n2];
            if (sortMode.fKey.equals(key)) {
                return sortMode;
            }
            ++n2;
        }
        return null;
    }

    public abstract boolean isAffectedBy(String var1);

    public PartialViewerSorter.ElementComparer<?> getComparator() {
        return this.fComparator;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getKey() {
        return this.fKey;
    }

    /* synthetic */ SortMode(String string, int n, String string2, String string3, PartialViewerSorter.ElementComparer elementComparer, SortMode sortMode) {
        this(string2, string3, elementComparer);
    }

    private static final class CreationDateSortMode
    extends PartialViewerSorter.ElementComparer<PlanItem> {
        public CreationDateSortMode() {
            super(PlanItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return CREATION_DATE.isAffectedBy(attributeName);
        }

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            return o2.getId() - o1.getId();
        }
    }

    private static final class DurationSortMode
    extends PartialViewerSorter.ElementComparer<PlanItem> {
        public DurationSortMode() {
            super(PlanItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return DURATION.isAffectedBy(attributeName);
        }

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            long d2;
            long d1 = ((IterationPlanItem)o1).getDeepDuration().longValue();
            if (d1 > (d2 = ((IterationPlanItem)o2).getDeepDuration().longValue())) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return -(o1.getId() - o2.getId());
        }
    }

    private static final class ModifiedDateSortMode
    extends PartialViewerSorter.ElementComparer<PlanItem> {
        public ModifiedDateSortMode() {
            super(PlanItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return MODIFIED_DATE.isAffectedBy(attributeName);
        }

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            Date d1 = o1.getModificationDate();
            Date d2 = o2.getModificationDate();
            if (d1 == null || d2 == null) {
                return (d1 == null ? 0 : 1) - (d2 == null ? 0 : 1);
            }
            int result = -Dates.compareTo((Date)d1, (Date)d2);
            return result != 0 ? result : -(o1.getId() - o2.getId());
        }
    }

    private static final class PrioritySortMode
    extends PartialViewerSorter.ElementComparer<PlanItem> {
        public PrioritySortMode() {
            super(PlanItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return PRIORITY.isAffectedBy(attributeName);
        }

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            ILiteral p1 = (ILiteral)o1.getAttributeValue(PlanItem.PRIORITY);
            ILiteral p2 = (ILiteral)o2.getAttributeValue(PlanItem.PRIORITY);
            if (p1 == null) {
                if (p2 == null) {
                    return 0;
                }
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            int result = p2.compareTo((Object)p1);
            return result != 0 ? result : -(o1.getId() - o2.getId());
        }
    }

    private static final class SequenceSortMode
    extends PartialViewerSorter.ElementComparer<IScheduleItem> {
        public SequenceSortMode() {
            super(IScheduleItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return SCHEDULED.isAffectedBy(attributeName);
        }

        @Override
        public int compare(IScheduleItem o1, IScheduleItem o2) {
            Timespan t1 = o1.getScheduledTime();
            Timespan t2 = o2.getScheduledTime();
            if (t1 == null || t2 == null) {
                return (t1 == null ? 1 : 0) - (t2 == null ? 1 : 0);
            }
            return Dates.compareTo((Date)t1.getStart(), (Date)t2.getStart());
        }
    }

    private static final class SeveritySortMode
    extends PartialViewerSorter.ElementComparer<PlanItem> {
        public SeveritySortMode() {
            super(PlanItem.class);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            return SEVERITY.isAffectedBy(attributeName);
        }

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            ILiteral s1 = (ILiteral)o1.getAttributeValue(PlanItem.SEVERITY);
            ILiteral s2 = (ILiteral)o2.getAttributeValue(PlanItem.SEVERITY);
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            int result = s2.compareTo((Object)s1);
            return result != 0 ? result : -(o1.getId() - o2.getId());
        }
    }

    private static final class UserDefinedOrderSortMode
    extends PartialViewerSorter.ElementComparer<Object> {
        public UserDefinedOrderSortMode() {
            super(Object.class);
        }

        @Override
        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

