/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.DropTarget;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.progress.IProgressService;

public class SequenceItemMovePolicy
extends ItemMovePolicy {
    @Override
    public ItemMovePolicy.DropLocation validateDrop(final IStructuredSelection sourceSelection, final DropTarget dropTarget) {
        return (ItemMovePolicy.DropLocation)((Object)dropTarget.getTargetEntry().getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<ItemMovePolicy.DropLocation, RuntimeException>(){

            public ItemMovePolicy.DropLocation run(IViewModelReader readAccessor) throws RuntimeException {
                ItemMovePolicy.DropLocation location;
                IViewModelNavigator n = readAccessor.getEntryNavigator(true);
                ItemMovePolicy.DropLocation result = location = dropTarget.getLocation();
                boolean hasValidAdoptions = false;
                IViewEntry<?> targetEntry = dropTarget.getTargetEntry();
                Object target = targetEntry.getElement();
                ResolvedPlan plan = SequenceItemMovePolicy.this.getPlan(targetEntry);
                Object[] objectArray = sourceSelection.toArray();
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object source = objectArray[n3];
                    if (SequenceItemMovePolicy.this.isIncompatibleProjectArea(source, targetEntry)) {
                        result = ItemMovePolicy.DropLocation.None;
                    } else if (source instanceof IWorkItemHandle || source instanceof PlanItem) {
                        Object parentElement;
                        IWorkItemHandle sourceHandle = source instanceof PlanItem ? ((PlanItem)source).getWorkItemHandle() : (IWorkItemHandle)source;
                        PlanItem sourceItem = (PlanItem)(source instanceof PlanItem ? source : plan.getPlanItem((IWorkItemHandle)source));
                        if (source instanceof IWorkItem && this.isClosed((IWorkItem)source, plan) || sourceItem != null && sourceItem.isResolved()) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (target instanceof MessageElement) {
                            result = ItemMovePolicy.DropLocation.OntoParent;
                            hasValidAdoptions = true;
                        } else if (location != ItemMovePolicy.DropLocation.Onto) {
                            if (target instanceof PlanItem && ((PlanItem)target).getWorkItemHandle().sameItemId((IItemHandle)sourceHandle)) {
                                result = ItemMovePolicy.DropLocation.None;
                            } else {
                                parentElement = n.parentElement(targetEntry);
                                if (parentElement instanceof TimeElement) {
                                    TimeSpanDefinition timeSpan = ((TimeElement)parentElement).getTimeSpan();
                                    if (timeSpan == null) {
                                        result = ItemMovePolicy.DropLocation.None;
                                    } else if (timeSpan == TimeSpanDefinition.UNSCHEDULED) {
                                        result = ItemMovePolicy.DropLocation.OntoParent;
                                        boolean isValidAdoption = true;
                                        if (sourceItem != null) {
                                            isValidAdoption = sourceItem.getTarget() == null || !plan.getPlannedIterations().contains((Object)sourceItem.getTarget()) || sourceItem.getScheduledTime() != null;
                                        }
                                        hasValidAdoptions |= isValidAdoption;
                                    } else {
                                        Object nextSibling = location == ItemMovePolicy.DropLocation.Before ? n.predecessor(targetEntry) : n.successor(targetEntry);
                                        if (nextSibling == null && target instanceof PlanItem && !((PlanItem)target).isResolved()) {
                                            hasValidAdoptions = true;
                                        } else if (nextSibling instanceof PlanItem && !((PlanItem)nextSibling).isResolved() && !sourceHandle.sameItemId((IItemHandle)((PlanItem)nextSibling).getWorkItemHandle())) {
                                            hasValidAdoptions = true;
                                        }
                                    }
                                }
                            }
                        } else if (target instanceof PlanItem) {
                            TimeSpanDefinition timeSpan;
                            result = ItemMovePolicy.DropLocation.None;
                            parentElement = n.parentElement(targetEntry);
                            if (parentElement instanceof TimeElement && (timeSpan = ((TimeElement)parentElement).getTimeSpan()) == TimeSpanDefinition.UNSCHEDULED) {
                                result = ItemMovePolicy.DropLocation.OntoParent;
                                hasValidAdoptions = true;
                            }
                        } else if (target instanceof TimeElement) {
                            TimeSpanDefinition timeSpan = ((TimeElement)target).getTimeSpan();
                            if (timeSpan == TimeSpanDefinition.UNSCHEDULED || !timeSpan.getStartTime().before(plan.getReferenceTime())) {
                                result = ItemMovePolicy.DropLocation.OntoUnderlayChildern;
                                boolean isValidAdoption = true;
                                if (timeSpan == TimeSpanDefinition.UNSCHEDULED && sourceItem != null) {
                                    isValidAdoption = sourceItem.getTarget() == null || !plan.getPlannedIterations().contains((Object)sourceItem.getTarget()) || sourceItem.getScheduledTime() != null;
                                }
                                hasValidAdoptions |= isValidAdoption;
                            }
                        } else if (target instanceof GroupElement) {
                            hasValidAdoptions = true;
                        } else {
                            result = ItemMovePolicy.DropLocation.None;
                        }
                    }
                    if (result == ItemMovePolicy.DropLocation.None) break;
                    ++n3;
                }
                return hasValidAdoptions ? result : ItemMovePolicy.DropLocation.None;
            }

            private boolean isClosed(IWorkItem workItem, ResolvedPlan plan) {
                if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) && plan.getProjectAreaHandle().sameItemId((IItemHandle)workItem.getProjectArea())) {
                    return plan.getCombinedWorkflowInfos().getStateGroup(workItem.getState2()) == 2;
                }
                return false;
            }
        }));
    }

    @Override
    public boolean drop(IStructuredSelection sourceSelection, DropTarget dropTarget, IProgressService progressService) {
        final IViewEntry<?> targetEntry = dropTarget.getTargetEntry();
        final ItemMovePolicy.DropLocation location = dropTarget.getLocation();
        final IViewEntry groupEntry = (IViewEntry)targetEntry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<IViewEntry<GroupElement>, RuntimeException>(){

            public IViewEntry<GroupElement> run(IViewModelReader readAccessor) throws RuntimeException {
                return readAccessor.getEntryNavigator(true).parentEntryOfType(targetEntry, GroupElement.class);
            }
        });
        boolean result = this.doResolveAndDrop(sourceSelection, new IPlanItemAttributeSetter(){

            public String getWorkItemTypeIdentifier() {
                return null;
            }

            public void setAttributes(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", 1);
                try {
                    if (!planItem.isResolved()) {
                        Object element;
                        if (groupEntry != null) {
                            ((GroupElement)groupEntry.getElement()).adopt((PlanElement)planItem, (IViewEntry<? extends GroupElement>)groupEntry, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        if ((element = targetEntry.getElement()) instanceof PlanItem) {
                            PlanItem before = location == ItemMovePolicy.DropLocation.After ? (PlanItem)element : null;
                            PlanItem after = location == ItemMovePolicy.DropLocation.Before ? (PlanItem)element : null;
                            planItem.schedule(before, after);
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, this.getViewModel(targetEntry), dropTarget.getEvent(), progressService);
        if (result) {
            this.doSelect(sourceSelection, (IViewEntry<GroupElement>)groupEntry);
        }
        return result;
    }

    @Override
    public boolean canIncreaseIndent(IViewEntry<?> entry) {
        return false;
    }

    @Override
    public void increaseIndent(IViewEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canDecreaseIndent(IViewEntry<?> entry) {
        return false;
    }

    @Override
    public void decreaseIndent(IViewEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canMoveUp(IViewEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return false;
        }
        PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return false;
        }
        ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        try {
            return sequenceManager.getIndexOf(item) > 0;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public void moveUp(IViewEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final PlanItem[] scheduleBefore = new PlanItem[1];
        sequenceManager.executeLocked(new Runnable(){

            @Override
            public void run() {
                int scheduleIndex = sequenceManager.getIndexOf(item);
                if (scheduleIndex > 0) {
                    scheduleBefore[0] = sequenceManager.getAt(scheduleIndex - 1);
                }
            }
        });
        if (scheduleBefore[0] == null) {
            return;
        }
        sequenceManager.schedule(item, null, scheduleBefore[0]);
        this.getViewModel(entry).setSelectedElements(new PlanElement[]{item});
    }

    @Override
    public boolean canMoveDown(IViewEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return false;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return false;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final boolean[] result = new boolean[1];
        sequenceManager.executeLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = sequenceManager.getIndexOf(item) < sequenceManager.getScheduledItemCount() - 1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        });
        return result[0];
    }

    @Override
    public void moveDown(IViewEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final PlanItem[] scheduleAfter = new PlanItem[1];
        sequenceManager.executeLocked(new Runnable(){

            @Override
            public void run() {
                int scheduleIndex = sequenceManager.getIndexOf(item);
                if (sequenceManager.getIndexOf(item) < sequenceManager.getScheduledItemCount() - 1) {
                    scheduleAfter[0] = sequenceManager.getAt(scheduleIndex + 1);
                }
            }
        });
        if (scheduleAfter[0] == null) {
            return;
        }
        sequenceManager.schedule(item, scheduleAfter[0], null);
        this.getViewModel(entry).setSelectedElements(new PlanElement[]{item});
    }

    @Override
    public boolean canAddItemAbove(IViewEntry<?> entry, IWorkItemType workItemType) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        PlanItem planItem = (PlanItem)entry.getElement();
        return !planItem.isResolved() && planItem.getScheduledTime() != null;
    }

    @Override
    public void addItemAbove(IViewEntry<?> entry, IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, true, context);
    }

    @Override
    public boolean canAddItemBelow(IViewEntry<?> entry, IWorkItemType workItemType) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        PlanItem planItem = (PlanItem)entry.getElement();
        return !planItem.isResolved() && planItem.getScheduledTime() != null;
    }

    @Override
    public void addItemBelow(IViewEntry<?> entry, IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, false, context);
    }

    @Override
    public boolean canAddItemToGroup(IViewEntry<GroupElement> groupEntry, IWorkItemType workItemType) {
        TimeSpanDefinition timeSpan;
        if (!super.canAddItemToGroup(groupEntry, workItemType)) {
            return false;
        }
        GroupElement group = (GroupElement)groupEntry.getElement();
        ResolvedPlan plan = this.getPlan(groupEntry);
        return !(group instanceof TimeElement) || (timeSpan = ((TimeElement)group).getTimeSpan()) == TimeSpanDefinition.UNSCHEDULED || timeSpan != null && timeSpan.getEndTime().after(plan.getReferenceTime());
    }

    private void addSibling(final IViewEntry<PlanItem> entry, final IWorkItemType workItemType, final boolean before, final IRunnableContext context) throws TeamRepositoryException {
        final ResolvedPlan plan = this.getPlan(entry);
        final PlanViewModel viewModel = (PlanViewModel)entry.getModel();
        viewModel.updateModel(new IViewModelUpdateFunction<Void, TeamRepositoryException>(){

            public Void run(IViewModelUpdater updateAccessor) throws TeamRepositoryException {
                IViewEntry candidateEntry;
                IViewModelNavigator n = updateAccessor.getEntryNavigator(true);
                Object parentElement = n.parentElement(entry);
                final PlanItem sibling = (PlanItem)entry.getElement();
                PlanElement modelParent = parentElement instanceof PlanElement ? (PlanElement)parentElement : plan;
                final IViewEntry groupEntry = n.parentEntryOfType(entry, GroupElement.class);
                IViewEntry successorEntry = entry;
                if (!before && EntryUtils.isType(candidateEntry = n.successorEntry(entry), PlanElement.class)) {
                    successorEntry = candidateEntry;
                }
                SequenceItemMovePolicy.this.addItem(viewModel, modelParent, new IPlanItemAttributeSetter(){

                    public String getWorkItemTypeIdentifier() {
                        return workItemType.getIdentifier();
                    }

                    public void setAttributes(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
                        if (groupEntry != null) {
                            ((GroupElement)groupEntry.getElement()).adopt((PlanElement)item, (IViewEntry<? extends GroupElement>)groupEntry, monitor);
                        }
                        Assert.isTrue((boolean)item.getOwner().sameItemId((IItemHandle)sibling.getOwner()));
                        if (sibling.getCategory() != null) {
                            item.setCategory(sibling.getCategory());
                        }
                        if (sibling.getScheduledTime() != null) {
                            item.schedule(before ? null : sibling, before ? sibling : null);
                        } else {
                            item.markAsNewItem(sibling.isNewItem());
                        }
                    }
                }, (IViewEntry<? extends PlanElement>)successorEntry, updateAccessor, context);
                return null;
            }
        });
    }
}

