/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class RowElement
extends GroupElement {
    private final UUID fParentId;
    private final ArrayList<ColumnDescription> fColumns;
    private final ResolvedPlan fPlan;
    private final GroupElement[] fParent;
    private final boolean fIsHeader;

    public RowElement(GroupElement[] parent, ResolvedPlan plan) {
        this(null, parent, plan, false);
    }

    public RowElement(UUID parentId, GroupElement[] parent, ResolvedPlan plan, boolean isHeader) {
        this.fParentId = parentId;
        this.fColumns = new ArrayList();
        this.fParent = parent;
        this.fPlan = plan;
        this.fIsHeader = isHeader;
    }

    void addColumn(ColumnDescription column) {
        Assert.isLegal((this.fColumns.size() <= column.getIndex() ? 1 : 0) != 0);
        this.fColumns.add(column);
    }

    @Override
    public String getId() {
        return this.fParentId.getUuidValue();
    }

    public boolean isHeader() {
        return this.fIsHeader;
    }

    public ColumnDescription[] getColumns() {
        return this.fColumns.toArray(new ColumnDescription[this.fColumns.size()]);
    }

    public PlanElement getParent() {
        if (this.fParentId == null) {
            return this.fPlan;
        }
        return this.fPlan.getPlanItem(this.fParentId);
    }

    public int hashCode() {
        if (this.fIsHeader) {
            return 1;
        }
        if (this.fParentId == null) {
            return 0;
        }
        return this.fParentId.hashCode();
    }

    @Override
    public boolean canAdopt(PlanElement toAdopt, IViewEntry<GroupElement> groupEntry) {
        if (!(toAdopt instanceof PlanItem)) {
            return false;
        }
        PlanItem planItem = (PlanItem)toAdopt;
        PlanElement parent = this.getParent();
        while (parent instanceof PlanItem) {
            if (planItem.equals((Object)parent)) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public boolean adopt(PlanElement toAdopt, IViewEntry<? extends GroupElement> groupEntry, IProgressMonitor monitor) {
        if (!(toAdopt instanceof PlanItem)) {
            return false;
        }
        PlanItem planItem = (PlanItem)toAdopt;
        if (!planItem.getWorkItemId().equals((Object)this.fParentId)) {
            planItem.moveTo(this.getParent());
        }
        GroupElement[] groupElementArray = this.fParent;
        int n = this.fParent.length;
        int n2 = 0;
        while (n2 < n) {
            GroupElement parent = groupElementArray[n2];
            parent.adopt(toAdopt, groupEntry, monitor);
            ++n2;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowElement other = (RowElement)obj;
        if (this.fIsHeader != other.fIsHeader) {
            return false;
        }
        return !(this.fParentId == null ? other.fParentId != null : !this.fParentId.equals((Object)other.fParentId));
    }

    @Override
    public String getLabel() {
        if (this.fParentId == null) {
            return "";
        }
        return this.fPlan.getPlanItem(this.fParentId).getSummary();
    }

    @Override
    public int compareTo(GroupElement o) {
        if (o instanceof RowElement) {
            RowElement r = (RowElement)o;
            if (r.fIsHeader && !this.fIsHeader) {
                return 1;
            }
            if (!r.fIsHeader && this.fIsHeader) {
                return -1;
            }
            if (r.fIsHeader && this.fIsHeader) {
                return 0;
            }
            if (r.fParentId == null && this.fParentId != null) {
                return -1;
            }
            if (r.fParentId != null && this.fParentId == null) {
                return 1;
            }
            return 0;
        }
        return super.compareTo(o);
    }
}

