/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractJavaPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProgressUpdater<T> {
    private AbstractJavaPlanModelTransformer fTransformer;
    private Class<T> fClass;
    private static final Set<IPlanningAttributeIdentifier> AFFECTS_FOLDER_PROGRESS = new HashSet<IPlanningAttributeIdentifier>();

    public ProgressUpdater(AbstractJavaPlanModelTransformer transformer, Class<T> clazz) {
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.STATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.ESTIMATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.CORRECTED_ESTIMATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.TIMESPENT);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.AUXILIARY_ITEM);
        this.fClass = clazz;
        this.fTransformer = transformer;
    }

    protected AbstractJavaPlanModelTransformer getTransformer() {
        return this.fTransformer;
    }

    public void processElementAdded(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, true), updateAccessor);
        this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
    }

    public void processElementRemoved(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, false), updateAccessor);
        this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
    }

    public void processElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IViewModelUpdater updateAccessor) {
        if (!(removeDelta.getPlanElement() instanceof PlanItem) || !(addDelta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        List<PlanItem> removedParents = this.getTopLevelParents(removeDelta, updateAccessor, false);
        HashSet<PlanItem> addParents = new HashSet<PlanItem>(this.getTopLevelParents(addDelta, updateAccessor, true));
        ArrayList<PlanItem> parentsToUpdate = new ArrayList<PlanItem>();
        for (PlanItem planItem : removedParents) {
            if (addParents.remove(planItem)) continue;
            parentsToUpdate.add(planItem);
        }
        parentsToUpdate.addAll(addParents);
        this.updateTopLevelProgress(parentsToUpdate, updateAccessor);
        List<IViewEntry<T>> removedFolders = this.getParentFolders(removeDelta, updateAccessor, false);
        HashSet<IViewEntry<T>> addFolders = new HashSet<IViewEntry<T>>(this.getParentFolders(addDelta, updateAccessor, true));
        ArrayList<IViewEntry<T>> foldersToUpdate = new ArrayList<IViewEntry<T>>();
        for (IViewEntry iViewEntry : removedFolders) {
            if (addFolders.remove(iViewEntry)) continue;
            foldersToUpdate.add(iViewEntry);
        }
        foldersToUpdate.addAll(addFolders);
        this.updateFolderProgress(foldersToUpdate, updateAccessor);
    }

    public void processElementChanged(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        if (this.affectsFolderProgress(delta)) {
            this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
        }
        if (this.affectsTopLevelItem(delta)) {
            this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, true), updateAccessor);
        }
    }

    private boolean affectsTopLevelItem(IPlanElementDelta delta) {
        return delta.getAttributeDelta(PlanItem.STATE) != null;
    }

    private List<PlanItem> getTopLevelParents(IPlanElementDelta delta, IViewModelUpdater updateAccessor, boolean newValue) {
        ArrayList<PlanItem> result = new ArrayList<PlanItem>();
        List<AbstractJavaPlanModelTransformer.ElementInfo> elementInfoPath = this.fTransformer.getElementInfoPath(delta, newValue);
        if (elementInfoPath.isEmpty()) {
            return result;
        }
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        if (!(element instanceof PlanItem)) {
            return result;
        }
        List entries = updateAccessor.getElementEntries((Object)((PlanItem)element));
        IViewEntry current = null;
        for (IViewEntry entry : entries) {
            if (!entry.hasTag((IViewEntryTag)PrimaryLocationTag.INSTANCE)) continue;
            current = entry;
            break;
        }
        while (current != null) {
            PlanItem currentElement;
            if (current.hasTag((IViewEntryTag)PrimaryLocationTag.INSTANCE) && EntryUtils.isType(current, PlanItem.class) && (currentElement = (PlanItem)current.getElement()).isTopLevelPlanItem()) {
                result.add(currentElement);
            }
            current = updateAccessor.getParent(current);
        }
        return result;
    }

    private void updateTopLevelProgress(List<PlanItem> items, IViewModelUpdater updateAccessor) {
        for (PlanItem item : items) {
            for (IViewEntry entry : updateAccessor.getElementEntries((Object)item)) {
                updateAccessor.update(entry, new String[]{"progress"});
            }
        }
    }

    protected boolean affectsFolderProgress(IPlanElementDelta delta) {
        IPlanAttributeDelta[] attributeDeltas;
        IPlanAttributeDelta[] iPlanAttributeDeltaArray = attributeDeltas = delta.getAttributeDeltas();
        int n = attributeDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
            if (AFFECTS_FOLDER_PROGRESS.contains(attributeDelta.getAttribute())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<IViewEntry<T>> getParentFolders(IPlanElementDelta delta, IViewModelUpdater updateAccessor, boolean newValue) {
        ArrayList<IViewEntry<T>> result = new ArrayList<IViewEntry<T>>();
        List<AbstractJavaPlanModelTransformer.ElementInfo> elementInfoPath = this.fTransformer.getElementInfoPath(delta, newValue);
        if (elementInfoPath.isEmpty()) {
            return result;
        }
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        if (!(element instanceof PlanItem)) {
            return result;
        }
        List entries = updateAccessor.getElementEntries((Object)((PlanItem)element));
        IViewEntry current = null;
        for (IViewEntry entry : entries) {
            if (!entry.hasTag((IViewEntryTag)PrimaryLocationTag.INSTANCE)) continue;
            current = entry;
            break;
        }
        while (current != null) {
            if (EntryUtils.isType(current, this.fClass)) {
                result.add(current);
            }
            current = updateAccessor.getParent(current);
        }
        return result;
    }

    private void updateFolderProgress(List<IViewEntry<T>> folders, IViewModelUpdater updateAccessor) {
        for (IViewEntry<T> folder : folders) {
            updateAccessor.update(folder, new String[]{"progress"});
        }
    }
}

