/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.ide.ui.common.model.EntrySorter;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PartialViewerSorter
extends EntrySorter {
    protected static final int CATEGORY_PLANITEM = 100;
    protected static final int CATEGORY_PROGRESSITEM = 110;
    protected static final int CATEGORY_GROUPELEMENT = 1000;
    protected static final int CATEGORY_USER_DEFINED = 10000;
    protected static final int CATEGORY_UNKNOWN = Integer.MAX_VALUE;
    private ElementComparer<?> fItemComparator;
    private TagComparer<?> fTagComparator;
    private final boolean fEnforceElementSortOrder;

    public PartialViewerSorter(boolean enforceElementSortOrder) {
        this.fEnforceElementSortOrder = enforceElementSortOrder;
    }

    public void setItemComparator(ElementComparer<?> comparator) {
        this.fItemComparator = comparator;
    }

    public ElementComparer<?> getItemComparator() {
        return this.fItemComparator;
    }

    public void setTagComparator(TagComparer<?> comparator) {
        this.fTagComparator = comparator;
    }

    public TagComparer<?> getTagComparator() {
        return this.fTagComparator;
    }

    @Override
    public boolean isSorterProperty(String property) {
        return this.fItemComparator != null ? this.fItemComparator.isAffectedBy(property) : false;
    }

    @Override
    public int category(IViewEntry<?> entry, IViewModelReader readAccessor) {
        if (EntryUtils.isType(entry, PlanElement.class)) {
            return 100;
        }
        if (EntryUtils.isType(entry, GroupElement.class)) {
            return 1000;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean enforceElementSort(int category) {
        return this.fEnforceElementSortOrder;
    }

    @Override
    public <T> int compare(int category, IViewEntry<T> e1, IViewEntry<T> e2, IViewModelReader readAccessor) {
        int result = PartialViewerSorter.compareTags(e1, e2, this.fTagComparator);
        if (result == 0) {
            result = PartialViewerSorter.compareElements(e1.getElement(), e2.getElement(), this.fItemComparator);
        }
        if (category == 1000) {
            GroupElement g1 = (GroupElement)e1.getElement();
            GroupElement g2 = (GroupElement)e2.getElement();
            result = g1.compareTo(g2);
        }
        return result;
    }

    protected static final <T> int compareElements(Object e1, Object e2, ElementComparer<T> comparer) {
        Class<T> comparatorType;
        if (comparer != null && (comparatorType = comparer.getElementClass()).isInstance(e1) && comparatorType.isInstance(e2)) {
            return comparer.compare(comparatorType.cast(e1), comparatorType.cast(e2));
        }
        return 0;
    }

    protected static final <T extends EntryTag<?>> int compareTags(IViewEntry<?> e1, IViewEntry<?> e2, TagComparer<T> comparer) {
        if (comparer != null) {
            Class<T> tagType = comparer.getTagClass();
            List t1 = e1.getTags(tagType);
            List t2 = e2.getTags(tagType);
            return comparer.compare(t1, t2);
        }
        return 0;
    }

    public static class CompositeElementComparer
    extends ElementComparer<Object> {
        private final List<ElementComparer<?>> fComparers;

        public CompositeElementComparer(List<ElementComparer<?>> comparers) {
            super(Object.class);
            this.fComparers = new ArrayList(comparers);
        }

        @Override
        public boolean isAffectedBy(String attributeName) {
            for (ElementComparer<?> comparer : this.fComparers) {
                if (!comparer.isAffectedBy(attributeName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int result = 0;
            Iterator<ElementComparer<?>> comparers = this.fComparers.iterator();
            while (result == 0 && comparers.hasNext()) {
                result = PartialViewerSorter.compareElements(o1, o2, comparers.next());
            }
            return result;
        }
    }

    public static abstract class ElementComparer<T>
    implements Comparator<T> {
        private final Class<T> fElementClass;

        public ElementComparer(Class<T> elementClass) {
            this.fElementClass = elementClass;
        }

        public Class<T> getElementClass() {
            return this.fElementClass;
        }

        public boolean isAffectedBy(String attributeName) {
            return false;
        }
    }

    public static abstract class TagComparer<T extends EntryTag<?>>
    implements Comparator<List<T>> {
        private final Class<T> fTagClass;

        public TagComparer(Class<T> elementClass) {
            this.fTagClass = elementClass;
        }

        public Class<T> getTagClass() {
            return this.fTagClass;
        }

        public boolean isAffectedBy(String attributeName) {
            return false;
        }
    }
}

