/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractItemElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.core.runtime.IProgressMonitor;

public class OwnerElement
extends AbstractItemElement {
    private static final int CATEGORY_TEAMMEMBER = 0;
    private static final int CATEGORY_OTHER = 1;
    private static final int CATEGORY_UNASSIGNED = 2;
    private final IContributor fOwner;
    private final int fCategory;

    public OwnerElement(ResolvedPlan plan, IContributor owner) {
        super(owner.getItemHandle());
        this.fOwner = owner;
        int category = 1;
        if (this.fOwner.sameItemId((IItemHandle)plan.getNullOwner())) {
            category = 2;
        } else if (plan instanceof ResolvedIterationPlan && ((ResolvedIterationPlan)plan).getMemberContributors().contains((Object)this.fOwner)) {
            category = 0;
        }
        this.fCategory = category;
    }

    public IContributor getOwner() {
        return this.fOwner;
    }

    @Override
    public String getId() {
        return this.fOwner.getItemId().getUuidValue();
    }

    @Override
    public String getLabel() {
        return this.fOwner.getName();
    }

    @Override
    public boolean adopt(PlanElement toAdopt, IViewEntry<? extends GroupElement> groupEntry, IProgressMonitor monitor) {
        if (!(toAdopt instanceof PlanItem)) {
            return false;
        }
        ((PlanItem)toAdopt).setOwner(this.fOwner);
        return true;
    }

    @Override
    public int compareTo(GroupElement o) {
        if (o instanceof OwnerElement) {
            OwnerElement other = (OwnerElement)o;
            if (this.fCategory != other.fCategory) {
                return this.fCategory - other.fCategory;
            }
        }
        return super.compareTo(o);
    }
}

