/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.LegacyHelper;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.ide.ui.common.DropTarget;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ICreateHandler;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineItem;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.GroupProviderProxy;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.ScriptableSorter;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.ViewModeTransformerProxy;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.rtc.common.scriptengine.environment.WrappedScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import com.ibm.team.rtc.foundation.api.ui.essentials.IMoveHandler;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.IProgressService;

public class JavaScriptItemMovePolicy
extends ItemMovePolicy {
    private IScriptEnvironment fScriptEnvironment;
    protected ViewModeTransformerProxy fViewMode;
    protected GroupProviderProxy fGroupProvider;
    protected ScriptableSorter fEntrySorter;

    public JavaScriptItemMovePolicy(IScriptEnvironment scriptEnvironment) {
        this.fScriptEnvironment = new WrappedScriptEnvironment(scriptEnvironment);
        ((IScriptingHelper)this.fScriptEnvironment.adapt(IScriptingHelper.class)).dojoRequire("com.ibm.team.apt.shared.ui.Move");
        ((IScriptingHelper)this.fScriptEnvironment.adapt(IScriptingHelper.class)).dojoRequire("com.ibm.team.apt.shared.ui.Create");
    }

    public void setViewMode(ViewModeTransformerProxy viewMode) {
        this.fViewMode = viewMode;
    }

    public void setGroupProvider(GroupProviderProxy groupProvider) {
        this.fGroupProvider = groupProvider;
    }

    public void setEntrySorter(ScriptableSorter entrySorter) {
        this.fEntrySorter = entrySorter;
    }

    @Override
    public ItemMovePolicy.DropLocation validateDrop(final IStructuredSelection sourceSelection, final DropTarget dropTarget) {
        return (ItemMovePolicy.DropLocation)((Object)dropTarget.getTargetEntry().getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<ItemMovePolicy.DropLocation, RuntimeException>(){

            public ItemMovePolicy.DropLocation run(IViewModelReader readAccessor) throws RuntimeException {
                IViewEntry<?> targetEntry = dropTarget.getTargetEntry();
                ResolvedPlan plan = JavaScriptItemMovePolicy.this.getPlan(targetEntry);
                boolean hasValidAdoptions = false;
                Object[] objectArray = sourceSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object source = objectArray[n2];
                    if (JavaScriptItemMovePolicy.this.isIncompatibleProjectArea(source, targetEntry)) {
                        return ItemMovePolicy.DropLocation.None;
                    }
                    if (source instanceof IWorkItemHandle) {
                        source = plan.getPlanItem((IWorkItemHandle)source);
                    }
                    if (source != null && !JavaScriptItemMovePolicy.this.canMove(source, null, targetEntry, dropTarget.getLocation(), readAccessor)) {
                        return ItemMovePolicy.DropLocation.None;
                    }
                    hasValidAdoptions |= true;
                    ++n2;
                }
                return hasValidAdoptions ? dropTarget.getLocation() : ItemMovePolicy.DropLocation.None;
            }
        }));
    }

    @Override
    public boolean drop(IStructuredSelection sourceSelection, final DropTarget dropTarget, IProgressService progressService) {
        final IViewEntry<?> targetEntry = dropTarget.getTargetEntry();
        DropTargetEvent event = dropTarget.getEvent();
        boolean result = this.doResolveAndDrop(sourceSelection, new IPlanItemAttributeSetter(){

            public String getWorkItemTypeIdentifier() {
                return null;
            }

            public void setAttributes(final PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
                JavaScriptItemMovePolicy.this.getViewModel(targetEntry).updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

                    public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                        JavaScriptItemMovePolicy.this.move(planItem, null, targetEntry, dropTarget.getLocation(), updateAccessor);
                        return null;
                    }
                });
            }
        }, this.getViewModel(targetEntry), event, progressService);
        IPlanOutlineSettings settings = (IPlanOutlineSettings)this.getViewModel(targetEntry).getOutlineSettings();
        if (LegacyHelper.isCustomSortMode((ISortModeDescription)settings.getSortMode())) {
            ((ResolvedIterationPlan)this.getPlan(targetEntry)).setAuxiliaryDataChanged();
        }
        if (result) {
            IViewEntry groupEntry = (IViewEntry)targetEntry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<IViewEntry<GroupElement>, RuntimeException>(){

                public IViewEntry<GroupElement> run(IViewModelReader readAccessor) throws RuntimeException {
                    return readAccessor.getEntryNavigator(true).parentEntryOfType(targetEntry, GroupElement.class);
                }
            });
            if (groupEntry != null) {
                this.doSelect(sourceSelection, (IViewEntry<GroupElement>)groupEntry);
            }
            if (groupEntry != null) {
                this.doSelect(sourceSelection, (IViewEntry<GroupElement>)groupEntry);
            }
        }
        return result;
    }

    @Override
    public boolean canIncreaseIndent(IViewEntry<?> entry) {
        return this.canMove(entry, new DemoteStrategy());
    }

    @Override
    public void increaseIndent(IViewEntry<?> entry) {
        this.executeMove(entry, new DemoteStrategy());
    }

    @Override
    public boolean canDecreaseIndent(IViewEntry<?> entry) {
        return this.canMove(entry, new PromoteStrategy());
    }

    @Override
    public void decreaseIndent(IViewEntry<?> entry) {
        this.executeMove(entry, new PromoteStrategy());
    }

    @Override
    public boolean canMoveUp(IViewEntry<?> entry) {
        return this.canMove(entry, new MoveUpStrategy());
    }

    @Override
    public void moveUp(IViewEntry<?> entry) {
        this.executeMove(entry, new MoveUpStrategy());
    }

    @Override
    public boolean canMoveDown(IViewEntry<?> entry) {
        return this.canMove(entry, new MoveDownStrategy());
    }

    @Override
    public void moveDown(IViewEntry<?> entry) {
        this.executeMove(entry, new MoveDownStrategy());
    }

    @Override
    public boolean canAddItemAbove(IViewEntry<?> entry, IWorkItemType workItemType) {
        return this.canCreate(entry, ItemMovePolicy.CreateLocation.Before, workItemType);
    }

    @Override
    public void addItemAbove(IViewEntry<?> entry, IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.executeCreate(entry, ItemMovePolicy.CreateLocation.Before, workItemType, context);
    }

    @Override
    public boolean canAddItemBelow(IViewEntry<?> entry, IWorkItemType workItemType) {
        return this.canCreate(entry, ItemMovePolicy.CreateLocation.After, workItemType);
    }

    @Override
    public void addItemBelow(IViewEntry<?> entry, IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.executeCreate(entry, ItemMovePolicy.CreateLocation.After, workItemType, context);
    }

    @Override
    public boolean canAddItemToGroup(IViewEntry<GroupElement> groupEntry, IWorkItemType workItemType) {
        return this.canCreate(groupEntry, ItemMovePolicy.CreateLocation.Child, workItemType);
    }

    @Override
    public void addItemToGroup(IViewEntry<?> groupEntry, IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.executeCreate(groupEntry, ItemMovePolicy.CreateLocation.Child, workItemType, context);
    }

    private boolean canMove(final IViewEntry<?> entry, final Strategy strategy) {
        return (Boolean)entry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<Boolean, RuntimeException>(){

            public Boolean run(IViewModelReader readAccessor) throws RuntimeException {
                strategy.calculate(entry, readAccessor);
                if (strategy.fTargetEntry != null) {
                    return JavaScriptItemMovePolicy.this.canMove(entry.getElement(), entry, strategy.fTargetEntry, strategy.fLocation, readAccessor);
                }
                return false;
            }
        });
    }

    private void executeMove(final IViewEntry<?> entry, final Strategy strategy) {
        final PlanViewModel viewModel = this.getViewModel(entry);
        viewModel.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                final IViewEntry toReveal = JavaScriptItemMovePolicy.this.preservingEditor((IViewEntry<PlanElement>)entry, updateAccessor, new PreservingEditorRunnable(){

                    @Override
                    public IViewEntry<? extends PlanElement> run(IViewEntry<PlanElement> entry, IViewModelUpdater updateAccessor) {
                        strategy.calculate(entry, (IViewModelReader)updateAccessor);
                        if (strategy.fTargetEntry != null) {
                            JavaScriptItemMovePolicy.this.move(entry.getElement(), entry, strategy.fTargetEntry, strategy.fLocation, updateAccessor);
                        }
                        return EntryUtils.isType(entry, PlanItem.class) ? updateAccessor.getEntryNavigator(true).findPrimaryEntry((Object)((PlanElement)entry.getElement())) : null;
                    }
                });
                if (toReveal != null) {
                    updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                        public void run() {
                            viewModel.revealEntry(toReveal);
                            viewModel.setSelectedEntry(toReveal);
                        }
                    });
                }
                return null;
            }
        });
        IPlanOutlineSettings settings = (IPlanOutlineSettings)this.getViewModel(entry).getOutlineSettings();
        if (LegacyHelper.isCustomSortMode((ISortModeDescription)settings.getSortMode())) {
            ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
        }
    }

    private boolean canCreate(final IViewEntry<?> target, final ItemMovePolicy.CreateLocation location, final IWorkItemType workItemType) {
        return (Boolean)target.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<Boolean, RuntimeException>(){

            public Boolean run(IViewModelReader readAccessor) throws RuntimeException {
                ICreateHandler.ICreateRequest request = JavaScriptItemMovePolicy.this.createItemCreateRequest(target, workItemType, location);
                boolean result = false;
                if (request != null) {
                    for (ICreateHandler handler : JavaScriptItemMovePolicy.this.getCreateHandlers()) {
                        ICreateHandler.ICreateResponse response = handler.canCreate(request, readAccessor);
                        if (response == null) continue;
                        if (!response.canCreate()) {
                            return false;
                        }
                        result = true;
                    }
                }
                return result;
            }
        });
    }

    private void executeCreate(final IViewEntry<?> target, final ItemMovePolicy.CreateLocation location, final IWorkItemType workItemType, IRunnableContext context) throws TeamRepositoryException {
        final PlanViewModel viewModel = this.getViewModel(target);
        final ResolvedPlan plan = viewModel.getInput();
        try {
            context.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                @Override
                public void execute(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, TeamRepositoryException {
                    viewModel.updateModel(new IViewModelUpdateFunction<Void, TeamRepositoryException>(){

                        public Void run(final IViewModelUpdater updateAccessor) throws TeamRepositoryException {
                            ICreateHandler.ICreateRequest request = JavaScriptItemMovePolicy.this.createItemCreateRequest(target, workItemType, location);
                            final List handlers = JavaScriptItemMovePolicy.this.getCreateHandlers();
                            final ArrayList<ICreateHandler.ICreateResponse> responses = new ArrayList<ICreateHandler.ICreateResponse>(handlers.size());
                            boolean result = false;
                            if (request != null) {
                                for (ICreateHandler handler : handlers) {
                                    ICreateHandler.ICreateResponse response = handler.canCreate(request, (IViewModelReader)updateAccessor);
                                    responses.add(response);
                                    if (response == null) continue;
                                    if (!response.canCreate()) {
                                        return null;
                                    }
                                    result = true;
                                }
                            }
                            if (result) {
                                PlanItem newPlanItem = plan.createNewPlanItem((PlanElement)plan, new IPlanItemAttributeSetter(){

                                    public String getWorkItemTypeIdentifier() {
                                        return workItemType.getIdentifier();
                                    }

                                    public void setAttributes(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
                                        int i = 0;
                                        while (i < handlers.size()) {
                                            ICreateHandler.ICreateResponse response = (ICreateHandler.ICreateResponse)responses.get(i);
                                            if (response != null) {
                                                response.setNewItem(item);
                                                ((ICreateHandler)handlers.get(i)).create(response, updateAccessor);
                                            }
                                            ++i;
                                        }
                                    }
                                }, monitor);
                                newPlanItem.modified();
                                IViewModelNavigator n = updateAccessor.getEntryNavigator(false);
                                final IViewEntry primaryEntry = n.findPrimaryEntry((Object)newPlanItem);
                                if (primaryEntry != null) {
                                    updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                                        public void run() {
                                            viewModel.setSelectedEntry(primaryEntry);
                                            viewModel.revealEntry(primaryEntry);
                                            PlanViewer planViewer = viewModel.getViewer();
                                            OutlineItem newOutlineItem = planViewer.findOutlineItem(primaryEntry);
                                            if (newOutlineItem instanceof PlanItemOutlineItem) {
                                                planViewer.getOutline().startEditSession(((PlanItemOutlineItem)newOutlineItem).getPlanItemGadget().getSummary());
                                            }
                                        }
                                    });
                                }
                            }
                            return null;
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            if (e.getCause() instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)e.getCause();
            }
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)e.getCause();
            }
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private List<IMoveHandler> getHandlers() {
        ArrayList<IMoveHandler> result = new ArrayList<IMoveHandler>(3);
        if (this.fViewMode != null) {
            result.add(this.fViewMode);
        }
        if (this.fGroupProvider != null) {
            result.add(this.fGroupProvider);
        }
        if (this.fEntrySorter != null) {
            result.add(this.fEntrySorter);
        }
        return result;
    }

    private List<ICreateHandler> getCreateHandlers() {
        ArrayList<ICreateHandler> result = new ArrayList<ICreateHandler>(3);
        if (this.fViewMode != null) {
            result.add(this.fViewMode);
        }
        if (this.fGroupProvider != null) {
            result.add(this.fGroupProvider);
        }
        if (this.fEntrySorter != null) {
            result.add(this.fEntrySorter);
        }
        return result;
    }

    private boolean canMove(Object source, IViewEntry<?> sourceEntry, IViewEntry<?> target, ItemMovePolicy.DropLocation dropLocation, IViewModelReader readAccessor) {
        boolean result = false;
        IMoveHandler.IMoveRequest request = this.createItemMoveRequest(source, sourceEntry, target, dropLocation);
        if (request != null) {
            for (IMoveHandler handler : this.getHandlers()) {
                IMoveHandler.IMoveResponse response = handler.canMove(request, readAccessor);
                if (response == null) continue;
                if (!response.canMove()) {
                    return false;
                }
                result = true;
            }
        }
        return result;
    }

    private void move(Object source, IViewEntry<?> sourceEntry, IViewEntry<?> target, ItemMovePolicy.DropLocation dropLocation, IViewModelUpdater updateAccessor) {
        IMoveHandler.IMoveRequest request = this.createItemMoveRequest(source, sourceEntry, target, dropLocation);
        if (request != null) {
            IMoveHandler.IMoveResponse response;
            List<IMoveHandler> handlers = this.getHandlers();
            ArrayList<IMoveHandler.IMoveResponse> responses = new ArrayList<IMoveHandler.IMoveResponse>(handlers.size());
            int i = 0;
            while (i < handlers.size()) {
                response = handlers.get(i).canMove(request, (IViewModelReader)updateAccessor);
                responses.add(response);
                if (response != null && !response.canMove()) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < handlers.size()) {
                response = (IMoveHandler.IMoveResponse)responses.get(i);
                if (response != null) {
                    handlers.get(i).move(response, updateAccessor);
                }
                ++i;
            }
        }
    }

    private IMoveHandler.IMoveRequest createItemMoveRequest(Object source, IViewEntry<?> sourceEntry, IViewEntry<?> target, ItemMovePolicy.DropLocation dropLocation) {
        int location = this.getMoveRequestLocation(dropLocation);
        if (location != 0) {
            return (IMoveHandler.IMoveRequest)ScriptUtilities.newInstance((IScriptEnvironment)this.fScriptEnvironment, IMoveHandler.IMoveRequest.class, (String)"com.ibm.team.apt.shared.ui.Move.Request", (Object[])new Object[]{source, sourceEntry, target, location});
        }
        return null;
    }

    private int getMoveRequestLocation(ItemMovePolicy.DropLocation location) {
        switch (location) {
            case After: {
                return 1;
            }
            case Before: {
                return 2;
            }
            case Onto: {
                return 3;
            }
            case Demote: {
                return 4;
            }
            case Promote: {
                return 5;
            }
        }
        return 0;
    }

    private ICreateHandler.ICreateRequest createItemCreateRequest(IViewEntry<?> target, IWorkItemType workItemType, ItemMovePolicy.CreateLocation createLocation) {
        int location = this.getCreateRequestLocation(createLocation);
        if (location != 0) {
            return (ICreateHandler.ICreateRequest)ScriptUtilities.newInstance((IScriptEnvironment)this.fScriptEnvironment, ICreateHandler.ICreateRequest.class, (String)"com.ibm.team.apt.shared.ui.Create.Request", (Object[])new Object[]{target, workItemType, location});
        }
        return null;
    }

    private int getCreateRequestLocation(ItemMovePolicy.CreateLocation location) {
        switch (location) {
            case After: {
                return 1;
            }
            case Before: {
                return 2;
            }
        }
        return 3;
    }

    private IViewEntry<? extends PlanElement> preservingEditor(IViewEntry<PlanElement> entry, IViewModelUpdater updateAccessor, PreservingEditorRunnable code) {
        PlanViewModel viewModel = this.getViewModel(entry);
        final PlanItemOutlineViewer viewer = (PlanItemOutlineViewer)viewModel.getViewer();
        final PlanCanvas outline = viewModel.getViewer().getOutline();
        AbstractTextEditor editor = outline.getCurrentTextEditor();
        boolean editingElementToBeIndented = false;
        String id = null;
        Point editorSelection = null;
        if (editor != null) {
            outline.storeData();
            editorSelection = editor.getSelection();
            editingElementToBeIndented = entry.equals(editor.getEntry());
            id = editor.getOwner().getId();
        }
        final IViewEntry<? extends PlanElement> newEntry = code.run(entry, updateAccessor);
        if (editingElementToBeIndented && newEntry != null) {
            final Point finalSelection = editorSelection;
            final String finalId = id;
            updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                public void run() {
                    OutlineItem newItem = viewer.findOutlineItem(newEntry);
                    PlanItemGadget content = (PlanItemGadget)newItem.getContent();
                    ((ITextEditor)outline.startEditSession(JavaScriptItemMovePolicy.this.getOwner(content, finalId))).setSelection(finalSelection);
                    viewer.startEditSession((IViewEntry<? extends PlanElement>)newEntry);
                }
            });
        }
        return newEntry;
    }

    private GText getOwner(PlanItemGadget content, String id) {
        if ("summary".equals(id)) {
            return content.getSummary();
        }
        if ("description".equals(id)) {
            return content.getDescription();
        }
        return null;
    }

    private static class DemoteStrategy
    extends Strategy {
        private DemoteStrategy() {
        }

        @Override
        public void calculate(IViewEntry<?> entry, IViewModelReader readAccessor) {
            this.fTargetEntry = entry;
            this.fLocation = ItemMovePolicy.DropLocation.Demote;
        }
    }

    private static class MoveDownStrategy
    extends Strategy {
        private MoveDownStrategy() {
        }

        @Override
        public void calculate(IViewEntry<?> entry, IViewModelReader readAccessor) {
            List childEntries;
            IViewEntry parentEntry;
            boolean isMovingPlanElement = EntryUtils.isType(entry, PlanElement.class);
            IViewModelNavigator n = readAccessor.getEntryNavigator(true);
            if (!isMovingPlanElement) {
                final Class<?> elementClass = entry.getElement().getClass();
                n = readAccessor.getFilterEntryNavigator(new IViewModelNavigator.IViewModelNavigatorFilter(){

                    public boolean select(IViewEntry<?> entry) {
                        return entry.isVisible() && elementClass.isInstance(EntryUtils.element(entry));
                    }
                });
            }
            this.fLocation = ItemMovePolicy.DropLocation.After;
            this.fTargetEntry = n.successorEntry(entry);
            if (!(this.fTargetEntry != null || EntryUtils.isType(parentEntry = n.parentEntry(entry), PlanItem.class) && isMovingPlanElement)) {
                this.fTargetEntry = n.successorEntry(parentEntry);
            }
            if (EntryUtils.isType(this.fTargetEntry, GroupElement.class) && isMovingPlanElement && (childEntries = n.childEntries(this.fTargetEntry)).size() > 0) {
                this.fTargetEntry = (IViewEntry)childEntries.get(0);
                this.fLocation = ItemMovePolicy.DropLocation.Before;
            }
        }
    }

    private static class MoveUpStrategy
    extends Strategy {
        private MoveUpStrategy() {
        }

        @Override
        public void calculate(IViewEntry<?> entry, IViewModelReader readAccessor) {
            boolean isMovingPlanElement = EntryUtils.isType(entry, PlanElement.class);
            IViewModelNavigator n = readAccessor.getEntryNavigator(true);
            if (!isMovingPlanElement) {
                final Class<?> elementClass = entry.getElement().getClass();
                n = readAccessor.getFilterEntryNavigator(new IViewModelNavigator.IViewModelNavigatorFilter(){

                    public boolean select(IViewEntry<?> entry) {
                        return entry.isVisible() && elementClass.isInstance(EntryUtils.element(entry));
                    }
                });
            }
            this.fLocation = ItemMovePolicy.DropLocation.Before;
            this.fTargetEntry = n.predecessorEntry(entry);
            if (this.fTargetEntry == null) {
                this.fTargetEntry = n.parentEntry(entry);
                if (!EntryUtils.isType(this.fTargetEntry, PlanElement.class) || !isMovingPlanElement) {
                    List childEntries;
                    this.fTargetEntry = n.predecessorEntry(this.fTargetEntry);
                    if (EntryUtils.isType(this.fTargetEntry, GroupElement.class) && isMovingPlanElement && (childEntries = n.childEntries(this.fTargetEntry)).size() > 0) {
                        this.fTargetEntry = (IViewEntry)childEntries.get(childEntries.size() - 1);
                    }
                    this.fLocation = ItemMovePolicy.DropLocation.After;
                }
            }
        }
    }

    private static interface PreservingEditorRunnable {
        public IViewEntry<? extends PlanElement> run(IViewEntry<PlanElement> var1, IViewModelUpdater var2);
    }

    private static class PromoteStrategy
    extends Strategy {
        private PromoteStrategy() {
        }

        @Override
        public void calculate(IViewEntry<?> entry, IViewModelReader readAccessor) {
            this.fTargetEntry = entry;
            this.fLocation = ItemMovePolicy.DropLocation.Promote;
        }
    }

    private static abstract class Strategy {
        protected IViewEntry<?> fTargetEntry;
        protected ItemMovePolicy.DropLocation fLocation;

        private Strategy() {
        }

        public abstract void calculate(IViewEntry<?> var1, IViewModelReader var2);
    }
}

