/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.jdojo.lang.IJSFunction;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenericElement
extends GroupElement {
    private final String fId;
    private final String fLabel;
    private final Object fValue;
    private IAdoptFunction fCanAdopt;
    private IAdoptFunction fAdopter;
    private IElementComparator fComparator;

    public GenericElement(String id, String label, Object value) {
        Assert.isLegal((id != null ? 1 : 0) != 0);
        this.fId = id;
        this.fLabel = label;
        this.fValue = value;
    }

    public void setCanAdopt(IAdoptFunction canAdopt) {
        this.fCanAdopt = canAdopt;
    }

    public void setAdopter(IAdoptFunction adopter) {
        this.fAdopter = adopter;
    }

    public void setComparator(IElementComparator comparator) {
        this.fComparator = comparator;
    }

    public Object getValue() {
        return this.fValue;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public boolean canAdopt(PlanElement toAdopt, IViewEntry<GroupElement> groupEntry) {
        return !(this.fAdopter == null || toAdopt != null && !(toAdopt instanceof PlanItem) || this.fCanAdopt != null && !this.fCanAdopt.run((PlanItem)toAdopt));
    }

    @Override
    public boolean adopt(PlanElement toAdopt, IViewEntry<? extends GroupElement> groupEntry, IProgressMonitor monitor) {
        if (!(toAdopt instanceof PlanItem) || this.fAdopter == null) {
            return false;
        }
        return this.fAdopter.run((PlanItem)toAdopt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.fId.equals(((GenericElement)obj).fId);
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    @Override
    public int compareTo(GroupElement o) {
        if (this.fComparator != null) {
            return this.fComparator.compare(this, o);
        }
        return super.compareTo(o);
    }

    public static interface IAdoptFunction
    extends IJSFunction {
        public boolean run(PlanItem var1);
    }

    public static interface IElementComparator
    extends IJSFunction {
        public int compare(Object var1, Object var2);
    }
}

