/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SequenceItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import com.ibm.team.apt.internal.ide.ui.mywork.TimeSpansMode;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;

public abstract class CommonGroupBySequenceDescription
extends GroupByDescription {
    private final List<SortMode> SEQUENCE_SORT_MODE = Collections.singletonList(SortMode.SCHEDULED);
    public static final String ID = "TIMELINE";

    public CommonGroupBySequenceDescription(String label) {
        super(ID, label);
    }

    @Override
    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        TimeSpansMode timeSpanMode = TimeSpansMode.Progressive;
        if (options != null) {
            timeSpanMode = (TimeSpansMode)((Object)options.getAdapter(TimeSpansMode.class));
        }
        return this.createModelTransformer(timeSpanMode.createTimeSpanFactory());
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new SequenceItemMovePolicy();
    }

    @Override
    public PartialViewerSorter createSorter() {
        return new ScheduledTimeSorter();
    }

    @Override
    public List<SortMode> getSortModes() {
        return this.SEQUENCE_SORT_MODE;
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.SCHEDULED;
    }

    protected abstract PlanModelTransformer createModelTransformer(TimeSpanFactory var1);

    private static class ScheduledTimeSorter
    extends PartialViewerSorter {
        private static final int CATEGORY_ITEM = 1;
        private static final int CATEGORY_ITEM_UNSCHEDULED = 2;
        private static final int CATEGORY_ELEMENT_TIME = 3;
        private static final int CATEGORY_ELEMENT_GENERIC = 4;
        private static final int CATEGORY_UNKNOWN = Integer.MAX_VALUE;

        public ScheduledTimeSorter() {
            super(true);
        }

        @Override
        public int category(IViewEntry<?> entry, IViewModelReader readAccessor) {
            if (EntryUtils.isType(entry, IScheduleItem.class)) {
                if (((IScheduleItem)entry.getElement()).getScheduledTime() != null) {
                    return 1;
                }
                return 2;
            }
            if (EntryUtils.isType(entry, TimeElement.class)) {
                return 3;
            }
            if (EntryUtils.isType(entry, GroupElement.class)) {
                return 4;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public <T> int compare(int category, IViewEntry<T> e1, IViewEntry<T> e2, IViewModelReader readAccessor) {
            if (category == 1) {
                IScheduleItem s1 = (IScheduleItem)e1.getElement();
                IScheduleItem s2 = (IScheduleItem)e2.getElement();
                Timespan t1 = s1.getScheduledTime();
                Timespan t2 = s2.getScheduledTime();
                if (t1 == null || t2 == null) {
                    return (t1 == null ? 1 : 0) - (t2 == null ? 1 : 0);
                }
                int result = Dates.compareTo((Date)t1.getStart(), (Date)t2.getStart());
                if (result == 0) {
                    result = s1.getSequenceValue().compareTo(s2.getSequenceValue());
                }
                return result;
            }
            if (category == 2) {
                int result = ScheduledTimeSorter.compareTags(e1, e2, this.getTagComparator());
                if (result == 0) {
                    result = ScheduledTimeSorter.compareElements(e1.getElement(), e2.getElement(), this.getItemComparator());
                }
                return result;
            }
            if (category == 3) {
                TimeSpanDefinition t1 = ((TimeElement)e1.getElement()).getTimeSpan();
                TimeSpanDefinition t2 = ((TimeElement)e2.getElement()).getTimeSpan();
                if (t1 == TimeSpanDefinition.UNSCHEDULED || t2 == TimeSpanDefinition.UNSCHEDULED) {
                    return (t1 == TimeSpanDefinition.UNSCHEDULED ? 1 : 0) - (t2 == TimeSpanDefinition.UNSCHEDULED ? 1 : 0);
                }
                return t1.compareTo(t2);
            }
            if (category == 4) {
                GroupElement g1 = (GroupElement)e1.getElement();
                GroupElement g2 = (GroupElement)e2.getElement();
                return g1.compareTo(g2);
            }
            return 0;
        }
    }
}

