/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.OutplaceLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractJavaPlanModelTransformer
extends PlanModelTransformer {
    protected static final Collection<GroupElement[]> NO_GROUP = Collections.singleton(new GroupElement[0]);
    protected static final Object[] EMPTY_PATH = new Object[0];
    protected static final EntryTag[] NO_TAGS = new EntryTag[0];
    protected static final EntryTag[] DEFAULT_TAGS = new EntryTag[]{PrimaryLocationTag.INSTANCE};
    private final List<IPlanningAttributeIdentifier> fStructureAttributes;
    private final int fStructureAttributesCount;
    private PlanViewModel fViewModel;
    private ResolvedPlan fPlan;
    private final IPlanElementListener fListener;
    private Map<PlanElement, ElementInfo> fElementInfos = new HashMap<PlanElement, ElementInfo>();

    public AbstractJavaPlanModelTransformer(Collection<IPlanningAttributeIdentifier> structureAttributes) {
        this.fStructureAttributes = Collections.unmodifiableList(new ArrayList<IPlanningAttributeIdentifier>(structureAttributes));
        this.fStructureAttributesCount = this.fStructureAttributes.size();
        this.fListener = new PlanElementListener();
    }

    @Override
    public List<IViewEntry<?>> getElementsToExpandInitially() {
        return (List)this.fViewModel.readModel(new IViewModelReadFunction<List<IViewEntry<?>>, RuntimeException>(){

            public List<IViewEntry<?>> run(IViewModelReader reader) {
                IViewEntry rootEntry = reader.getRootEntry(IViewModel.Domain.Content);
                return rootEntry != null ? reader.getChildren(rootEntry) : Collections.EMPTY_LIST;
            }
        });
    }

    @Override
    public LocationMarker calculateLocationMarker(IViewEntry<?> entry) {
        if (EntryUtils.isType(entry, PlanItem.class) && ((PlanItem)entry.getElement()).isAuxiliaryPlanItem()) {
            return new OutplaceLocationMarker((PlanItem)entry.getElement());
        }
        return null;
    }

    protected ResolvedPlan getPlan() {
        return this.fPlan;
    }

    protected PlanViewModel getViewModel() {
        return this.fViewModel;
    }

    public void inputChanged(IViewModel model, Object newInput) {
        this.fViewModel = (PlanViewModel)model;
        if (this.fPlan != null) {
            this.fPlan.removeListener(this.fListener);
        }
        this.fPlan = (ResolvedPlan)newInput;
        this.fElementInfos.clear();
        if (this.fPlan != null) {
            this.fPlan.addListener(this.fListener);
        }
    }

    public void refreshModel(IViewModelUpdater updateAccessor) {
        this.onBeginRefresh();
        try {
            this.fElementInfos.clear();
            for (GroupElement[] defaultGroup : this.getDefaultGroups()) {
                Assert.isTrue((defaultGroup.length > 0 ? 1 : 0) != 0);
                Object[] path = new Object[defaultGroup.length - 1];
                System.arraycopy(defaultGroup, 0, path, 0, defaultGroup.length - 1);
                updateAccessor.addEntry(IViewModel.Domain.Content, path, (Object)defaultGroup[defaultGroup.length - 1]);
            }
            Collection<? extends PlanElement> allPlanElements = this.getAllPlanElements();
            for (PlanElement planElement : allPlanElements) {
                ElementInfo pathElementInfo = new ElementInfo(planElement);
                this.fElementInfos.put(planElement, pathElementInfo);
            }
            for (PlanElement planElement : allPlanElements) {
                if (!this.isElementInitiallyIncluded(planElement)) continue;
                ArrayList<ElementInfo> path = new ArrayList<ElementInfo>();
                PlanElement pathElement = planElement;
                while (pathElement != null && !(pathElement instanceof ResolvedPlan)) {
                    ElementInfo pathElementInfo = this.fElementInfos.get(pathElement);
                    Assert.isNotNull((Object)pathElementInfo);
                    path.add(pathElementInfo);
                    pathElement = pathElement.getParent();
                }
                this.doAddElement(path, updateAccessor);
            }
            updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                public void run() {
                    AbstractJavaPlanModelTransformer.this.fViewModel.expandEntries(AbstractJavaPlanModelTransformer.this.getElementsToExpandInitially());
                }
            });
        }
        finally {
            this.onEndRefresh();
        }
    }

    protected void onBeginRefresh() {
    }

    protected void onEndRefresh() {
    }

    protected Collection<? extends PlanElement> getAllPlanElements() {
        return this.getPlan().getAllPlanItems();
    }

    protected boolean isElementInitiallyIncluded(PlanElement element) {
        return this.isElementIncluded(element) && (!(element instanceof PlanItem) || ((PlanItem)element).isPrimaryPlanItem());
    }

    protected boolean isElementIncluded(PlanElement element) {
        return element instanceof PlanItem;
    }

    protected Collection<GroupElement[]> getDefaultGroups() {
        return Collections.EMPTY_LIST;
    }

    protected Collection<GroupElement[]> getGroups(List<ElementInfo> elementInfoPath) {
        return NO_GROUP;
    }

    protected List<PlanElement> doTransformElementPath(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        ArrayList<PlanElement> result = new ArrayList<PlanElement>(elementInfoPath.size() - 1);
        int i = elementInfoPath.size() - 1;
        while (i > 0) {
            result.add(elementInfoPath.get(i).getPlanElement());
            --i;
        }
        return result;
    }

    protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        return DEFAULT_TAGS;
    }

    private Object[] calculatePath(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        ArrayList<GroupElement> path = new ArrayList<GroupElement>(Arrays.asList(groupPath));
        path.addAll(this.doTransformElementPath(groupPath, elementInfoPath));
        return path.toArray();
    }

    protected void aboutToRefreshModel(IViewModelReader reader) {
    }

    protected void doElementAdded(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
    }

    protected void doElementRemoved(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
    }

    protected void doElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IViewModelUpdater updateAccessor) {
    }

    protected void doElementChanged(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
    }

    protected boolean doProcessPlanChanged(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        return true;
    }

    private boolean processElementAdded(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        this.doAddElement(this.getElementInfoPath(delta, true), updateAccessor);
        this.doElementAdded(delta, updateAccessor);
        return true;
    }

    private boolean processElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IViewModelUpdater updateAccessor) {
        Assert.isTrue((removeDelta.getOtherMoveDelta() == addDelta && addDelta.getOtherMoveDelta() == removeDelta ? 1 : 0) != 0);
        Assert.isTrue((removeDelta.getPlanElement() == addDelta.getPlanElement() ? 1 : 0) != 0);
        this.recomputeSubtree(removeDelta, addDelta, updateAccessor);
        this.doElementMoved(removeDelta, addDelta, updateAccessor);
        return true;
    }

    private boolean processElementRemoved(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        this.doRemoveElement(this.getElementInfoPath(delta, false), updateAccessor);
        this.doElementRemoved(delta, updateAccessor);
        return true;
    }

    private boolean processElementChanged(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
        boolean visitChildren = true;
        boolean needsUpdate = false;
        if (delta.isContentChange()) {
            IPlanAttributeDelta[] iPlanAttributeDeltaArray = delta.getAttributeDeltas();
            int n = iPlanAttributeDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
                if (this.fStructureAttributes.contains(attributeDelta.getAttribute())) {
                    if (this.getElementInfo(delta, false).equals(this.getElementInfo(delta, true))) break;
                    this.recomputeSubtree(delta, delta, updateAccessor);
                    visitChildren = false;
                    break;
                }
                ++n2;
            }
            needsUpdate = true;
        }
        if (delta.affectsAttribute(PlanElement.PLANCHECK_REPORT)) {
            needsUpdate = true;
        }
        this.doElementChanged(delta, updateAccessor);
        if (needsUpdate) {
            IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
            String[] attributes = new String[deltas.length];
            int i = 0;
            while (i < deltas.length) {
                attributes[i] = deltas[i].getAttribute().getId();
                ++i;
            }
            for (IViewEntry entry : updateAccessor.getElementEntries((Object)delta.getPlanElement())) {
                updateAccessor.update(entry, attributes);
            }
        }
        return visitChildren;
    }

    private void recomputeSubtree(IPlanElementDelta oldDelta, IPlanElementDelta newDelta, final IViewModelUpdater updateAccessor) {
        IViewModelNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement planElement = oldDelta.getPlanElement();
        IViewEntry sourceEntry = n.findPrimaryEntry((Object)planElement);
        Assert.isNotNull((Object)sourceEntry);
        ModelSnapshotNode structureSnapshot = new ModelSnapshotNode(sourceEntry, (IViewModelReader)updateAccessor);
        structureSnapshot.walkSnapshot(newDelta, true, new ISnapshotVisitor(){

            @Override
            public void visit(List<ElementInfo> elementInfoPath) {
                AbstractJavaPlanModelTransformer.this.doAddElement(elementInfoPath, updateAccessor);
            }
        });
        structureSnapshot.walkSnapshot(oldDelta, false, new ISnapshotVisitor(){

            @Override
            public void visit(List<ElementInfo> elementInfoPath) {
                AbstractJavaPlanModelTransformer.this.doRemoveElement(elementInfoPath, updateAccessor);
            }
        });
    }

    private IViewEntry<PlanElement> doAddElement(List<ElementInfo> elementInfoPath, IViewModelUpdater updateAccessor) {
        Assert.isLegal((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
        IViewModelNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        IViewEntry result = null;
        for (GroupElement[] groupPath : this.getGroups(elementInfoPath)) {
            IViewEntry candidateParent;
            boolean shouldExpandGroup = groupPath.length > 0 && !updateAccessor.containsElement((Object)groupPath[groupPath.length - 1]);
            IViewEntry newEntry = updateAccessor.addEntry(IViewModel.Domain.Content, this.calculatePath(groupPath, elementInfoPath), (Object)element);
            EntryTag[] entryTagArray = this.doCalculateTags(groupPath, elementInfoPath);
            int n2 = entryTagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EntryTag tag = entryTagArray[n3];
                updateAccessor.setTag(newEntry, (IViewEntryTag)tag);
                ++n3;
            }
            if (newEntry.hasTag((IViewEntryTag)PrimaryLocationTag.INSTANCE)) {
                result = newEntry;
            }
            if ((candidateParent = n.parentEntryOfType(newEntry, GroupElement.class)) != null && !candidateParent.isRootEntry()) {
                updateAccessor.update(candidateParent, null);
            }
            if (!shouldExpandGroup) continue;
            final IViewEntry toExpand = n.parentEntryOfType(newEntry, GroupElement.class);
            updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                public void run() {
                    AbstractJavaPlanModelTransformer.this.fViewModel.setEntryExpandState(toExpand, true);
                }
            });
        }
        return result;
    }

    private void doRemoveElement(List<ElementInfo> elementInfoPath, IViewModelUpdater updateAccessor) {
        Assert.isLegal((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
        IViewModelNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        block0: for (GroupElement[] groupPath : this.getGroups(elementInfoPath)) {
            Object[] path = this.calculatePath(groupPath, elementInfoPath);
            List candidateEntries = updateAccessor.getElementEntries((Object)element);
            for (IViewEntry candidateEntry : candidateEntries) {
                boolean pathEqual = true;
                IViewEntry chainEntry = n.parentEntry(candidateEntry);
                int level = path.length - 1;
                while (pathEqual && level >= 0 && chainEntry != null) {
                    pathEqual &= path[level--].equals(chainEntry.getElement());
                    chainEntry = n.parentEntry(chainEntry);
                }
                if (!pathEqual || level != -1 || !n.parentEntry(chainEntry).isRootEntry()) continue;
                IViewEntry candidateParent = n.parentEntryOfType(candidateEntry, GroupElement.class);
                if (candidateParent != null && !candidateParent.isRootEntry()) {
                    updateAccessor.update(candidateParent, null);
                }
                EntryTag[] entryTagArray = this.doCalculateTags(groupPath, elementInfoPath);
                int n2 = entryTagArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    EntryTag tag = entryTagArray[n3];
                    updateAccessor.clearTag(candidateEntry, (IViewEntryTag)tag);
                    ++n3;
                }
                updateAccessor.removeEntry(candidateEntry);
                continue block0;
            }
        }
    }

    protected DeltaKind computeDeltaKind(IPlanElementDelta delta, IViewModelReader readAccessor) {
        DeltaKind result = DeltaKind.Ignore;
        if (delta.isAdded()) {
            result = DeltaKind.Added;
        } else if (delta.isRemoved()) {
            result = DeltaKind.Removed;
        } else if (delta.isChanged()) {
            result = DeltaKind.Changed;
        }
        PlanElement element = delta.getPlanElement();
        boolean wasIncluded = !readAccessor.getElementEntries((Object)element).isEmpty();
        boolean isIncluded = this.isElementIncluded(element);
        if (result == DeltaKind.Added && !isIncluded) {
            result = DeltaKind.Ignore;
        } else if (result == DeltaKind.Removed && !wasIncluded) {
            result = DeltaKind.Ignore;
        } else if (result == DeltaKind.Changed) {
            IPlanAttributeDelta[] attributeDeltas = delta.getAttributeDeltas();
            boolean isPlanCheckerChangeOnly = attributeDeltas.length == 1 && PlanItem.PLANCHECK_REPORT.equals(attributeDeltas[0].getAttribute());
            if (wasIncluded != isIncluded && (isPlanCheckerChangeOnly &= !delta.isStructuralChange())) {
                result = DeltaKind.Ignore;
            } else if (wasIncluded && !isIncluded) {
                result = DeltaKind.Removed;
            } else if (!wasIncluded && isIncluded) {
                result = DeltaKind.Added;
            } else if (!wasIncluded && !isIncluded) {
                result = DeltaKind.Ignore;
            }
        }
        return result;
    }

    protected List<ElementInfo> getElementInfoPath(IPlanElementDelta delta, boolean newValues) {
        ArrayList<ElementInfo> result = new ArrayList<ElementInfo>();
        while (delta != null && !(delta.getPlanElement() instanceof ResolvedPlan)) {
            result.add(this.getElementInfo(delta, newValues));
            delta = delta.getParentDelta();
        }
        return result;
    }

    protected ElementInfo getElementInfo(IPlanElementDelta delta, boolean newValues) {
        PlanElement planElement = delta.getPlanElement();
        ElementInfo elementInfo = this.fElementInfos.get(planElement);
        if (elementInfo == null) {
            elementInfo = new ElementInfo(planElement);
        }
        return elementInfo.update(delta, newValues);
    }

    private boolean hasStructuralChange(IPlanElementDelta delta) {
        for (IPlanningAttributeIdentifier attribueId : this.fStructureAttributes) {
            if (delta.getAttributeDelta(attribueId) == null) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$2(AbstractJavaPlanModelTransformer abstractJavaPlanModelTransformer, IPlanElementDelta iPlanElementDelta, IViewModelUpdater iViewModelUpdater) {
        return abstractJavaPlanModelTransformer.processElementAdded(iPlanElementDelta, iViewModelUpdater);
    }

    static /* synthetic */ boolean access$3(AbstractJavaPlanModelTransformer abstractJavaPlanModelTransformer, IPlanElementDelta iPlanElementDelta, IPlanElementDelta iPlanElementDelta2, IViewModelUpdater iViewModelUpdater) {
        return abstractJavaPlanModelTransformer.processElementMoved(iPlanElementDelta, iPlanElementDelta2, iViewModelUpdater);
    }

    static /* synthetic */ boolean access$4(AbstractJavaPlanModelTransformer abstractJavaPlanModelTransformer, IPlanElementDelta iPlanElementDelta, IViewModelUpdater iViewModelUpdater) {
        return abstractJavaPlanModelTransformer.processElementRemoved(iPlanElementDelta, iViewModelUpdater);
    }

    static /* synthetic */ boolean access$5(AbstractJavaPlanModelTransformer abstractJavaPlanModelTransformer, IPlanElementDelta iPlanElementDelta, IViewModelUpdater iViewModelUpdater) {
        return abstractJavaPlanModelTransformer.processElementChanged(iPlanElementDelta, iViewModelUpdater);
    }

    protected static enum DeltaKind {
        Added,
        Removed,
        Changed,
        Ignore,
        Refresh;

    }

    protected class ElementInfo {
        private final PlanElement fPlanElement;
        private final Object[] fStructureValues;

        public ElementInfo(PlanElement planElement) {
            this.fPlanElement = planElement;
            this.fStructureValues = new Object[AbstractJavaPlanModelTransformer.this.fStructureAttributesCount];
            int i = 0;
            while (i < AbstractJavaPlanModelTransformer.this.fStructureAttributesCount) {
                this.fStructureValues[i] = planElement.getAttributeValue((IPlanningAttributeIdentifier)AbstractJavaPlanModelTransformer.this.fStructureAttributes.get(i));
                ++i;
            }
        }

        private ElementInfo(ElementInfo source, IPlanElementDelta delta, boolean newValue) {
            this.fPlanElement = source.fPlanElement;
            this.fStructureValues = new Object[AbstractJavaPlanModelTransformer.this.fStructureAttributesCount];
            System.arraycopy(source.fStructureValues, 0, this.fStructureValues, 0, AbstractJavaPlanModelTransformer.this.fStructureAttributesCount);
            int i = 0;
            while (i < AbstractJavaPlanModelTransformer.this.fStructureAttributesCount) {
                IPlanAttributeDelta attributeDelta = delta.getAttributeDelta((IPlanningAttributeIdentifier)AbstractJavaPlanModelTransformer.this.fStructureAttributes.get(i));
                if (attributeDelta != null) {
                    this.fStructureValues[i] = newValue ? attributeDelta.getNewValue() : attributeDelta.getOldValue();
                }
                ++i;
            }
        }

        public ElementInfo update(IPlanElementDelta delta, boolean newValue) {
            return new ElementInfo(this, delta, newValue);
        }

        public PlanElement getPlanElement() {
            return this.fPlanElement;
        }

        public Object[] getStructureValues() {
            return this.fStructureValues;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ElementInfo other = (ElementInfo)obj;
            return this.fPlanElement.equals(other.fPlanElement) && Arrays.equals(this.fStructureValues, other.fStructureValues);
        }
    }

    private static interface ISnapshotVisitor {
        public void visit(List<ElementInfo> var1);
    }

    private class ModelSnapshotNode {
        private final boolean fIsAddedExplicitly;
        private final ElementInfo fElementInfo;
        private final List<ModelSnapshotNode> fChildren;

        public ModelSnapshotNode(IViewEntry<?> entry, IViewModelReader readAccessor) {
            this.fIsAddedExplicitly = entry.isAddedExplicitly();
            this.fElementInfo = (ElementInfo)AbstractJavaPlanModelTransformer.this.fElementInfos.get(entry.getElement());
            IViewModelNavigator n = readAccessor.getEntryNavigator(false);
            this.fChildren = new ArrayList<ModelSnapshotNode>();
            for (IViewEntry childEntry : n.childEntries(entry)) {
                this.fChildren.add(new ModelSnapshotNode(childEntry, readAccessor));
            }
        }

        public void walkSnapshot(IPlanElementDelta delta, boolean newValues, ISnapshotVisitor visitor) {
            Assert.isTrue((boolean)this.fElementInfo.getPlanElement().equals(delta.getPlanElement()));
            this.accept(visitor, delta, newValues, new LinkedList<ElementInfo>(AbstractJavaPlanModelTransformer.this.getElementInfoPath(delta, newValues)));
        }

        private void accept(ISnapshotVisitor visitor, IPlanElementDelta delta, boolean newValues, LinkedList<ElementInfo> elementInfoPath) {
            if (this.fIsAddedExplicitly) {
                visitor.visit(elementInfoPath);
            }
            for (ModelSnapshotNode childNode : this.fChildren) {
                PlanElementDelta childDelta;
                PlanElementDelta planElementDelta = childDelta = delta != null ? delta.getChild(childNode.fElementInfo.getPlanElement()) : null;
                if (childDelta != null && AbstractJavaPlanModelTransformer.this.hasStructuralChange((IPlanElementDelta)childDelta)) {
                    elementInfoPath.addFirst(AbstractJavaPlanModelTransformer.this.getElementInfo((IPlanElementDelta)childDelta, newValues));
                } else {
                    elementInfoPath.addFirst(childNode.fElementInfo);
                }
                childNode.accept(visitor, (IPlanElementDelta)childDelta, newValues, elementInfoPath);
                elementInfoPath.removeFirst();
            }
        }
    }

    private class PlanElementListener
    implements IPlanElementListener {
        private PlanElementListener() {
        }

        public void planElementChanged(final IPlanElementChangeEvent event) {
            AbstractJavaPlanModelTransformer.this.fViewModel.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){
                boolean refreshModel = false;

                public Void run(final IViewModelUpdater updateAccessor) {
                    event.getDelta().accept(new IPlanElementDeltaVisitor(){
                        private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind;

                        /*
                         * Unable to fully structure code
                         */
                        public boolean visit(IPlanElementDelta delta) {
                            block21: {
                                block22: {
                                    block23: {
                                        if (refreshModel) {
                                            return false;
                                        }
                                        visitChildren = true;
                                        try {
                                            if (!(delta.getPlanElement() instanceof ResolvedPlan) || !delta.isChanged()) break block21;
                                            var5_3 = PlanElementListener.access$1(1.access$1(this)).doProcessPlanChanged(delta, updateAccessor);
                                            if (refreshModel) break block22;
                                            if (!visitChildren) break block23;
                                        }
                                        catch (Throwable var4_8) {
                                            if (!refreshModel) {
                                                if (visitChildren) {
                                                    planElement = delta.getPlanElement();
                                                    if (!(planElement instanceof ResolvedPlan)) {
                                                        AbstractJavaPlanModelTransformer.access$1(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                                    }
                                                } else {
                                                    delta.accept(new IPlanElementDeltaVisitor(){

                                                        public boolean visit(IPlanElementDelta delta) {
                                                            AbstractJavaPlanModelTransformer.this.fElementInfos.put(delta.getPlanElement(), AbstractJavaPlanModelTransformer.this.getElementInfo(delta, true));
                                                            return true;
                                                        }
                                                    });
                                                }
                                            }
                                            throw var4_8;
                                        }
                                        planElement = delta.getPlanElement();
                                        if (!(planElement instanceof ResolvedPlan)) {
                                            AbstractJavaPlanModelTransformer.access$1(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                        }
                                        break block22;
                                    }
                                    delta.accept(new /* invalid duplicate definition of identical inner class */);
                                }
                                return var5_3;
                            }
                            otherMoveDelta = delta.getOtherMoveDelta();
                            switch (PlanElementListener.1.$SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind()[PlanElementListener.access$1(1.access$1(this)).computeDeltaKind(delta, (IViewModelReader)updateAccessor).ordinal()]) {
                                case 1: {
                                    if (otherMoveDelta == null) {
                                        visitChildren = AbstractJavaPlanModelTransformer.access$2(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                        ** break;
                                    }
                                    visitChildren = AbstractJavaPlanModelTransformer.access$3(PlanElementListener.access$1(1.access$1(this)), otherMoveDelta, delta, updateAccessor);
                                    ** break;
                                }
                                case 2: {
                                    if (otherMoveDelta == null) {
                                        visitChildren = AbstractJavaPlanModelTransformer.access$4(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                        ** break;
                                    }
                                    break;
                                }
                                case 3: {
                                    visitChildren = AbstractJavaPlanModelTransformer.access$5(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                    ** break;
                                }
                                case 5: {
                                    refreshModel = true;
                                    visitChildren = false;
                                }
                            }
                            if (!refreshModel) {
                                if (visitChildren) {
                                    planElement = delta.getPlanElement();
                                    if (!(planElement instanceof ResolvedPlan)) {
                                        AbstractJavaPlanModelTransformer.access$1(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                    }
                                } else {
                                    delta.accept(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            return visitChildren;
                        }

                        static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind() {
                            if ($SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind != null) {
                                return $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind;
                            }
                            int[] nArray = new int[DeltaKind.values().length];
                            try {
                                nArray[DeltaKind.Added.ordinal()] = 1;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Changed.ordinal()] = 3;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Ignore.ordinal()] = 4;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Refresh.ordinal()] = 5;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Removed.ordinal()] = 2;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$AbstractJavaPlanModelTransformer$DeltaKind = nArray;
                            return nArray;
                        }
                    });
                    if (this.refreshModel) {
                        AbstractJavaPlanModelTransformer.this.aboutToRefreshModel((IViewModelReader)updateAccessor);
                        AbstractJavaPlanModelTransformer.this.fViewModel.viewerPreservingRefresh();
                    }
                    return null;
                }
            });
        }
    }
}

