/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ContentProposalRecentQuery;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposal;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposalProvider;
import com.ibm.team.apt.internal.ide.ui.quickquery.IQuickQueryExpression;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class QuickQueryTextField {
    private static final long DEFAULT_EXECUTION_DELAY = 0L;
    private Text fQuickQueryInput;
    private ControlDecoration fContentProposalDecoration;
    private ListenerList fQuickQueryListeners = new ListenerList();
    private final QuickQueryEvaluationJob fFilterJob = new QuickQueryEvaluationJob();
    private volatile long fLastModification;
    private IQuickQueryExpression fLastExpression;
    private IQuickQueryExpression fCurrentExpression;
    private long fExecutionDelay = 0L;
    private QuickQueryParser fQuickQueryParser;
    private ContentAssistAction fContentAssistAction = new ContentAssistAction();
    private MyContentProposalAdapter fContentProposalAdapter;
    private boolean fIsOpen;

    public QuickQueryTextField(Composite parent) {
        Text textControl = new Text(parent, 2432);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)textControl);
        this.setupContentAssist(textControl);
    }

    public QuickQueryTextField(Text textControl) {
        this.setupContentAssist(textControl);
    }

    public Action getAction(String id) {
        if ("org.eclipse.ui.edit.text.contentAssist.proposals".equals(id)) {
            return this.fContentAssistAction;
        }
        return null;
    }

    public void setQuickQueryParser(QuickQueryParser quickQueryParser) {
        this.fQuickQueryParser = quickQueryParser;
        this.fContentProposalAdapter.setContentProposalProvider(quickQueryParser != null ? new QuickQueryProposalProvider(quickQueryParser) : null);
    }

    public void setExecutionDelay(long delay) {
        this.fExecutionDelay = delay;
    }

    public void setText(String queryText) {
        this.fQuickQueryInput.setText(queryText != null ? queryText : "");
    }

    public void addListener(IQuickQueryListener listener) {
        this.fQuickQueryListeners.add((Object)listener);
    }

    public void removeListener(IQuickQueryListener listener) {
        this.fQuickQueryListeners.remove((Object)listener);
    }

    public Text getControl() {
        return this.fQuickQueryInput;
    }

    public boolean isDisposed() {
        if (this.fQuickQueryInput == null) {
            return true;
        }
        return this.fQuickQueryInput.isDisposed();
    }

    public IQuickQueryExpression getFilterExpression() {
        this.fCurrentExpression = null;
        if (!this.fQuickQueryInput.isDisposed()) {
            this.fQuickQueryInput.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!QuickQueryTextField.this.fQuickQueryInput.isDisposed()) {
                        QuickQueryTextField.this.fCurrentExpression = QuickQueryTextField.this.fQuickQueryParser.getExpression(QuickQueryTextField.this.fQuickQueryInput.getText());
                    }
                }
            });
        }
        return this.fCurrentExpression;
    }

    public IQuickQueryExpression getCurrentExpression() {
        return this.fCurrentExpression;
    }

    public boolean hasProposalPopupFocus() {
        return this.fIsOpen;
    }

    private void setupContentAssist(Text textControl) {
        this.fQuickQueryInput = textControl;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        this.fQuickQueryInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuickQueryTextField.this.modifiedText();
            }
        });
        this.fContentProposalDecoration = new ControlDecoration((Control)this.fQuickQueryInput, 16512);
        this.fContentProposalDecoration.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    QuickQueryTextField.this.fContentProposalDecoration.show();
                }
                if (event.type == 27) {
                    QuickQueryTextField.this.fContentProposalDecoration.hide();
                }
            }
        };
        this.fQuickQueryInput.addListener(26, listener);
        this.fQuickQueryInput.addListener(27, listener);
        this.fContentProposalDecoration.setDescriptionText(NLS.bind((String)Messages.QuickQueryTextField_CONTENT_ASSIST_AVAILABLE, (Object)keyStroke.format(), (Object[])new Object[0]));
        this.fContentProposalDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        this.fContentProposalAdapter = new MyContentProposalAdapter((Control)this.fQuickQueryInput, (IControlContentAdapter)new TextContentAdapter(), null, keyStroke, null);
        this.fContentProposalAdapter.setProposalAcceptanceStyle(3);
        this.fContentProposalAdapter.setPropagateKeys(true);
        this.fContentProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                String newContent = QuickQueryTextField.this.fQuickQueryInput.getText();
                int cursorPosition = QuickQueryTextField.this.fQuickQueryInput.getCaretPosition();
                if (proposal instanceof QuickQueryProposal) {
                    QuickQueryProposal attributeProposal = (QuickQueryProposal)proposal;
                    String currentContent = newContent;
                    StringBuilder result = new StringBuilder();
                    if (attributeProposal.getStart() > currentContent.length()) {
                        result.append(currentContent).append(' ');
                    } else {
                        result.append(currentContent.substring(0, attributeProposal.getStart()));
                    }
                    cursorPosition = proposal.getCursorPosition() + result.length();
                    result.append(proposal.getContent());
                    if (currentContent.length() > attributeProposal.getEnd()) {
                        result.append(currentContent.substring(attributeProposal.getEnd()));
                    }
                    newContent = result.toString();
                }
                QuickQueryTextField.this.fQuickQueryInput.setText(newContent);
                QuickQueryTextField.this.fQuickQueryInput.setSelection(cursorPosition);
            }
        });
        this.fContentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                QuickQueryTextField.this.proposalPopupOpened();
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                QuickQueryTextField.this.proposalPopupClosed();
            }
        });
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fQuickQueryInput);
        this.fContentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider((ResourceManager)resourceManager){
            private final /* synthetic */ ResourceManager val$resourceManager;
            {
                this.val$resourceManager = resourceManager;
            }

            public String getText(Object element) {
                return ((IContentProposal)element).getLabel();
            }

            public Image getImage(Object element) {
                if (element instanceof QuickQueryProposal) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)((QuickQueryProposal)element).getIcon());
                }
                if (element instanceof ContentProposalRecentQuery) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)ImagePool.REFRESH);
                }
                return super.getImage(element);
            }
        });
    }

    private void modifiedText() {
        this.fLastModification = System.currentTimeMillis();
        this.fFilterJob.schedule(this.fExecutionDelay);
    }

    private void proposalPopupOpened() {
        this.fIsOpen = true;
        this.fLastModification = -1L;
        this.fFilterJob.cancel();
    }

    private void proposalPopupClosed() {
        this.fIsOpen = false;
        this.fLastModification = System.currentTimeMillis();
        this.fFilterJob.schedule(this.fExecutionDelay);
    }

    private class ContentAssistAction
    extends Action {
        private ContentAssistAction() {
        }

        public void run() {
            QuickQueryTextField.this.fContentProposalAdapter.openProposalPopup();
        }
    }

    private class MyContentProposalAdapter
    extends ContentProposalAdapter {
        public MyContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        public void openProposalPopup() {
            super.openProposalPopup();
        }
    }

    private class QuickQueryEvaluationJob
    extends Job {
        public QuickQueryEvaluationJob() {
            super(Messages.QuickQueryTextField_JOB_FILTERING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            long lastModification = QuickQueryTextField.this.fLastModification;
            if (lastModification != -1L) {
                long modificationDelta = System.currentTimeMillis() - lastModification;
                if (modificationDelta >= QuickQueryTextField.this.fExecutionDelay) {
                    QuickQueryEvaluationJob quickQueryEvaluationJob = this;
                    synchronized (quickQueryEvaluationJob) {
                        final IQuickQueryExpression filterExpression = QuickQueryTextField.this.getFilterExpression();
                        if (!(monitor.isCanceled() || QuickQueryTextField.this.fLastExpression != null && QuickQueryTextField.this.fLastExpression.equals(filterExpression))) {
                            QuickQueryTextField.this.fQuickQueryListeners.getListeners();
                            Object[] objectArray = QuickQueryTextField.this.fQuickQueryListeners.getListeners();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                final Object listener = objectArray[n2];
                                if (monitor.isCanceled()) break;
                                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                    public void run() throws Exception {
                                        ((IQuickQueryListener)listener).evaluateQuery(filterExpression);
                                    }
                                });
                                ++n2;
                            }
                            QuickQueryTextField.this.fLastExpression = filterExpression;
                        }
                    }
                    QuickQueryTextField.this.fLastModification = System.currentTimeMillis();
                } else {
                    this.schedule(QuickQueryTextField.this.fExecutionDelay - modificationDelta);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

