/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.common.quickquery.ContentProposalRecentQuery;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ProposalMatcher;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposal;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.ui.IMemento;

public class QuickQueryProposalProvider
implements IContentProposalProvider {
    private static final int MAX_RECENT_QUERIES = 50;
    private final ProposalComparator fProposalComparator = new ProposalComparator();
    private final List<String> fRecentQueries = new LinkedList<String>();
    private final QuickQueryParser fQuickQueryParser;

    public QuickQueryProposalProvider(QuickQueryParser quickQueryParser) {
        this.fQuickQueryParser = quickQueryParser;
    }

    public void addRecentQuery(String query) {
        if (!this.fRecentQueries.remove(query) && this.fRecentQueries.size() > 50) {
            this.fRecentQueries.remove(50);
        }
        this.fRecentQueries.add(0, query);
    }

    public void loadState(IMemento state) {
    }

    public void saveState(IMemento state) {
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        ProposalMatcher queryMatcher = new ProposalMatcher(contents.substring(0, position));
        for (String recentQuery : this.fRecentQueries) {
            if (!queryMatcher.matches(recentQuery)) continue;
            proposals.add(new ContentProposalRecentQuery(recentQuery));
        }
        IContentProposal[] quickQueryProposals = this.fQuickQueryParser.getContentProposals(contents, position);
        if (quickQueryProposals != null) {
            IContentProposal[] iContentProposalArray = quickQueryProposals;
            int n = quickQueryProposals.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProposal proposal = iContentProposalArray[n2];
                proposals.add(proposal);
                ++n2;
            }
        }
        IContentProposal[] elements = proposals.toArray(new IContentProposal[proposals.size()]);
        Arrays.sort(elements, this.fProposalComparator);
        return elements;
    }

    private static class ProposalComparator
    implements Comparator<IContentProposal> {
        private final int CATEGORY_RECENT_USED = 0;
        private final int CATEGORY_FILTER_OPERATION = 1;
        private final int CATEGORY_OTHER = Integer.MAX_VALUE;

        private ProposalComparator() {
        }

        private int category(IContentProposal proposal) {
            if (proposal instanceof ContentProposalRecentQuery) {
                return 0;
            }
            if (proposal instanceof QuickQueryProposal) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(IContentProposal p1, IContentProposal p2) {
            int c2;
            int c1 = this.category(p1);
            if (c1 != (c2 = this.category(p2))) {
                return c1 - c2;
            }
            return CollatorCache.getInstance().compare(p1.getLabel(), p2.getLabel());
        }
    }
}

