/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.common.util.AttributeDefinitionUtil;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.ImageDescriptor;

public class QuickQueryProposal
implements IContentProposal {
    private final IPlanningAttribute fAttribute;
    private final String fOperator;
    private final String fParameter;
    private final int fStart;
    private final int fEnd;
    private final boolean fAttributeMatched;

    public QuickQueryProposal(IPlanningAttribute attribute, String operator, int start, int end) {
        this(attribute, operator, null, start, end, false);
    }

    public QuickQueryProposal(IPlanningAttribute attribute, String operator, String parameter, int start, int end, boolean attributeMatched) {
        this.fAttribute = attribute;
        this.fOperator = operator;
        this.fParameter = parameter;
        this.fStart = start;
        this.fEnd = end;
        this.fAttributeMatched = attributeMatched;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public ImageDescriptor getIcon() {
        return this.fParameter == null ? ImagePool.QUICKFILTER_ATTRIBUTE : ImagePool.QUICKFILTER_PARAMETER;
    }

    public int compareTo(QuickQueryProposal other) {
        if (!this.fAttribute.equals(other.fAttribute)) {
            return CollatorCache.getInstance().compare(this.getDisplayName(this.fAttribute), this.getDisplayName(other.fAttribute));
        }
        return (this.fParameter == null ? 0 : 1) - (other.fParameter == null ? 0 : 1);
    }

    public String getContent() {
        if (this.fOperator == null & this.fParameter != null) {
            return this.escape(this.fParameter);
        }
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(this.getDisplayName(this.fAttribute));
        contentBuilder.append(this.fOperator);
        if (this.fParameter != null) {
            contentBuilder.append(this.escape(this.fParameter));
        }
        return contentBuilder.toString();
    }

    public String getLabel() {
        if (!this.fAttributeMatched && this.fParameter == null) {
            return this.getDisplayName(this.fAttribute);
        }
        if (this.fAttributeMatched && this.fParameter != null) {
            return this.fParameter;
        }
        return NLS.bind((String)Messages.QuickQueryProposal_KEYWORD_PARAMETER, (Object)this.getDisplayName(this.fAttribute), (Object[])new Object[]{this.fParameter});
    }

    public String getDescription() {
        return null;
    }

    public int getCursorPosition() {
        if (this.fOperator == null & this.fParameter != null) {
            return this.escape(this.fParameter).length();
        }
        int length = this.getDisplayName(this.fAttribute).length();
        length += this.fOperator.length();
        if (this.fParameter != null) {
            length += this.escape(this.fParameter).length();
        }
        return length;
    }

    private String escape(String value) {
        boolean needsEscape = false;
        int i = 0;
        while (i < value.length()) {
            if (Character.isWhitespace(value.charAt(i))) {
                needsEscape = true;
                break;
            }
            ++i;
        }
        if (!needsEscape) {
            return value;
        }
        return NLS.bind((String)"\"{0}\"", (Object)value.replace("\"", "\\\""), (Object[])new Object[0]);
    }

    private String getDisplayName(IPlanningAttribute attribute) {
        if (attribute.getAttributeType() == PlanningAttributeType.REFERENCE) {
            return AttributeDefinitionUtil.toCamelCase((String)this.fAttribute.getDisplayName());
        }
        return this.fAttribute.getQueryId();
    }
}

