/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class QuickQueryModeSelectionAction
extends Action
implements IMenuCreator {
    private ResourceManager fResourceManager;
    private Menu fMenu;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            if (item.getSelection()) {
                QuickQueryModeSelectionAction.this.setCurrentMode((QuickQueryMode)((Object)item.getData()));
            }
        }
    };

    public QuickQueryModeSelectionAction() {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    protected abstract Collection<QuickQueryMode> getAvailableModes();

    protected abstract QuickQueryMode getCurrentMode();

    protected abstract void setCurrentMode(QuickQueryMode var1);

    public ImageDescriptor getImageDescriptor() {
        QuickQueryMode currentMode = this.getCurrentMode();
        return currentMode != null ? currentMode.getImage() : ImagePool.QUICKFILTER_FIND;
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public int getStyle() {
        return 4;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    protected void fillMenu(Menu menu) {
        for (QuickQueryMode mode : this.getAvailableModes()) {
            MenuItem item = new MenuItem(menu, 16);
            item.setData((Object)mode);
            item.setSelection(mode == this.getCurrentMode());
            item.addSelectionListener(this.fSelectionListener);
            item.setText(mode.getLabel());
            item.setImage(this.fResourceManager.createImageWithDefault(mode.getImage()));
        }
    }
}

