/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractQuickQueryParticipant;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class QuickQueryEntryFinder
extends AbstractQuickQueryParticipant
implements IQuickQueryEntryFinder {
    public QuickQueryEntryFinder(PlanViewModel viewModel) {
        super(QuickQueryMode.Find, viewModel);
    }

    @Override
    public boolean find(boolean searchAll) {
        if (this.isInstalled()) {
            boolean result = this.fViewModel.readModel(new IViewModelReadFunction<Boolean, RuntimeException>(){

                public Boolean run(IViewModelReader readAccessor) throws RuntimeException {
                    List<IViewEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    IViewEntry<PlanItem> entry = EntryUtils.firstEntryOfType(selectedEntries, PlanItem.class);
                    if (entry != null && QuickQueryEntryFinder.this.fExpression.evaluate((PlanItem)entry.getElement())) {
                        QuickQueryEntryFinder.this.selectEntry((IViewEntry<PlanItem>)entry);
                        return true;
                    }
                    return false;
                }
            });
            return result || this.findNext(searchAll);
        }
        return false;
    }

    @Override
    public boolean findNext(final boolean searchAll) {
        if (this.isInstalled()) {
            return this.fViewModel.readModel(new IViewModelReadFunction<Boolean, RuntimeException>(){

                public Boolean run(IViewModelReader readAccessor) throws RuntimeException {
                    IViewEntry<PlanItem> candidate;
                    List<IViewEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    EntryTreeWalker<PlanItem> walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                    walker.setCurrentEntry(EntryUtils.firstEntryOfType(selectedEntries, PlanItem.class));
                    boolean canReset = searchAll;
                    do {
                        if ((candidate = walker.getNext()) == null && canReset) {
                            walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                            candidate = walker.getNext();
                            canReset = false;
                            QuickQueryEntryFinder.this.beep();
                        }
                        if (candidate != null) continue;
                        return false;
                    } while (!QuickQueryEntryFinder.this.fExpression.evaluate((PlanItem)candidate.getElement()));
                    QuickQueryEntryFinder.this.selectEntry((IViewEntry<PlanItem>)candidate);
                    return true;
                }
            });
        }
        return false;
    }

    @Override
    public boolean findPrevious(final boolean searchAll) {
        if (this.isInstalled()) {
            return this.fViewModel.readModel(new IViewModelReadFunction<Boolean, RuntimeException>(){

                public Boolean run(IViewModelReader readAccessor) throws RuntimeException {
                    IViewEntry<PlanItem> candidate;
                    EntryTreeWalker<PlanItem> walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                    List<IViewEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    walker.setCurrentEntry(EntryUtils.lastEntryOfType(selectedEntries, PlanItem.class));
                    boolean canReset = searchAll;
                    do {
                        if ((candidate = walker.getPrevious()) == null && canReset) {
                            walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                            candidate = walker.getPrevious();
                            canReset = false;
                            QuickQueryEntryFinder.this.beep();
                        }
                        if (candidate != null) continue;
                        return false;
                    } while (!QuickQueryEntryFinder.this.fExpression.evaluate((PlanItem)candidate.getElement()));
                    QuickQueryEntryFinder.this.selectEntry((IViewEntry<PlanItem>)candidate);
                    return true;
                }
            });
        }
        return false;
    }

    @Override
    protected void doUnInstall() {
        boolean shouldBeInstalled;
        boolean bl = shouldBeInstalled = this.fExpression != null && this.fEnabled;
        if (this.fIsInstalled ^ shouldBeInstalled) {
            this.fIsInstalled = shouldBeInstalled;
        }
    }

    private void beep() {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.beep();
            }
        });
    }

    private void selectEntry(IViewEntry<PlanItem> entry) {
        this.fViewModel.setSelectedEntry(entry);
        this.fViewModel.revealEntry(entry);
    }

    private class EntryTreeWalker<T> {
        private final IViewModelReader fReadAccessor;
        private final Class<T> fType;
        private IViewEntry<T> fCurrentEntry;

        public EntryTreeWalker(IViewModelReader readAccessor, Class<T> type) {
            this.fReadAccessor = readAccessor;
            this.fType = type;
        }

        public void setCurrentEntry(IViewEntry<T> currentEntry) {
            this.fCurrentEntry = currentEntry;
        }

        public IViewEntry<T> getNext() {
            if (this.fCurrentEntry == null) {
                this.fCurrentEntry = this.getNextEntry(this.fReadAccessor.getRootEntry(IViewModel.Domain.Content), false);
                return this.fCurrentEntry;
            }
            this.fCurrentEntry = this.getNextEntry(this.fCurrentEntry, true);
            return this.fCurrentEntry;
        }

        public IViewEntry<T> getPrevious() {
            if (this.fCurrentEntry == null) {
                this.fCurrentEntry = this.getPreviousEntry(this.fReadAccessor.getRootEntry(IViewModel.Domain.Content), false);
                return this.fCurrentEntry;
            }
            this.fCurrentEntry = this.getPreviousEntry(this.fCurrentEntry, true);
            return this.fCurrentEntry;
        }

        private IViewEntry<T> getNextEntry(IViewEntry<?> currentEntry, boolean skip) {
            IViewEntry<T> candidate;
            IViewModelNavigator n = this.fReadAccessor.getEntryNavigator(true);
            if (!skip && EntryUtils.isType(currentEntry, this.fType)) {
                return currentEntry;
            }
            Iterator childIterator = n.childEntries(currentEntry).iterator();
            if (childIterator.hasNext() && (candidate = this.getNextEntry((IViewEntry)childIterator.next(), false)) != null) {
                return candidate;
            }
            do {
                if ((candidate = n.successorEntry(currentEntry)) == null) continue;
                return this.getNextEntry(candidate, false);
            } while ((currentEntry = n.parentEntry(currentEntry)) != null);
            return null;
        }

        private IViewEntry<T> getPreviousEntry(IViewEntry<?> currentEntry, boolean skip) {
            IViewEntry<T> candidate;
            IViewModelNavigator n = this.fReadAccessor.getEntryNavigator(true);
            List childEntries = n.childEntries(currentEntry);
            if (childEntries.size() > 0 && (candidate = this.getPreviousEntry((IViewEntry)childEntries.get(childEntries.size() - 1), false)) != null) {
                return candidate;
            }
            if (!skip && EntryUtils.isType(currentEntry, this.fType)) {
                return currentEntry;
            }
            do {
                if ((candidate = n.predecessorEntry(currentEntry)) == null) continue;
                return this.getPreviousEntry(candidate, false);
            } while ((currentEntry = n.parentEntry(currentEntry)) != null);
            return null;
        }
    }
}

