/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractQuickQueryParticipant;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;

public class QuickQueryColorizer
extends AbstractQuickQueryParticipant {
    private final ColorizeRunnable fColorizer = new ColorizeRunnable();
    private IViewModel.IPostUpdateRunnerHandle fColorizerHandle;
    private AtomicInteger fUpdatesSuppressed = new AtomicInteger();
    private int fPriority;
    private RGB fColor;
    private String fLabel;
    private ColorizeTag fTag;
    private boolean fNeedsRefresh;

    public QuickQueryColorizer(PlanViewModel viewModel) {
        super(QuickQueryMode.Colorize, viewModel);
    }

    public void allowUpdates(boolean allow) {
        if (allow) {
            if (this.fUpdatesSuppressed.decrementAndGet() == 0) {
                this.doUnInstall();
            }
        } else {
            this.fUpdatesSuppressed.incrementAndGet();
        }
    }

    public void setPriority(int priority) {
        if (this.fPriority != priority) {
            this.fPriority = priority;
            this.doUnInstall();
        }
    }

    public void setLabel(String label) {
        if (this.fLabel == null && label != null || !this.fLabel.equals(label)) {
            this.fLabel = label;
            this.doUnInstall();
        }
    }

    public void setColor(RGB color) {
        if (this.fColor == null && color != null || !this.fColor.equals((Object)color)) {
            this.fColor = color;
            this.doUnInstall();
        }
    }

    @Override
    protected void doUnInstall() {
        if (this.fUpdatesSuppressed.get() == 0) {
            this.fViewModel.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

                public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                    boolean shouldBeInstalled = QuickQueryColorizer.this.fExpression != null && QuickQueryColorizer.this.fColor != null && QuickQueryColorizer.this.fEnabled;
                    QuickQueryColorizer.this.fNeedsRefresh = true;
                    if (QuickQueryColorizer.this.fIsInstalled ^ shouldBeInstalled) {
                        if (shouldBeInstalled) {
                            Assert.isTrue((QuickQueryColorizer.this.fColorizerHandle == null ? 1 : 0) != 0);
                            QuickQueryColorizer.this.fColorizerHandle = QuickQueryColorizer.this.fViewModel.addPostUpdateRunnable(QuickQueryColorizer.this.fColorizer, true);
                            QuickQueryColorizer.this.fIsInstalled = true;
                        } else {
                            Assert.isNotNull((Object)QuickQueryColorizer.this.fColorizerHandle);
                            updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                                public void run() {
                                    (this).QuickQueryColorizer.this.fViewModel.removePostUpdateRunnable(QuickQueryColorizer.this.fColorizerHandle);
                                    QuickQueryColorizer.this.fColorizerHandle = null;
                                }
                            });
                            QuickQueryColorizer.this.fIsInstalled = false;
                        }
                    }
                    if (QuickQueryColorizer.this.fColor != null) {
                        QuickQueryColorizer.this.fTag = new ColorizeTag(QuickQueryColorizer.this, QuickQueryColorizer.this.fColor, QuickQueryColorizer.this.fPriority);
                    }
                    return null;
                }
            });
        }
    }

    private class ColorizeRunnable
    implements IViewModelUpdateFunction<Void, RuntimeException> {
        private ColorizeRunnable() {
        }

        public Void run(final IViewModelUpdater updateAccessor) throws RuntimeException {
            updateAccessor.accept(new IViewEntryVisitor(){

                public boolean visit(IViewEntry<?> entry) {
                    Object element = entry.getElement();
                    if (element instanceof PlanItem) {
                        boolean needsResort = false;
                        if (((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fIsInstalled) {
                            if (QuickQueryColorizer.this.fNeedsRefresh || updateAccessor.isModified(entry)) {
                                updateAccessor.clearTag(entry, (IViewEntryTag)QuickQueryColorizer.this.fTag);
                                if (((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fExpression != null && ((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fExpression.evaluate((PlanItem)element)) {
                                    updateAccessor.setTag(entry, (IViewEntryTag)QuickQueryColorizer.this.fTag);
                                }
                                needsResort = true;
                            }
                        } else {
                            updateAccessor.clearTag(entry, (IViewEntryTag)QuickQueryColorizer.this.fTag);
                            needsResort = true;
                        }
                        if (needsResort) {
                            IViewEntry toSort = updateAccessor.getParent(entry);
                            updateAccessor.requestChildrenSort(toSort, false);
                        }
                    }
                    return true;
                }
            }, null);
            QuickQueryColorizer.this.fNeedsRefresh = false;
            return null;
        }
    }
}

