/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfiguration;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfigurationControl;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class ColorizeDialog
extends StatusDialog {
    private ColorizeConfigurationControl fConfigControl;

    public ColorizeDialog(Shell parent, QuickQueryParser quickQueryParser, ResolvedPlan planContext, List<ColorizeConfiguration> configurations) {
        super(parent);
        ArrayList<IColorizeDescription> configCopy = new ArrayList<IColorizeDescription>(configurations.size());
        for (ColorizeConfiguration configuration : configurations) {
            configCopy.add(this.copyConfig(configuration));
        }
        this.fConfigControl = new DialogColorizeConfigurationControl(quickQueryParser, configCopy);
        this.setTitle(Messages.ColorizeDialog_TITLE);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public List<ColorizeConfiguration> getConfigurations() {
        return this.copyConfigurations(this.fConfigControl.getConfigurations());
    }

    public Collection<ColorizeConfiguration> getAddedConfigs() {
        return this.copyConfigurations(this.fConfigControl.getAddedConfigs());
    }

    public Collection<ColorizeConfiguration> getContentChangedConfigs() {
        return this.copyConfigurations(this.fConfigControl.getContentChangedConfigs());
    }

    public Collection<ColorizeConfiguration> getEnablementChangedConfigs() {
        return this.copyConfigurations(this.fConfigControl.getEnablementChangedConfigs());
    }

    public Collection<ColorizeConfiguration> getRemovedConfigs() {
        return this.copyConfigurations(this.fConfigControl.getRemovedConfigs());
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int width = Math.max(600, result.x);
        int height = Math.max((int)((double)width / 3.0) * 2, result.y);
        result.x = width;
        result.y = height;
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UI.hookHelpListener((Control)shell, "com.ibm.team.apt.ide.ui.dialog_colorize");
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        this.fConfigControl.createControls(result);
        Dialog.applyDialogFont((Control)result);
        this.checkStatus();
        return result;
    }

    public boolean close() {
        boolean result = super.close();
        this.fConfigControl.dispose();
        return result;
    }

    protected abstract ColorizeConfiguration createConfig();

    protected abstract ColorizeConfiguration copyConfig(ColorizeConfiguration var1);

    private List<ColorizeConfiguration> copyConfigurations(Collection<IColorizeDescription> configurations) {
        ArrayList<ColorizeConfiguration> result = new ArrayList<ColorizeConfiguration>();
        for (IColorizeDescription colorizeDescription : configurations) {
            result.add((ColorizeConfiguration)colorizeDescription);
        }
        return result;
    }

    private void checkStatus() {
        this.updateStatus(this.fConfigControl.getStatus());
    }

    private class DialogColorizeConfigurationControl
    extends ColorizeConfigurationControl {
        public DialogColorizeConfigurationControl(QuickQueryParser quickQueryParser, List<IColorizeDescription> configurations) {
            super(quickQueryParser, configurations);
        }

        @Override
        protected ColorizeConfiguration createConfig() {
            return ColorizeDialog.this.createConfig();
        }

        @Override
        protected void added(IColorizeDescription configuration) {
            super.added(configuration);
            ColorizeDialog.this.checkStatus();
        }

        @Override
        protected void contentChanged(IColorizeDescription configuration) {
            super.contentChanged(configuration);
            ColorizeDialog.this.checkStatus();
        }

        @Override
        protected void removed(IColorizeDescription configuration) {
            super.removed(configuration);
            ColorizeDialog.this.checkStatus();
        }

        @Override
        protected void updateActions(IStructuredSelection selection) {
            super.updateActions(selection);
            ColorizeDialog.this.checkStatus();
        }
    }
}

