/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorSelectionImageDescriptor;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorUtil;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryTextField;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class ColorizeConfigurationControl {
    private static ColorDefinition[] DEFAULT_COLORS = new ColorDefinition[]{new ColorDefinition(new RGB(141, 198, 63), Messages.AbstractSelectQuickColorizeColorAction_GREEN), new ColorDefinition(new RGB(247, 148, 29), Messages.AbstractSelectQuickColorizeColorAction_ORANGE), new ColorDefinition(new RGB(228, 215, 61), Messages.AbstractSelectQuickColorizeColorAction_GOLD), new ColorDefinition(new RGB(90, 179, 163), Messages.AbstractSelectQuickColorizeColorAction_TURQUOISE), new ColorDefinition(new RGB(121, 121, 121), Messages.AbstractSelectQuickColorizeColorAction_GRAY), new ColorDefinition(new RGB(52, 122, 171), Messages.AbstractSelectQuickColorizeColorAction_DARK_TURQUOISE), new ColorDefinition(new RGB(67, 89, 160), Messages.AbstractSelectQuickColorizeColorAction_BLUE), new ColorDefinition(new RGB(199, 99, 99), Messages.AbstractSelectQuickColorizeColorAction_RED)};
    private List<IColorizeDescription> fConfigurations;
    private Set<IColorizeDescription> fAdded = new HashSet<IColorizeDescription>();
    private Set<IColorizeDescription> fRemoved = new HashSet<IColorizeDescription>();
    private Set<IColorizeDescription> fContentChanged = new HashSet<IColorizeDescription>();
    private Set<IColorizeDescription> fEnablementChanged = new HashSet<IColorizeDescription>();
    private ContentAssistAction fContentAssistAction = new ContentAssistAction();
    private TableViewer fTableViewer;
    private QuickQueryTextField fQueryTextField;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Menu fColorMenu;
    private final QuickQueryParser fQuickQueryParser;
    private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public ColorizeConfigurationControl(QuickQueryParser quickQueryParser, List<IColorizeDescription> configurations) {
        this.fQuickQueryParser = quickQueryParser;
        this.fConfigurations = configurations;
    }

    public void setConfigurations(List<IColorizeDescription> configurations) {
        this.fConfigurations = configurations;
        this.fAdded.clear();
        this.fRemoved.clear();
        this.fContentChanged.clear();
        this.fEnablementChanged.clear();
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput(this.fConfigurations);
        }
    }

    public List<IColorizeDescription> getConfigurations() {
        int i = 0;
        while (i < this.fConfigurations.size()) {
            IColorizeDescription configuration = this.fConfigurations.get(i);
            if (configuration.getPriority() != i) {
                configuration.setPriority(i);
                this.contentChanged(configuration);
            }
            ++i;
        }
        return this.fConfigurations;
    }

    public Collection<IColorizeDescription> getAddedConfigs() {
        return this.fAdded;
    }

    public Collection<IColorizeDescription> getContentChangedConfigs() {
        return this.fContentChanged;
    }

    public Collection<IColorizeDescription> getEnablementChangedConfigs() {
        return this.fEnablementChanged;
    }

    public Collection<IColorizeDescription> getRemovedConfigs() {
        return this.fRemoved;
    }

    public IStatus getStatus() {
        int i = 0;
        while (i < this.fConfigurations.size()) {
            IColorizeDescription configuration = this.fConfigurations.get(i);
            String expression = configuration.getExpression();
            if (expression == null || expression.trim().length() == 0) {
                return new Status(4, PlanningUIPlugin.getPluginId(), 0, MessageFormat.format(Messages.ColorizeDialog_MESSAGE_MISSING_EXPRESSION, i), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public Action getAction(String id) {
        if ("org.eclipse.ui.edit.text.contentAssist.proposals".equals(id)) {
            return this.fContentAssistAction;
        }
        return null;
    }

    public void createControls(Composite parent) {
        Composite tableGroup = new Composite(parent, 0);
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(tableGroup);
        tableGroup.setBackground(parent.getBackground());
        this.fTableViewer = new TableViewer(tableGroup, 68098);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        final Table table = this.fTableViewer.getTable();
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setSorter((ViewerSorter)new ConfigurationSorter());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this.createEnablementColumn(this.fTableViewer);
        this.createColorColumn(this.fTableViewer);
        this.createLabelColumn(this.fTableViewer);
        this.createExpressionColumn(this.fTableViewer);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ColorizeConfigurationControl.this.updateActions(selection);
            }
        });
        table.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (event.button != 1 && event.button != 3) {
                    return;
                }
                TableItem item = table.getItem(new Point(event.x, event.y));
                if (item != null) {
                    int startX = 0;
                    TableColumn[] columns = table.getColumns();
                    int i = 0;
                    while (i < columns.length) {
                        TableColumn tableColumn = columns[i];
                        int endX = startX + tableColumn.getWidth();
                        if (event.x > startX && event.x < endX) {
                            IColorizeDescription config = (IColorizeDescription)item.getData();
                            switch (i) {
                                case 0: {
                                    config.setEnabled(!config.isEnabled());
                                    ColorizeConfigurationControl.this.enablementChanged(config);
                                    break;
                                }
                                case 1: {
                                    if (ColorizeConfigurationControl.this.fColorMenu != null && !ColorizeConfigurationControl.this.fColorMenu.isDisposed()) {
                                        ColorizeConfigurationControl.this.fColorMenu.dispose();
                                    }
                                    ColorizeConfigurationControl.this.fColorMenu = new Menu((Control)table);
                                    ColorizeConfigurationControl.this.fillMenu(ColorizeConfigurationControl.this.fColorMenu, config);
                                    Point menuPosition = table.getParent().toDisplay(startX + 16, item.getBounds().y + 16);
                                    ColorizeConfigurationControl.this.fColorMenu.setLocation(menuPosition.x, menuPosition.y);
                                    ColorizeConfigurationControl.this.fColorMenu.setVisible(true);
                                }
                            }
                            break;
                        }
                        startX = endX;
                        ++i;
                    }
                }
            }
        });
        Composite buttonContainer = new Composite(tableGroup, 0);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.fillDefaults().applyTo(buttonContainer);
        buttonContainer.setBackground(tableGroup.getBackground());
        this.fAddButton = new Button(buttonContainer, 0);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.setText(Messages.ColorizeDialog_BUTTON_ADD);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorizeConfigurationControl.this.added(ColorizeConfigurationControl.this.createConfig());
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 0);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.setText(Messages.ColorizeDialog_BUTTON_REMOVE);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ColorizeConfigurationControl.this.fTableViewer.getSelection();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    ColorizeConfigurationControl.this.removed((IColorizeDescription)iterator.next());
                }
            }
        });
        this.fUpButton = new Button(buttonContainer, 0);
        this.fUpButton.setLayoutData((Object)new GridData(768));
        this.fUpButton.setText(Messages.ColorizeDialog_BUTTON_UP);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IColorizeDescription selectedConfig = (IColorizeDescription)((StructuredSelection)ColorizeConfigurationControl.this.fTableViewer.getSelection()).getFirstElement();
                int index = ColorizeConfigurationControl.this.fConfigurations.indexOf(selectedConfig);
                ColorizeConfigurationControl.this.swapPriority((IColorizeDescription)ColorizeConfigurationControl.this.fConfigurations.get(index), (IColorizeDescription)ColorizeConfigurationControl.this.fConfigurations.get(index - 1));
                ColorizeConfigurationControl.this.fConfigurations.remove(index);
                ColorizeConfigurationControl.this.fConfigurations.add(index - 1, selectedConfig);
                ColorizeConfigurationControl.this.fTableViewer.refresh();
                ColorizeConfigurationControl.this.updateActions((IStructuredSelection)ColorizeConfigurationControl.this.fTableViewer.getSelection());
            }
        });
        this.fDownButton = new Button(buttonContainer, 0);
        this.fDownButton.setLayoutData((Object)new GridData(768));
        this.fDownButton.setText(Messages.ColorizeDialog_BUTTON_DOWN);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IColorizeDescription selectedConfig = (IColorizeDescription)((StructuredSelection)ColorizeConfigurationControl.this.fTableViewer.getSelection()).getFirstElement();
                int index = ColorizeConfigurationControl.this.fConfigurations.indexOf(selectedConfig);
                ColorizeConfigurationControl.this.swapPriority((IColorizeDescription)ColorizeConfigurationControl.this.fConfigurations.get(index), (IColorizeDescription)ColorizeConfigurationControl.this.fConfigurations.get(index + 1));
                ColorizeConfigurationControl.this.fConfigurations.remove(index);
                ColorizeConfigurationControl.this.fConfigurations.add(index + 1, selectedConfig);
                ColorizeConfigurationControl.this.fTableViewer.refresh();
                ColorizeConfigurationControl.this.updateActions((IStructuredSelection)ColorizeConfigurationControl.this.fTableViewer.getSelection());
            }
        });
        this.fTableViewer.setInput(this.fConfigurations);
    }

    public void dispose() {
        this.fResourceManager.dispose();
    }

    protected void swapPriority(IColorizeDescription c1, IColorizeDescription c2) {
        int p1 = c1.getPriority();
        c1.setPriority(c2.getPriority());
        c2.setPriority(p1);
        this.contentChanged(c1);
        this.contentChanged(c2);
    }

    private void createEnablementColumn(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn column = new TableColumn(tableViewer.getTable(), 16384);
        ((TableLayout)table.getLayout()).addColumnData((ColumnLayoutData)new ColumnPixelData(22));
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, column);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setImage(ColorizeConfigurationControl.this.fResourceManager.createImage(((IColorizeDescription)cell.getElement()).isEnabled() ? ImagePool.COLORIZE_ON : ImagePool.COLORIZE_OFF));
            }
        });
    }

    private void createColorColumn(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn column = new TableColumn(tableViewer.getTable(), 16384);
        ((TableLayout)table.getLayout()).addColumnData((ColumnLayoutData)new ColumnPixelData(22));
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, column);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RGB color = QuickQueryColorUtil.parseColor(((IColorizeDescription)cell.getElement()).getValue());
                cell.setImage(ColorizeConfigurationControl.this.fResourceManager.createImage((ImageDescriptor)new ColorSelectionImageDescriptor(ColorizeConfigurationControl.this.fResourceManager.getDevice(), color)));
            }
        });
    }

    private void createLabelColumn(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn column = new TableColumn(tableViewer.getTable(), 16384);
        column.setText(Messages.ColorizeDialog_COLUMN_LABEL);
        ((TableLayout)table.getLayout()).addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, column);
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){
            private CellEditor fCellEditor;

            protected void setValue(Object element, Object value) {
                Assert.isLegal((boolean)(element instanceof IColorizeDescription));
                Assert.isLegal((boolean)(value instanceof String));
                ((IColorizeDescription)element).setLabel((String)value);
                ColorizeConfigurationControl.this.contentChanged((IColorizeDescription)element);
            }

            protected Object getValue(Object element) {
                return ((IColorizeDescription)element).getLabel();
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.fCellEditor == null) {
                    this.fCellEditor = new TextCellEditor((Composite)ColorizeConfigurationControl.this.fTableViewer.getTable());
                }
                return this.fCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((IColorizeDescription)cell.getElement()).getLabel());
            }
        });
    }

    private void createExpressionColumn(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn column = new TableColumn(tableViewer.getTable(), 16384);
        column.setText(Messages.ColorizeDialog_COLUMN_EXPRESSION);
        ((TableLayout)table.getLayout()).addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, column);
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){
            private CellEditor fCellEditor;

            protected void setValue(Object element, Object value) {
                Assert.isLegal((boolean)(element instanceof IColorizeDescription));
                Assert.isLegal((boolean)(value instanceof String));
                ((IColorizeDescription)element).setExpression((String)value);
                ColorizeConfigurationControl.this.contentChanged((IColorizeDescription)element);
            }

            protected Object getValue(Object element) {
                return ((IColorizeDescription)element).getExpression();
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.fCellEditor == null) {
                    this.fCellEditor = new TextCellEditor((Composite)ColorizeConfigurationControl.this.fTableViewer.getTable()){

                        protected void focusLost() {
                            if (!ColorizeConfigurationControl.this.fQueryTextField.hasProposalPopupFocus()) {
                                super.focusLost();
                            }
                        }

                        protected boolean dependsOnExternalFocusListener() {
                            return false;
                        }
                    };
                    Control control = this.fCellEditor.getControl();
                    Listener listener = new Listener(){

                        public void handleEvent(Event event) {
                            if (event.type == 26) {
                                ColorizeConfigurationControl.this.fContentAssistAction.setEnabled(true);
                            } else if (event.type == 27) {
                                ColorizeConfigurationControl.this.fContentAssistAction.setEnabled(false);
                            }
                        }
                    };
                    control.addListener(26, listener);
                    control.addListener(27, listener);
                    ColorizeConfigurationControl.this.fQueryTextField = new QuickQueryTextField((Text)control);
                    ColorizeConfigurationControl.this.fQueryTextField.setQuickQueryParser(ColorizeConfigurationControl.this.fQuickQueryParser);
                }
                return this.fCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((IColorizeDescription)cell.getElement()).getExpression());
            }
        });
    }

    protected abstract IColorizeDescription createConfig();

    protected void added(IColorizeDescription configuration) {
        configuration.setPriority(this.fConfigurations.size());
        this.fConfigurations.add(configuration);
        this.fAdded.add(configuration);
        this.fTableViewer.add((Object)configuration);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
    }

    protected void contentChanged(IColorizeDescription configuration) {
        if (!this.fAdded.contains(configuration)) {
            Assert.isTrue((!this.fRemoved.contains(configuration) ? 1 : 0) != 0);
            this.fContentChanged.add(configuration);
        }
        this.fTableViewer.update((Object)configuration, null);
    }

    protected void enablementChanged(IColorizeDescription configuration) {
        if (!this.fAdded.contains(configuration)) {
            Assert.isTrue((!this.fRemoved.contains(configuration) ? 1 : 0) != 0);
            this.fEnablementChanged.add(configuration);
        }
        this.fTableViewer.update((Object)configuration, null);
    }

    protected void removed(IColorizeDescription configuration) {
        this.fConfigurations.remove(configuration);
        if (!this.fAdded.remove(configuration)) {
            this.fContentChanged.remove(configuration);
            this.fEnablementChanged.remove(configuration);
            this.fRemoved.add(configuration);
        }
        this.fTableViewer.remove((Object)configuration);
    }

    protected void updateActions(IStructuredSelection selection) {
        this.fRemoveButton.setEnabled(selection.size() > 0);
        if (selection.size() == 1) {
            int selectionIndex = this.fConfigurations.indexOf(selection.getFirstElement());
            this.fUpButton.setEnabled(selectionIndex > 0);
            this.fDownButton.setEnabled(selectionIndex != -1 && selectionIndex < this.fConfigurations.size() - 1);
        } else {
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    private void fillMenu(Menu menu, IColorizeDescription config) {
        ColorMenuListener menuListener = new ColorMenuListener(config);
        ColorDefinition[] colorDefinitionArray = DEFAULT_COLORS;
        int n = DEFAULT_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition colorDefinition = colorDefinitionArray[n2];
            MenuItem item = new MenuItem(menu, 16);
            item.setData((Object)colorDefinition.fValue);
            item.setSelection(colorDefinition.fValue.equals((Object)QuickQueryColorUtil.parseColor(config.getValue())));
            item.setText(colorDefinition.fName);
            item.addSelectionListener((SelectionListener)menuListener);
            item.setImage(this.fResourceManager.createImageWithDefault((ImageDescriptor)new ColorSelectionImageDescriptor((Device)this.fTableViewer.getTable().getDisplay(), colorDefinition.fValue)));
            ++n2;
        }
        new MenuItem(menu, 2);
        MenuItem item = new MenuItem(menu, 0);
        item.setData(null);
        item.addSelectionListener((SelectionListener)menuListener);
        item.setText(Messages.AbstractSelectQuickColorizeColorAction_MENUITEM_OPEN_COLORDIALOG);
    }

    private static class ColorDefinition {
        public final RGB fValue;
        public final String fName;

        public ColorDefinition(RGB color, String name) {
            this.fValue = color;
            this.fName = name;
        }
    }

    private class ColorMenuListener
    extends SelectionAdapter {
        private final IColorizeDescription fConfig;

        ColorMenuListener(IColorizeDescription config) {
            this.fConfig = config;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            if (item.getData() == null) {
                ColorDialog colorDialog = new ColorDialog(ColorizeConfigurationControl.this.fTableViewer.getTable().getShell());
                colorDialog.setText(Messages.AbstractSelectQuickColorizeColorAction_COLORDIALOG_TITLE);
                RGB color = colorDialog.open();
                if (color != null) {
                    this.setColor(color);
                }
            } else if (item.getSelection()) {
                this.setColor((RGB)item.getData());
            }
        }

        private void setColor(RGB color) {
            this.fConfig.setValue(QuickQueryColorUtil.serializeColor(color));
            ColorizeConfigurationControl.this.contentChanged(this.fConfig);
        }
    }

    private class ConfigurationSorter
    extends ViewerSorter {
        private ConfigurationSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ColorizeConfigurationControl.this.fConfigurations.indexOf(e1) - ColorizeConfigurationControl.this.fConfigurations.indexOf(e2);
        }
    }

    private class ContentAssistAction
    extends Action {
        public ContentAssistAction() {
            this.setEnabled(false);
        }

        public void run() {
            if (ColorizeConfigurationControl.this.fQueryTextField == null || ColorizeConfigurationControl.this.fQueryTextField.isDisposed()) {
                return;
            }
            ColorizeConfigurationControl.this.fQueryTextField.getAction("org.eclipse.ui.edit.text.contentAssist.proposals").run();
        }
    }
}

