/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ColorSelectionImageDescriptor
extends ImageDescriptor {
    private final RGB fColor;
    private final Device fDevice;
    private final int fImageSize;
    private final int fRectangleSize;

    public ColorSelectionImageDescriptor(Device device, RGB color) {
        this(device, color, 16, 10);
    }

    public ColorSelectionImageDescriptor(Device device, RGB color, int imageSize, int rectangleSize) {
        this.fDevice = device;
        this.fColor = color;
        this.fImageSize = imageSize;
        this.fRectangleSize = rectangleSize;
    }

    public ImageData getImageData() {
        Image image = this.createImage();
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public Image createImage() {
        Color borderColor = PlanningUIPlugin.getDefault().getDarkShadow();
        Color color = new Color(this.fDevice, this.fColor);
        RGB unused = new RGB(0, 0, 0);
        ImageData data = new ImageData(this.fImageSize, this.fImageSize, 2, new PaletteData(new RGB[]{this.fColor, borderColor.getRGB(), unused, unused}));
        data.transparentPixel = 3;
        Arrays.fill(data.data, (byte)-1);
        Image image = new Image(this.fDevice, data);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(borderColor);
        int spacing = (this.fImageSize - this.fRectangleSize) / 2;
        gc.fillRectangle(spacing, spacing, this.fRectangleSize - 1, this.fRectangleSize - 1);
        gc.drawRectangle(spacing, spacing, this.fRectangleSize - 1, this.fRectangleSize - 1);
        gc.dispose();
        color.dispose();
        return image;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fColor == null ? 0 : this.fColor.hashCode());
        result = 31 * result + this.fImageSize;
        result = 31 * result + this.fRectangleSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ColorSelectionImageDescriptor other = (ColorSelectionImageDescriptor)((Object)obj);
        if (this.fImageSize != other.fImageSize) {
            return false;
        }
        if (this.fRectangleSize != other.fRectangleSize) {
            return false;
        }
        return !(this.fColor == null ? other.fColor != null : !this.fColor.equals((Object)other.fColor));
    }
}

