/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelCanvas;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineViewer;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class OutlineModelViewer
extends OutlineViewer {
    private final GadgetFactory fGadgetFactory;

    public OutlineModelViewer(GadgetFactory gadgetFactory, OutlineModelCanvas control) {
        super(control);
        this.fGadgetFactory = gadgetFactory;
    }

    public OutlineModel getViewModel() {
        return (OutlineModel)this.getInput();
    }

    public OutlineItem findOutlineItem(IViewEntry<?> entry) {
        return (OutlineItem)this.findItem(entry);
    }

    public void resort(IViewEntry<?> entry) {
        ViewerComparator comparator = this.getComparator();
        if (comparator != null) {
            OutlineItem toSort;
            OutlineModelCanvas outline = (OutlineModelCanvas)this.getOutline();
            OutlineItem outlineItem = toSort = entry == null || entry == this.getInput() ? outline.getRootItem() : (OutlineItem)this.findItem(entry);
            if (toSort != null) {
                OutlineItem[] children = toSort.getItems();
                Arrays.sort(children, new OutlineItemComparator(comparator));
                toSort.setSortedChildren(children);
            }
        }
    }

    protected void internalRemove(Object[] elementsOrPaths) {
        Object input = this.getInput();
        int i = 0;
        while (i < elementsOrPaths.length) {
            Object element = elementsOrPaths[i];
            if (this.equals(element, input)) {
                this.setInput(null);
                return;
            }
            Widget[] childItems = this.internalFindItems(element);
            if (childItems.length > 0) {
                int j = 0;
                while (j < childItems.length) {
                    Widget childItem = childItems[j];
                    if (childItem instanceof Item) {
                        this.disassociate((Item)childItem);
                        childItem.dispose();
                    }
                    ++j;
                }
            } else {
                Object parent = this.getParentElement(element);
                if (parent != null && parent != TreePath.EMPTY) {
                    Widget[] parentItems;
                    Widget[] widgetArray = parentItems = this.internalFindItems(parent);
                    int n = parentItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget parentItem = widgetArray[n2];
                        if (parentItem instanceof Item) {
                            this.updatePlus((Item)parentItem, parent);
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        ContentOutlineItem outlineItem = (ContentOutlineItem)item;
        GTreeNode<?> content = this.fGadgetFactory.createGadget(outlineItem, (IViewEntry)element);
        if (content != null) {
            outlineItem.setContent(content);
        }
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        if (v == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int size = v.size();
        ArrayList<Widget> newSelection = new ArrayList<Widget>(size);
        int i = 0;
        while (i < size) {
            IViewEntry candidateEntry;
            Object lastSegment;
            Object elementOrTreePath = v.get(i);
            Widget w = this.internalExpand(elementOrTreePath, false);
            if (w instanceof Item) {
                newSelection.add(w);
            } else if (w == null && elementOrTreePath instanceof TreePath && (lastSegment = ((TreePath)elementOrTreePath).getLastSegment()) instanceof IViewEntry && (candidateEntry = (IViewEntry)this.getViewModel().readModel(new IViewModelReadFunction<IViewEntry<?>, RuntimeException>(){

                public IViewEntry<?> run(IViewModelReader readAccessor) throws RuntimeException {
                    Object element = ((IViewEntry)lastSegment).getElement();
                    List elementEntries = readAccessor.getElementEntries(element);
                    IViewEntry candidateEntry = EntryUtils.firstEntryWithTag(elementEntries, PrimaryLocationTag.INSTANCE);
                    if (candidateEntry == null) {
                        candidateEntry = EntryUtils.firstEntry(elementEntries);
                    }
                    return candidateEntry;
                }
            })) != null && (w = this.internalExpand(candidateEntry, false)) instanceof Item) {
                newSelection.add(w);
            }
            ++i;
        }
        this.setSelection(newSelection);
        if (reveal && newSelection.size() > 0) {
            this.showItem((Item)newSelection.get(0));
        }
    }

    List<ExpansionHullEntry> getExpansionHull(IViewEntry<?> root) {
        ArrayList<ExpansionHullEntry> result = Collections.EMPTY_LIST;
        if (root == null) {
            result = new ArrayList<ExpansionHullEntry>();
            OutlineItem[] outlineItemArray = this.getOutline().getItems();
            int n = outlineItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineItem child = outlineItemArray[n2];
                Assert.isLegal((boolean)(child.getData() instanceof IViewEntry));
                Object element = ((IViewEntry)child.getData()).getElement();
                this.getExpansionHull(result, child, new TreePath(new Object[]{element}));
                ++n2;
            }
        } else {
            OutlineItem rootItem = this.findOutlineItem(root);
            if (rootItem != null) {
                result = new ArrayList();
                this.getExpansionHull(result, rootItem, TreePath.EMPTY);
            }
        }
        return result;
    }

    List<ExpansionHullEntry> setExpansionHull(final IViewEntry<?> rootEntry, final List<ExpansionHullEntry> paths) {
        return this.getViewModel().readModel(new IViewModelReadFunction<List<ExpansionHullEntry>, RuntimeException>(){

            public List<ExpansionHullEntry> run(IViewModelReader readAccessor) throws RuntimeException {
                ArrayList<ExpansionHullEntry> result = Collections.EMPTY_LIST;
                if (!paths.isEmpty()) {
                    result = new ArrayList<ExpansionHullEntry>();
                    for (ExpansionHullEntry entry : paths) {
                        TreePath treePath = entry.fPath;
                        IViewEntry toToggle = null;
                        if (treePath.getSegmentCount() > 0) {
                            Object element = treePath.getLastSegment();
                            Iterator iterator = readAccessor.getElementEntries(element).iterator();
                            while (iterator.hasNext()) {
                                IViewEntry elementEntry;
                                IViewEntry currentEntry = elementEntry = (IViewEntry)iterator.next();
                                int i = treePath.getSegmentCount() - 1;
                                while (i >= 0 && currentEntry != null) {
                                    Object segment = treePath.getSegment(i);
                                    if (!segment.equals(currentEntry.getElement())) break;
                                    currentEntry = readAccessor.getParent(currentEntry);
                                    if (i == 0 && (rootEntry == null && currentEntry.isRootEntry() || rootEntry != null && rootEntry.equals(currentEntry))) {
                                        toToggle = elementEntry;
                                        break;
                                    }
                                    --i;
                                }
                                if (toToggle == null) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            toToggle = rootEntry;
                        }
                        if (toToggle != null) {
                            OutlineModelViewer.this.setExpandedState(toToggle, entry.fState);
                            continue;
                        }
                        result.add(entry);
                    }
                }
                return result;
            }
        });
    }

    private void getExpansionHull(List<ExpansionHullEntry> result, Item item, TreePath currentPath) {
        Item[] children = this.getChildren((Widget)item);
        if (children.length > 0) {
            result.add(new ExpansionHullEntry(currentPath, this.getExpanded(item)));
            Item[] itemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Item child = itemArray[n2];
                Object data = child.getData();
                if (data instanceof IViewEntry) {
                    Object element = ((IViewEntry)data).getElement();
                    this.getExpansionHull(result, child, currentPath.createChildPath(element));
                }
                ++n2;
            }
        }
    }

    class ExpansionHullEntry {
        private final TreePath fPath;
        private final boolean fState;

        ExpansionHullEntry(TreePath path, boolean state) {
            this.fPath = path;
            this.fState = state;
        }
    }

    private class OutlineItemComparator
    implements Comparator<OutlineItem> {
        private final ViewerComparator fComparator;

        public OutlineItemComparator(ViewerComparator comparator) {
            this.fComparator = comparator;
        }

        @Override
        public int compare(OutlineItem o1, OutlineItem o2) {
            return this.fComparator.compare((Viewer)OutlineModelViewer.this, o1.getData(), o2.getData());
        }
    }
}

