/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class OutlineModelContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ENTRIES = new Object[0];
    private OutlineModel fOutlineModel;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isLegal((newInput == null || newInput instanceof OutlineModel ? 1 : 0) != 0);
        this.fOutlineModel = (OutlineModel)newInput;
    }

    public void dispose() {
        this.fOutlineModel = null;
    }

    public Object[] getElements(Object inputElement) {
        Assert.isLegal((boolean)(inputElement instanceof OutlineModel));
        return this.fOutlineModel.readModel(new IViewModelReadFunction<Object[], RuntimeException>(){

            public Object[] run(IViewModelReader readAccessor) {
                IViewEntry rootEntry = readAccessor.getRootEntry(IViewModel.Domain.Content);
                return rootEntry != null ? OutlineModelContentProvider.this.getVisibleChildren(rootEntry, readAccessor).toArray() : NO_ENTRIES;
            }
        });
    }

    public Object[] getChildren(final Object parentElement) {
        Assert.isLegal((boolean)(parentElement instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new IViewModelReadFunction<Object[], RuntimeException>(){

            public Object[] run(IViewModelReader readAccessor) {
                return OutlineModelContentProvider.this.getVisibleChildren((OutlineEntry)parentElement, readAccessor).toArray();
            }
        });
    }

    public Object getParent(final Object element) {
        Assert.isLegal((boolean)(element instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new IViewModelReadFunction<Object, RuntimeException>(){

            public Object run(IViewModelReader readAccessor) {
                OutlineEntry entry = (OutlineEntry)element;
                return !entry.isDisposed() ? entry.getParent() : null;
            }
        });
    }

    public boolean hasChildren(final Object element) {
        Assert.isLegal((boolean)(element instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new IViewModelReadFunction<Boolean, RuntimeException>(){

            public Boolean run(IViewModelReader readAccessor) {
                return !OutlineModelContentProvider.this.getVisibleChildren((OutlineEntry)element, readAccessor).isEmpty();
            }
        });
    }

    private List<IViewEntry<?>> getVisibleChildren(IViewEntry<?> entry, IViewModelReader readAccessor) {
        List children = readAccessor.getChildren(entry);
        ArrayList result = new ArrayList(children.size());
        for (IViewEntry child : children) {
            if (!child.isVisible()) continue;
            result.add(child);
        }
        return result;
    }

    private <T> IViewEntry<T> ensureCurrentEntry(IViewEntry<T> source, IViewModelReader readAccessor) {
        if (!source.isDisposed()) {
            return source;
        }
        for (IViewEntry candidateEntry : readAccessor.getElementEntries(source.getElement())) {
            if (!source.equals((Object)candidateEntry)) continue;
            return candidateEntry;
        }
        return source;
    }
}

