/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.jdojo.util.IMappable;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.model.CopyResult;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerRunnable;
import com.ibm.team.apt.internal.ide.ui.common.structure.RowElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.UnfilteredChildrenTag;
import com.ibm.team.apt.internal.ide.ui.util.RefreshRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.rtc.foundation.api.ui.essentials.IModificationPolicy;
import com.ibm.team.rtc.foundation.api.ui.model.IEntryColumn;
import com.ibm.team.rtc.foundation.api.ui.model.IExpansionHull;
import com.ibm.team.rtc.foundation.api.ui.model.IUnlockedViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryComparator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryFilter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntrySorter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelTransformer;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OutlineModel
implements IViewModel {
    private static final ExpansionHull EMPTY_EXPANSION_HULL = new ExpansionHull(Collections.EMPTY_LIST);
    private OutlineModelViewer fViewer;
    private Object fInput;
    private IViewModelTransformer fModelTransformer;
    private List<IViewEntryFilter> fFilters = new ArrayList<IViewEntryFilter>();
    private IViewEntrySorter fSorter;
    private OutlineEntry<IViewModel.Domain> fRootEntry;
    private Map<IViewModel.Domain, OutlineEntry<IViewModel.Domain>> fDomainRootEntries = new HashMap<IViewModel.Domain, OutlineEntry<IViewModel.Domain>>();
    private final Map<Object, Set<OutlineEntry<?>>> fReverseItemMap = new WeakHashMap();
    private final Map<Object, Object> fOptions = new HashMap<Object, Object>();
    private int fGenerationCounter = 0;
    private int fNestedUpdates = 0;
    private List<IViewModelFunction> fEndUpdateRunnables;
    private final ILock fModelLock = Job.getJobManager().newLock();
    private final ListenerList fPostUpdateBeforeFilterRunnables = new ListenerList(1);
    private final ListenerList fPostUpdateAfterFilterRunnables = new ListenerList(1);
    private final ModelSelectionManager fSelectionManager = new ModelSelectionManager();
    private static final IViewModelNavigator.IViewModelNavigatorFilter fInvisibleFilter = new IViewModelNavigator.IViewModelNavigatorFilter(){

        public boolean select(IViewEntry<?> entry) {
            return entry.isVisible();
        }
    };

    public void setOption(Object key, Object value) {
        this.fOptions.put(key, value);
    }

    public Object getOption(Object key) {
        return this.fOptions.get(key);
    }

    public void setViewer(OutlineModelViewer newViewer) {
        this.aquireWriteLock();
        try {
            OutlineModelViewer oldViewer = this.fViewer;
            this.fViewer = newViewer;
            this.fSelectionManager.viewerChanges(oldViewer, newViewer);
            this.fViewer.setInput(this);
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void setInput(Object input) {
        this.aquireWriteLock();
        try {
            this.fInput = input;
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged((IViewModel)this, this.fInput);
            }
            if (this.fSorter != null) {
                this.fSorter.inputChanged((IViewModel)this, this.fInput);
            }
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public Object getInput() {
        this.aquireReadLock();
        try {
            Object object = this.fInput;
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public IViewModelTransformer getModelTransformer() {
        return this.fModelTransformer;
    }

    public void setModelTransformer(IViewModelTransformer transformer) {
        this.aquireWriteLock();
        try {
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged(null, null);
            }
            this.fModelTransformer = transformer;
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged((IViewModel)this, this.getInput());
            }
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void viewerPreservingRefresh() {
        Outline modelCanvas;
        final OutlineModelViewer modelViewer = this.getViewer();
        Outline outline = modelCanvas = modelViewer != null ? modelViewer.getOutline() : null;
        if (modelCanvas != null && modelViewer != null) {
            Runnable refreshRunnable = new Runnable(){

                @Override
                public void run() {
                    modelCanvas.setRedraw(false);
                    try {
                        final ISelection selection = modelViewer.getSelection();
                        final int scrollY = modelCanvas.getTransformation().getY();
                        final List<OutlineModelViewer.ExpansionHullEntry> expansionHull = modelViewer.getExpansionHull(null);
                        OutlineModel.this.refresh();
                        OutlineModel.this.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

                            public Void run(IViewModelUpdater modifier) {
                                modifier.executeAfterUpdate(new IViewModelFunction(){

                                    public void run() {
                                        if (!modelCanvas.isDisposed()) {
                                            modelViewer.setExpansionHull(null, expansionHull);
                                            modelViewer.setSelection(selection);
                                            int newY = modelCanvas.getTransformation().getY();
                                            modelCanvas.scroll(0, scrollY - newY);
                                        }
                                    }
                                });
                                return null;
                            }
                        });
                    }
                    finally {
                        modelCanvas.setRedraw(true);
                    }
                }
            };
            if (!modelCanvas.isDisposed()) {
                Display display = modelCanvas.getDisplay();
                if (display.getThread() == Thread.currentThread()) {
                    refreshRunnable.run();
                } else {
                    UI.asyncExec((Control)modelCanvas, refreshRunnable);
                }
            }
        } else {
            this.refresh();
        }
    }

    public void refresh() {
        this.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) {
                if (OutlineModel.this.fRootEntry != null) {
                    OutlineModel.this.fRootEntry.dispose();
                    OutlineModel.this.fRootEntry = null;
                }
                OutlineModel.this.fReverseItemMap.clear();
                if (OutlineModel.this.fModelTransformer != null && OutlineModel.this.fInput != null) {
                    OutlineModel.this.createRootEntries(updateAccessor);
                    OutlineModel.this.fModelTransformer.refreshModel(updateAccessor);
                    OutlineModel.this.resort();
                }
                return null;
            }
        });
    }

    public void addComparator(IViewEntryComparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void removeComparator(IViewEntryComparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void setSorter(IViewEntrySorter sorter) {
        this.aquireWriteLock();
        try {
            if (this.fSorter != null) {
                this.fSorter.inputChanged(null, null);
            }
            this.fSorter = sorter;
            if (this.fSorter != null) {
                this.fSorter.inputChanged((IViewModel)this, this.getInput());
            }
            this.resort();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public IViewEntrySorter getSorter() {
        return this.fSorter;
    }

    public void refreshSortOrder() {
        this.aquireWriteLock();
        try {
            this.resort();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void addFilter(IViewEntryFilter filter) {
        this.aquireWriteLock();
        try {
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
            }
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void addParentVisibilityFilter(IViewEntryFilter filter) {
        throw new UnsupportedOperationException();
    }

    public void setDelayedChildrenLoadingMode(boolean enableDelayedChildrenLoading) {
        throw new UnsupportedOperationException();
    }

    public boolean isDelayedChildrenLoadingEnabled() {
        throw new UnsupportedOperationException();
    }

    public void removeFilter(IViewEntryFilter filter) {
        this.aquireWriteLock();
        try {
            this.fFilters.remove(filter);
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removeParentVisibilityFilter(IViewEntryFilter filter) {
        throw new UnsupportedOperationException();
    }

    public void refreshFilters() {
        this.aquireWriteLock();
        try {
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public OutlineModelViewer getViewer() {
        return this.fViewer;
    }

    public IViewModel.IPostUpdateRunnerHandle addPostUpdateRunnable(IViewModelUpdateFunction<Void, ? extends RuntimeException> code, boolean runsBeforeFiltering) {
        this.aquireWriteLock();
        try {
            this.getPostUpdateRunnables(runsBeforeFiltering).add(code);
            PostUpdateRunnerHandle postUpdateRunnerHandle = new PostUpdateRunnerHandle(code, runsBeforeFiltering);
            return postUpdateRunnerHandle;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removePostUpdateRunnable(IViewModel.IPostUpdateRunnerHandle handle) {
        this.aquireWriteLock();
        try {
            Assert.isLegal((boolean)(handle instanceof PostUpdateRunnerHandle));
            this.getPostUpdateRunnables(((PostUpdateRunnerHandle)handle).fRunsBeforeFiltering).remove(((PostUpdateRunnerHandle)handle).fCode);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public <V, E extends Exception> V readModel(IViewModelReadFunction<V, E> code) throws E {
        this.aquireReadLock();
        try {
            Object object;
            ModelReadAccessor accessor = this.createReadAccessor();
            try {
                object = code.run((IViewModelReader)accessor);
            }
            catch (Throwable throwable) {
                accessor.revokeAccess();
                throw throwable;
            }
            accessor.revokeAccess();
            return (V)object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public <V, E extends Exception> V executeUnlocked(final IUnlockedViewModelFunction<V, E> code) throws E {
        return this.updateModel(new IViewModelUpdateFunction<V, E>(){

            public V run(IViewModelUpdater updateAccessor) throws Exception {
                return updateAccessor.executeUnlocked(code);
            }
        });
    }

    public <V, E extends Exception> V updateModel(IViewModelUpdateFunction<V, E> code) throws E {
        Object result;
        List<IViewModelFunction> viewerUpdates = null;
        try {
            this.aquireWriteLock();
            ++this.fGenerationCounter;
            ModelUpdateAccessor accessor = this.createUpdateAccessor();
            try {
                try {
                    if (++this.fNestedUpdates == 1) {
                        this.doStartUpdate();
                    }
                    result = code.run((IViewModelUpdater)accessor);
                }
                finally {
                    if (--this.fNestedUpdates == 0) {
                        viewerUpdates = this.doEndUpdate(accessor);
                    }
                }
            }
            finally {
                accessor.revokeAccess();
            }
        }
        finally {
            this.releaseWriteLock();
        }
        if (viewerUpdates != null && viewerUpdates.size() > 0) {
            Assert.isNotNull((Object)((Object)this.fViewer));
            final int finalGenerationCount = this.fGenerationCounter;
            final List<IViewModelFunction> finalUpdateList = viewerUpdates;
            UI.syncExec(this.fViewer.getControl(), new Runnable(){

                @Override
                public void run() {
                    if (finalGenerationCount == OutlineModel.this.fGenerationCounter) {
                        try {
                            OutlineModel.this.aquireReadLock();
                            for (IViewModelFunction runnable : finalUpdateList) {
                                runnable.run();
                            }
                        }
                        finally {
                            OutlineModel.this.releaseReadLock();
                        }
                    }
                }
            });
        }
        return (V)result;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionManager;
    }

    public List<IViewEntry<?>> getSelectedEntries() {
        final List[] result = new List[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    result[0] = ((IStructuredSelection)OutlineModel.this.fViewer.getSelection()).toList();
                }
            }.syncExec();
        }
        return result[0] != null ? result[0] : Collections.EMPTY_LIST;
    }

    public List<IViewEntry<?>> getOrderedEntries(List<IViewEntry<?>> entries) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<IViewEntry<?>> getOrderedSelectedEntries() {
        List<IViewEntry<?>> entries = this.getSelectedEntries();
        this.getSorter().sort(entries, (IViewModelReader)this.createReadAccessor(), true);
        return entries;
    }

    public List<?> getSelectedElements() {
        List<IViewEntry<?>> entries = this.getSelectedEntries();
        ArrayList<Object> result = new ArrayList<Object>(entries.size());
        for (IViewEntry iViewEntry : entries) {
            result.add(iViewEntry.getElement());
        }
        return result;
    }

    public IModificationPolicy getModificationPolicy() {
        return null;
    }

    public boolean isSelected(IViewEntry<?> toSelect) {
        return false;
    }

    public void setSelected(IViewEntry<?> toSelect, boolean setSelected) {
    }

    public void addSelectionListener(IViewModel.ISelectionChangeListener listener) {
    }

    public void removeSelectionListener(IViewModel.ISelectionChangeListener listener) {
    }

    public void clearSelection() {
    }

    public <T> void setSelectedEntry(IViewEntry<T> toSelect) {
        StructuredSelection selection = new StructuredSelection(toSelect);
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer, (IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                    super($anonymous0);
                }

                @Override
                protected void doRun() {
                    OutlineModel.this.fViewer.setSelection((ISelection)this.val$selection);
                }
            }.syncExec();
        }
    }

    public void setSelectedEntries(List<? extends IViewEntry<?>> toSelect) {
        StructuredSelection selection = new StructuredSelection(toSelect.toArray());
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer, (IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                    super($anonymous0);
                }

                @Override
                protected void doRun() {
                    OutlineModel.this.fViewer.setSelection((ISelection)this.val$selection);
                }
            }.syncExec();
        }
    }

    public void expandEntries(final List<? extends IViewEntry<?>> toExpand) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    OutlineModel.this.fViewer.setExpandedElements(toExpand.toArray());
                }
            }.syncExec();
        }
    }

    public <T> void setEntryExpandState(final IViewEntry<T> entry, final boolean expanded) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    OutlineModel.this.fViewer.setExpandedState(entry, expanded);
                }
            }.syncExec();
        }
    }

    public <T> void revealEntry(final IViewEntry<T> toReveal) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    OutlineModel.this.fViewer.reveal(toReveal);
                }
            }.syncExec();
        }
    }

    public IExpansionHull getExpansionHull(final IViewEntry<?> rootEntry) {
        final List[] result = new List[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    result[0] = OutlineModel.this.fViewer.getExpansionHull(rootEntry);
                }
            }.syncExec();
        }
        return result[0] != null ? new ExpansionHull(result[0]) : EMPTY_EXPANSION_HULL;
    }

    public void setExpansionHull(final IViewEntry<?> rootEntry, final IExpansionHull expansionHull) {
        final List[] result = new List[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                @Override
                protected void doRun() {
                    result[0] = OutlineModel.this.fViewer.setExpansionHull(rootEntry, ((ExpansionHull)expansionHull).fExpansionHull);
                }
            }.syncExec();
        }
    }

    boolean calculateFilterState(OutlineEntry<?> entry, IViewModelReader readAccessor) {
        PlanItem planItem;
        Object element = entry.getElement();
        if (element instanceof PlanItem && (planItem = (PlanItem)element).isDirty()) {
            return true;
        }
        for (IViewEntryFilter filter : this.fFilters) {
            if (filter.select(entry, readAccessor)) continue;
            return false;
        }
        return true;
    }

    private void doStartUpdate() {
        if (this.fRootEntry != null) {
            this.fRootEntry.accept(new StartUpdateVisitor(), false);
        }
        Assert.isTrue((this.fEndUpdateRunnables == null ? 1 : 0) != 0);
        this.fEndUpdateRunnables = new ArrayList<IViewModelFunction>();
    }

    private List<IViewModelFunction> doEndUpdate(IViewModelUpdater updateAccessor) {
        ArrayList<IViewModelFunction> viewerUpdates = new ArrayList<IViewModelFunction>();
        if (this.fRootEntry != null) {
            this.runPostUpdateRunnables(updateAccessor, true);
            for (IViewEntry<?> child : this.fDomainRootEntries.get(IViewModel.Domain.Content).getChildren()) {
                this.filterRecursive((OutlineEntry)child, updateAccessor);
            }
            this.executePendingSortRequests(this.fDomainRootEntries.get(IViewModel.Domain.Content), updateAccessor);
            this.runPostUpdateRunnables(updateAccessor, false);
            if (this.fViewer != null) {
                this.fRootEntry.accept(new CollectUpdatesVisitor(this.fViewer, viewerUpdates), true);
            }
        } else if (this.fViewer != null) {
            viewerUpdates.add(new IViewModelFunction(){

                public void run() {
                    new RefreshRunnable((StructuredViewer)OutlineModel.this.fViewer, this).run();
                }
            });
        }
        Assert.isNotNull(this.fEndUpdateRunnables);
        if (this.fViewer != null) {
            viewerUpdates.addAll(this.fEndUpdateRunnables);
        }
        this.fEndUpdateRunnables = null;
        return viewerUpdates;
    }

    private void runPostUpdateRunnables(final IViewModelUpdater updateAccessor, boolean isBeforeFiltering) {
        Object[] objectArray = this.getPostUpdateRunnables(isBeforeFiltering).getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object runnable = objectArray[n2];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IViewModelUpdateFunction)runnable).run(updateAccessor);
                }

                public void handleException(Throwable exception) {
                    PlanningUIPlugin.log(exception);
                }
            });
            ++n2;
        }
    }

    private ListenerList getPostUpdateRunnables(boolean beforeFiltering) {
        return beforeFiltering ? this.fPostUpdateBeforeFilterRunnables : this.fPostUpdateAfterFilterRunnables;
    }

    private boolean filterRecursive(OutlineEntry<?> entry, IViewModelUpdater updateAccessor) {
        boolean isFiltered;
        if (entry.getElement() instanceof RowElement) {
            return this.filterRow(entry, updateAccessor, (RowElement)entry.getElement());
        }
        boolean hasUnfilteredChildren = false;
        for (IViewEntry<?> child : entry.getChildren()) {
            hasUnfilteredChildren |= !this.filterRecursive((OutlineEntry)child, updateAccessor);
        }
        boolean bl = isFiltered = !this.calculateFilterState(entry, (IViewModelReader)updateAccessor);
        if (isFiltered && !hasUnfilteredChildren && entry.isVisible()) {
            entry.hide(updateAccessor);
        } else if (!(isFiltered && !hasUnfilteredChildren || entry.isVisible())) {
            entry.show(updateAccessor);
        }
        if (isFiltered && hasUnfilteredChildren) {
            if (!entry.hasTag(UnfilteredChildrenTag.INSTANCE)) {
                updateAccessor.setTag(entry, (IViewEntryTag)UnfilteredChildrenTag.INSTANCE);
            }
        } else if (entry.hasTag(UnfilteredChildrenTag.INSTANCE)) {
            updateAccessor.clearTag(entry, (IViewEntryTag)UnfilteredChildrenTag.INSTANCE);
        }
        return isFiltered && !hasUnfilteredChildren;
    }

    private boolean filterRow(OutlineEntry<?> entry, IViewModelUpdater updateAccessor, RowElement rowElement) {
        boolean show = rowElement.isHeader() ? this.hasUnfilteredSiblings(entry, updateAccessor) : this.hasUnfilteredChildren(entry.getChildren(), updateAccessor);
        if (show) {
            if (!entry.isVisible()) {
                entry.show(updateAccessor);
            }
        } else if (entry.isVisible()) {
            entry.hide(updateAccessor);
        }
        return !show;
    }

    private boolean hasUnfilteredSiblings(OutlineEntry<?> header, IViewModelUpdater updateAccessor) {
        List<IViewEntry<?>> rows = ((OutlineEntry)header.getParent()).getChildren();
        for (IViewEntry<?> row : rows) {
            if (row == header || !this.hasUnfilteredChildren(((OutlineEntry)row).getChildren(), updateAccessor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnfilteredChildren(List<IViewEntry<?>> columns, IViewModelUpdater updateAccessor) {
        boolean hasUnfilteredChildren = false;
        for (IViewEntry<?> column : columns) {
            List<IViewEntry<?>> children = ((OutlineEntry)column).getChildren();
            for (IViewEntry<?> child : children) {
                hasUnfilteredChildren |= !this.filterRecursive((OutlineEntry)child, updateAccessor);
            }
        }
        return hasUnfilteredChildren;
    }

    private void executePendingSortRequests(OutlineEntry<?> entry, IViewModelUpdater updateAccessor) {
        for (IViewEntry<?> child : entry.getChildren()) {
            this.executePendingSortRequests((OutlineEntry)child, updateAccessor);
        }
        entry.doPendingSort(updateAccessor);
    }

    protected void resort() {
        this.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(final IViewModelUpdater modifier) {
                if (OutlineModel.this.fRootEntry != null) {
                    ((OutlineEntry)OutlineModel.this.fDomainRootEntries.get(IViewModel.Domain.Content)).accept(new IViewEntryVisitor(){

                        public boolean visit(IViewEntry<? extends Object> entry) {
                            ((OutlineEntry)entry).requestSortChildren(modifier, true);
                            return true;
                        }
                    }, false);
                }
                return null;
            }
        });
    }

    protected void refilter() {
        this.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater modifier) {
                return null;
            }
        });
    }

    private <T> List<IViewEntry<T>> doGetElementEntries(T element) {
        Set<OutlineEntry<?>> entries = this.fReverseItemMap.get(element);
        if (entries == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IViewEntry<T>> result = new ArrayList<IViewEntry<T>>(entries.size());
        for (OutlineEntry<?> entry : entries) {
            result.add(entry);
        }
        return result;
    }

    private void createRootEntries(IViewModelUpdater updateAccessor) {
        Assert.isTrue((this.fRootEntry == null ? 1 : 0) != 0);
        this.fDomainRootEntries.clear();
        this.fRootEntry = this.createRootEntry(IViewModel.Domain.Root, updateAccessor);
        this.createRootEntry(IViewModel.Domain.Content, updateAccessor);
        this.createRootEntry(IViewModel.Domain.Connection, updateAccessor);
    }

    private OutlineEntry<IViewModel.Domain> createRootEntry(IViewModel.Domain domain, IViewModelUpdater updateAccessor) {
        OutlineEntry<IViewModel.Domain> domainRootEntry = new OutlineEntry<IViewModel.Domain>(domain, this.fRootEntry, this, true);
        this.fDomainRootEntries.put(domain, domainRootEntry);
        this.registerEntry(domainRootEntry, updateAccessor);
        if (this.fRootEntry != null) {
            this.fRootEntry.add(domainRootEntry, updateAccessor);
        }
        return domainRootEntry;
    }

    private <T> OutlineEntry<T> doAddEntry(IViewModel.Domain domain, Object[] path, T newElement, IViewModelUpdater updateAccessor) {
        if (IViewModel.Domain.Root == domain) {
            Assert.isLegal((path.length >= 1 && path[0] instanceof IViewModel.Domain ? 1 : 0) != 0);
            domain = (IViewModel.Domain)path[0];
            Object[] newPath = new Object[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, path.length - 1);
            path = newPath;
        }
        return this.doAddEntryToDomain(domain, path, newElement, updateAccessor);
    }

    private <T> OutlineEntry<T> doAddEntryToDomain(IViewModel.Domain domain, Object[] path, T newElement, IViewModelUpdater updateAccessor) {
        OutlineEntry<Object> parent = this.fDomainRootEntries.get(domain);
        if (parent == null) {
            throw new IllegalStateException();
        }
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            OutlineEntry<Object> currentEntry = this.getExistingEntry(parent, currentElement);
            if (currentEntry == null) {
                currentEntry = this.createEntry(currentElement, parent, updateAccessor);
            }
            currentEntry.added(false);
            parent = currentEntry;
            ++n2;
        }
        Assert.isNotNull(parent);
        OutlineEntry<T> newEntry = this.getExistingEntry(parent, newElement);
        if (newEntry == null) {
            newEntry = this.createEntry(newElement, parent, updateAccessor);
        }
        parent.requestSortChildren(updateAccessor, false);
        newEntry.added(true);
        return newEntry;
    }

    private <T> OutlineEntry<T> getExistingEntry(OutlineEntry<?> parent, T element) {
        for (IViewEntry<?> candidate : parent.getChildren()) {
            if (!element.equals(candidate.getElement())) continue;
            return (OutlineEntry)candidate;
        }
        return null;
    }

    private void doRemoveEntry(OutlineEntry<?> entry, IViewModelUpdater updateAccessor) {
        Assert.isLegal((entry != null ? 1 : 0) != 0);
        if (entry.removed(true)) {
            this.unregisterEntry(entry, updateAccessor);
        }
        OutlineEntry parent = (OutlineEntry)entry.getParent();
        while (parent != null && !parent.isRootEntry()) {
            if (parent.removed(false)) {
                this.unregisterEntry(parent, updateAccessor);
            }
            parent = (OutlineEntry)parent.getParent();
        }
    }

    private <T> OutlineEntry<T> doReparentEntry(OutlineEntry<T> entry, Object[] path, IViewModelUpdater updateAccessor) {
        OutlineEntry<Object> parent = entry;
        while (!parent.isRootEntry()) {
            parent = (OutlineEntry<Object>)parent.getParent();
        }
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            parent = this.getExistingEntry(parent, currentElement);
            Assert.isNotNull(parent);
            ++n2;
        }
        return this.doReparentEntry(entry, parent, updateAccessor);
    }

    /*
     * WARNING - void declaration
     */
    private <T> OutlineEntry<T> doReparentEntry(OutlineEntry<T> entry, OutlineEntry<?> parent, IViewModelUpdater updateAccessor) {
        void var7_11;
        CopyResult<T> newEntry = entry.copy(parent);
        this.registerEntry(newEntry.entry, updateAccessor);
        parent.add(newEntry.entry, updateAccessor);
        OutlineEntry candidate = newEntry.entry;
        while (candidate != null) {
            int i = 0;
            while (i < newEntry.count) {
                candidate.added(newEntry.entry == candidate);
                ++i;
            }
            candidate = (OutlineEntry)candidate.getParent();
        }
        ArrayList children = new ArrayList(entry.getChildren());
        for (IViewEntry iViewEntry : children) {
            this.doReparentEntry((OutlineEntry)iViewEntry, newEntry.entry, updateAccessor);
        }
        boolean bl = false;
        while (var7_11 < newEntry.count) {
            this.doRemoveEntry(entry, updateAccessor);
            ++var7_11;
        }
        return newEntry.entry;
    }

    private <T> OutlineEntry<T> createEntry(T element, OutlineEntry<?> parent, IViewModelUpdater updateAccessor) {
        OutlineEntry<T> childEntry = new OutlineEntry<T>(element, parent, this, false);
        this.registerEntry(childEntry, updateAccessor);
        if (parent != null) {
            parent.add(childEntry, updateAccessor);
        }
        return childEntry;
    }

    private void registerEntry(OutlineEntry<?> entry, IViewModelUpdater updateAccessor) {
        Object key = entry.getElement();
        Set<OutlineEntry<?>> entrySet = this.fReverseItemMap.get(key);
        if (entrySet == null) {
            entrySet = new IdentityHashSet();
            this.fReverseItemMap.put(key, entrySet);
        }
        entrySet.add(entry);
    }

    private void unregisterEntry(OutlineEntry<?> entry, IViewModelUpdater updateAccessor) {
        Object key = entry.getElement();
        Set<OutlineEntry<?>> entrySet = this.fReverseItemMap.get(key);
        Assert.isNotNull(entrySet);
        if (entrySet.size() > 1) {
            entrySet.remove(entry);
        } else {
            this.fReverseItemMap.remove(key);
        }
    }

    public <T> List<IViewEntry<T>> getPrimaryEntries(final Collection<T> elements) {
        return (List)this.readModel(new IViewModelReadFunction<List<IViewEntry<T>>, RuntimeException>(){

            public List<IViewEntry<T>> run(IViewModelReader readAccessor) throws RuntimeException {
                ArrayList result = new ArrayList(elements.size());
                for (Object toSelect : elements) {
                    result.add(readAccessor.getEntryNavigator(true).findPrimaryEntry(toSelect));
                }
                return result;
            }
        });
    }

    private void aquireReadLock() {
        this.fModelLock.acquire();
    }

    private void releaseReadLock() {
        this.fModelLock.release();
    }

    private void aquireWriteLock() {
        this.fModelLock.acquire();
    }

    private void releaseWriteLock() {
        this.fModelLock.release();
    }

    protected ModelReadAccessor createReadAccessor() {
        return new ModelReadAccessor();
    }

    protected ModelUpdateAccessor createUpdateAccessor() {
        return new ModelUpdateAccessor();
    }

    public void createEntryInModel(IMappable element, IViewEntry<?> parent, IViewModelUpdater updateAccessor) {
    }

    private static class CollectUpdatesVisitor
    implements IViewEntryVisitor {
        private final List<IViewModelFunction> fViewerUpdates;
        private final OutlineModelViewer fViewer;

        public CollectUpdatesVisitor(OutlineModelViewer viewer, List<IViewModelFunction> viewerUpdates) {
            this.fViewer = viewer;
            this.fViewerUpdates = viewerUpdates;
        }

        public boolean visit(IViewEntry<? extends Object> entry) {
            return ((OutlineEntry)entry).collectUpdates(this.fViewer, this.fViewerUpdates);
        }
    }

    public static class ExpansionHull
    implements IExpansionHull {
        private final List<OutlineModelViewer.ExpansionHullEntry> fExpansionHull;

        private ExpansionHull(List<OutlineModelViewer.ExpansionHullEntry> expansionHull) {
            this.fExpansionHull = expansionHull;
        }
    }

    private static final class IdentityHashSet<E>
    extends AbstractSet<E>
    implements Set<E> {
        private static final Object DUMMY = new Object();
        private transient IdentityHashMap<E, Object> fMap = new IdentityHashMap();

        @Override
        public Iterator<E> iterator() {
            return this.fMap.keySet().iterator();
        }

        @Override
        public int size() {
            return this.fMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.fMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.fMap.containsKey(o);
        }

        @Override
        public boolean add(E o) {
            return this.fMap.put(o, DUMMY) == null;
        }

        @Override
        public boolean remove(Object o) {
            return this.fMap.remove(o) == DUMMY;
        }

        @Override
        public void clear() {
            this.fMap.clear();
        }
    }

    protected abstract class LimitedModelAccessor {
        private boolean fIsAccessGranted = true;

        protected LimitedModelAccessor() {
        }

        public final void revokeAccess() {
            this.fIsAccessGranted = false;
        }

        protected final void checkAccess() {
            if (!this.fIsAccessGranted) {
                throw new IllegalStateException("The model access has been revoked");
            }
        }

        protected final void checkAccess(IViewEntry<?> entry) {
            this.checkAccess();
            if (OutlineModel.this != entry.getModel()) {
                throw new IllegalArgumentException("ModelAccessor can't grant access to this OutlineEntry");
            }
        }

        public <V, E extends Exception> V executeUnlocked(IUnlockedViewModelFunction<V, E> code) throws E {
            this.checkAccess();
            this.fIsAccessGranted = false;
            this.unlock();
            try {
                Object object = code.run();
                return (V)object;
            }
            finally {
                this.lock();
                this.fIsAccessGranted = true;
            }
        }

        protected abstract void unlock();

        protected abstract void lock();
    }

    protected class ModelReadAccessor
    extends LimitedModelAccessor
    implements IViewModelReader {
        private EntryNavigator fVisibleEntryNavigator;
        private EntryNavigator fAllEntryNavigator;

        protected ModelReadAccessor() {
        }

        public EntryNavigator getEntryNavigator(boolean navigateVisibleOnly) {
            EntryNavigator result;
            this.checkAccess();
            EntryNavigator entryNavigator = result = navigateVisibleOnly ? this.fVisibleEntryNavigator : this.fAllEntryNavigator;
            if (result == null) {
                result = new EntryNavigator(this, (IViewModelNavigator.IViewModelNavigatorFilter)(navigateVisibleOnly ? fInvisibleFilter : null));
                if (navigateVisibleOnly) {
                    this.fVisibleEntryNavigator = result;
                } else {
                    this.fAllEntryNavigator = result;
                }
            }
            return result;
        }

        public EntryNavigator getFilterEntryNavigator(IViewModelNavigator.IViewModelNavigatorFilter filter) {
            this.checkAccess();
            return new EntryNavigator(this, filter);
        }

        public final OutlineModel getModel() {
            this.checkAccess();
            return OutlineModel.this;
        }

        public final void accept(IViewEntryVisitor visitor, IViewEntry<?> startEntry) {
            if (startEntry != null) {
                this.checkAccess(startEntry);
                ((OutlineEntry)startEntry).accept(visitor, false);
            } else {
                this.checkAccess();
                if (OutlineModel.this.fRootEntry != null) {
                    ((OutlineEntry)OutlineModel.this.fDomainRootEntries.get(IViewModel.Domain.Content)).accept(visitor, false);
                }
            }
        }

        public final OutlineEntry<?> getRootEntry(IViewModel.Domain domain) {
            this.checkAccess();
            if (domain == null) {
                domain = IViewModel.Domain.Content;
            }
            return (OutlineEntry)OutlineModel.this.fDomainRootEntries.get(domain);
        }

        public IEntryColumn getRootColumn() {
            return null;
        }

        public final boolean containsElement(Object element) {
            this.checkAccess();
            return OutlineModel.this.fReverseItemMap.containsKey(element);
        }

        public final <T> List<IViewEntry<T>> getElementEntries(T element) {
            this.checkAccess();
            return OutlineModel.this.doGetElementEntries(element);
        }

        public <T> IViewEntry<T> getElementEntry(IViewModel.Domain domain, Object[] path, T element) {
            this.checkAccess();
            throw new UnsupportedOperationException();
        }

        public final List<IViewEntry<?>> getChildren(IViewEntry<?> entry) {
            this.checkAccess(entry);
            return ((OutlineEntry)entry).getChildren();
        }

        public final IViewEntry<?> getParent(IViewEntry<?> entry) {
            this.checkAccess(entry);
            return ((OutlineEntry)entry).getParent();
        }

        @Override
        protected void unlock() {
            OutlineModel.this.releaseReadLock();
        }

        @Override
        protected void lock() {
            OutlineModel.this.aquireReadLock();
        }
    }

    private class ModelSelectionManager
    implements ISelectionProvider,
    ISelectionChangedListener {
        private final ListenerList fSelectionListeners = new ListenerList();

        private ModelSelectionManager() {
        }

        public void viewerChanges(OutlineModelViewer oldViewer, OutlineModelViewer newViewer) {
            if (oldViewer != null) {
                oldViewer.removeSelectionChangedListener(this);
            }
            if (newViewer != null) {
                newViewer.addSelectionChangedListener(this);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return this.convertToSelection(OutlineModel.this.getSelectedEntries());
        }

        public void setSelection(ISelection selection) {
            OutlineModel.this.setSelectedEntries(this.convertToEntryList(selection));
        }

        public void selectionChanged(SelectionChangedEvent viewerEvent) {
            Object[] listeners = this.fSelectionListeners.getListeners();
            if (listeners.length > 0) {
                StructuredSelection newSelection = new StructuredSelection(this.convertToEntryList(viewerEvent.getSelection()));
                final SelectionChangedEvent modelEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    final Object listener = objectArray[n2];
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            ((ISelectionChangedListener)listener).selectionChanged(modelEvent);
                        }

                        public void handleException(Throwable exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    });
                    ++n2;
                }
            }
        }

        private IStructuredSelection convertToSelection(List<IViewEntry<?>> entries) {
            return new StructuredSelection(entries.toArray());
        }

        private List<OutlineEntry<?>> convertToEntryList(ISelection selection) {
            ArrayList result = new ArrayList();
            if (selection instanceof IStructuredSelection) {
                Object[] selectedObjects = ((IStructuredSelection)selection).toArray();
                result.ensureCapacity(selectedObjects.length);
                Object[] objectArray = selectedObjects;
                int n = selectedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof OutlineEntry) {
                        result.add((OutlineEntry)object);
                    }
                    ++n2;
                }
            }
            return result;
        }
    }

    protected class ModelUpdateAccessor
    extends ModelReadAccessor
    implements IViewModelUpdater {
        protected ModelUpdateAccessor() {
        }

        public <T> OutlineEntry<T> addEntry(IViewModel.Domain domain, Object[] path, T element) {
            this.checkAccess();
            if (domain == null) {
                domain = IViewModel.Domain.Content;
            }
            return OutlineModel.this.doAddEntry(domain, path, element, this);
        }

        public boolean removeElement(IViewModel.Domain domain, Object[] path, Object element) {
            throw new UnsupportedOperationException();
        }

        public <T> OutlineEntry<T> reparentEntry(IViewEntry<T> entry, Object[] path) {
            this.checkAccess();
            return OutlineModel.this.doReparentEntry((OutlineEntry)entry, path, this);
        }

        public void update(IViewEntry<?> entry, String[] properties) {
            this.checkAccess(entry);
            ((OutlineEntry)entry).update(properties, this);
        }

        public void setTag(IViewEntry<?> entry, IViewEntryTag<?> tag) {
            this.checkAccess(entry);
            ((OutlineEntry)entry).setTag(tag);
        }

        public void clearTag(IViewEntry<?> entry, IViewEntryTag<?> tag) {
            this.checkAccess(entry);
            ((OutlineEntry)entry).clearTag(tag);
        }

        public void move(IViewEntry<?> entry, int index) {
            this.checkAccess(entry);
            if (entry.isRootEntry()) {
                throw new IllegalArgumentException("Can't move root item");
            }
            ((OutlineEntry)((OutlineEntry)entry).getParent()).move((OutlineEntry)entry, index, this);
        }

        public void requestChildrenSort(IViewEntry<?> entry, boolean forceResort) {
            this.checkAccess(entry);
            ((OutlineEntry)entry).requestSortChildren(this, forceResort);
        }

        public final void removeEntry(IViewEntry<?> entry) {
            this.checkAccess(entry);
            OutlineModel.this.doRemoveEntry((OutlineEntry)entry, this);
        }

        public boolean isModified(IViewEntry<?> entry) {
            return ((OutlineEntry)entry).hasUpdates();
        }

        @Override
        protected void unlock() {
            OutlineModel.this.releaseWriteLock();
        }

        @Override
        protected void lock() {
            OutlineModel.this.aquireWriteLock();
        }

        public void executeAfterUpdate(IViewModelFunction code) {
            this.checkAccess();
            Assert.isNotNull((Object)OutlineModel.this.fEndUpdateRunnables);
            OutlineModel.this.fEndUpdateRunnables.add(code);
        }

        public void acceptModified(IViewEntryVisitor visitor, IViewEntry<?> startEntry) {
            this.accept(visitor, startEntry);
        }
    }

    private static class PostUpdateRunnerHandle
    implements IViewModel.IPostUpdateRunnerHandle {
        public final IViewModelUpdateFunction<Void, ? extends RuntimeException> fCode;
        public final boolean fRunsBeforeFiltering;

        public PostUpdateRunnerHandle(IViewModelUpdateFunction<Void, ? extends RuntimeException> code, boolean runsBeforeFiltering) {
            this.fCode = code;
            this.fRunsBeforeFiltering = runsBeforeFiltering;
        }
    }

    private static class StartUpdateVisitor
    implements IViewEntryVisitor {
        private StartUpdateVisitor() {
        }

        public boolean visit(IViewEntry<? extends Object> entry) {
            return ((OutlineEntry)entry).doStartUpdate();
        }
    }
}

