/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.CopyResult;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryState;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.UnfilteredState;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntrySorter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.mozilla.javascript.EvaluatorException;

public class OutlineEntry<T>
implements IViewEntry<T> {
    static final boolean TRACE_OUTLINE_ENTRIES;
    private final List<Exception> DEBUGInvocationLocations = TRACE_OUTLINE_ENTRIES ? new ArrayList() : null;
    private boolean fDisposed = false;
    private final OutlineModel fModel;
    private final boolean fIsRootEntry;
    private final T fElement;
    private final String fEntryId = Integer.toHexString(System.identityHashCode(this));
    private final OutlineEntry<?> fParent;
    private int fOwnIndex = -1;
    private List<OutlineEntry<?>> fChildren;
    private List<OutlineEntry<?>> fRemovedChildren;
    private SortRequest fSortRequest = SortRequest.NONE;
    private Map<IViewEntryTag<?>, TagRefCount> fTags = new HashMap();
    private int fAddedAsNodeCount = 0;
    private int fAddedAsLeafCount = 0;
    private EntryState fState = EntryState.INITIAL;
    private UnfilteredState fUnfilteredState = null;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.apt.ide.ui/traceOutlineEntries");
        TRACE_OUTLINE_ENTRIES = value != null && value.equalsIgnoreCase("true");
    }

    protected OutlineEntry(T modelElement, OutlineEntry<?> parent, OutlineModel model, boolean isRootEntry) {
        this.fModel = model;
        this.fElement = modelElement;
        this.fParent = parent;
        this.fIsRootEntry = isRootEntry;
    }

    private OutlineEntry(OutlineEntry<T> other, OutlineEntry<?> parent) {
        Assert.isTrue((!other.fDisposed ? 1 : 0) != 0);
        this.fModel = other.fModel;
        this.fElement = other.fElement;
        this.fIsRootEntry = other.fIsRootEntry;
        this.fParent = parent;
        this.fSortRequest = other.fSortRequest;
        for (Map.Entry<IViewEntryTag<?>, TagRefCount> entry : other.fTags.entrySet()) {
            this.fTags.put(entry.getKey(), new TagRefCount(entry.getValue()));
        }
        this.fUnfilteredState = other.fUnfilteredState;
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("OutlineEntry(other:%s, parent:%s)", other.toString(), parent.toString()));
        }
    }

    public OutlineModel getModel() {
        return this.fModel;
    }

    public boolean isRootEntry() {
        return this.fIsRootEntry;
    }

    public boolean isVisible() {
        return this.fState.isVisible();
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public T getElement() {
        return this.fElement;
    }

    public boolean isAddedExplicitly() {
        return this.fAddedAsLeafCount > 0;
    }

    public int getOwnIndex() {
        if (this.fParent != null && this.fOwnIndex != -1) {
            Assert.isTrue((this.fParent.fChildren.get(this.fOwnIndex) == this ? 1 : 0) != 0);
        }
        return this.fOwnIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTag(IViewEntryTag<?> tag) {
        Map<IViewEntryTag<?>, TagRefCount> map = this.fTags;
        synchronized (map) {
            return this.fTags.containsKey(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends IViewEntryTag<?>> List<S> getTags(Class<S> tagClass) {
        Map<IViewEntryTag<?>, TagRefCount> map = this.fTags;
        synchronized (map) {
            ArrayList result = new ArrayList();
            for (IViewEntryTag<?> tag : this.fTags.keySet()) {
                if (!tagClass.isAssignableFrom(tag.getClass())) continue;
                result.add(tag);
            }
            return result;
        }
    }

    public String getIdentifier() {
        return this.fEntryId;
    }

    public boolean isMyParent(IViewEntry<?> parent) {
        return parent == this.fParent;
    }

    public boolean isMyAncestor(IViewEntry<?> ancestor) {
        return this.isMyParent(ancestor) || this.fParent != null && this.fParent.isMyAncestor(ancestor);
    }

    void added(boolean asLeaf) {
        if (asLeaf) {
            ++this.fAddedAsLeafCount;
        } else {
            ++this.fAddedAsNodeCount;
        }
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("added(asLeaf:%b) -> nLeaf:%d, nNode:%d", asLeaf, this.fAddedAsLeafCount, this.fAddedAsNodeCount));
        }
    }

    CopyResult<T> copy(OutlineEntry<?> newParent) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("copy(newParent)", new Object[0]));
        }
        OutlineEntry<T> result = new OutlineEntry<T>(this, newParent);
        return new CopyResult<T>(result, this.fAddedAsLeafCount);
    }

    boolean removed(boolean asLeaf) {
        if (asLeaf) {
            --this.fAddedAsLeafCount;
        } else {
            --this.fAddedAsNodeCount;
        }
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("removed(asLeaf:%b) -> nLeaf:%d, nNode:%d", asLeaf, this.fAddedAsLeafCount, this.fAddedAsNodeCount));
        }
        Assert.isTrue((this.fAddedAsLeafCount >= 0 && this.fAddedAsNodeCount >= 0 ? 1 : 0) != 0);
        if (this.fAddedAsLeafCount == 0 && this.fAddedAsNodeCount == 0) {
            Assert.isTrue((this.fChildren == null || this.fChildren.isEmpty() ? 1 : 0) != 0);
            this.fState = this.fState.remove();
            super.remove(this);
            return true;
        }
        return false;
    }

    void dispose() {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation("dispose()");
        }
        if (this.fChildren != null) {
            for (OutlineEntry<?> childEntry : this.fChildren) {
                childEntry.dispose();
            }
            this.fChildren.clear();
        }
        if (this.fRemovedChildren != null) {
            for (OutlineEntry<?> childEntry : this.fRemovedChildren) {
                childEntry.dispose();
            }
            this.fRemovedChildren.clear();
        }
        if (this.fTags != null) {
            this.fTags.clear();
        }
        this.fOwnIndex = -1;
        this.fDisposed = true;
    }

    void setUnfilteredState(UnfilteredState state) {
        this.fUnfilteredState = state;
    }

    UnfilteredState getUnfiltered() {
        return this.fUnfilteredState;
    }

    boolean doStartUpdate() {
        return true;
    }

    boolean hasUpdates() {
        return this.fState.hasUpdates();
    }

    boolean collectUpdates(OutlineModelViewer viewer, List<IViewModelFunction> viewerUpdates) {
        this.fState.collectUpdates(viewer, this, viewerUpdates);
        return !this.fState.includesChildUpdates(this);
    }

    void processUpdate() {
        this.processUpdate(this.fState.includesChildUpdates(this));
    }

    private void processUpdate(boolean updateChildren) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("processUpdate(updateChildren:%b)", updateChildren));
        }
        if (updateChildren && this.fChildren != null) {
            for (OutlineEntry<?> child : this.fChildren) {
                super.processUpdate(updateChildren);
            }
        }
        if (this.fRemovedChildren != null) {
            for (OutlineEntry<?> removedChild : this.fRemovedChildren) {
                removedChild.dispose();
            }
            this.fRemovedChildren.clear();
        }
        this.fState = this.fState.getUpdatedState();
    }

    IViewEntry<?> getParent() {
        return this.fParent;
    }

    List<IViewEntry<?>> getChildren() {
        return this.fChildren != null ? Collections.unmodifiableList(this.fChildren) : Collections.EMPTY_LIST;
    }

    void add(OutlineEntry<?> childEntry, IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("add(childEntry:%s, IOMU)", childEntry));
        }
        Assert.isLegal((childEntry.fParent == this ? 1 : 0) != 0);
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(childEntry);
        childEntry.fOwnIndex = this.fChildren.size() - 1;
        this.requestSortChildren(updateAccessor, false);
    }

    void show(IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("show()", new Object[0]));
        }
        this.fState = this.fState.show();
    }

    void hide(IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("hide()", new Object[0]));
        }
        this.fState = this.fState.hide();
    }

    void update(String[] properties, IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("update(%s)", Arrays.toString(properties)));
        }
        this.fState = this.fState.update(properties);
        IViewEntrySorter sorter = this.fModel.getSorter();
        if (this.fParent != null && sorter != null) {
            boolean needsResort = properties == null;
            int i = 0;
            while (!needsResort && i < properties.length) {
                needsResort = sorter.isSorterProperty(properties[i]);
                ++i;
            }
            if (needsResort) {
                this.fParent.requestSortChildren(updateAccessor, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTag(IViewEntryTag<?> tag) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("setTag(%s)", tag.toString()));
        }
        Map<IViewEntryTag<?>, TagRefCount> map = this.fTags;
        synchronized (map) {
            TagRefCount tagRefCount = this.fTags.get(tag);
            if (tagRefCount == null) {
                tagRefCount = new TagRefCount();
                this.fTags.put(tag, tagRefCount);
                this.fState = this.fState.update(null);
            } else {
                tagRefCount.incReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearTag(IViewEntryTag<?> tag) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("clearTag(%s)", tag.toString()));
        }
        Map<IViewEntryTag<?>, TagRefCount> map = this.fTags;
        synchronized (map) {
            TagRefCount tagRefCount = this.fTags.get(tag);
            if (tagRefCount != null && tagRefCount.decReference()) {
                this.fTags.remove(tag);
                this.fState = this.fState.update(null);
            }
        }
    }

    void move(OutlineEntry<?> childEntry, int newIndex, IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("move(%s, %d)", childEntry.toString(), newIndex));
        }
        Assert.isLegal((childEntry.getParent() == this ? 1 : 0) != 0);
        Assert.isTrue((this.fChildren != null ? 1 : 0) != 0);
        Assert.isLegal((newIndex >= 0 && newIndex <= this.fChildren.size() ? 1 : 0) != 0);
        int oldIndex = childEntry.getOwnIndex();
        Assert.isLegal((oldIndex >= 0 && oldIndex < this.fChildren.size() ? 1 : 0) != 0);
        Assert.isLegal((this.fChildren.get(oldIndex) == childEntry ? 1 : 0) != 0);
        if (oldIndex != newIndex) {
            this.fChildren.remove(oldIndex);
            int insertIndex = newIndex < oldIndex ? newIndex : newIndex - 1;
            this.fChildren.add(insertIndex, childEntry);
            int i = Math.min(insertIndex, oldIndex);
            while (i < this.fChildren.size()) {
                this.fChildren.get((int)i).fOwnIndex = i;
                ++i;
            }
            if (!childEntry.fState.isAdd()) {
                this.fState = this.fState.resort();
            }
            this.requestSortChildren(updateAccessor, false);
        }
    }

    void refresh(IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("refresh()", new Object[0]));
        }
        this.fState = this.fState.refresh();
    }

    void requestSortChildren(IViewModelUpdater updateAccessor, boolean forceResort) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("requestSortChildren(...)", new Object[0]));
        }
        this.fSortRequest = this.fSortRequest.getSortRequest(forceResort);
    }

    void doPendingSort(IViewModelUpdater updateAccessor) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("doPendingSort(...)", new Object[0]));
        }
        if (this.fSortRequest != SortRequest.NONE) {
            IViewEntrySorter sorter = this.fModel.getSorter();
            if (sorter != null && this.fChildren != null) {
                sorter.sort(this.fChildren, (IViewModelReader)updateAccessor, this.fSortRequest == SortRequest.FULLSORT);
                boolean hasChanges = false;
                int indexDelta = 0;
                int i = 0;
                while (i < this.fChildren.size()) {
                    OutlineEntry<?> childEntry = this.fChildren.get(i);
                    if (childEntry.fState.isAdd()) {
                        ++indexDelta;
                    } else if (childEntry.fOwnIndex + indexDelta != i) {
                        hasChanges = true;
                    }
                    childEntry.fOwnIndex = i++;
                }
                if (hasChanges) {
                    this.fState = this.fState.resort();
                }
            }
            this.fSortRequest = SortRequest.NONE;
        }
    }

    private void remove(OutlineEntry<?> childEntry) {
        if (TRACE_OUTLINE_ENTRIES) {
            this.recordInvocation(String.format("remove(childEntry:%s)", childEntry));
        }
        Assert.isLegal((childEntry.fParent == this ? 1 : 0) != 0);
        Assert.isTrue((this.fChildren != null ? 1 : 0) != 0);
        if (this.fRemovedChildren == null) {
            this.fRemovedChildren = new ArrayList();
        }
        this.fRemovedChildren.add(childEntry);
        int oldIndex = childEntry.fOwnIndex;
        childEntry.fOwnIndex = -1;
        Assert.isTrue((this.fChildren.get(oldIndex) == childEntry ? 1 : 0) != 0);
        this.fChildren.remove(oldIndex);
        int i = oldIndex;
        while (i < this.fChildren.size()) {
            this.fChildren.get((int)i).fOwnIndex = i;
            ++i;
        }
    }

    void accept(IViewEntryVisitor visitor, boolean visitDeleted) {
        if (visitDeleted && this.fRemovedChildren != null) {
            for (OutlineEntry<?> entry : this.fRemovedChildren) {
                entry.accept(visitor, visitDeleted);
            }
        }
        if (visitor.visit((IViewEntry)this) && this.fChildren != null) {
            for (OutlineEntry<?> entry : this.fChildren) {
                entry.accept(visitor, visitDeleted);
            }
        }
    }

    public void setChildrenResolver(Object resolver) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordInvocation(String reason) {
        List<Exception> list = this.DEBUGInvocationLocations;
        synchronized (list) {
            EvaluatorException exception = new EvaluatorException(reason);
            exception.getStackTrace();
            this.DEBUGInvocationLocations.add((Exception)exception);
        }
    }

    public String toString() {
        String entryInfo = "?";
        if (this.fElement instanceof PlanItem) {
            entryInfo = Integer.valueOf(((PlanItem)this.fElement).getId()).toString();
        } else if (this.fElement instanceof GroupElement) {
            entryInfo = ((GroupElement)this.fElement).getLabel();
        }
        return String.format("%08x: OutlineEntry<%s (%s)>%s tags:%s state:%s nNode:%d nLeaf:%d children:%d deleted:%d", System.identityHashCode(this), this.fElement.getClass().getSimpleName(), entryInfo, this.isDisposed() ? "**DISPOSED** " : "", this.fTags != null ? Arrays.toString(this.fTags.values().toArray()) : "", this.fState.getClass().getSimpleName(), this.fAddedAsNodeCount, this.fAddedAsLeafCount, this.fChildren != null ? this.fChildren.size() : 0, this.fRemovedChildren != null ? this.fRemovedChildren.size() : 0);
    }

    public boolean hasUnloadedChildren() {
        return false;
    }

    private static enum SortRequest {
        NONE{

            @Override
            public SortRequest getSortRequest(boolean forceResort) {
                return forceResort ? FULLSORT : NORMAL;
            }
        }
        ,
        NORMAL{

            @Override
            public SortRequest getSortRequest(boolean forceResort) {
                return forceResort ? FULLSORT : NORMAL;
            }
        }
        ,
        FULLSORT{

            @Override
            public SortRequest getSortRequest(boolean forceResort) {
                return FULLSORT;
            }
        };


        public abstract SortRequest getSortRequest(boolean var1);
    }

    private class TagRefCount {
        private int fReferenceCount;

        public TagRefCount(TagRefCount other) {
            this.fReferenceCount = other.fReferenceCount;
        }

        public TagRefCount() {
            this.fReferenceCount = 1;
        }

        public void incReference() {
            Assert.isTrue((this.fReferenceCount > 0 ? 1 : 0) != 0);
            ++this.fReferenceCount;
        }

        public boolean decReference() {
            Assert.isTrue((this.fReferenceCount > 0 ? 1 : 0) != 0);
            return --this.fReferenceCount == 0;
        }
    }
}

