/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EntryUtils {
    public static boolean isType(IViewEntry<?> entry, Class<?> type) {
        return type.isInstance(EntryUtils.element(entry));
    }

    public static <T> IViewEntry<T> cast(IViewEntry<?> entry, Class<T> type) {
        if (!EntryUtils.isType(entry, type)) {
            throw new ClassCastException(NLS.bind((String)"Can't cast IViewEntry<?> to IViewEntry<{0}>", (Object)type.getName(), (Object[])new Object[0]));
        }
        return entry;
    }

    public static <T> List<T> elements(Collection<IViewEntry<T>> entries) {
        ArrayList<Object> result = new ArrayList<Object>(entries.size());
        for (IViewEntry<T> entry : entries) {
            result.add(entry.getElement());
        }
        return result;
    }

    public static <T> T element(IViewEntry<T> entry) {
        return (T)(entry != null ? entry.getElement() : null);
    }

    public static <T> T element(IViewEntry<?> entry, Class<T> type) {
        return (T)(EntryUtils.isType(entry, type) ? EntryUtils.cast(entry, type).getElement() : null);
    }

    public static <T> T firstElement(Collection<IViewEntry<T>> entries) {
        return EntryUtils.element(EntryUtils.firstEntry(entries));
    }

    public static <T> T lastElement(Collection<IViewEntry<T>> entries) {
        return EntryUtils.element(EntryUtils.lastEntry(entries));
    }

    public static <T> List<T> elementsOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.elements(EntryUtils.entriesOfType(entries, typeClass));
    }

    public static <T> T firstElementOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.element(EntryUtils.firstEntryOfType(entries, typeClass));
    }

    public static <T> T lastElementOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.element(EntryUtils.lastEntryOfType(entries, typeClass));
    }

    public static <T> IViewEntry<T> firstEntry(Collection<IViewEntry<T>> entries) {
        Iterator<IViewEntry<T>> entryIterator = entries.iterator();
        return entryIterator.hasNext() ? entryIterator.next() : null;
    }

    public static <T> IViewEntry<T> lastEntry(Collection<IViewEntry<T>> entries) {
        Iterator<IViewEntry<T>> entryIterator = entries.iterator();
        IViewEntry<T> result = null;
        while (entryIterator.hasNext()) {
            result = entryIterator.next();
        }
        return result;
    }

    public static <T> Collection<IViewEntry<T>> entriesWithTag(Collection<IViewEntry<T>> entries, EntryTag<?> tag) {
        ArrayList<IViewEntry<T>> result = new ArrayList<IViewEntry<T>>();
        for (IViewEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> IViewEntry<T> firstEntryWithTag(Collection<IViewEntry<T>> entries, EntryTag<?> tag) {
        for (IViewEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            return entry;
        }
        return null;
    }

    public static <T> IViewEntry<T> lastEntryWithTag(Collection<IViewEntry<T>> entries, EntryTag<?> tag) {
        IViewEntry<T> result = null;
        for (IViewEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            result = entry;
        }
        return result;
    }

    public static <T> List<IViewEntry<T>> entriesOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        ArrayList<IViewEntry<T>> result = new ArrayList<IViewEntry<T>>();
        for (IViewEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> IViewEntry<T> firstEntryOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        for (IViewEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            return entry;
        }
        return null;
    }

    public static <T> IViewEntry<T> lastEntryOfType(Collection<IViewEntry<?>> entries, Class<T> typeClass) {
        IViewEntry<?> result = null;
        for (IViewEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            result = entry;
        }
        return result;
    }
}

