/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.AddEntryRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.RefreshEntryRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.RemoveEntryRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ResortEntryRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.UpdateEntryRunnable;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;

abstract class EntryState {
    public static final EntryState INITIAL = new ShowTransition(new HiddenState());
    private final boolean fIsVisible;

    protected EntryState(boolean visible) {
        this.fIsVisible = visible;
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    public abstract EntryState show();

    public abstract EntryState hide();

    public abstract EntryState update(String[] var1);

    public abstract EntryState resort();

    public abstract EntryState refresh();

    public abstract EntryState remove();

    public abstract boolean hasUpdates();

    public boolean isAdd() {
        return false;
    }

    public abstract void collectUpdates(OutlineModelViewer var1, OutlineEntry<?> var2, List<IViewModelFunction> var3);

    public abstract EntryState getUpdatedState();

    public abstract boolean includesChildUpdates(OutlineEntry<?> var1);

    private static abstract class AbstractState
    extends EntryState {
        protected AbstractState(boolean visible) {
            super(visible);
        }

        @Override
        public EntryState show() {
            return new ShowTransition(this);
        }

        @Override
        public EntryState hide() {
            return new HideTransition(this);
        }

        @Override
        public EntryState update(String[] properties) {
            return new UpdateTransition(this, properties);
        }

        @Override
        public EntryState resort() {
            return new ResortTransition(this);
        }

        @Override
        public EntryState refresh() {
            return new RefreshTransition(this);
        }

        @Override
        public EntryState remove() {
            return new RemoveTransition(this);
        }

        @Override
        public boolean hasUpdates() {
            return false;
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
        }

        @Override
        public EntryState getUpdatedState() {
            return this;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return false;
        }
    }

    private static abstract class AbstractStateTransition
    extends EntryState {
        protected final AbstractState fRootState;

        protected AbstractStateTransition(AbstractState rootState, boolean visible) {
            super(visible);
            this.fRootState = rootState;
        }

        @Override
        public EntryState show() {
            return this.isVisible() ? this : this.fRootState.show();
        }

        @Override
        public EntryState hide() {
            return !this.isVisible() ? this : this.fRootState.hide();
        }

        @Override
        public EntryState update(String[] properties) {
            return !this.isVisible() ? this : this.fRootState.update(properties);
        }

        @Override
        public EntryState resort() {
            return !this.isVisible() ? this : this.fRootState.resort();
        }

        @Override
        public EntryState refresh() {
            return !this.isVisible() ? this : this.fRootState.refresh();
        }

        @Override
        public EntryState remove() {
            return this.fRootState.remove();
        }

        @Override
        public boolean hasUpdates() {
            return true;
        }
    }

    private static class HiddenState
    extends AbstractState {
        public static final HiddenState INSTANCE = new HiddenState();

        private HiddenState() {
            super(false);
        }

        @Override
        public EntryState hide() {
            return this;
        }

        @Override
        public EntryState update(String[] properties) {
            return this;
        }

        @Override
        public EntryState resort() {
            return this;
        }

        @Override
        public EntryState refresh() {
            return this;
        }
    }

    private static class HideTransition
    extends AbstractStateTransition {
        protected HideTransition(AbstractState rootState) {
            super(rootState, false);
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            viewerUpdates.add(new RemoveEntryRunnable(viewer, entry, true));
        }

        @Override
        public EntryState getUpdatedState() {
            return HiddenState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return true;
        }
    }

    private static class RefreshTransition
    extends AbstractStateTransition {
        protected RefreshTransition(AbstractState rootState) {
            super(rootState, true);
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            viewerUpdates.add(new RefreshEntryRunnable(viewer, entry));
        }

        @Override
        public EntryState update(String[] properties) {
            return this;
        }

        @Override
        public EntryState resort() {
            return this;
        }

        @Override
        public EntryState getUpdatedState() {
            return ShownState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return true;
        }
    }

    private static class RemoveTransition
    extends AbstractStateTransition {
        protected RemoveTransition(AbstractState rootState) {
            super(rootState, false);
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            viewerUpdates.add(new RemoveEntryRunnable(viewer, entry, false));
        }

        @Override
        public EntryState getUpdatedState() {
            return HiddenState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return true;
        }
    }

    private static class ResortTransition
    extends AbstractStateTransition {
        protected ResortTransition(AbstractState rootState) {
            super(rootState, true);
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            viewerUpdates.add(new ResortEntryRunnable(viewer, entry));
        }

        @Override
        public EntryState update(String[] properties) {
            return new RefreshTransition(this.fRootState);
        }

        @Override
        public EntryState resort() {
            return this;
        }

        @Override
        public EntryState getUpdatedState() {
            return ShownState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return false;
        }
    }

    private static class ShowTransition
    extends AbstractStateTransition {
        protected ShowTransition(AbstractState rootState) {
            super(rootState, true);
        }

        @Override
        public EntryState update(String[] properties) {
            return this;
        }

        @Override
        public EntryState resort() {
            return this;
        }

        @Override
        public EntryState refresh() {
            return this;
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            if (entry.isRootEntry()) {
                Assert.isTrue((this == INITIAL ? 1 : 0) != 0);
                viewerUpdates.add(new RefreshEntryRunnable(viewer, entry));
            } else {
                viewerUpdates.add(new AddEntryRunnable(viewer, entry));
            }
        }

        @Override
        public EntryState getUpdatedState() {
            return ShownState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return true;
        }

        @Override
        public boolean isAdd() {
            return true;
        }
    }

    private static class ShownState
    extends AbstractState {
        public static final ShownState INSTANCE = new ShownState();

        private ShownState() {
            super(true);
        }

        @Override
        public EntryState show() {
            return this;
        }
    }

    private static class UpdateTransition
    extends AbstractStateTransition {
        private final String[] fProperties;

        protected UpdateTransition(AbstractState rootState, String[] properties) {
            super(rootState, true);
            this.fProperties = properties;
        }

        @Override
        public EntryState update(String[] properties) {
            String property;
            if (properties == null || this.fProperties == null) {
                return super.update(null);
            }
            HashSet<String> mergedProperties = new HashSet<String>();
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                property = stringArray[n2];
                mergedProperties.add(property);
                ++n2;
            }
            stringArray = this.fProperties;
            n = this.fProperties.length;
            n2 = 0;
            while (n2 < n) {
                property = stringArray[n2];
                mergedProperties.add(property);
                ++n2;
            }
            return super.update(mergedProperties.toArray(new String[mergedProperties.size()]));
        }

        @Override
        public EntryState resort() {
            return new RefreshTransition(this.fRootState);
        }

        @Override
        public void collectUpdates(OutlineModelViewer viewer, OutlineEntry<?> entry, List<IViewModelFunction> viewerUpdates) {
            viewerUpdates.add(new UpdateEntryRunnable(viewer, entry, this.fProperties));
        }

        @Override
        public EntryState getUpdatedState() {
            return ShownState.INSTANCE;
        }

        @Override
        public boolean includesChildUpdates(OutlineEntry<?> entry) {
            return false;
        }
    }
}

