/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class EntryNavigator
implements IViewModelNavigator {
    private final IViewModelReader fReadAccessor;
    private IViewModelNavigator.IViewModelNavigatorFilter fEntryFilter;

    EntryNavigator(IViewModelReader readAccessor, IViewModelNavigator.IViewModelNavigatorFilter filter) {
        this.fReadAccessor = readAccessor;
        this.fEntryFilter = filter;
    }

    public <T> IViewEntry<T> findPrimaryEntry(T element) {
        return this.firstEntryWithTag(this.fReadAccessor.getElementEntries(element), PrimaryLocationTag.INSTANCE);
    }

    public <T> IViewEntry<T> findFirstEntryWithTag(T element, IViewEntryTag<?> tag) {
        return this.firstEntryWithTag(this.fReadAccessor.getElementEntries(element), tag);
    }

    public <T> IViewEntry<T> findFirstEntryInSubtree(T element, IViewEntry<?> searchRoot) {
        for (IViewEntry entry : this.fReadAccessor.getElementEntries(element)) {
            if (!this.isIncluded(entry) || !this.startsWith(entry, searchRoot)) continue;
            return entry;
        }
        return null;
    }

    public Object parentElement(IViewEntry<?> entry) {
        return EntryUtils.element(this.parentEntry(entry));
    }

    public Object parentElement(IViewEntry<?> entry, int level) {
        return EntryUtils.element(this.parentEntry(entry, level));
    }

    public List<Object> children(IViewEntry<?> entry) {
        return EntryNavigator.doGetElements(this.childEntries(entry));
    }

    public List<Object> siblings(IViewEntry<?> entry) {
        return EntryNavigator.doGetElements(this.siblingEntries(entry));
    }

    public Object firstSibling(IViewEntry<?> entry) {
        return EntryUtils.element(this.firstSiblingEntry(entry));
    }

    public Object lastSibling(IViewEntry<?> entry) {
        return EntryUtils.element(this.lastSiblingEntry(entry));
    }

    public Object predecessor(IViewEntry<?> entry) {
        return EntryUtils.element(this.predecessorEntry(entry));
    }

    public Object successor(IViewEntry<?> entry) {
        return EntryUtils.element(this.predecessorEntry(entry));
    }

    public IViewEntry<?> parentEntry(IViewEntry<?> entry) {
        return this.fReadAccessor.getParent(entry);
    }

    public IViewEntry<?> parentEntry(IViewEntry<?> entry, int level) {
        if (level < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = level;
        while (entry != null && i > 0) {
            entry = this.fReadAccessor.getParent(entry);
            --i;
        }
        return entry;
    }

    public <T> IViewEntry<T> parentEntryOfType(IViewEntry<?> entry, Class<T> typeClass) {
        while (entry != null) {
            if (typeClass.isInstance(entry.getElement())) {
                return entry;
            }
            entry = this.fReadAccessor.getParent(entry);
        }
        return null;
    }

    public List<IViewEntry<?>> childEntries(IViewEntry<?> entry) {
        return this.filterInvisible(this.fReadAccessor.getChildren(entry));
    }

    public List<IViewEntry<?>> siblingEntries(IViewEntry<?> entry) {
        IViewEntry parent = this.fReadAccessor.getParent(entry);
        return parent != null ? this.filterInvisible(this.fReadAccessor.getChildren(parent)) : null;
    }

    public IViewEntry<?> firstSiblingEntry(IViewEntry<?> entry) {
        List<IViewEntry<?>> siblings = this.siblingEntries(entry);
        return siblings != null ? siblings.get(0) : null;
    }

    public IViewEntry<?> lastSiblingEntry(IViewEntry<?> entry) {
        List<IViewEntry<?>> siblings = this.siblingEntries(entry);
        return siblings != null ? siblings.get(siblings.size() - 1) : null;
    }

    public IViewEntry<?> predecessorEntry(IViewEntry<?> entry) {
        List<IViewEntry<?>> siblings = this.siblingEntries(entry);
        if (siblings != null && !siblings.isEmpty()) {
            int index = siblings.indexOf(entry);
            Assert.isTrue((index != -1 ? 1 : 0) != 0);
            if (index > 0) {
                return siblings.get(index - 1);
            }
        }
        return null;
    }

    public IViewEntry<?> successorEntry(IViewEntry<?> entry) {
        List<IViewEntry<?>> siblings = this.siblingEntries(entry);
        if (siblings != null && !siblings.isEmpty()) {
            int index = siblings.indexOf(entry);
            Assert.isTrue((index != -1 ? 1 : 0) != 0);
            if (index < siblings.size() - 1) {
                return siblings.get(index + 1);
            }
        }
        return null;
    }

    public int index(IViewEntry<?> entry) {
        return entry != null ? this.siblingEntries(entry).indexOf(entry) : -1;
    }

    public boolean startsWith(IViewEntry<?> entry, IViewEntry<?> prefix) {
        while (entry != null) {
            if (entry == prefix) {
                return true;
            }
            entry = this.fReadAccessor.getParent(entry);
        }
        return false;
    }

    public boolean isFirst(IViewEntry<?> entry) {
        return entry == this.firstSiblingEntry(entry);
    }

    public boolean isLast(IViewEntry<?> entry) {
        return entry == this.lastSiblingEntry(entry);
    }

    public int indexOf(IViewEntry<?> entry, Class<?> elementClass) {
        int result = 0;
        while (entry != null) {
            if (elementClass.isInstance(entry.getElement())) {
                return result;
            }
            entry = this.fReadAccessor.getParent(entry);
            ++result;
        }
        return -1;
    }

    private boolean isIncluded(IViewEntry<?> entry) {
        return this.fEntryFilter == null || this.fEntryFilter.select(entry);
    }

    private List<IViewEntry<?>> filterInvisible(List<IViewEntry<?>> entries) {
        if (this.fEntryFilter == null) {
            return entries;
        }
        ArrayList result = new ArrayList(entries.size());
        for (IViewEntry<?> entry : entries) {
            if (!this.isIncluded(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private static List<Object> doGetElements(List<IViewEntry<?>> entries) {
        ArrayList<Object> result = new ArrayList<Object>(entries.size());
        for (IViewEntry<?> entry : entries) {
            result.add(entry.getElement());
        }
        return result;
    }

    private <T> IViewEntry<T> firstEntryWithTag(List<IViewEntry<T>> entries, IViewEntryTag<?> tag) {
        for (IViewEntry<T> entry : entries) {
            if (!this.isIncluded(entry) || !entry.hasTag(tag)) continue;
            return entry;
        }
        return null;
    }

    public <T> IViewEntry<T> findIncludedEntry(T element) {
        return null;
    }
}

