/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntryUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.UnfilteredState;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.core.runtime.Assert;

class AddEntryRunnable
extends OutlineEntryUpdateRunnable {
    public AddEntryRunnable(OutlineModelViewer viewer, OutlineEntry<?> entry) {
        super(viewer, entry);
        Assert.isLegal((!entry.isRootEntry() ? 1 : 0) != 0, (String)"Can't add root entry to viewer!");
    }

    @Override
    protected void doRun() {
        OutlineEntry<?> entry = this.getEntry();
        OutlineEntry parentEntry = (OutlineEntry)entry.getParent();
        Object parentElement = parentEntry.isRootEntry() ? entry.getModel() : parentEntry;
        this.getViewer().add(parentElement, entry);
        super.doRun();
        this.restoreState(entry);
    }

    private void restoreState(OutlineEntry<?> entry) {
        UnfilteredState unfilteredState;
        if (entry.isVisible() && (unfilteredState = entry.getUnfiltered()) != null) {
            this.getViewer().setExpandedState(entry, unfilteredState.wasExpanded());
            entry.setUnfilteredState(null);
            for (IViewEntry<?> child : entry.getChildren()) {
                this.restoreState((OutlineEntry)child);
            }
        }
    }
}

