/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SummaryEditor
extends AbstractTextEditor {
    private IViewEntry<PlanItem> fEntry;
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SummaryEditor.this.fireContentChanged();
        }
    };
    private FocusListener fFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            SummaryEditor.this.stopEditSession();
        }
    };

    public SummaryEditor(Composite parent, int style) {
        super(parent, style | 4 | 0x800);
    }

    @Override
    public IViewEntry<?> getEntry() {
        return this.fEntry;
    }

    @Override
    public void transferOwnership(PlanItemGadget gadget) {
        this.setOwner(gadget.getSummary());
        this.fEntry = (IViewEntry)gadget.getOutlineItem().getData();
    }

    @Override
    public boolean isOwner(PlanItemGadget gadget) {
        return this.getOwner() == gadget.getSummary();
    }

    @Override
    protected StyledText createStyledText(Composite parent, int style) {
        StyledText result = new StyledText(parent, style);
        result.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (131072 == e.stateMask && 9 == e.keyCode) {
                    e.doit = false;
                }
            }
        });
        result.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.keyCode == 13 && (event.stateMask == 0 || (event.stateMask & 0x10000) != 0) || event.keyCode == 0x1000050 && ((event.stateMask & 0x20000) != 0 || (event.stateMask & 0x10000) != 0)) {
                    event.doit = false;
                }
            }
        });
        return result;
    }

    @Override
    protected String getTextContent() {
        return this.fEditControl.getText();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void startEditSession(GText newOwner, IViewEntry<?> entry, Transformation transformation) {
        this.stopEditSession();
        if (newOwner != null && entry != null && entry.getElement() instanceof PlanItem) {
            this.setOwner(newOwner);
            this.fEntry = entry;
            Rectangle bounds = transformation.toViewPort(this.getOwner().getBounds());
            this.setBounds(bounds);
            this.fMaximumWidth = this.getOwner().getMaximumWidth();
            this.fEditControl.setText(this.getPlanItem().getHTMLSummary().getPlainText());
            this.getOwner().startEditSession(this);
            this.fEditControl.setVisible(true);
            this.fEditControl.setFocus();
            this.fEditControl.addModifyListener(this.fModifyListener);
            this.fEditControl.addFocusListener(this.fFocusListener);
        } else {
            this.fEditControl.removeModifyListener(this.fModifyListener);
            this.fEditControl.removeFocusListener(this.fFocusListener);
            this.fEditControl.setVisible(false);
        }
    }

    @Override
    public void storeData() {
        PlanItem planItem = this.getPlanItem();
        if (planItem != null && planItem.isConnected()) {
            planItem.setHTMLSummary(XMLString.createFromPlainText((String)this.fEditControl.getText()));
        }
    }

    @Override
    public void cancelEditSession() {
        this.stopEditSession(false);
    }

    @Override
    public void stopEditSession() {
        this.stopEditSession(true);
    }

    private void stopEditSession(boolean store) {
        if (this.getOwner() != null) {
            this.fEditControl.removeModifyListener(this.fModifyListener);
            this.fEditControl.removeFocusListener(this.fFocusListener);
            this.fEditControl.setVisible(false);
            if (store) {
                this.storeData();
            } else {
                this.getOwner().setText(this.getPlanItem().getHTMLSummary().getPlainText());
            }
            if (this.getOwner() != null) {
                this.getOwner().stopEditSession(this);
            }
            this.setOwner(null);
            this.fEntry = null;
            this.fEditControl.setText("");
        }
    }

    private PlanItem getPlanItem() {
        return this.fEntry != null ? (PlanItem)this.fEntry.getElement() : null;
    }
}

