/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanItemWorkItemAttribute;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GConstraintType;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GDate;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GDecimal;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GDuration;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GEmptyCell;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GOwner;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GPlanningAttribute;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GReferenceAttribute;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GState;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.common.structure.CustomFieldTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.FieldTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GProbability;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.common.model.IAttribute;

public class PlanItemColumnFactory {
    private static PlanItemColumnFactory fgInstance;

    public static PlanItemColumnFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new PlanItemColumnFactory();
        }
        return fgInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Gadget createItem(FieldTag field, PlanItem planItem, IViewEntry<?> outlineEntry, GStatusLine parent) {
        if (((String)FieldTag.STATE.getValue()).equalsIgnoreCase((String)field.getValue())) {
            if (planItem.getWorkflowInfo() == null) return new GEmptyCell(parent);
            return new GState(parent, planItem, 0x1000000);
        }
        if (((String)FieldTag.OWNER.getValue()).equalsIgnoreCase((String)field.getValue())) {
            if (!"com.ibm.team.apt.ide.planmode.PersonalMode".equals(((PlanItemOutline)parent.getOutline()).getSettings().getId())) return new GOwner(parent, planItem, 0x1000000);
            return null;
        }
        if (((String)FieldTag.COMPLEXITY.getValue()).equalsIgnoreCase((String)field.getValue())) {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)planItem.getPlan();
            IComplexityAttribute complexityAttribute = plan.getComplexityAttribute();
            if (complexityAttribute == null) {
                return new GEmptyCell(parent);
            }
            IPlanningAttribute attribute = plan.findAttribute(PlanningAttributeIdentifier.create((String)complexityAttribute.getAttributeId()));
            if (attribute == null || !attribute.isSupported(PlanItem.class) || !attribute.isDefined((Object)planItem)) {
                return new GEmptyCell(parent);
            }
            GPlanningAttribute gadget = new GPlanningAttribute(parent, planItem, attribute, 0x1000000);
            String label = gadget.getLabel();
            try {
                Long.parseLong(label);
                gadget.setLabel(String.valueOf(label) + ' ' + complexityAttribute.getShortDisplayName());
                return gadget;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return gadget;
        }
        if (!(field instanceof CustomFieldTag)) return null;
        String planAttributeId = (String)field.getValue();
        IPlanningAttribute attribute = planItem.getPlan().findAttribute(PlanningAttributeIdentifier.create((String)planAttributeId));
        if (attribute == null || !attribute.isSupported(PlanItem.class)) return this.createNotSupportedLabel(parent, planAttributeId, attribute);
        if (attribute.getAttributeType() == PlanningAttributeType.DURATION) {
            if (planItem.isTopLevelPlanItem()) return new GEmptyCell(parent);
            return new GDuration(parent, planItem, (IPlanningAttributeIdentifier)attribute, 0x1000000);
        }
        if (attribute.getAttributeType() == PlanningAttributeType.REFERENCE) {
            return new GReferenceAttribute(parent, planItem, attribute);
        }
        if (attribute.getAttributeType() == PlanningAttributeType.DECIMAL) {
            return new GDecimal(parent, planItem, attribute, PlanningAttributeIdentifier.create((String)planAttributeId), 0x1000000);
        }
        if (attribute.getAttributeType() == PlanningAttributeType.TIMESPAN) {
            return this.createNotSupportedLabel(parent, planAttributeId, attribute);
        }
        if (attribute.getAttributeType() == PlanningAttributeType.INSTANT) {
            if (attribute.isDefined((Object)planItem)) return new GDate(parent, planItem, attribute, PlanningAttributeIdentifier.create((String)planAttributeId), 0x1000000);
            return this.createNotSupportedLabel(parent, planAttributeId, attribute);
        }
        if (!attribute.isDefined((Object)planItem)) return new GEmptyCell(parent);
        if ("com.ibm.team.tempo.probability".equals(planAttributeId)) {
            return new GProbability(parent, planItem, attribute, 0x1000000);
        }
        if (PlanItem.CONSTRAINT_TYPE.equals(PlanningAttributeIdentifier.create((String)planAttributeId))) {
            new GConstraintType(parent, planItem, attribute, 0x1000000);
            return null;
        } else {
            PlanItemWorkItemAttribute planItemWorkItemAttribute;
            IAttribute workItemAttribute;
            if (attribute instanceof PlanItemWorkItemAttribute && (workItemAttribute = (planItemWorkItemAttribute = (PlanItemWorkItemAttribute)attribute).getAttribute()).getAttributeType().equals("deliverable")) {
                return this.createNotSupportedLabel(parent, planAttributeId, attribute);
            }
            new GPlanningAttribute(parent, planItem, attribute, 0x1000000);
        }
        return null;
    }

    private Gadget createNotSupportedLabel(GStatusLine parent, String planAttributeId, IPlanningAttribute<PlanItem, ?> attribute) {
        GLabel notSupportedLabel = new GLabel(parent, Messages.PlanItemColumnFactory_NOT_AVAILABLE, 0);
        notSupportedLabel.setToolTipText(NLS.bind((String)Messages.PlanItemColumnFactory_NOT_AVAILABLE_TOOLTIP, (Object)(attribute != null ? attribute.getDisplayName() : planAttributeId), (Object[])new Object[0]));
        notSupportedLabel.setColor(((PlanOutlineResources)parent.getOutlineResources()).getNoContentColor());
        return notSupportedLabel;
    }
}

