/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.internal.client.progress.ProgressScriptEnvironment;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.progress.IProgressComputer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

public abstract class GroupNodeContent
extends GTreeNodeContent {
    protected GLabel fNameLabel;
    protected GLabel fStatusLabel;
    private int fOpen;
    private int fClosed;
    private Insets fInsets;

    protected GroupNodeContent(GTreeNode parent, IViewEntry<? extends GroupElement> groupEntry, String title) {
        super(parent);
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fNameLabel = new GLabel(this, title, 64);
        this.fNameLabel.setColor(resources.getGroupTextColor());
        this.fNameLabel.setFont(resources.getGroupTextFont());
        this.fNameLabel.setReturnParentElement(true);
        int[] openClosedCount = this.getOpenCloseCount(groupEntry);
        this.fOpen = openClosedCount[0];
        this.fClosed = openClosedCount[1];
        this.fStatusLabel = new GLabel(this, NLS.bind((String)Messages.GroupNodeContent_CLOSED_OPEN_COUNT, (Object)this.fClosed, (Object[])new Object[]{this.fOpen}), 64);
        this.fStatusLabel.setColor(resources.getGroupTextColor());
        this.fStatusLabel.setFont(resources.getGroupStatusFont());
        this.fInsets = new Insets(3, 5, 3, 5);
    }

    protected IProgressInformation getProgressInformation(IViewEntry<?> entry) {
        Object option = ((PlanViewModel)entry.getModel()).getOption(IProgressComputer.class);
        if (option instanceof IProgressComputer) {
            return ((IProgressComputer)option).getProgress(entry);
        }
        return (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)ProgressScriptEnvironment.createScriptEnvironment(), IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
    }

    protected int[] getOpenCloseCount(IViewEntry<? extends GroupElement> groupEntry) {
        IProgressInformation progressInformation = this.getProgressInformation(groupEntry);
        return new int[]{progressInformation.getOpenCount(), progressInformation.getCloseCount()};
    }

    @Override
    public Insets getInsets() {
        return this.fInsets;
    }

    @Override
    public int computeMinimalWidth() {
        return this.max(this.fNameLabel.computeMinimalWidth(), this.fStatusLabel.computeMinimalWidth());
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        this.fNameLabel.layout(x, y, -1, -1);
        this.fStatusLabel.layout(x, y += this.fNameLabel.getHeight(), -1, -1);
        return new Point(this.max(wHint, this.fNameLabel.getWidth(), this.fStatusLabel.getWidth()), this.fNameLabel.getHeight() + this.fStatusLabel.getHeight());
    }

    public int getOpenCount() {
        return this.fOpen;
    }

    public int getClosedCount() {
        return this.fClosed;
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    protected int height(Font font) {
        FontData[] data;
        if (font == null) {
            font = this.getPlanOutlineResources().getTextFonts().getNormalFont();
        }
        int result = 0;
        FontData[] fontDataArray = data = font.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            result = Math.max(result, fontData.getHeight());
            ++n2;
        }
        return result;
    }
}

