/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.ValueSetDropDownAction;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GState
extends GStatusLineItem {
    private static final Identifier<IWorkflowAction> CLEAR_ACTION = Identifier.create(IWorkflowAction.class, (String)"782437_xxx_clear_xxx_action");
    private final PlanItem fPlanItem;
    private final LocalResourceManager fResourceManager;

    private static String getText(PlanItem planItem) {
        if (planItem.getWorkflowAction() == null) {
            return planItem.getWorkflowInfo().getStateName(planItem.getState());
        }
        return planItem.getWorkflowInfo().getActionName(planItem.getWorkflowAction());
    }

    public GState(GStatusLine parent, PlanItem planItem) {
        this(parent, planItem, 0);
    }

    public GState(GStatusLine parent, PlanItem planItem, boolean readOnly, int style) {
        super(parent, Messages.GState_LABEL, null, GState.getText(planItem), planItem, PlanItem.STATE, readOnly, style);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent.getOutline().getParent());
        this.setImage(this.getImage(planItem));
        this.fPlanItem = planItem;
        this.setReturnParentElement(true);
        this.setAction((IAction)new StateDropDownAction());
        this.update();
    }

    public GState(GStatusLine parent, PlanItem planItem, int style) {
        this(parent, planItem, false, style);
    }

    @Override
    public Object getElement() {
        return this.fPlanItem.getState();
    }

    private boolean update() {
        this.setLabel(GState.getText(this.fPlanItem));
        this.setImage(this.getImage(this.fPlanItem));
        return true;
    }

    private Image getImage(PlanItem planItem) {
        URL url = planItem.getWorkflowAction() == null ? planItem.getWorkflowInfo().getStateIconName(planItem.getState()) : planItem.getWorkflowInfo().getActionIconName(planItem.getWorkflowAction());
        if (url == null) {
            return null;
        }
        return this.createImageFromUrl(url);
    }

    private Image createImageFromUrl(URL url) {
        ImageDescriptor desc = WorkItemUI.getImageDescriptor((URL)url);
        return JazzResources.getImage((ResourceManager)this.fResourceManager, (ImageDescriptor)desc, null);
    }

    private class StateDropDownAction
    extends ValueSetDropDownAction<Identifier<IWorkflowAction>> {
        @Override
        protected MenuItem createMenuItem(Menu menu, Identifier<IWorkflowAction> action) {
            MenuItem item = new MenuItem(menu, 0);
            item.setImage(this.getImage(action));
            item.setText(this.getName(action));
            return item;
        }

        @Override
        protected List<Identifier<IWorkflowAction>> fastResolveValues() {
            Identifier state = GState.this.fPlanItem.getState();
            if (state == null) {
                return Collections.emptyList();
            }
            Identifier[] actions = GState.this.fPlanItem.getWorkflowInfo().getActionIds(state);
            Identifier currentAction = GState.this.fPlanItem.getWorkflowAction();
            if (currentAction == null) {
                return Arrays.asList(actions);
            }
            ArrayList<Identifier<IWorkflowAction>> result = new ArrayList<Identifier<IWorkflowAction>>(actions.length);
            Identifier[] identifierArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier action = identifierArray[n2];
                if (!action.equals((Object)currentAction)) {
                    result.add((Identifier<IWorkflowAction>)action);
                }
                ++n2;
            }
            result.add(CLEAR_ACTION);
            return result;
        }

        @Override
        protected void setValue(Identifier<IWorkflowAction> action) {
            if (action == CLEAR_ACTION) {
                GState.this.fPlanItem.setWorkflowAction(null);
            } else {
                GState.this.fPlanItem.setWorkflowAction(action);
            }
        }

        @Override
        protected List<Identifier<IWorkflowAction>> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
            return this.fastResolveValues();
        }

        private String getName(Identifier<IWorkflowAction> action) {
            if (action == CLEAR_ACTION) {
                return GState.this.fPlanItem.getWorkflowInfo().getStateName(GState.this.fPlanItem.getState());
            }
            return GState.this.fPlanItem.getWorkflowInfo().getActionName(action);
        }

        private Image getImage(Identifier<IWorkflowAction> action) {
            URL url = action == CLEAR_ACTION ? GState.this.fPlanItem.getWorkflowInfo().getStateIconName(GState.this.fPlanItem.getState()) : GState.this.fPlanItem.getWorkflowInfo().getActionIconName(action);
            if (url == null) {
                return null;
            }
            return GState.this.createImageFromUrl(url);
        }
    }
}

