/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.util.Collections2;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GEmptyCell;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GHBox;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GReferenceAttribute
extends GHBox {
    public GReferenceAttribute(CompositeGadget parent, PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute) {
        super(parent);
        Assert.isTrue((attribute.getAttributeType() == PlanningAttributeType.REFERENCE ? 1 : 0) != 0);
        Object value = attribute.getValue((Object)planItem);
        ArrayList<IReference> references = null;
        if (value instanceof List) {
            references = (ArrayList<IReference>)value;
        } else if (value instanceof Object[]) {
            references = new ArrayList<IReference>(((Object[])value).length);
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                references.add((IReference)obj);
                ++n2;
            }
        }
        if (references.isEmpty()) {
            new GEmptyCell(this);
        } else {
            IReference next = (IReference)references.iterator().next();
            IEndPointDescriptor endpoint = next.getLink().getThisEndpointDescriptor(next);
            new GImage(this, this.getOutlineResources().getResourceManager().createImage(ImageDescriptor.createFromURL((URL)endpoint.getIcon())));
            new GLink(this, NLS.bind((String)Messages.GReferenceAttribute_LABEL_PATTERN, (Object)endpoint.getDisplayName(), (Object[])new Object[]{String.valueOf(references.size())}), 0).setAction((IAction)new OpenReferencesAction(planItem, attribute.getDisplayName(), references));
        }
    }

    @Override
    protected int getSpacing() {
        return super.getSpacing() / 3;
    }

    private class OpenReferencesAction
    extends Action {
        private final List<IReference> fReferences;
        private final String fTitle;
        private final PlanItem fPlanItem;

        public OpenReferencesAction(PlanItem planItem, String title, List<IReference> references) {
            this.fPlanItem = planItem;
            this.fTitle = title;
            this.fReferences = references;
        }

        public void run() {
            List handles = Collections2.map(this.fReferences, (Collections2.IMapping)new Collections2.IMapping<IReference, IWorkItemHandle>(){

                public IWorkItemHandle map(IReference element) {
                    if (!element.isItemReference()) {
                        return null;
                    }
                    IItemHandle handle = ((IItemReference)element).getReferencedItem();
                    if (handle instanceof IWorkItemHandle) {
                        return (IWorkItemHandle)handle;
                    }
                    return null;
                }
            }, (boolean)true);
            if (handles.size() < this.fReferences.size()) {
                PlanningUIPlugin.log((IStatus)new Status(2, PlanningUIPlugin.getPluginId(), NLS.bind((String)"GReferenceAttribute.OpenReferencesAction skips {1} references because they are not work item references", (Object)(this.fReferences.size() - handles.size()), (Object[])new Object[0])));
                this.handleNonWIReferences();
            }
            WorkItemUI.showWorkItems((IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IProjectAreaHandle)this.fPlanItem.getPlan().getProjectArea(), (String)this.fTitle, (IWorkItemHandle[])handles.toArray(new IWorkItemHandle[0]));
        }

        private void handleNonWIReferences() {
            ArrayList<IReference> nonWIReferences = new ArrayList<IReference>();
            for (IReference reference : this.fReferences) {
                IItemHandle handle;
                if (!reference.isItemReference() || (handle = ((IItemReference)reference).getReferencedItem()) instanceof IWorkItemHandle) continue;
                nonWIReferences.add(reference);
            }
            if (nonWIReferences.size() > 0) {
                this.openReferences(this.fPlanItem.getPlan().getTeamRepository(), nonWIReferences);
            }
        }

        private void openReferences(final ITeamRepository teamRepository, final List<IReference> references) {
            FoundationJob job = new FoundationJob(Messages.GReferenceAttribute_OPENING_REFERENCES){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    ArrayList<URI> uris = new ArrayList<URI>();
                    URI context = null;
                    for (IReference reference : references) {
                        IItemHandle handle;
                        URI uri;
                        if (context == null) {
                            context = Location.itemLocation((IItemHandle)reference.getLink(), (String)teamRepository.getRepositoryURI()).toAbsoluteUri();
                        }
                        if ((uri = Location.itemLocation((IItemHandle)(handle = ((IItemReference)reference).getReferencedItem()), (String)teamRepository.getRepositoryURI()).toAbsoluteUri()) == null) continue;
                        uris.add(uri);
                    }
                    return Hyperlinks.open(uris, (ContextProvider)new StandardContextProvider(null, new URIReference("context", "", context)), (IProgressMonitor)monitor);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

