/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeDropDownAction;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GOwner
extends GStatusLineItem
implements ILabelProviderListener {
    private ILabelProvider fLabelProvider;
    private PlanItem fPlanItem;

    private static Image getImage(PlanItem planItem, OutlineResources resources) {
        IContributor owner = planItem.getOwner();
        if (owner == null) {
            return resources.getImage(ImagePool.WORKITEM_USER);
        }
        return resources.getStandardLabelProvider().getImage((Object)planItem.getOwner());
    }

    private static String getText(PlanItem planItem, OutlineResources resources) {
        IContributor owner = planItem.getOwner();
        if (owner == null) {
            return Messages.GOwner_UNASSIGNED;
        }
        return resources.getStandardLabelProvider().getText((Object)owner);
    }

    public GOwner(GStatusLine parent, PlanItem planItem) {
        this(parent, planItem, 0);
    }

    public GOwner(GStatusLine parent, PlanItem planItem, boolean readOnly, int style) {
        super(parent, Messages.GOwner_LABEL, GOwner.getImage(planItem, parent.getOutlineResources()), GOwner.getText(planItem, parent.getOutlineResources()), planItem, PlanItem.OWNER, readOnly, style);
        this.fPlanItem = planItem;
        this.fLabelProvider = parent.getOutlineResources().getStandardLabelProvider();
        this.fLabelProvider.addListener((ILabelProviderListener)this);
        this.setReturnParentElement(true);
        this.setAction((IAction)new OwnerDropDownAction(planItem));
        this.update();
    }

    public GOwner(GStatusLine parent, PlanItem planItem, int style) {
        this(parent, planItem, false, style);
    }

    private boolean affected(Object[] elements) {
        IContributor contributor = this.fPlanItem.getOwner();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IContributor current;
            Object element = objectArray[n2];
            if (element instanceof IContributor && (current = (IContributor)element).sameItemId((IItemHandle)contributor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.fLabelProvider.removeListener((ILabelProviderListener)this);
        super.dispose();
    }

    @Override
    public Object getElement() {
        return this.fPlanItem.getOwner();
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        Object[] elements = event.getElements();
        if ((elements == null || this.affected(elements)) && this.update() && this.isLayouted()) {
            this.redraw(true);
        }
    }

    private boolean update() {
        OutlineResources resources = this.getParent().getOutlineResources();
        this.setLabel(GOwner.getText(this.fPlanItem, resources));
        this.setImage(GOwner.getImage(this.fPlanItem, resources));
        return true;
    }

    private class OwnerDropDownAction
    extends AttributeDropDownAction<IContributor> {
        public OwnerDropDownAction(PlanItem planItem) {
            super(planItem, planItem.getPlan().getOwnerAttribute(), true);
        }

        @Override
        protected MenuItem createMenuItem(Menu menu, IContributor contributor) {
            MenuItem item = new MenuItem(menu, 0);
            item.setImage(GOwner.this.getOutlineResources().getStandardLabelProvider().getImage((Object)contributor));
            item.setText(contributor.getName());
            return item;
        }

        @Override
        protected List<IContributor> extendValueSet(List<IContributor> values) {
            ArrayList<IContributor> result = new ArrayList<IContributor>();
            ResolvedPlan plan = this.getPlanItem().getPlan();
            if (plan instanceof ResolvedIterationPlan) {
                for (IContributor owner : ((ResolvedIterationPlan)plan).getMemberContributors()) {
                    result.add(owner);
                }
            } else {
                for (IContributor owner : plan.getOwners()) {
                    result.add(owner);
                }
            }
            Collections.sort(result, new Comparator<IContributor>(){
                Collator collator = CollatorCache.getInstance();

                @Override
                public int compare(IContributor c1, IContributor c2) {
                    return this.collator.compare(c1.getName(), c2.getName());
                }
            });
            return result;
        }

        @Override
        protected void setValue(IContributor data) {
            this.getPlanItem().setOwner(data);
        }
    }
}

