/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.planchecker.PlanItemPlanCheckReport;
import com.ibm.team.apt.internal.common.IMessage;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.actions.LinkTypeColorizeAction;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.MessageMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.structure.CustomMarkerTag;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GMarkerGadget
extends SimpleGadget {
    private final IViewEntry<PlanItem> fPlanItemEntry;
    private final LocationMarker fLocationMarker;
    private Point fMarkerSize;
    private Point fImageSize;

    public GMarkerGadget(CompositeGadget parent, IViewEntry<PlanItem> planItemEntry, LocationMarker locationMarker) {
        super(parent);
        this.fPlanItemEntry = planItemEntry;
        this.fLocationMarker = locationMarker;
        this.initResouces();
    }

    private void initResouces() {
        Rectangle fatalBounds = this.getOutlineResources().getFatalErrorImage().getBounds();
        Rectangle warningBounds = this.getOutlineResources().getWarningImage().getBounds();
        Rectangle errorBounds = this.getOutlineResources().getErrorImage().getBounds();
        Rectangle doesNotBelongBounds = this.getOutlineResources().getDoesNotBelongToImage().getBounds();
        Rectangle pinnedBounds = this.getOutlineResources().getPinnedItemImage().getBounds();
        this.fImageSize = new Point(this.max(this.max(fatalBounds.width, warningBounds.width, errorBounds.width, doesNotBelongBounds.width), pinnedBounds.width), this.max(this.max(fatalBounds.height, warningBounds.height, errorBounds.height, doesNotBelongBounds.height), pinnedBounds.height));
        Font normalFont = this.getOutlineResources().getTextFonts().getNormalFont();
        Device device = normalFont.getDevice();
        GC gc = new GC((Drawable)device);
        try {
            gc.setFont(normalFont);
            this.fMarkerSize = new Point(gc.getCharWidth('*'), gc.getCharWidth('*'));
        }
        finally {
            gc.dispose();
        }
    }

    @Override
    protected Point arrangeContent(int x, int y, int hint, int hint2) {
        return new Point(this.computeMinimalWidth(), this.fMarkerSize.y + 1 + this.fImageSize.y);
    }

    @Override
    public int computeMinimalWidth() {
        return Math.max(this.fImageSize.x, this.fMarkerSize.x);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fBounds.width == 0 || this.fBounds.height == 0) {
            return;
        }
        GCState state = GCState.save(gc, 392);
        Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
        Image markerImage = null;
        if (((PlanItem)this.fPlanItemEntry.getElement()).isDirty() && !(this.fLocationMarker instanceof SecondaryLocationMarker)) {
            gc.setFont(resources.getTextFonts().getNormalFont());
            gc.drawString("*", rect.x, rect.y - 1, true);
            gc.setForeground(this.getPlanOutlineResources().getLabelColor());
        }
        if (this.fLocationMarker == null) {
            List<IMessage> messages = this.getMessages();
            if (!this.getMessages().isEmpty()) {
                IMessage message = messages.get(0);
                markerImage = this.getImage(message);
            }
        } else {
            markerImage = this.getOutlineResources().getDoesNotBelongToImage();
        }
        if (markerImage != null) {
            Rectangle bounds = markerImage.getBounds();
            int imgWidth = bounds.width;
            int imgHeight = bounds.height;
            gc.drawImage(markerImage, 0, 0, imgWidth, imgHeight, rect.x, rect.y + rect.height - imgHeight, imgWidth, imgHeight);
        }
        if (this.getOutlineResources().debugLayout) {
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
        state.restore();
    }

    private List<IMessage> getMessages() {
        List tags;
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        PlanItemPlanCheckReport report = ((PlanItem)this.fPlanItemEntry.getElement()).getPlanCheckReport();
        if (report != null) {
            result.addAll(report.getProblems());
        }
        if ((tags = this.fPlanItemEntry.getTags(CustomMarkerTag.class)) != null) {
            result.addAll(tags);
        }
        Collections.sort(result, new Comparator<IMessage>(){

            @Override
            public int compare(IMessage o1, IMessage o2) {
                return -o1.getSeverity().compareTo((Enum)o2.getSeverity());
            }
        });
        return result;
    }

    @Override
    public Object getElement() {
        if (this.fLocationMarker != null) {
            return this.fLocationMarker;
        }
        List<IMessage> messages = this.getMessages();
        if (messages.isEmpty()) {
            return null;
        }
        return new MessageMarker(messages);
    }

    public Image getImage(IMessage message) {
        if (message instanceof LinkTypeColorizeAction.ReferenceTag) {
            return this.getOutlineResources().getResourceManager().createImage(ImagePool.LINKED);
        }
        if (message.getSeverity() == Severity.INFO) {
            return this.getOutlineResources().getInfoImage();
        }
        if (message.getSeverity() == Severity.WARNING) {
            return this.getOutlineResources().getWarningImage();
        }
        if (message.getSeverity() == Severity.ERROR || message.getSeverity() == Severity.FATAL_ERROR) {
            return this.getOutlineResources().getErrorImage();
        }
        return null;
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }
}

