/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.GAbstractLabelButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GFiledAgainst
extends GAbstractLabelButton {
    private PlanItem fPlanItem;

    public GFiledAgainst(CompositeGadget parent, PlanItem planItem) {
        super(parent);
        this.fPlanItem = planItem;
        this.setLabel(this.getCategoryLabel());
        this.setAction((IAction)new SetTargetAction());
        this.setImage(((PlanOutlineResources)this.getOutlineResources()).getCategoryImage());
    }

    private String getCategoryLabel() {
        ICategory category = this.fPlanItem.getCategory();
        if (category != null) {
            return category.getName();
        }
        new UIUpdaterJob(Messages.GFiledAgainst_JOB_UPDATE_CATEGORY){
            String fCategoryName;

            public IStatus runInBackground(IProgressMonitor monitor) {
                ResolvedPlan plan = GFiledAgainst.this.fPlanItem.getPlan();
                IItemManager manager = plan.getTeamRepository().itemManager();
                try {
                    ICategory category = (ICategory)manager.fetchCompleteItem((IItemHandle)GFiledAgainst.this.fPlanItem.getCategoryHandle(), 0, monitor);
                    this.fCategoryName = category.getName();
                }
                catch (TeamRepositoryException e) {
                    PlanningUIPlugin.log("Deferred Category Name Loading failed", e);
                    this.fCategoryName = Messages.GFiledAgainst_LABEL_LOAD_FAILED;
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (!GFiledAgainst.this.isDisposed()) {
                    GFiledAgainst.this.setLabel(this.fCategoryName);
                    GFiledAgainst.this.resize(0, 0);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return Messages.GFiledAgainst_LABEL_LOADING;
    }

    private class SetTargetAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private SelectionAdapter fListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.widget;
                GFiledAgainst.this.fPlanItem.setCategory((ICategory)item.getData());
            }
        };

        public SetTargetAction() {
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                if (this.fMenu.isDisposed()) {
                    this.fMenu = null;
                } else if (!this.fMenu.isVisible()) {
                    this.fMenu.dispose();
                    this.fMenu = null;
                }
            }
        }

        public Menu getMenu(Control parent) {
            this.dispose();
            this.fMenu = new Menu(parent);
            ArrayList<ICategory> categories = new ArrayList<ICategory>();
            for (ICategory category : GFiledAgainst.this.fPlanItem.getPlan().getCategories()) {
                categories.add(category);
            }
            Categories.sort(categories);
            String predecessorName = String.valueOf('/');
            for (ICategory category : categories) {
                if (category.isArchived()) continue;
                String currentName = category.getHierarchicalName();
                int maxLength = Math.min(predecessorName.length(), currentName.length());
                int lastCommonSeparator = 0;
                int i = 0;
                while (i < maxLength) {
                    if (predecessorName.charAt(i) != currentName.charAt(i)) break;
                    if (currentName.charAt(i) == '/') {
                        lastCommonSeparator = i;
                    }
                    ++i;
                }
                String prependedCategories = "";
                int indent = category.getDepth();
                int lastSlash = currentName.lastIndexOf(47);
                if (lastSlash != lastCommonSeparator) {
                    prependedCategories = currentName.substring(0, lastSlash + 1);
                    indent = 0;
                }
                StringBuilder labelBuilder = new StringBuilder();
                int i2 = 0;
                while (i2 < indent) {
                    labelBuilder.append(Messages.GFiledAgainst_INDENTATION);
                    ++i2;
                }
                labelBuilder.append(prependedCategories);
                labelBuilder.append(category.getName());
                MenuItem menuItem = this.createMenuItem(labelBuilder.toString(), category);
                menuItem.setSelection(category.sameItemId((IItemHandle)GFiledAgainst.this.fPlanItem.getCategory()));
                predecessorName = String.valueOf(currentName) + String.valueOf('/');
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return this.fMenu;
        }

        private MenuItem createMenuItem(String label, ICategory category) {
            MenuItem result = new MenuItem(this.fMenu, 16);
            result.setText(label);
            result.setData((Object)category);
            result.addSelectionListener((SelectionListener)this.fListener);
            return result;
        }
    }
}

