/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class GFadeableTreeNodeContent
extends GTreeNodeContent {
    protected GFadeableTreeNodeContent(CompositeGadget parent) {
        super(parent);
    }

    protected abstract int getAlphaValue();

    protected abstract Color getBackgroundColor();

    @Override
    public void paint(GC gc, OutlineResources resources) {
        int alphaValue = this.getAlphaValue();
        if (alphaValue < 255 && !this.getDisplay().getHighContrast()) {
            Rectangle view = this.getTransformation().toViewPort(this.fBounds);
            Image bufferImage = new Image(gc.getDevice(), this.fBounds.width, this.fBounds.height);
            GC bufferGC = new GC((Drawable)bufferImage);
            Object state = this.getTransformation().beginOverlay(this.fBounds.x, this.fBounds.y);
            try {
                super.paint(bufferGC, resources);
            }
            finally {
                this.getTransformation().endOverlay(state);
            }
            GCState gcState = GCState.save(gc, 2);
            try {
                gc.setAlpha(alphaValue);
                gc.drawImage(bufferImage, 0, 0, this.fBounds.width, this.fBounds.height, view.x, view.y, view.width, view.height);
            }
            finally {
                gcState.restore();
                bufferGC.dispose();
                bufferImage.dispose();
            }
        }
        super.paint(gc, resources);
    }
}

