/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.AttributeNotAvailableException;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.DurationDropDownAction;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.workitem.common.model.Duration;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;

public class GDuration
extends GStatusLineItem {
    public static final int MAX_WIDTH = 190;
    static final String VALUE = "duration_value";

    public GDuration(GStatusLine parent, PlanItem planItem, IPlanningAttributeIdentifier attribute, int style) {
        super(parent, Messages.GDuration_LABEL, GDuration.getImage(parent), GDuration.getDurationText(parent, planItem, attribute), planItem, attribute, false, style);
        if (PlanItem.ORIGINAL_ESTIMATE.equals(attribute) && planItem.getDuration().isOriginalEstimateFixed()) {
            this.setEnabled(false);
        }
        this.setAction((IAction)new DurationDropDownAction(planItem, attribute));
    }

    private static String getDurationText(GStatusLine line, PlanItem planItem, IPlanningAttributeIdentifier durationAttribute) {
        Duration currentDuration = Duration.UNSPECIFIED;
        try {
            currentDuration = (Duration)planItem.getAttributeValue(durationAttribute);
        }
        catch (AttributeNotAvailableException attributeNotAvailableException) {
            // empty catch block
        }
        return ((PlanOutlineResources)line.getOutlineResources()).getDurationFormat(planItem.getPlan()).format(currentDuration);
    }

    private static Image getImage(GStatusLine line) {
        return ((PlanOutlineResources)line.getOutlineResources()).getDurationImage();
    }
}

