/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GDate
extends GStatusLineItem {
    public static final int MAX_WIDTH = 100;
    public static final String AS_SOON_AS_POSSIBLE = "constraintEnum.literal.asap";
    private PlanItem fPlanItem;
    private IPlanningAttributeIdentifier fAttributeIdentifier;

    public GDate(GStatusLine parent, PlanItem planItem, IPlanningAttribute attribute, IPlanningAttributeIdentifier attributeIdentifier, int style) {
        super(parent, GDate.getLabel(attribute), GDate.getImage(parent), GDate.getText(planItem, attributeIdentifier), planItem, attributeIdentifier, attribute.isReadOnly(), style);
        ConfigurationItem constraintType;
        this.fAttributeIdentifier = attributeIdentifier;
        this.fPlanItem = planItem;
        if (PlanItem.CONSTRAINT_DATE.equals(this.fAttributeIdentifier) && (constraintType = (ConfigurationItem)this.fPlanItem.getAttributeValue(PlanItem.CONSTRAINT_TYPE)).getIdentifier().equals(AS_SOON_AS_POSSIBLE)) {
            this.setEnabled(false);
        }
        if (this.isEnabled()) {
            this.setAction((IAction)new DateAction());
        } else {
            this.setColor(((PlanOutlineResources)parent.getOutlineResources()).getNoContentColor());
        }
    }

    private static String getLabel(IPlanningAttribute attribute) {
        return attribute.getDisplayName();
    }

    private static Image getImage(GStatusLine line) {
        return ((PlanOutlineResources)line.getOutlineResources()).getDueDateImage();
    }

    private static String getText(PlanItem planItem, IPlanningAttributeIdentifier attributeIdentifier) {
        Date date = (Date)planItem.getAttributeValue(attributeIdentifier);
        if (date == null) {
            return Messages.GDate_NOT_SET;
        }
        return MessageFormat.format((String)Messages.GDate_SET, (Object[])new Object[]{date});
    }

    private class DateAction
    extends Action {
        public void run() {
            Outline outline = GDate.this.getOutline();
            Rectangle bounds = GDate.this.getBounds();
            Point pickerLocation = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
            pickerLocation = outline.toDisplay(GDate.this.getOutline().getTransformation().toViewPort(pickerLocation));
            DatePicker picker = new DatePicker(outline.getShell(), 2);
            picker.setLocation(pickerLocation.x, pickerLocation.y);
            Date date = (Date)GDate.this.fPlanItem.getAttributeValue(GDate.this.fAttributeIdentifier);
            if (date != null) {
                picker.setDate(date);
            }
            picker.open();
            if (picker.getDateObject() != null) {
                if (PlanItem.DUE_DATE.equals(GDate.this.fAttributeIdentifier)) {
                    GDate.this.fPlanItem.setDueDate(new Timestamp(picker.getDateObject().getTime()));
                } else {
                    GDate.this.fPlanItem.setAttributeValue(GDate.this.fAttributeIdentifier, (Object)new Timestamp(picker.getDateObject().getTime()));
                }
            }
        }
    }
}

